/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util.config;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiColorized;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.GolemDescription;
import com.mcmoddev.golems.util.config.special.GolemSpecialContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.IRegistryDelegate;

public final class GolemContainer {
    private final Class<? extends GolemBase> entityClass;
    private final List<IRegistryDelegate<Block>> validBuildingBlocks;
    private final List<ResourceLocation> validBuildingBlockTags;
    private final EntityType<? extends GolemBase> entityType;
    private final String name;
    private final ResourceLocation basicTexture;
    private final SoundEvent basicSound;
    private final boolean fallDamage;
    private final boolean explosionImmunity;
    private final SwimMode swimMode;
    private final boolean hasCustomRender;
    private final boolean canInteractChangeTexture;
    private double health;
    private double attack;
    private final double speed;
    private final double knockbackResist;
    private boolean enabled = true;
    private final ImmutableMap<String, GolemSpecialContainer> specialContainers;
    private final ImmutableList<GolemDescription> descContainers;
    private final ImmutableMap<IRegistryDelegate<Item>, Double> healItemMap;
    private final Supplier<AttributeModifierMap.MutableAttribute> attributeSupplier;

    private GolemContainer(EntityType<? extends GolemBase> lEntityType, Class<? extends GolemBase> lEntityClass, String lPath, List<IRegistryDelegate<Block>> lValidBuildingBlocks, List<ResourceLocation> lValidBuildingBlockTags, double lHealth, double lAttack, double lSpeed, double lKnockbackResist, boolean lFallDamage, boolean lExplosionImmunity, SwimMode lSwimMode, HashMap<String, GolemSpecialContainer> lSpecialContainers, List<GolemDescription> lDesc, Map<IRegistryDelegate<Item>, Double> lHealItemMap, Supplier<AttributeModifierMap.MutableAttribute> lAttributeSupplier, ResourceLocation lTexture, SoundEvent lBasicSound, boolean lCustomRender) {
        this.entityType = lEntityType;
        this.entityClass = lEntityClass;
        this.validBuildingBlocks = lValidBuildingBlocks;
        this.validBuildingBlockTags = lValidBuildingBlockTags;
        this.name = lPath;
        this.health = lHealth;
        this.attack = lAttack;
        this.speed = lSpeed;
        this.knockbackResist = lKnockbackResist;
        this.fallDamage = lFallDamage;
        this.explosionImmunity = lExplosionImmunity;
        this.swimMode = lSwimMode;
        this.specialContainers = ImmutableMap.copyOf(lSpecialContainers);
        this.descContainers = ImmutableList.copyOf(lDesc);
        this.healItemMap = ImmutableMap.copyOf(lHealItemMap);
        this.attributeSupplier = lAttributeSupplier;
        this.basicTexture = lTexture;
        this.basicSound = lBasicSound;
        this.hasCustomRender = lCustomRender;
        this.canInteractChangeTexture = ExtraGolemsConfig.enableTextureInteract() && (GolemMultiTextured.class.isAssignableFrom(lEntityClass) || GolemMultiColorized.class.isAssignableFrom(lEntityClass));
    }

    public void addDescription(List<IFormattableTextComponent> list) {
        if (this.entityType.func_220338_c()) {
            list.add(new TranslationTextComponent("entitytip.is_fireproof").func_240699_a_(TextFormatting.GOLD));
        }
        if (this.explosionImmunity) {
            list.add(new TranslationTextComponent("entitytip.is_explosionproof").func_240701_a_(new TextFormatting[]{TextFormatting.GRAY, TextFormatting.BOLD}));
        }
        if (this.canInteractChangeTexture) {
            list.add(new TranslationTextComponent("entitytip.click_change_texture").func_240699_a_(TextFormatting.BLUE));
        }
        for (GolemDescription desc : this.descContainers) {
            desc.addDescription(list, this);
        }
    }

    public boolean hasBuildingBlock() {
        return !this.validBuildingBlocks.isEmpty() || !this.validBuildingBlockTags.isEmpty();
    }

    public Set<Block> getBuildingBlocks() {
        HashSet<Block> blocks = this.validBuildingBlocks.isEmpty() ? new HashSet<Block>() : this.validBuildingBlocks.stream().map(d -> (Block)d.get()).collect(Collectors.toSet());
        for (ITag<Block> tag : GolemContainer.loadTags(this.validBuildingBlockTags)) {
            blocks.addAll(tag.func_230236_b_());
        }
        return blocks;
    }

    public ImmutableCollection<GolemSpecialContainer> getSpecialContainers() {
        return this.specialContainers.values();
    }

    public GolemSpecialContainer getSpecialContainer(String key) {
        return (GolemSpecialContainer)this.specialContainers.get((Object)key);
    }

    public double getHealAmount(Item item) {
        Map<IRegistryDelegate<Item>, Double> map = GolemContainer.loadTagsForHealMap(this.getBuildingBlocks(), this.healItemMap);
        if (item != null && item != Items.field_190931_a && map.containsKey(item.delegate)) {
            return map.get(item.delegate);
        }
        return 0.0;
    }

    public boolean areBuildingBlocks(Block body, Block legs, Block arm1, Block arm2) {
        Set<Block> blocks = this.getBuildingBlocks();
        return blocks.contains(body) && blocks.contains(legs) && blocks.contains(arm1) && blocks.contains(arm2);
    }

    @Nullable
    public Block getPrimaryBuildingBlock() {
        Block[] blocks;
        if (this.hasBuildingBlock() && (blocks = this.getBuildingBlocks().toArray(new Block[0])) != null && blocks.length > 0) {
            return blocks[0];
        }
        return null;
    }

    public boolean addBlocks(Block ... additional) {
        return additional.length > 0 && this.validBuildingBlocks.addAll(Arrays.asList(additional).stream().map(d -> d.delegate).collect(Collectors.toList()));
    }

    public boolean addBlocks(@Nonnull ITag.INamedTag<Block> additional) {
        return this.validBuildingBlockTags.add(additional.func_230234_a_());
    }

    private static Collection<ITag<Block>> loadTags(Collection<ResourceLocation> rls) {
        HashSet<ITag<Block>> tags = new HashSet<ITag<Block>>();
        for (ResourceLocation rl : rls) {
            if (BlockTags.func_199896_a().func_199910_a(rl) == null) continue;
            tags.add((ITag<Block>)BlockTags.func_199896_a().func_199910_a(rl));
        }
        return tags;
    }

    private static Map<IRegistryDelegate<Item>, Double> loadTagsForHealMap(Set<Block> set, Map<IRegistryDelegate<Item>, Double> healItems) {
        HashMap<IRegistryDelegate<Item>, Double> map = new HashMap<IRegistryDelegate<Item>, Double>(healItems);
        for (Block b : set) {
            Item ib = b.func_199767_j();
            if (ib == Items.field_190931_a || map.containsKey(ib.delegate)) continue;
            map.put((IRegistryDelegate<Item>)ib.delegate, 0.75);
        }
        return map;
    }

    public void setHealth(double pHealth) {
        this.health = pHealth;
    }

    public void setAttack(double pAttack) {
        this.attack = pAttack;
    }

    public void setEnabled(boolean pEnabled) {
        this.enabled = pEnabled;
    }

    public Class<? extends GolemBase> getEntityClass() {
        return this.entityClass;
    }

    public EntityType<? extends GolemBase> getEntityType() {
        return this.entityType;
    }

    public ResourceLocation getRegistryName() {
        return this.entityType.getRegistryName();
    }

    public Supplier<AttributeModifierMap.MutableAttribute> getAttributeSupplier() {
        return this.attributeSupplier;
    }

    public ResourceLocation getTexture() {
        return this.basicTexture;
    }

    public boolean useDefaultRender() {
        return !this.hasCustomRender;
    }

    public SoundEvent getSound() {
        return this.basicSound;
    }

    public String getName() {
        return this.name;
    }

    public double getHealth() {
        return this.health;
    }

    public double getAttack() {
        return this.attack;
    }

    public double getSpeed() {
        return this.speed;
    }

    public double getKnockbackResist() {
        return this.knockbackResist;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean takesFallDamage() {
        return this.fallDamage;
    }

    public boolean isImmuneToExplosions() {
        return this.explosionImmunity;
    }

    public boolean canSwim() {
        return this.swimMode == SwimMode.FLOAT;
    }

    public SwimMode getSwimMode() {
        return this.swimMode;
    }

    public static enum SwimMode {
        SINK,
        FLOAT,
        SWIM;

    }

    public static final class Builder {
        private final String golemName;
        private final Class<? extends GolemBase> entityClass;
        private EntityType.Builder<? extends GolemBase> entityTypeBuilder;
        private ResourceLocation basicTexture = null;
        private SoundEvent basicSound = SoundEvents.field_187902_gb;
        private String modid = "golems";
        private double health = 100.0;
        private double attack = 7.0;
        private double speed = 0.25;
        private double knockBackResist = 0.4;
        private boolean fallDamage = false;
        private boolean customRender = false;
        private boolean explosionImmunity = false;
        private SwimMode swimMode = SwimMode.SINK;
        private List<IRegistryDelegate<Block>> validBuildingBlocks = new ArrayList<IRegistryDelegate<Block>>();
        private List<ResourceLocation> validBuildingBlockTags = new ArrayList<ResourceLocation>();
        private List<GolemSpecialContainer> specials = new ArrayList<GolemSpecialContainer>();
        private List<GolemDescription> descriptions = new ArrayList<GolemDescription>();
        private final Map<IRegistryDelegate<Item>, Double> healItemMap = new HashMap<IRegistryDelegate<Item>, Double>();

        public Builder(String golemName, Class<? extends GolemBase> entityClazz, EntityType.IFactory<? extends GolemBase> entityFactory) {
            this.golemName = golemName;
            this.entityClass = entityClazz;
            this.entityTypeBuilder = EntityType.Builder.func_220322_a(entityFactory, (EntityClassification)EntityClassification.MISC).setTrackingRange(48).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).func_220321_a(1.4f, 2.9f);
        }

        public Builder setModId(String lModId) {
            this.modid = lModId;
            return this;
        }

        public Builder setHealth(double lHealth) {
            this.health = lHealth;
            return this;
        }

        public Builder setAttack(double lAttack) {
            this.attack = lAttack;
            return this;
        }

        public Builder setSpeed(double lMoveSpeed) {
            this.speed = lMoveSpeed;
            return this;
        }

        public Builder setKnockback(double lKnockbackResist) {
            this.knockBackResist = lKnockbackResist;
            return this;
        }

        public Builder setTexture(ResourceLocation lTexture) {
            this.basicTexture = lTexture;
            return this;
        }

        public Builder basicTexture() {
            return this.setTexture(new ResourceLocation(this.modid + ":textures/entity/" + this.golemName + ".png"));
        }

        public Builder hasCustomRender() {
            this.customRender = true;
            return this;
        }

        public Builder setSound(SoundEvent lSound) {
            this.basicSound = lSound;
            return this;
        }

        public Builder setSwimMode(SwimMode mode) {
            this.swimMode = mode;
            return this;
        }

        public Builder addBlocks(Block ... additionalBlocks) {
            if (additionalBlocks != null && additionalBlocks.length > 0) {
                this.validBuildingBlocks.addAll(Arrays.asList(additionalBlocks).stream().map(b -> b.delegate).collect(Collectors.toList()));
            }
            return this;
        }

        public Builder addBlocks(ITag.INamedTag<Block> blockTag) {
            this.validBuildingBlockTags.add(blockTag.func_230234_a_());
            return this;
        }

        public Builder addBlocks(ResourceLocation blockTag) {
            this.validBuildingBlockTags.add(blockTag);
            return this;
        }

        public Builder addSpecials(GolemSpecialContainer ... specialContainers) {
            this.specials.addAll(Arrays.asList(specialContainers));
            return this;
        }

        public Builder addSpecial(String name, Object value, String comment) {
            this.specials.add(new GolemSpecialContainer.Builder<Object>(name, value, comment).build());
            return this;
        }

        public Builder addSpecial(String name, Boolean value, String comment, IFormattableTextComponent desc) {
            this.addSpecial(name, value, comment);
            this.addDesc(new GolemDescription(desc, name));
            return this;
        }

        public Builder addDesc(GolemDescription ... desc) {
            for (GolemDescription cont : desc) {
                this.descriptions.add(cont);
            }
            return this;
        }

        public Builder addHealItem(Item item, double amount) {
            this.healItemMap.put((IRegistryDelegate<Item>)item.delegate, amount);
            return this;
        }

        public Builder immuneToFire() {
            this.entityTypeBuilder = this.entityTypeBuilder.func_220320_c();
            return this;
        }

        public Builder immuneToExplosions() {
            this.explosionImmunity = true;
            return this;
        }

        public Builder enableFallDamage() {
            this.fallDamage = true;
            return this;
        }

        public GolemContainer build() {
            EntityType entityType = this.entityTypeBuilder.func_206830_a(this.golemName);
            entityType.setRegistryName(this.modid, this.golemName);
            HashMap<String, GolemSpecialContainer> containerMap = new HashMap<String, GolemSpecialContainer>();
            for (GolemSpecialContainer c : this.specials) {
                containerMap.put(c.name, c);
            }
            Supplier<AttributeModifierMap.MutableAttribute> attributes = () -> MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, this.health).func_233815_a_(Attributes.field_233821_d_, this.speed).func_233815_a_(Attributes.field_233820_c_, this.knockBackResist).func_233815_a_(Attributes.field_233823_f_, this.attack);
            return new GolemContainer(entityType, this.entityClass, this.golemName, this.validBuildingBlocks, this.validBuildingBlockTags, this.health, this.attack, this.speed, this.knockBackResist, this.fallDamage, this.explosionImmunity, this.swimMode, containerMap, this.descriptions, this.healItemMap, attributes, this.basicTexture, this.basicSound, this.customRender);
        }
    }
}

