/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.util.config;

import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.GolemContainer;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;

public class GolemDescription {
    private final IFormattableTextComponent text;
    private final String configKey;
    private final Predicate<ForgeConfigSpec.ConfigValue<?>> configValue;

    public GolemDescription(IFormattableTextComponent textIn, String configKeyIn, @Nullable Predicate<ForgeConfigSpec.ConfigValue<?>> configValueIn) {
        this.text = textIn;
        this.configKey = configKeyIn != null ? configKeyIn : "";
        this.configValue = configValueIn != null ? configValueIn : c -> true;
    }

    public GolemDescription(IFormattableTextComponent textIn, String configKeyIn) {
        this(textIn, configKeyIn, c -> c != null && c.get() instanceof Boolean && (Boolean)c.get() != false);
    }

    public GolemDescription(IFormattableTextComponent textIn) {
        this(textIn, "", c -> true);
    }

    public boolean addDescription(List<IFormattableTextComponent> list) {
        return list.add(this.text);
    }

    public boolean addDescription(List<IFormattableTextComponent> list, GolemContainer container) {
        if (this.isEnabledFor(container)) {
            return this.addDescription(list);
        }
        return false;
    }

    public boolean isEnabledFor(GolemContainer container) {
        return this.configKey.isEmpty() || this.configValue.test(ExtraGolemsConfig.GOLEM_CONFIG.specials.get((Object)container.getSpecialContainer((String)this.configKey)).value);
    }
}

