/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_quark;

import com.mcmoddev.golems.entity.CoalGolem;
import com.mcmoddev.golems.entity.GenericGolem;
import com.mcmoddev.golems.entity.NetherBrickGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.util.config.GolemContainer;
import com.mcmoddev.golems.util.config.GolemDescription;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import com.mcmoddev.golems_quark.entity.CaveCrystalGolem;
import com.mcmoddev.golems_quark.entity.ColorSlimeGolem;
import com.mcmoddev.golems_quark.entity.GenericGlowingGolem;
import com.mcmoddev.golems_quark.entity.GlowshroomGolem;
import com.mcmoddev.golems_quark.entity.IronPlateGolem;
import com.mcmoddev.golems_quark.entity.PermafrostGolem;
import com.mcmoddev.golems_quark.entity.QuiltedWoolGolem;
import com.mcmoddev.golems_quark.util.DeferredContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.automation.module.ColorSlimeModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.module.CompressedBlocksModule;
import vazkii.quark.building.module.DuskboundBlocksModule;
import vazkii.quark.building.module.FramedGlassModule;
import vazkii.quark.building.module.IronPlatesModule;
import vazkii.quark.building.module.LitLampModule;
import vazkii.quark.building.module.MidoriModule;
import vazkii.quark.building.module.MoreBrickTypesModule;
import vazkii.quark.building.module.MoreStoneVariantsModule;
import vazkii.quark.building.module.QuiltedWoolModule;
import vazkii.quark.building.module.SoulSandstoneModule;
import vazkii.quark.building.module.SturdyStoneModule;
import vazkii.quark.world.module.BiotiteModule;
import vazkii.quark.world.module.NewStoneTypesModule;
import vazkii.quark.world.module.underground.BrimstoneUndergroundBiomeModule;
import vazkii.quark.world.module.underground.CaveCrystalUndergroundBiomeModule;
import vazkii.quark.world.module.underground.ElderPrismarineUndergroundBiomeModule;
import vazkii.quark.world.module.underground.GlowshroomUndergroundBiomeModule;
import vazkii.quark.world.module.underground.PermafrostUndergroundBiomeModule;

public final class QuarkGolemsEntities {
    public static final String MODID = "golems_quark";
    private static final List<DeferredContainer> deferred = new ArrayList<DeferredContainer>();

    private QuarkGolemsEntities() {
    }

    public static void initEntityTypes() {
        ExtraGolems.LOGGER.info("Extra Golems: Quark - initEntityTypes");
        String[] quiltedWoolTypes = new String[DyeColor.values().length];
        int l = quiltedWoolTypes.length;
        for (int i = 0; i < l; ++i) {
            quiltedWoolTypes[i] = DyeColor.values()[i] + "_quilted_wool";
        }
        QuarkGolemsEntities.softRegister(BiotiteModule.class, new GolemContainer.Builder("golem_biotite", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(116.0).setAttack(8.5).setSpeed(0.28).setKnockback(0.6).basicTexture().build(), "biotite_block", "chiseled_biotite_block", "smooth_biotite", "biotite_pillar");
        QuarkGolemsEntities.softRegister(CompressedBlocksModule.class, QuarkGolemsEntities.buildEnabledPredicate().and(m -> CompressedBlocksModule.enableBlazeLantern), new GolemContainer.Builder("golem_blaze_lantern", GenericGlowingGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGlowingGolem::new)).setModId(MODID).setHealth(34.0).setAttack(7.6).setSpeed(0.26).immuneToFire().addSpecial("Allow Special: Emit Light", true, "Whether this golem can glow", new TranslationTextComponent("entitytip.lights_area").func_240699_a_(TextFormatting.GOLD)).setSwimMode(GolemContainer.SwimMode.FLOAT).basicTexture().build(), "blaze_lantern");
        QuarkGolemsEntities.softRegister(BrimstoneUndergroundBiomeModule.class, new GolemContainer.Builder("golem_brimstone", NetherBrickGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)NetherBrickGolem::new)).setModId(MODID).setHealth(25.0).setAttack(6.5).setSpeed(0.28).setKnockback(0.2).addSpecial("Allow Special: Burn Enemies", true, "Whether this golem can light creatures on fire", new TranslationTextComponent("entitytip.lights_mobs_on_fire").func_240699_a_(TextFormatting.RED)).immuneToFire().basicTexture().build(), "brimstone", "brimstone_bricks");
        QuarkGolemsEntities.softRegister(CaveCrystalUndergroundBiomeModule.class, new GolemContainer.Builder("golem_cave_crystal", CaveCrystalGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)CaveCrystalGolem::new)).setModId(MODID).setHealth(18.0).setAttack(8.2).setSpeed(0.29).basicTexture().enableFallDamage().addSpecial("Allow Special: Emit Light", true, "Whether this golem can glow", new TranslationTextComponent("entitytip.lights_area").func_240699_a_(TextFormatting.LIGHT_PURPLE)).build(), "red_crystal", "orange_crystal", "yellow_crystal", "green_crystal", "blue_crystal", "indigo_crystal", "violet_crystal", "white_crystal", "black_crystal");
        QuarkGolemsEntities.softRegister(CompressedBlocksModule.class, QuarkGolemsEntities.buildEnabledPredicate().and(m -> CompressedBlocksModule.enableCharcoalBlock), new GolemContainer.Builder("golem_charcoal", CoalGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)CoalGolem::new)).setModId(MODID).setHealth(24.0).setAttack(2.5).setSpeed(0.28).setKnockback(0.2).basicTexture().addSpecial("Allow Special: Blindness", false, "Whether this golem can inflict blindness", new TranslationTextComponent("entitytip.blinds_creatures").func_240699_a_(TextFormatting.GRAY)).addHealItem(Items.field_151044_h, 0.25).addHealItem(Items.field_196155_l, 0.25).build(), "charcoal_block");
        QuarkGolemsEntities.softRegister(ColorSlimeModule.class, new GolemContainer.Builder("golem_color_slime", ColorSlimeGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)ColorSlimeGolem::new)).setModId(MODID).setHealth(58.0).setAttack(2.5).setSpeed(0.288).setKnockback(0.35).basicTexture().addSpecial("Splitting Factor", 2, "The number of mini-golems to spawn when this golem dies").addSpecial("Allow Special: Extra Knockback", true, "Whether this golem can apply extra knockback when attacking", new TranslationTextComponent("entitytip.has_knockback").func_240699_a_(TextFormatting.GREEN)).addSpecial("Knockback Factor", 1.0412, "Slime Golem knockback power (Higher Value = Further Knockback)").addDesc(new GolemDescription(new TranslationTextComponent("entitytip.splits_upon_death").func_240699_a_(TextFormatting.GREEN), "Splitting Factor", c -> (Integer)c.get() > 0)).setSwimMode(GolemContainer.SwimMode.FLOAT).setSound(SoundEvents.field_187886_fs).addHealItem(Items.field_151123_aH, 0.25).build(), "red_slime_block", "blue_slime_block", "cyan_slime_block", "magenta_slime_block", "yellow_slime_block");
        QuarkGolemsEntities.softRegister(DuskboundBlocksModule.class, new GolemContainer.Builder("golem_duskbound", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(84.0).setAttack(6.6).setSpeed(0.26).setKnockback(0.6).basicTexture().build(), "duskbound_block");
        QuarkGolemsEntities.softRegister(DuskboundBlocksModule.class, new GolemContainer.Builder("golem_duskbound_lamp", GenericGlowingGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGlowingGolem::new)).setModId(MODID).setHealth(88.0).setAttack(6.0).setSpeed(0.26).addSpecial("Allow Special: Emit Light", true, "Whether this golem can glow", new TranslationTextComponent("entitytip.lights_area").func_240699_a_(TextFormatting.LIGHT_PURPLE)).basicTexture().build(), "duskbound_lantern");
        QuarkGolemsEntities.softRegister(ElderPrismarineUndergroundBiomeModule.class, new GolemContainer.Builder("golem_elder_prismarine", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(38.0).setAttack(7.0).setKnockback(0.7).basicTexture().setSwimMode(GolemContainer.SwimMode.SWIM).addHealItem(Items.field_179562_cC, 0.25).build(), "elder_prismarine", "elder_prismarine_bricks", "dark_elder_prismarine");
        QuarkGolemsEntities.softRegister(ElderPrismarineUndergroundBiomeModule.class, new GolemContainer.Builder("golem_elder_sea_lantern", GenericGlowingGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGlowingGolem::new)).setModId(MODID).setHealth(36.0).setAttack(6.1).setSpeed(0.26).setKnockback(0.9).addSpecial("Allow Special: Emit Light", true, "Whether this golem can glow", new TranslationTextComponent("entitytip.lights_area").func_240699_a_(TextFormatting.LIGHT_PURPLE)).setSwimMode(GolemContainer.SwimMode.SWIM).basicTexture().addHealItem(Items.field_179562_cC, 0.25).build(), "elder_sea_lantern");
        QuarkGolemsEntities.softRegister(FramedGlassModule.class, new GolemContainer.Builder("golem_framed_glass", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(16.0).setAttack(8.5).setSpeed(0.3).basicTexture().enableFallDamage().setSound(SoundEvents.field_187569_bQ).build(), "framed_glass");
        QuarkGolemsEntities.softRegister(GlowshroomUndergroundBiomeModule.class, new GolemContainer.Builder("golem_glowshroom", GlowshroomGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GlowshroomGolem::new)).setModId(MODID).setHealth(30.0).setAttack(3.0).setSpeed(0.3).addSpecial("Mushroom Frequency", 420, "Average number of ticks between planting glowshrooms").addSpecial("Allow Special: Plant Glowshrooms", true, "Whether this golem can plant glowshrooms randomly", new TranslationTextComponent("entitytip.plants_shrooms").func_240699_a_(TextFormatting.DARK_AQUA)).addSpecial("Allow Special: Emit Light", true, "Whether this golem can glow", new TranslationTextComponent("entitytip.lights_area").func_240699_a_(TextFormatting.AQUA)).addSpecial("Allow Special: Random Healing", true, "Whether this golem can randomly heal (at night)", new TranslationTextComponent("entitytip.heals").func_240699_a_(TextFormatting.RED)).basicTexture().build(), "glowshroom_block", "glowshroom_stem");
        QuarkGolemsEntities.softRegister(IronPlatesModule.class, new GolemContainer.Builder("golem_iron_plate", IronPlateGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)IronPlateGolem::new)).setModId(MODID).setHealth(40.0).setAttack(7.0).setSpeed(0.26).setKnockback(1.0).basicTexture().build(), "iron_plate", "rusty_iron_plate");
        QuarkGolemsEntities.softRegister(NewStoneTypesModule.class, new GolemContainer.Builder("golem_jasper", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(52.0).setAttack(5.9).setSpeed(0.28).setKnockback(0.8).basicTexture().build(), "polished_jasper", "jasper_pillar", "chiseled_jasper_bricks", "jasper_pavement");
        QuarkGolemsEntities.softRegister(NewStoneTypesModule.class, new GolemContainer.Builder("golem_limestone", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(49.0).setAttack(5.0).setSpeed(0.27).setKnockback(0.8).basicTexture().build(), "polished_limestone", "limestone_pillar", "chiseled_limestone_bricks", "limestone_pavement");
        QuarkGolemsEntities.softRegister(NewStoneTypesModule.class, new GolemContainer.Builder("golem_marble", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(54.0).setAttack(6.5).setSpeed(0.28).setKnockback(0.8).basicTexture().build(), "polished_marble", "marble_pillar", "chiseled_marble_bricks", "marble_pavement");
        QuarkGolemsEntities.softRegister(MidoriModule.class, new GolemContainer.Builder("golem_midori", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(32.0).setAttack(3.0).setSpeed(0.28).setKnockback(0.6).basicTexture().build(), "midori_block", "midori_pillar");
        QuarkGolemsEntities.softRegister(PermafrostUndergroundBiomeModule.class, new GolemContainer.Builder("golem_permafrost", PermafrostGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)PermafrostGolem::new)).setModId(MODID).setHealth(42.0).setAttack(4.0).setSpeed(0.28).setKnockback(0.6).basicTexture().addSpecial("Allow Special: Slowness", true, "Whether this golem can apply slowness when attacking", new TranslationTextComponent("entitytip.slows_creatures").func_240699_a_(TextFormatting.AQUA)).build(), "permafrost", "permafrost_bricks");
        QuarkGolemsEntities.softRegister(QuiltedWoolModule.class, new GolemContainer.Builder("golem_quilted_wool", QuiltedWoolGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)QuiltedWoolGolem::new)).setModId(MODID).setHealth(16.0).setAttack(1.0).setSpeed(0.295).setKnockback(0.2).basicTexture().build(), quiltedWoolTypes);
        QuarkGolemsEntities.softRegister(NewStoneTypesModule.class, new GolemContainer.Builder("golem_slate", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(50.0).setAttack(5.8).setSpeed(0.28).setKnockback(0.8).basicTexture().build(), "polished_slate", "slate_pillar", "chiseled_slate_bricks", "slate_pavement");
        QuarkGolemsEntities.softRegister(SoulSandstoneModule.class, new GolemContainer.Builder("golem_soul_sandstone", PermafrostGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)PermafrostGolem::new)).setModId(MODID).setHealth(30.0).setAttack(4.0).setSpeed(0.28).basicTexture().addSpecial("Allow Special: Slowness", true, "Whether this golem can apply slowness when attacking", new TranslationTextComponent("entitytip.slows_creatures").func_240699_a_(TextFormatting.DARK_GRAY)).build(), "soul_sandstone", "soul_sandstone_bricks", "chiseled_soul_sandstone", "cut_soul_sandstone");
        QuarkGolemsEntities.softRegister(SturdyStoneModule.class, new GolemContainer.Builder("golem_sturdy_stone", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(70.0).setAttack(4.0).setSpeed(0.27).setKnockback(1.0).basicTexture().build(), "sturdy_stone");
        QuarkGolemsEntities.softRegister(SturdyStoneModule.class, new GolemContainer.Builder("golem_tallow", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(48.0).setAttack(2.0).setSpeed(0.27).basicTexture().build(), "tallow_block");
        QuarkGolemsEntities.softRegister(NewStoneTypesModule.class, new GolemContainer.Builder("golem_voidstone", GenericGolem.class, (EntityType.IFactory<? extends GolemBase>)((EntityType.IFactory)GenericGolem::new)).setModId(MODID).setHealth(52.0).setAttack(5.8).setSpeed(0.28).setKnockback(0.8).immuneToFire().basicTexture().build(), "polished_basalt", "basalt_pillar", "chiseled_basalt_bricks", "basalt_pavement");
    }

    public static void interModEnqueueEvent(InterModEnqueueEvent event) {
        for (DeferredContainer d : deferred) {
            boolean enabled = d.enabled.test(d.module);
            d.container.setEnabled(enabled);
            QuarkGolemsEntities.addBlocks(d.container, "quark", d.blocks);
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(MoreBrickTypesModule.class)) {
            QuarkGolemsEntities.addBlocks(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_nether_brick")), "quark", "charred_nether_bricks");
            QuarkGolemsEntities.addBlocks(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_magma")), "quark", "magma_bricks");
            QuarkGolemsEntities.addBlocks(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_sandstone")), "quark", "sandstone_bricks");
            QuarkGolemsEntities.addBlocks(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_red_sandstone")), "quark", "red_sandstone_bricks");
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(MoreStoneVariantsModule.class)) {
            QuarkGolemsEntities.addBlocks(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_andesite")), "quark", "chiseled_andesite_bricks", "andesite_pavement", "andesite_pillar");
            QuarkGolemsEntities.addBlocks(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_diorite")), "quark", "chiseled_diorite_bricks", "diorite_pavement", "diorite_pillar");
            QuarkGolemsEntities.addBlocks(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_granite")), "quark", "chiseled_granite_bricks", "granite_pavement", "granite_pillar");
        }
        if (ModuleLoader.INSTANCE.isModuleEnabled(LitLampModule.class)) {
            QuarkGolemsEntities.addBlocks(GolemRegistrar.getContainer(new ResourceLocation("golems", "golem_redstone_lamp")), "quark", "lit_lamp");
        }
    }

    public static void addBlocks(GolemContainer cont, String modid, String ... blockNames) {
        if (null == cont) {
            return;
        }
        for (String s : blockNames) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modid, s));
            if (block == null) continue;
            cont.addBlocks(block);
        }
    }

    public static void softRegister(Class<? extends Module> module, GolemContainer cont, String ... blockNames) {
        QuarkGolemsEntities.softRegister(module, QuarkGolemsEntities.buildEnabledPredicate(), cont, blockNames);
    }

    public static void softRegister(Class<? extends Module> module, Predicate<Class<? extends Module>> pred, GolemContainer cont, String ... blockNames) {
        deferred.add(new DeferredContainer(cont, module, blockNames, pred));
        GolemRegistrar.registerGolem(cont);
    }

    private static Predicate<Class<? extends Module>> buildEnabledPredicate() {
        return m -> ModuleLoader.INSTANCE.isModuleEnabled(m);
    }
}

