/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_quark.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;

public final class IronPlateGolem
extends GolemMultiTextured {
    public static final String[] PLATE_TYPES = new String[]{"normal", "rusty"};

    public IronPlateGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "golems_quark", PLATE_TYPES);
    }

    @Override
    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
        byte textureNum = "quark:iron_plate".equals(body.func_177230_c().getRegistryName().toString()) ? (byte)0 : 1;
        textureNum = (byte)(textureNum % this.getNumTextures());
        this.setTextureNum(textureNum);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        Block plateNormal = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "iron_plate"));
        Block plateRusty = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark", "rusty_iron_plate"));
        if (plateNormal != null && plateRusty != null) {
            return new ItemStack((IItemProvider)(this.getTextureNum() == 0 ? plateNormal : plateRusty));
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        return new HashMap<Block, Byte>();
    }
}

