/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems_quark.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiColorized;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.building.module.QuiltedWoolModule;

public class QuiltedWoolGolem
extends GolemMultiColorized {
    private static final Map<Block, Byte> textureBytes = new HashMap<Block, Byte>();
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeTexture("golems", "golem_stained_glass");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeTexture("golems_quark", "golem_quilted_wool_white");

    public QuiltedWoolGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "golems_quark", TEXTURE_BASE, TEXTURE_OVERLAY, DYE_COLORS);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(textureBytes, (byte)this.getTextureNum()));
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        if (textureBytes.isEmpty()) {
            QuiltedWoolGolem.fillTextureBytes();
        }
        return textureBytes;
    }

    private static void fillTextureBytes() {
        if (ModuleLoader.INSTANCE.isModuleEnabled(QuiltedWoolModule.class)) {
            for (DyeColor d : DyeColor.values()) {
                Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:" + d.func_176762_d() + "_quilted_wool"));
                textureBytes.put(b, (byte)d.func_196059_a());
            }
        }
    }
}

