/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.platform.GlStateManager;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.Color4f;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1263;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2680;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3341;
import net.minecraft.class_777;

public class RenderUtils {
    public static final class_2960 TEXTURE_MAP_BACKGROUND = new class_2960("textures/map/map_background.png");
    private static final Random RAND = new Random();

    public static void setupBlend() {
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
    }

    public static void bindTexture(class_2960 texture) {
        RenderUtils.mc().method_1531().method_4618(texture);
    }

    public static void color(float r, float g, float b, float a) {
        GlStateManager.color4f((float)r, (float)g, (float)b, (float)a);
    }

    public static void disableItemLighting() {
        class_308.method_1450();
    }

    public static void enableItemLighting() {
        class_308.method_1452();
    }

    public static void enableGuiItemLighting() {
        class_308.method_1453();
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder) {
        RenderUtils.drawOutlinedBox(x, y, width, height, colorBg, colorBorder, 0.0f);
    }

    public static void drawOutlinedBox(int x, int y, int width, int height, int colorBg, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, width, height, colorBg, zLevel);
        RenderUtils.drawOutline(x - 1, y - 1, width + 2, height + 2, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - 1, y, 1, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y, width - 2, 1, colorBorder, zLevel);
        RenderUtils.drawRect(x + 1, y + height - 1, width - 2, 1, colorBorder, zLevel);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder) {
        RenderUtils.drawOutline(x, y, width, height, borderWidth, colorBorder, 0.0f);
    }

    public static void drawOutline(int x, int y, int width, int height, int borderWidth, int colorBorder, float zLevel) {
        RenderUtils.drawRect(x, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + width - borderWidth, y, borderWidth, height, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
        RenderUtils.drawRect(x + borderWidth, y + height - borderWidth, width - 2 * borderWidth, borderWidth, colorBorder, zLevel);
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        RenderUtils.drawTexturedRect(x, y, u, v, width, height, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color) {
        RenderUtils.drawRect(x, y, width, height, color, 0.0f);
    }

    public static void drawRect(int x, int y, int width, int height, int color, float zLevel) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        GlStateManager.disableTexture();
        RenderUtils.setupBlend();
        RenderUtils.color(r, g, b, a);
        buffer.method_1328(7, class_290.field_1592);
        buffer.method_1315((double)x, (double)y, (double)zLevel).method_1344();
        buffer.method_1315((double)x, (double)(y + height), (double)zLevel).method_1344();
        buffer.method_1315((double)(x + width), (double)(y + height), (double)zLevel).method_1344();
        buffer.method_1315((double)(x + width), (double)y, (double)zLevel).method_1344();
        tessellator.method_1350();
        GlStateManager.enableTexture();
        GlStateManager.disableBlend();
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height, float zLevel) {
        float pixelWidth = 0.00390625f;
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(7, class_290.field_1585);
        buffer.method_1315((double)x, (double)(y + height), (double)zLevel).method_1312((double)((float)u * pixelWidth), (double)((float)(v + height) * pixelWidth)).method_1344();
        buffer.method_1315((double)(x + width), (double)(y + height), (double)zLevel).method_1312((double)((float)(u + width) * pixelWidth), (double)((float)(v + height) * pixelWidth)).method_1344();
        buffer.method_1315((double)(x + width), (double)y, (double)zLevel).method_1312((double)((float)(u + width) * pixelWidth), (double)((float)v * pixelWidth)).method_1344();
        buffer.method_1315((double)x, (double)y, (double)zLevel).method_1312((double)((float)u * pixelWidth), (double)((float)v * pixelWidth)).method_1344();
        tessellator.method_1350();
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, class_287 buffer) {
        RenderUtils.drawTexturedRectBatched(x, y, u, v, width, height, 0.0f, buffer);
    }

    public static void drawTexturedRectBatched(int x, int y, int u, int v, int width, int height, float zLevel, class_287 buffer) {
        float pixelWidth = 0.00390625f;
        buffer.method_1315((double)x, (double)(y + height), (double)zLevel).method_1312((double)((float)u * pixelWidth), (double)((float)(v + height) * pixelWidth)).method_1344();
        buffer.method_1315((double)(x + width), (double)(y + height), (double)zLevel).method_1312((double)((float)(u + width) * pixelWidth), (double)((float)(v + height) * pixelWidth)).method_1344();
        buffer.method_1315((double)(x + width), (double)y, (double)zLevel).method_1312((double)((float)(u + width) * pixelWidth), (double)((float)v * pixelWidth)).method_1344();
        buffer.method_1315((double)x, (double)y, (double)zLevel).method_1312((double)((float)u * pixelWidth), (double)((float)v * pixelWidth)).method_1344();
    }

    public static void drawHoverText(int x, int y, List<String> textLines) {
        class_310 mc = RenderUtils.mc();
        if (!textLines.isEmpty() && GuiUtils.getCurrentScreen() != null) {
            class_327 font = mc.field_1772;
            GlStateManager.disableRescaleNormal();
            RenderUtils.disableItemLighting();
            GlStateManager.disableLighting();
            GlStateManager.disableDepthTest();
            int maxLineLength = 0;
            int maxWidth = GuiUtils.getCurrentScreen().width;
            ArrayList<String> linesNew = new ArrayList<String>();
            for (String lineOrig : textLines) {
                String[] lines;
                for (String line : lines = lineOrig.split("\\n")) {
                    int length = font.method_1727(line);
                    if (length > maxLineLength) {
                        maxLineLength = length;
                    }
                    linesNew.add(line);
                }
            }
            textLines = linesNew;
            font.getClass();
            int lineHeight = 9 + 1;
            int textHeight = textLines.size() * lineHeight - 2;
            int textStartX = x + 4;
            int textStartY = Math.max(8, y - textHeight - 6);
            if (textStartX + maxLineLength + 6 > maxWidth) {
                textStartX = Math.max(2, maxWidth - maxLineLength - 8);
            }
            double zLevel = 300.0;
            int borderColor = -267386864;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 4, textStartX + maxLineLength + 3, textStartY - 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 3, textStartX + maxLineLength + 3, textStartY + textHeight + 4, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX - 4, textStartY - 3, textStartX - 3, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 3, textStartY - 3, textStartX + maxLineLength + 4, textStartY + textHeight + 3, zLevel, borderColor, borderColor);
            int fillColor1 = 0x505000FF;
            int fillColor2 = 1344798847;
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3 + 1, textStartX - 3 + 1, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX + maxLineLength + 2, textStartY - 3 + 1, textStartX + maxLineLength + 3, textStartY + textHeight + 3 - 1, zLevel, fillColor1, fillColor2);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY - 3, textStartX + maxLineLength + 3, textStartY - 3 + 1, zLevel, fillColor1, fillColor1);
            RenderUtils.drawGradientRect(textStartX - 3, textStartY + textHeight + 2, textStartX + maxLineLength + 3, textStartY + textHeight + 3, zLevel, fillColor2, fillColor2);
            for (int i = 0; i < textLines.size(); ++i) {
                String str = textLines.get(i);
                font.method_1720(str, (float)textStartX, (float)textStartY, -1);
                textStartY += lineHeight;
            }
            GlStateManager.enableLighting();
            GlStateManager.enableDepthTest();
            class_308.method_1453();
            GlStateManager.enableRescaleNormal();
        }
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, double zLevel, int startColor, int endColor) {
        float sa = (float)(startColor >> 24 & 0xFF) / 255.0f;
        float sr = (float)(startColor >> 16 & 0xFF) / 255.0f;
        float sg = (float)(startColor >> 8 & 0xFF) / 255.0f;
        float sb = (float)(startColor & 0xFF) / 255.0f;
        float ea = (float)(endColor >> 24 & 0xFF) / 255.0f;
        float er = (float)(endColor >> 16 & 0xFF) / 255.0f;
        float eg = (float)(endColor >> 8 & 0xFF) / 255.0f;
        float eb = (float)(endColor & 0xFF) / 255.0f;
        GlStateManager.disableTexture();
        GlStateManager.disableAlphaTest();
        RenderUtils.setupBlend();
        GlStateManager.shadeModel((int)7425);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_1315((double)right, (double)top, zLevel).method_1336(sr, sg, sb, sa).method_1344();
        buffer.method_1315((double)left, (double)top, zLevel).method_1336(sr, sg, sb, sa).method_1344();
        buffer.method_1315((double)left, (double)bottom, zLevel).method_1336(er, eg, eb, ea).method_1344();
        buffer.method_1315((double)right, (double)bottom, zLevel).method_1336(er, eg, eb, ea).method_1344();
        tessellator.method_1350();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlphaTest();
        GlStateManager.enableTexture();
    }

    public static void drawCenteredString(int x, int y, int color, String text) {
        class_327 textRenderer = RenderUtils.mc().field_1772;
        textRenderer.method_1720(text, (float)(x - textRenderer.method_1727(text) / 2), (float)y, color);
    }

    public static void drawHorizontalLine(int x, int y, int width, int color) {
        RenderUtils.drawRect(x, y, width, 1, color);
    }

    public static void drawVerticalLine(int x, int y, int height, int color) {
        RenderUtils.drawRect(x, y, 1, height, color);
    }

    public static void renderSprite(int x, int y, int width, int height, String texture) {
        if (texture != null) {
            class_1058 sprite = RenderUtils.mc().method_1549().method_4607(texture);
            GlStateManager.disableLighting();
            class_332.blit((int)x, (int)y, (int)0, (int)width, (int)height, (class_1058)sprite);
        }
    }

    public static void renderText(int x, int y, int color, String text) {
        String[] parts = text.split("\\\\n");
        class_327 textRenderer = RenderUtils.mc().field_1772;
        for (String line : parts) {
            textRenderer.method_1720(line, (float)x, (float)y, color);
            textRenderer.getClass();
            y += 9 + 1;
        }
    }

    public static void renderText(int x, int y, int color, List<String> lines) {
        if (!lines.isEmpty()) {
            class_327 textRenderer = RenderUtils.mc().field_1772;
            for (String line : lines) {
                textRenderer.method_1729(line, (float)x, (float)y, color);
                textRenderer.getClass();
                y += 9 + 2;
            }
        }
    }

    public static int renderText(int xOff, int yOff, double scale, int textColor, int bgColor, HudAlignment alignment, boolean useBackground, boolean useShadow, List<String> lines) {
        class_327 fontRenderer = RenderUtils.mc().field_1772;
        int scaledWidth = GuiUtils.getScaledWindowWidth();
        fontRenderer.getClass();
        int lineHeight = 9 + 2;
        int contentHeight = lines.size() * lineHeight - 2;
        int bgMargin = 2;
        if (scale == 0.0) {
            return 0;
        }
        if (scale != 1.0) {
            if (scale != 0.0) {
                xOff = (int)((double)xOff * scale);
                yOff = (int)((double)yOff * scale);
            }
            GlStateManager.pushMatrix();
            GlStateManager.scaled((double)scale, (double)scale, (double)0.0);
        }
        double posX = xOff + 2;
        double posY = yOff + 2;
        posY = RenderUtils.getHudPosY((int)posY, yOff, contentHeight, scale, alignment);
        posY += (double)RenderUtils.getHudOffsetForPotions(alignment, scale, (class_1657)RenderUtils.mc().field_1724);
        for (String line : lines) {
            int width = fontRenderer.method_1727(line);
            switch (alignment) {
                case TOP_RIGHT: 
                case BOTTOM_RIGHT: {
                    posX = (double)scaledWidth / scale - (double)width - (double)xOff - 2.0;
                    break;
                }
                case CENTER: {
                    posX = (double)scaledWidth / scale / 2.0 - (double)(width / 2) - (double)xOff;
                    break;
                }
            }
            int x = (int)posX;
            int y = (int)posY;
            posY += (double)lineHeight;
            if (useBackground) {
                fontRenderer.getClass();
                RenderUtils.drawRect(x - 2, y - 2, width + 2, 2 + 9, bgColor);
            }
            if (useShadow) {
                fontRenderer.method_1720(line, (float)x, (float)y, textColor);
                continue;
            }
            fontRenderer.method_1729(line, (float)x, (float)y, textColor);
        }
        if (scale != 1.0) {
            GlStateManager.popMatrix();
        }
        return contentHeight + 4;
    }

    public static int getHudOffsetForPotions(HudAlignment alignment, double scale, class_1657 player) {
        if (alignment == HudAlignment.TOP_RIGHT) {
            if (scale == 0.0) {
                return 0;
            }
            Collection effects = player.method_6026();
            if (!effects.isEmpty()) {
                int y1 = 0;
                int y2 = 0;
                for (class_1293 effectInstance : effects) {
                    class_1291 effect = effectInstance.method_5579();
                    if (!effectInstance.method_5581() || !effectInstance.method_5592()) continue;
                    if (effect.method_5573()) {
                        y1 = 26;
                        continue;
                    }
                    y2 = 52;
                    break;
                }
                return (int)((double)Math.max(y1, y2) / scale);
            }
        }
        return 0;
    }

    public static int getHudPosY(int yOrig, int yOffset, int contentHeight, double scale, HudAlignment alignment) {
        int scaledHeight = GuiUtils.getScaledWindowHeight();
        int posY = yOrig;
        switch (alignment) {
            case BOTTOM_RIGHT: 
            case BOTTOM_LEFT: {
                posY = (int)((double)scaledHeight / scale - (double)contentHeight - (double)yOffset);
                break;
            }
            case CENTER: {
                posY = (int)((double)scaledHeight / scale / 2.0 - (double)contentHeight / 2.0 + (double)yOffset);
                break;
            }
        }
        return posY;
    }

    public static void drawBlockBoundingBoxSidesBatchedQuads(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        double minX = (double)pos.method_10263() - expand;
        double minY = (double)pos.method_10264() - expand;
        double minZ = (double)pos.method_10260() - expand;
        double maxX = (double)pos.method_10263() + expand + 1.0;
        double maxY = (double)pos.method_10264() + expand + 1.0;
        double maxZ = (double)pos.method_10260() + expand + 1.0;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBlockBoundingBoxOutlinesBatchedLines(class_2338 pos, Color4f color, double expand, class_287 buffer) {
        double minX = (double)pos.method_10263() - expand;
        double minY = (double)pos.method_10264() - expand;
        double minZ = (double)pos.method_10260() - expand;
        double maxX = (double)pos.method_10263() + expand + 1.0;
        double maxY = (double)pos.method_10264() + expand + 1.0;
        double maxZ = (double)pos.method_10260() + expand + 1.0;
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
    }

    public static void drawBoxAllSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, class_287 buffer) {
        RenderUtils.drawBoxHorizontalSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxTopBatchedQuads(minX, minZ, maxX, maxY, maxZ, color, buffer);
        RenderUtils.drawBoxBottomBatchedQuads(minX, minY, minZ, maxX, maxZ, color, buffer);
    }

    public static void drawBoxWithEdgesBatched(class_2338 posMin, class_2338 posMax, Color4f colorLines, Color4f colorSides, class_287 bufferQuads, class_287 bufferLines) {
        double x1 = posMin.method_10263();
        double y1 = posMin.method_10264();
        double z1 = posMin.method_10260();
        double x2 = posMax.method_10263() + 1;
        double y2 = posMax.method_10264() + 1;
        double z2 = posMax.method_10260() + 1;
        RenderUtils.drawBoxAllSidesBatchedQuads(x1, y1, z1, x2, y2, z2, colorSides, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(x1, y1, z1, x2, y2, z2, colorLines, bufferLines);
    }

    public static void drawBoxHorizontalSidesBatchedQuads(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, class_287 buffer) {
        buffer.method_1315(minX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
    }

    public static void drawBoxTopBatchedQuads(double minX, double minZ, double maxX, double maxY, double maxZ, Color4f color, class_287 buffer) {
        buffer.method_1315(minX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
    }

    public static void drawBoxBottomBatchedQuads(double minX, double minY, double minZ, double maxX, double maxZ, Color4f color, class_287 buffer) {
        buffer.method_1315(maxX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
    }

    public static void drawBoxAllEdgesBatchedLines(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, Color4f color, class_287 buffer) {
        buffer.method_1315(minX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, minZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, minY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(maxX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
        buffer.method_1315(minX, maxY, maxZ).method_1336(color.r, color.g, color.b, color.a).method_1344();
    }

    public static void drawBox(IntBoundingBox bb, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        double minX = bb.minX;
        double minY = bb.minY;
        double minZ = bb.minZ;
        double maxX = bb.maxX + 1;
        double maxY = bb.maxY + 1;
        double maxZ = bb.maxZ + 1;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawBox(class_3341 bb, Color4f color, class_287 bufferQuads, class_287 bufferLines) {
        double minX = bb.field_14381;
        double minY = bb.field_14380;
        double minZ = bb.field_14379;
        double maxX = bb.field_14378 + 1;
        double maxY = bb.field_14377 + 1;
        double maxZ = bb.field_14376 + 1;
        RenderUtils.drawBoxAllSidesBatchedQuads(minX, minY, minZ, maxX, maxY, maxZ, color, bufferQuads);
        RenderUtils.drawBoxAllEdgesBatchedLines(minX, minY, minZ, maxX, maxY, maxZ, color, bufferLines);
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float scale) {
        class_1297 entity = RenderUtils.mc().method_1560();
        if (entity != null) {
            RenderUtils.drawTextPlate(text, x, y, z, entity.field_6031, entity.field_5965, scale, -1, 0x40000000, true);
        }
    }

    public static void drawTextPlate(List<String> text, double x, double y, double z, float yaw, float pitch, float scale, int textColor, int bgColor, boolean disableDepth) {
        class_327 textRenderer = RenderUtils.mc().field_1772;
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)pitch, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)(-scale), (float)(-scale), (float)scale);
        GlStateManager.disableLighting();
        GlStateManager.disableCull();
        if (disableDepth) {
            GlStateManager.depthMask((boolean)false);
            GlStateManager.disableDepthTest();
        }
        RenderUtils.setupBlend();
        GlStateManager.disableTexture();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        int maxLineLen = 0;
        for (String line : text) {
            maxLineLen = Math.max(maxLineLen, textRenderer.method_1727(line));
        }
        int strLenHalf = maxLineLen / 2;
        textRenderer.getClass();
        int textHeight = 9 * text.size() - 1;
        float bga = (float)(bgColor >>> 24 & 0xFF) * 255.0f;
        float bgr = (float)(bgColor >>> 16 & 0xFF) * 255.0f;
        float bgg = (float)(bgColor >>> 8 & 0xFF) * 255.0f;
        float bgb = (float)(bgColor & 0xFF) * 255.0f;
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_1315((double)(-strLenHalf - 1), -1.0, 0.0).method_1336(bgr, bgg, bgb, bga).method_1344();
        buffer.method_1315((double)(-strLenHalf - 1), (double)textHeight, 0.0).method_1336(bgr, bgg, bgb, bga).method_1344();
        buffer.method_1315((double)strLenHalf, (double)textHeight, 0.0).method_1336(bgr, bgg, bgb, bga).method_1344();
        buffer.method_1315((double)strLenHalf, -1.0, 0.0).method_1336(bgr, bgg, bgb, bga).method_1344();
        tessellator.method_1350();
        GlStateManager.enableTexture();
        int textY = 0;
        if (!disableDepth) {
            GlStateManager.enablePolygonOffset();
            GlStateManager.polygonOffset((float)-0.6f, (float)-1.2f);
        }
        for (String line : text) {
            if (disableDepth) {
                GlStateManager.depthMask((boolean)false);
                GlStateManager.disableDepthTest();
            }
            textRenderer.method_1729(line, (float)(-strLenHalf), (float)textY, 0x20000000 | textColor & 0xFFFFFF);
            GlStateManager.enableDepthTest();
            GlStateManager.depthMask((boolean)true);
            textRenderer.method_1729(line, (float)(-strLenHalf), (float)textY, textColor);
            textRenderer.getClass();
            textY += 9;
        }
        if (!disableDepth) {
            GlStateManager.polygonOffset((float)0.0f, (float)0.0f);
            GlStateManager.disablePolygonOffset();
        }
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.enableCull();
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    public static void renderBlockTargetingOverlay(class_1297 entity, class_2338 pos, class_2350 side, class_243 hitVec, Color4f color, class_310 mc) {
        class_2350 playerFacing = entity.method_5735();
        PositionUtils.HitPart part = PositionUtils.getHitPart(side, playerFacing, pos, hitVec);
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        GlStateManager.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        float quadAlpha = 0.18f;
        float ha = color.a;
        float hr = color.r;
        float hg = color.g;
        float hb = color.b;
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_1315(x - 0.5, y - 0.5, z).method_1336(1.0f, 1.0f, 1.0f, quadAlpha).method_1344();
        buffer.method_1315(x + 0.5, y - 0.5, z).method_1336(1.0f, 1.0f, 1.0f, quadAlpha).method_1344();
        buffer.method_1315(x + 0.5, y + 0.5, z).method_1336(1.0f, 1.0f, 1.0f, quadAlpha).method_1344();
        buffer.method_1315(x - 0.5, y + 0.5, z).method_1336(1.0f, 1.0f, 1.0f, quadAlpha).method_1344();
        switch (part) {
            case CENTER: {
                buffer.method_1315(x - 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x + 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x + 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x - 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
            case LEFT: {
                buffer.method_1315(x - 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x - 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x - 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x - 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
            case RIGHT: {
                buffer.method_1315(x + 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x + 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x + 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x + 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
            case TOP: {
                buffer.method_1315(x - 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x - 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x + 0.25, y + 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x + 0.5, y + 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
            case BOTTOM: {
                buffer.method_1315(x - 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x - 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x + 0.25, y - 0.25, z).method_1336(hr, hg, hb, ha).method_1344();
                buffer.method_1315(x + 0.5, y - 0.5, z).method_1336(hr, hg, hb, ha).method_1344();
                break;
            }
        }
        tessellator.method_1350();
        GlStateManager.lineWidth((float)1.6f);
        buffer.method_1328(2, class_290.field_1576);
        buffer.method_1315(x - 0.25, y - 0.25, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x + 0.25, y - 0.25, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x + 0.25, y + 0.25, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x - 0.25, y + 0.25, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        tessellator.method_1350();
        buffer.method_1328(1, class_290.field_1576);
        buffer.method_1315(x - 0.5, y - 0.5, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x - 0.25, y - 0.25, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x - 0.5, y + 0.5, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x - 0.25, y + 0.25, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x + 0.5, y - 0.5, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x + 0.25, y - 0.25, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x + 0.5, y + 0.5, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x + 0.25, y + 0.25, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        tessellator.method_1350();
        GlStateManager.popMatrix();
    }

    public static void renderBlockTargetingOverlaySimple(class_1297 entity, class_2338 pos, class_2350 side, Color4f color, class_310 mc) {
        class_2350 playerFacing = entity.method_5735();
        class_243 cameraPos = mc.field_1773.method_19418().method_19326();
        double x = (double)pos.method_10263() + 0.5 - cameraPos.field_1352;
        double y = (double)pos.method_10264() + 0.5 - cameraPos.field_1351;
        double z = (double)pos.method_10260() + 0.5 - cameraPos.field_1350;
        GlStateManager.pushMatrix();
        RenderUtils.blockTargetingOverlayTranslations(x, y, z, side, playerFacing);
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_1349();
        float a = color.a;
        float r = color.r;
        float g = color.g;
        float b = color.b;
        buffer.method_1328(7, class_290.field_1576);
        buffer.method_1315(x - 0.5, y - 0.5, z).method_1336(r, g, b, a).method_1344();
        buffer.method_1315(x + 0.5, y - 0.5, z).method_1336(r, g, b, a).method_1344();
        buffer.method_1315(x + 0.5, y + 0.5, z).method_1336(r, g, b, a).method_1344();
        buffer.method_1315(x - 0.5, y + 0.5, z).method_1336(r, g, b, a).method_1344();
        tessellator.method_1350();
        GlStateManager.lineWidth((float)1.6f);
        buffer.method_1328(2, class_290.field_1576);
        buffer.method_1315(x - 0.375, y - 0.375, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x + 0.375, y - 0.375, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x + 0.375, y + 0.375, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        buffer.method_1315(x - 0.375, y + 0.375, z).method_1336(1.0f, 1.0f, 1.0f, 1.0f).method_1344();
        tessellator.method_1350();
        GlStateManager.popMatrix();
    }

    private static void blockTargetingOverlayTranslations(double x, double y, double z, class_2350 side, class_2350 playerFacing) {
        GlStateManager.translated((double)x, (double)y, (double)z);
        switch (side) {
            case field_11033: {
                GlStateManager.rotatef((float)(180.0f - playerFacing.method_10144()), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case field_11036: {
                GlStateManager.rotatef((float)(180.0f - playerFacing.method_10144()), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.rotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                break;
            }
            case field_11043: {
                GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case field_11035: {
                GlStateManager.rotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case field_11039: {
                GlStateManager.rotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case field_11034: {
                GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        GlStateManager.translated((double)(-x), (double)(-y), (double)(-z + 0.501));
    }

    public static void renderMapPreview(class_1799 stack, int x, int y, int dimensions) {
        if (stack.method_7909() instanceof class_1806 && GuiBase.isShiftDown()) {
            GlStateManager.pushMatrix();
            GlStateManager.disableLighting();
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            int y1 = y - dimensions - 20;
            int y2 = y1 + dimensions;
            int x1 = x + 8;
            int x2 = x1 + dimensions;
            int z = 300;
            RenderUtils.bindTexture(TEXTURE_MAP_BACKGROUND);
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            buffer.method_1328(7, class_290.field_1585);
            buffer.method_1315((double)x1, (double)y2, (double)z).method_1312(0.0, 1.0).method_1344();
            buffer.method_1315((double)x2, (double)y2, (double)z).method_1312(1.0, 1.0).method_1344();
            buffer.method_1315((double)x2, (double)y1, (double)z).method_1312(1.0, 0.0).method_1344();
            buffer.method_1315((double)x1, (double)y1, (double)z).method_1312(0.0, 0.0).method_1344();
            tessellator.method_1350();
            class_22 mapdata = class_1806.method_7997((class_1799)stack, (class_1937)RenderUtils.mc().field_1687);
            if (mapdata != null) {
                z = 310;
                double scale = (double)(dimensions - 16) / 128.0;
                GlStateManager.translatef((float)(x1 += 8), (float)(y1 += 8), (float)z);
                GlStateManager.scaled((double)scale, (double)scale, (double)0.0);
                RenderUtils.mc().field_1773.method_3194().method_1773(mapdata, false);
            }
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
        }
    }

    public static void renderShulkerBoxPreview(class_1799 stack, int x, int y, boolean useBgColors) {
        if (stack.method_7985()) {
            class_2371<class_1799> items = InventoryUtils.getStoredItems(stack, -1);
            if (items.size() == 0) {
                return;
            }
            GlStateManager.pushMatrix();
            RenderUtils.disableItemLighting();
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)700.0f);
            InventoryOverlay.InventoryRenderType type = InventoryOverlay.getInventoryType(stack);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, items.size());
            x += 8;
            y -= props.height + 18;
            if (stack.method_7909() instanceof class_1747 && ((class_1747)stack.method_7909()).method_7711() instanceof class_2480) {
                RenderUtils.setShulkerboxBackgroundTintColor((class_2480)((class_1747)stack.method_7909()).method_7711(), useBgColors);
            } else {
                RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
            }
            InventoryOverlay.renderInventoryBackground(type, x, y, props.slotsPerRow, items.size(), RenderUtils.mc());
            RenderUtils.enableGuiItemLighting();
            GlStateManager.enableDepthTest();
            GlStateManager.enableRescaleNormal();
            class_1263 inv = InventoryUtils.getAsInventory(items);
            InventoryOverlay.renderInventoryStacks(type, inv, x + props.slotOffsetX, y + props.slotOffsetY, props.slotsPerRow, 0, -1, RenderUtils.mc());
            GlStateManager.disableDepthTest();
            GlStateManager.popMatrix();
        }
    }

    public static void setShulkerboxBackgroundTintColor(@Nullable class_2480 block, boolean useBgColors) {
        if (block != null && useBgColors) {
            class_1767 dye = block.method_10528() != null ? block.method_10528() : class_1767.field_7945;
            float[] colors = dye.method_7787();
            RenderUtils.color(colors[0], colors[1], colors[2], 1.0f);
        } else {
            RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static void renderModelInGui(int x, int y, class_1087 model, class_2680 state, float zLevel) {
        if (state.method_11614() == class_2246.field_10124) {
            return;
        }
        GlStateManager.pushMatrix();
        RenderUtils.bindTexture(class_1059.field_5275);
        RenderUtils.mc().method_1531().method_4619(class_1059.field_5275).method_4626(false, false);
        GlStateManager.enableRescaleNormal();
        GlStateManager.enableAlphaTest();
        GlStateManager.alphaFunc((int)516, (float)0.1f);
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderUtils.color(1.0f, 1.0f, 1.0f, 1.0f);
        RenderUtils.setupGuiTransform(x, y, model.method_4712(), zLevel);
        GlStateManager.rotatef((float)30.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)225.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scalef((float)0.625f, (float)0.625f, (float)0.625f);
        RenderUtils.renderModel(model, state);
        RenderUtils.mc().method_1531().method_4619(class_1059.field_5275).method_4627();
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.disableLighting();
        GlStateManager.popMatrix();
    }

    public static void setupGuiTransform(int xPosition, int yPosition, boolean isGui3d, float zLevel) {
        GlStateManager.translatef((float)xPosition, (float)yPosition, (float)(100.0f + zLevel));
        GlStateManager.translatef((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.scalef((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.scalef((float)16.0f, (float)16.0f, (float)16.0f);
        if (isGui3d) {
            GlStateManager.enableLighting();
        } else {
            GlStateManager.disableLighting();
        }
    }

    private static void renderModel(class_1087 model, class_2680 state) {
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        int color = -1;
        if (!model.method_4713()) {
            class_289 tessellator = class_289.method_1348();
            class_287 bufferbuilder = tessellator.method_1349();
            bufferbuilder.method_1328(7, class_290.field_1590);
            for (class_2350 face : class_2350.values()) {
                RAND.setSeed(0L);
                RenderUtils.renderQuads(bufferbuilder, model.method_4707(state, face, RAND), state, color);
            }
            RAND.setSeed(0L);
            RenderUtils.renderQuads(bufferbuilder, model.method_4707(state, null, RAND), state, color);
            tessellator.method_1350();
        }
        GlStateManager.popMatrix();
    }

    private static void renderQuads(class_287 renderer, List<class_777> quads, class_2680 state, int color) {
        int quadCount = quads.size();
        for (int i = 0; i < quadCount; ++i) {
            class_777 quad = quads.get(i);
            RenderUtils.renderQuad(renderer, quad, state, -1);
        }
    }

    private static void renderQuad(class_287 buffer, class_777 quad, class_2680 state, int color) {
        buffer.method_1333(quad.method_3357());
        buffer.method_1332(color);
        if (quad.method_3360()) {
            class_324 blockColors = RenderUtils.mc().method_1505();
            int m = blockColors.method_1697(state, null, null, quad.method_3359());
            float r = (float)(m >>> 16 & 0xFF) / 255.0f;
            float g = (float)(m >>> 8 & 0xFF) / 255.0f;
            float b = (float)(m & 0xFF) / 255.0f;
            buffer.method_1317(r, g, b, 4);
            buffer.method_1317(r, g, b, 3);
            buffer.method_1317(r, g, b, 2);
            buffer.method_1317(r, g, b, 1);
        }
        RenderUtils.putQuadNormal(buffer, quad);
    }

    private static void putQuadNormal(class_287 renderer, class_777 quad) {
        class_2382 direction = quad.method_3358().method_10163();
        renderer.method_1318((float)direction.method_10263(), (float)direction.method_10264(), (float)direction.method_10260());
    }

    private static class_310 mc() {
        return class_310.method_1551();
    }
}

