/*
 * Decompiled with CFR 0.152.
 */
package github.io.lucunji.explayerenderer.config;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigBase;
import fi.dy.masa.malilib.config.options.ConfigBoolean;
import fi.dy.masa.malilib.config.options.ConfigDouble;
import fi.dy.masa.malilib.config.options.ConfigHotkey;
import fi.dy.masa.malilib.config.options.ConfigString;
import java.util.ArrayList;
import java.util.List;

public class Configs {
    public static final ConfigHotkey MENU_OPEN_KEY = Category.PARAMETERS.add(new ConfigHotkey("openMenuKey", "F8", "explayerenderer.gui.settings.open_key"));
    public static final ConfigBoolean SPECTATOR_AUTO_SWITCH = Category.PARAMETERS.add(new ConfigBoolean("spectatorAutoSwitch", true, "explayerenderer.gui.settings.spectator_auto_switch.desc"));
    public static final ConfigString PLAYER_NAME = Category.PARAMETERS.add(new ConfigString("playerName", "", "explayerenderer.gui.settings.player_name.desc"));
    public static final ConfigDouble OFFSET_X = Category.PARAMETERS.add(new ConfigDouble("offsetX", 0.05, -0.5, 1.5, "explayerenderer.gui.settings.offset_x.desc"));
    public static final ConfigDouble OFFSET_Y = Category.PARAMETERS.add(new ConfigDouble("offsetY", 1.5, -0.5, 2.5, "explayerenderer.gui.settings.offset_y.desc"));
    public static final ConfigDouble ROTATION_X = Category.PARAMETERS.add(new ConfigDouble("rotationX", 0.0, -180.0, 180.0, "explayerenderer.gui.settings.rotation_x.desc"));
    public static final ConfigDouble ROTATION_Y = Category.PARAMETERS.add(new ConfigDouble("rotationY", 0.0, -180.0, 180.0, "explayerenderer.gui.settings.rotation_y.desc"));
    public static final ConfigDouble ROTATION_Z = Category.PARAMETERS.add(new ConfigDouble("rotationZ", 0.0, -180.0, 180.0, "explayerenderer.gui.settings.rotation_z.desc"));
    public static final ConfigDouble SIZE = Category.PARAMETERS.add(new ConfigDouble("size", 0.5, 0.0, 2.0, "explayerenderer.gui.settings.size.desc"));
    public static final ConfigBoolean MIRROR = Category.PARAMETERS.add(new ConfigBoolean("mirror", false, "explayerenderer.gui.settings.mirror.desc"));
    public static final ConfigDouble PITCH_MIN = Category.PARAMETERS.add(new ConfigDouble("pitchMin", -20.0, -180.0, 180.0, "explayerenderer.gui.settings.pitch_min.desc"));
    public static final ConfigDouble PITCH_MAX = Category.PARAMETERS.add(new ConfigDouble("pitchMax", 20.0, -180.0, 180.0, "explayerenderer.gui.settings.pitch_max.desc"));
    public static final ConfigDouble PITCH_OFFSET = Category.PARAMETERS.add(new ConfigDouble("pitchOffset", 0.0, -90.0, 90.0, "explayerenderer.gui.settings.pitch_offset.desc"));
    public static final ConfigDouble HEAD_YAW_MIN = Category.PARAMETERS.add(new ConfigDouble("headYawMin", -15.0, -180.0, 180.0, "explayerenderer.gui.settings.head_yaw_min.desc"));
    public static final ConfigDouble HEAD_YAW_MAX = Category.PARAMETERS.add(new ConfigDouble("headYawMax", -15.0, -180.0, 180.0, "explayerenderer.gui.settings.head_yaw_max.desc"));
    public static final ConfigDouble BODY_YAW_MIN = Category.PARAMETERS.add(new ConfigDouble("bodyYawMin", 0.0, -180.0, 180.0, "explayerenderer.gui.settings.body_yaw_min.desc"));
    public static final ConfigDouble BODY_YAW_MAX = Category.PARAMETERS.add(new ConfigDouble("bodyYawMax", 0.0, -180.0, 180.0, "explayerenderer.gui.settings.body_yaw_max.desc"));
    public static final ConfigDouble SNEAKING_OFFSET_Y = Category.PARAMETERS.add(new ConfigDouble("sneakingYOffset", -30.0, -100.0, 100.0, "explayerenderer.gui.settings.sneaking_y_offset.desc"));
    public static final ConfigDouble ELYTRA_OFFSET_Y = Category.PARAMETERS.add(new ConfigDouble("elytraYOffset", -120.0, -300.0, 300.0, "explayerenderer.gui.settings.elytra_y_offset.desc"));
    public static final ConfigBoolean HURT_FLASH = Category.DETAILS.add(new ConfigBoolean("hurtFlash", true, "explayerenderer.gui.settings.hurt_flash.desc"));
    public static final ConfigBoolean SWING_HANDS = Category.DETAILS.add(new ConfigBoolean("swingHands", true, "explayerenderer.gui.settings.swing_hands.desc"));
    public static final ConfigDouble LIGHT_DEGREE = Category.DETAILS.add(new ConfigDouble("lightDegree", 0.0, -180.0, 180.0, "explayerenderer.gui.settings.light_degree.desc"));

    public static enum Category {
        PARAMETERS("explayerenderer.gui.settings.parameters"),
        DETAILS("explayerenderer.gui.settings.details");

        private final String key;
        private final List<IConfigBase> configs;

        private Category(String key) {
            this.key = key;
            this.configs = new ArrayList<IConfigBase>();
        }

        protected <T extends IConfigBase> T add(T config) {
            this.configs.add(config);
            return config;
        }

        public List<IConfigBase> getConfigs() {
            return ImmutableList.copyOf(this.configs);
        }

        public String getKey() {
            return this.key;
        }
    }
}

