/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.gui.wrappers;

import fi.dy.masa.malilib.gui.GuiTextFieldGeneric;
import fi.dy.masa.malilib.gui.interfaces.ITextFieldListener;

public class TextFieldWrapper<T extends GuiTextFieldGeneric> {
    private final T textField;
    private final ITextFieldListener<T> listener;

    public TextFieldWrapper(T textField, ITextFieldListener<T> listener) {
        this.textField = textField;
        this.listener = listener;
    }

    public T getTextField() {
        return this.textField;
    }

    public ITextFieldListener<T> getListener() {
        return this.listener;
    }

    public boolean isFocused() {
        return this.textField.isFocused();
    }

    public void setFocused(boolean isFocused) {
        ((GuiTextFieldGeneric)((Object)this.textField)).setFocused(isFocused);
    }

    public void onGuiClosed() {
        if (this.listener != null) {
            this.listener.onGuiClosed(this.textField);
        }
    }

    public void draw(int mouseX, int mouseY) {
        ((GuiTextFieldGeneric)((Object)this.textField)).render(mouseX, mouseY, 0.0f);
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        return ((GuiTextFieldGeneric)((Object)this.textField)).mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean onKeyTyped(int keyCode, int scanCode, int modifiers) {
        String textPre = this.textField.method_1882();
        if (this.textField.isFocused() && this.textField.keyPressed(keyCode, scanCode, modifiers)) {
            if (!(this.listener == null || keyCode != 257 && keyCode != 258 && this.textField.method_1882().equals(textPre))) {
                this.listener.onTextChange(this.textField);
            }
            return true;
        }
        return false;
    }

    public boolean onCharTyped(char charIn, int modifiers) {
        String textPre = this.textField.method_1882();
        if (this.textField.isFocused() && this.textField.charTyped(charIn, modifiers)) {
            if (this.listener != null && !this.textField.method_1882().equals(textPre)) {
                this.listener.onTextChange(this.textField);
            }
            return true;
        }
        return false;
    }
}

