/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapControls;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapPerformance;
import com.mamiyaotaru.voxelmap.gui.GuiRadarOptions;
import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMapOptions;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class GuiMinimapOptions
extends GuiScreenMinimap {
    private class_437 parent;
    private IVoxelMap master;
    private static EnumOptionsMinimap[] relevantOptions;
    private final MapSettingsManager options;
    protected String screenTitle = "Minimap Options";

    public GuiMinimapOptions(class_437 parent, IVoxelMap master) {
        this.parent = parent;
        this.master = master;
        this.options = master.getMapOptions();
    }

    public void init() {
        relevantOptions = new EnumOptionsMinimap[]{EnumOptionsMinimap.COORDS, EnumOptionsMinimap.HIDE, EnumOptionsMinimap.LOCATION, EnumOptionsMinimap.SIZE, EnumOptionsMinimap.SQUARE, EnumOptionsMinimap.ROTATES, EnumOptionsMinimap.BEACONS, EnumOptionsMinimap.CAVEMODE};
        int var2 = 0;
        this.screenTitle = I18nUtils.getString("options.minimap.title", new Object[0]);
        for (int t = 0; t < relevantOptions.length; ++t) {
            final EnumOptionsMinimap option = relevantOptions[t];
            GuiOptionButtonMinimap var7 = new GuiOptionButtonMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, this.options.getKeyText(option), null){

                public void onPress() {
                    GuiMinimapOptions.this.actionPerformed(this, option.returnEnumOrdinal());
                }
            };
            this.addButton((class_339)var7);
            if (option.equals((Object)EnumOptionsMinimap.CAVEMODE)) {
                var7.active = this.options.cavesAllowed;
            }
            ++var2;
        }
        class_4185 radarOptionsButton = new class_4185(this.getWidth() / 2 - 155, this.getHeight() / 6 + 120 - 6, 150, 20, I18nUtils.getString("options.minimap.radar", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 101);
            }
        };
        radarOptionsButton.active = this.master.getRadarOptions().radarAllowed != false || this.master.getRadarOptions().radarMobsAllowed != false || this.master.getRadarOptions().radarPlayersAllowed != false;
        this.addButton((class_339)radarOptionsButton);
        this.addButton((class_339)new class_4185(this.getWidth() / 2 + 5, this.getHeight() / 6 + 120 - 6, 150, 20, I18nUtils.getString("options.minimap.detailsperformance", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 103);
            }
        });
        this.addButton((class_339)new class_4185(this.getWidth() / 2 - 155, this.getHeight() / 6 + 144 - 6, 150, 20, I18nUtils.getString("options.controls", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 102);
            }
        });
        this.addButton((class_339)new class_4185(this.getWidth() / 2 + 5, this.getHeight() / 6 + 144 - 6, 150, 20, I18nUtils.getString("options.minimap.worldmap", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 100);
            }
        });
        this.addButton((class_339)new class_4185(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20, I18nUtils.getString("gui.done", new Object[0]), null){

            public void onPress() {
                GuiMinimapOptions.this.actionPerformed(this, 200);
            }
        });
    }

    protected void actionPerformed(class_4185 par1GuiButton, int id) {
        if (par1GuiButton.active) {
            if (id < 100 && par1GuiButton instanceof GuiOptionButtonMinimap) {
                this.options.setOptionValue(((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions(), 1);
                par1GuiButton.setMessage(this.options.getKeyText(EnumOptionsMinimap.getEnumOptions(id)));
                if (((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions() == EnumOptionsMinimap.OLDNORTH) {
                    this.master.getWaypointManager().setOldNorth(this.options.oldNorth);
                }
            }
            if (id == 103) {
                this.getMinecraft().method_1507((class_437)new GuiMinimapPerformance(this, this.master));
            }
            if (id == 102) {
                this.getMinecraft().method_1507((class_437)new GuiMinimapControls(this, this.master));
            }
            if (id == 101) {
                this.getMinecraft().method_1507((class_437)new GuiRadarOptions(this, this.master));
            }
            if (id == 100) {
                this.getMinecraft().method_1507((class_437)new GuiPersistentMapOptions(this, this.master));
            }
            if (id == 200) {
                this.getMinecraft().method_1507(this.parent);
            }
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.renderBackground();
        this.drawCenteredString(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
    }
}

