/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiSlotWaypoints;
import com.mamiyaotaru.voxelmap.gui.GuiWaypointsOptions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2874;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class GuiWaypoints
extends GuiScreenMinimap
implements IGuiWaypoints {
    private final class_437 parentScreen;
    private IVoxelMap master;
    protected final MapSettingsManager options;
    protected final IWaypointManager waypointManager;
    protected String screenTitle = "Waypoints";
    private GuiSlotWaypoints waypointList;
    private class_4185 buttonEdit;
    private boolean editClicked = false;
    private class_4185 buttonDelete;
    private boolean deleteClicked = false;
    private class_4185 buttonHighlight;
    private class_4185 buttonShare;
    private class_4185 buttonTeleport;
    private class_4185 buttonSortName;
    private class_4185 buttonSortCreated;
    private class_4185 buttonSortDistance;
    private class_4185 buttonSortColor;
    protected class_342 filter;
    private boolean addClicked = false;
    private String tooltip = null;
    protected Waypoint selectedWaypoint = null;
    protected Waypoint highlightedWaypoint = null;
    protected Waypoint newWaypoint = null;
    private Random generator = new Random();
    private boolean changedSort = false;
    private final int EDIT = -1;
    private final int DELETE = -2;
    private final int HIGHLIGHT = -3;
    private final int TELEPORT = -4;
    private final int SHARE = -5;
    private final int NEW = -6;
    private final int OPTIONS = -7;

    public GuiWaypoints(class_437 parentScreen, IVoxelMap master) {
        this.master = master;
        this.parentScreen = parentScreen;
        this.options = master.getMapOptions();
        this.waypointManager = master.getWaypointManager();
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
    }

    public void tick() {
        this.filter.method_1865();
    }

    public void init() {
        boolean isSomethingSelected;
        this.screenTitle = I18nUtils.getString("minimap.waypoints.title", new Object[0]);
        this.getMinecraft().field_1774.method_1462(true);
        this.waypointList = new GuiSlotWaypoints(this);
        this.buttonSortName = new class_4185(this.getWidth() / 2 - 154, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.options.getClass();
                GuiWaypoints.this.actionPerformed(this, 2);
            }
        };
        this.addButton((class_339)this.buttonSortName);
        this.buttonSortDistance = new class_4185(this.getWidth() / 2 - 77, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.options.getClass();
                GuiWaypoints.this.actionPerformed(this, 3);
            }
        };
        this.addButton((class_339)this.buttonSortDistance);
        this.buttonSortCreated = new class_4185(this.getWidth() / 2, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.options.getClass();
                GuiWaypoints.this.actionPerformed(this, 1);
            }
        };
        this.addButton((class_339)this.buttonSortCreated);
        this.buttonSortColor = new class_4185(this.getWidth() / 2 + 77, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.options.getClass();
                GuiWaypoints.this.actionPerformed(this, 4);
            }
        };
        this.addButton((class_339)this.buttonSortColor);
        int filterStringWidth = this.getFontRenderer().method_1727(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":");
        this.filter = new class_342(this.getFontRenderer(), this.getWidth() / 2 - 153 + filterStringWidth + 5, this.getHeight() - 80, 305 - filterStringWidth - 5, 20, "");
        this.filter.method_1880(35);
        this.addButton((class_339)this.filter);
        this.buttonEdit = new class_4185(this.getWidth() / 2 - 154, this.getHeight() - 52, 74, 20, I18nUtils.getString("selectServer.edit", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -1);
            }
        };
        this.addButton((class_339)this.buttonEdit);
        this.buttonDelete = new class_4185(this.getWidth() / 2 - 76, this.getHeight() - 52, 74, 20, I18nUtils.getString("selectServer.delete", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -2);
            }
        };
        this.addButton((class_339)this.buttonDelete);
        this.buttonHighlight = new class_4185(this.getWidth() / 2 + 2, this.getHeight() - 52, 74, 20, I18nUtils.getString("minimap.waypoints.highlight", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -3);
            }
        };
        this.addButton((class_339)this.buttonHighlight);
        this.buttonTeleport = new class_4185(this.getWidth() / 2 + 80, this.getHeight() - 52, 74, 20, I18nUtils.getString("minimap.waypoints.teleportto", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -4);
            }
        };
        this.addButton((class_339)this.buttonTeleport);
        this.buttonShare = new class_4185(this.getWidth() / 2 - 154, this.getHeight() - 28, 74, 20, I18nUtils.getString("minimap.waypoints.share", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -5);
            }
        };
        this.addButton((class_339)this.buttonShare);
        this.addButton((class_339)new class_4185(this.getWidth() / 2 - 76, this.getHeight() - 28, 74, 20, I18nUtils.getString("minimap.waypoints.newwaypoint", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -6);
            }
        });
        this.addButton((class_339)new class_4185(this.getWidth() / 2 + 2, this.getHeight() - 28, 74, 20, I18nUtils.getString("menu.options", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -7);
            }
        });
        this.addButton((class_339)new class_4185(this.getWidth() / 2 + 80, this.getHeight() - 28, 74, 20, I18nUtils.getString("gui.done", new Object[0]), null){

            public void onPress() {
                GuiWaypoints.this.actionPerformed(this, -200);
            }
        });
        this.setFocused((class_364)this.filter);
        this.filter.method_1876(true);
        this.buttonEdit.active = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.active = isSomethingSelected;
        this.buttonHighlight.active = isSomethingSelected;
        this.buttonShare.active = isSomethingSelected;
        this.buttonTeleport.active = isSomethingSelected && this.canTeleport();
        this.sort();
    }

    private void sort() {
        int sortKey = Math.abs(this.options.sort);
        boolean ascending = this.options.sort > 0;
        this.waypointList.sortBy(sortKey, ascending);
        String arrow = ascending ? "\u2191" : "\u2193";
        this.options.getClass();
        if (sortKey == 2) {
            this.buttonSortName.setMessage(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]) + " " + arrow);
        } else {
            this.buttonSortName.setMessage(I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]));
        }
        this.options.getClass();
        if (sortKey == 3) {
            this.buttonSortDistance.setMessage(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]) + " " + arrow);
        } else {
            this.buttonSortDistance.setMessage(I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]));
        }
        this.options.getClass();
        if (sortKey == 1) {
            this.buttonSortCreated.setMessage(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]) + " " + arrow);
        } else {
            this.buttonSortCreated.setMessage(I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]));
        }
        this.options.getClass();
        if (sortKey == 4) {
            this.buttonSortColor.setMessage(arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]) + " " + arrow);
        } else {
            this.buttonSortColor.setMessage(I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]));
        }
    }

    protected void actionPerformed(class_4185 par1GuiButton, int id) {
        if (par1GuiButton.active) {
            String var2;
            if (id > 0) {
                this.options.setSort(id);
                this.changedSort = true;
                this.sort();
            }
            if (id == -1) {
                this.editWaypoint(this.selectedWaypoint);
            }
            if (id == -2 && (var2 = this.selectedWaypoint.name) != null) {
                this.deleteClicked = true;
                String title = I18nUtils.getString("minimap.waypoints.deleteconfirm", new Object[0]);
                class_2588 explanation = new class_2588("selectServer.deleteWarning", new Object[]{var2});
                String affirm = I18nUtils.getString("selectServer.deleteButton", new Object[0]);
                String deny = I18nUtils.getString("gui.cancel", new Object[0]);
                class_410 var8 = new class_410((BooleanConsumer)this, (class_2561)new class_2585(title), (class_2561)explanation, affirm, deny);
                this.getMinecraft().method_1507((class_437)var8);
            }
            if (id == -3) {
                this.setHighlightedWaypoint();
            }
            if (id == -5) {
                CommandUtils.sendWaypoint(this.selectedWaypoint);
            }
            if (id == -4) {
                boolean mp;
                boolean bl = mp = !this.minecraft.method_1496();
                int y = this.selectedWaypoint.getY() > 0 ? this.selectedWaypoint.getY() : (this.options.game.field_1724.field_6026 != class_2874.field_13076 ? 128 : 64);
                this.options.game.field_1724.method_3142("/tp " + this.options.game.field_1724.method_5477().getString() + " " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                if (mp) {
                    this.options.game.field_1724.method_3142("/tppos " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                }
                this.getMinecraft().method_1507((class_437)null);
            }
            if (id == -6) {
                this.addWaypoint();
            }
            if (id == -7) {
                this.getMinecraft().method_1507((class_437)new GuiWaypointsOptions(this, this.options));
            }
            if (id == -200) {
                this.getMinecraft().method_1507(this.parentScreen);
            }
        }
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        boolean OK = super.keyPressed(keysm, scancode, b);
        if (this.filter.isFocused()) {
            this.waypointList.updateFilter(this.filter.method_1882().toLowerCase());
        }
        return OK;
    }

    public boolean charTyped(char character, int keycode) {
        boolean OK = super.charTyped(character, keycode);
        if (this.filter.isFocused()) {
            this.waypointList.updateFilter(this.filter.method_1882().toLowerCase());
        }
        return OK;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.waypointList.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.waypointList.mouseReleased(mouseX, mouseY, mouseButton);
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        return this.waypointList.mouseDragged(mouseX, mouseY, mouseEvent, deltaX, deltaY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double amount) {
        return this.waypointList.mouseScrolled(mouseX, mouseY, amount);
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void accept(boolean par1) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
            this.getMinecraft().method_1507((class_437)this);
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (par1) {
                this.waypointManager.saveWaypoints();
            }
            this.getMinecraft().method_1507((class_437)this);
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (par1) {
                this.waypointManager.addWaypoint(this.newWaypoint);
                this.setSelectedWaypoint(this.newWaypoint);
            }
            this.getMinecraft().method_1507((class_437)this);
        }
    }

    protected void setSelectedWaypoint(Waypoint waypoint) {
        boolean isSomethingSelected;
        this.selectedWaypoint = waypoint;
        this.buttonEdit.active = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.active = isSomethingSelected;
        this.buttonHighlight.active = isSomethingSelected;
        this.buttonHighlight.setMessage(I18nUtils.getString(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight", new Object[0]));
        this.buttonShare.active = isSomethingSelected;
        this.buttonTeleport.active = isSomethingSelected && this.canTeleport();
    }

    protected void setHighlightedWaypoint() {
        this.waypointManager.setHighlightedWaypoint(this.selectedWaypoint, true);
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
        boolean isSomethingSelected = this.selectedWaypoint != null;
        this.buttonHighlight.setMessage(I18nUtils.getString(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight", new Object[0]));
    }

    protected void editWaypoint(Waypoint waypoint) {
        this.editClicked = true;
        this.getMinecraft().method_1507((class_437)new GuiAddWaypoint(this, this.master, waypoint, true));
    }

    protected void addWaypoint() {
        float b;
        float g;
        float r;
        this.addClicked = true;
        if (this.waypointManager.getWaypoints().size() == 0) {
            r = 0.0f;
            g = 1.0f;
            b = 0.0f;
        } else {
            r = this.generator.nextFloat();
            g = this.generator.nextFloat();
            b = this.generator.nextFloat();
        }
        TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
        dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(this.getMinecraft().field_1687.field_9247));
        this.newWaypoint = new Waypoint("", this.options.game.field_1724.field_6026 != class_2874.field_13076 ? GameVariableAccessShim.xCoord() : GameVariableAccessShim.xCoord() * 8, this.options.game.field_1724.field_6026 != class_2874.field_13076 ? GameVariableAccessShim.zCoord() : GameVariableAccessShim.zCoord() * 8, GameVariableAccessShim.yCoord(), true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
        this.getMinecraft().method_1507((class_437)new GuiAddWaypoint(this, this.master, this.newWaypoint, false));
    }

    protected void toggleWaypointVisibility() {
        this.selectedWaypoint.enabled = !this.selectedWaypoint.enabled;
        this.waypointManager.saveWaypoints();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.tooltip = null;
        this.waypointList.render(mouseX, mouseY, partialTicks);
        this.drawCenteredString(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.render(mouseX, mouseY, partialTicks);
        this.drawString(this.getFontRenderer(), I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":", this.getWidth() / 2 - 153, this.getHeight() - 75, 0xA0A0A0);
        this.filter.render(mouseX, mouseY, partialTicks);
        if (this.tooltip != null) {
            this.renderTooltip(this.tooltip, mouseX, mouseY);
        }
    }

    public void renderTooltip(String par1Str, int par2, int par3) {
        if (par1Str != null) {
            int var4 = par2 + 12;
            int var5 = par3 - 12;
            int var6 = this.getFontRenderer().method_1727(par1Str);
            this.fillGradient(var4 - 3, var5 - 3, var4 + var6 + 3, var5 + 8 + 3, -1073741824, -1073741824);
            this.getFontRenderer().method_1720(par1Str, (float)var4, (float)var5, -1);
        }
    }

    static String setTooltip(GuiWaypoints par0GuiWaypoints, String par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    public boolean canTeleport() {
        boolean allowed = false;
        boolean singlePlayer = this.options.game.method_1496();
        if (singlePlayer) {
            try {
                allowed = this.getMinecraft().method_1576().method_3760().method_14569(this.getMinecraft().field_1724.method_7334());
            }
            catch (Exception e) {
                allowed = this.getMinecraft().method_1576().method_3847(class_2874.field_13072).method_8401().method_194();
            }
        } else {
            allowed = true;
        }
        return allowed;
    }

    @Override
    public void removed() {
        this.minecraft.field_1774.method_1462(false);
        if (this.changedSort) {
            super.removed();
        }
    }
}

