/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.gui.overridden.EnumOptionsMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionButtonMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiOptionSliderMinimap;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class GuiPersistentMapOptions
extends GuiScreenMinimap {
    private final class_437 parent;
    private static EnumOptionsMinimap[] relevantOptions;
    private final PersistentMapSettingsManager options;
    protected String screenTitle = "Worldmap Options";
    protected String cacheSettings = "Zoom/Cache Settings";
    protected String warning = "Edit at your own risk";
    private static EnumOptionsMinimap[] relevantOptions2;

    public GuiPersistentMapOptions(class_437 parent, IVoxelMap master) {
        this.parent = parent;
        this.options = master.getPersistentMapOptions();
    }

    public void init() {
        EnumOptionsMinimap option;
        int t;
        relevantOptions = new EnumOptionsMinimap[]{EnumOptionsMinimap.SHOWWAYPOINTS, EnumOptionsMinimap.SHOWWAYPOINTNAMES};
        this.screenTitle = I18nUtils.getString("options.worldmap.title", new Object[0]);
        this.cacheSettings = I18nUtils.getString("options.worldmap.cachesettings", new Object[0]);
        this.warning = I18nUtils.getString("options.worldmap.warning", new Object[0]);
        int var2 = 0;
        for (t = 0; t < relevantOptions.length; ++t) {
            option = relevantOptions[t];
            GuiOptionButtonMinimap var7 = new GuiOptionButtonMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, this.options.getKeyText(option), null){

                public void onPress() {
                    GuiPersistentMapOptions.this.actionPerformed(this, option.returnEnumOrdinal());
                }
            };
            this.addButton((class_339)var7);
            ++var2;
        }
        relevantOptions2 = new EnumOptionsMinimap[]{EnumOptionsMinimap.MINZOOM, EnumOptionsMinimap.MAXZOOM, EnumOptionsMinimap.CACHESIZE};
        var2 += 2;
        for (t = 0; t < relevantOptions2.length; ++t) {
            option = relevantOptions2[t];
            if (option.isFloat()) {
                float sValue = this.options.getOptionFloatValue(option);
                float fValue = 0.0f;
                switch (option) {
                    case MINZOOM: {
                        this.options.getClass();
                        this.options.getClass();
                        this.options.getClass();
                        fValue = (sValue - -3.0f) / (float)(5 - -3);
                        break;
                    }
                    case MAXZOOM: {
                        this.options.getClass();
                        this.options.getClass();
                        this.options.getClass();
                        fValue = (sValue - -3.0f) / (float)(5 - -3);
                        break;
                    }
                    case CACHESIZE: {
                        this.options.getClass();
                        fValue = sValue / 5000.0f;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + option.getName() + ". (possibly not a float value applicable to persistent map)");
                    }
                }
                this.addButton((class_339)new GuiOptionSliderMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, fValue, this.options));
            } else {
                GuiOptionButtonMinimap var7 = new GuiOptionButtonMinimap(this.getWidth() / 2 - 155 + var2 % 2 * 160, this.getHeight() / 6 + 24 * (var2 >> 1), option, this.options.getKeyText(option), null){

                    public void onPress() {
                        GuiPersistentMapOptions.this.actionPerformed(this, option.returnEnumOrdinal());
                    }
                };
                this.addButton((class_339)var7);
            }
            ++var2;
        }
        this.addButton((class_339)new class_4185(this.getWidth() / 2 - 100, this.getHeight() / 6 + 168, 200, 20, I18nUtils.getString("gui.done", new Object[0]), buttonWidget_1 -> this.getMinecraft().method_1507(this.parent)));
        for (class_339 buttonObj : this.getButtonList()) {
            GuiOptionButtonMinimap button;
            if (!(buttonObj instanceof GuiOptionButtonMinimap) || !(button = (GuiOptionButtonMinimap)buttonObj).returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWWAYPOINTNAMES)) continue;
            button.active = this.options.showWaypoints;
        }
    }

    protected void actionPerformed(class_4185 par1GuiButton, int id) {
        if (par1GuiButton.active && id < 100 && par1GuiButton instanceof GuiOptionButtonMinimap) {
            this.options.setOptionValue(((GuiOptionButtonMinimap)par1GuiButton).returnEnumOptions(), 1);
            par1GuiButton.setMessage(this.options.getKeyText(EnumOptionsMinimap.getEnumOptions(id)));
            for (class_339 buttonObj : this.getButtonList()) {
                GuiOptionButtonMinimap button;
                if (!(buttonObj instanceof GuiOptionButtonMinimap) || !(button = (GuiOptionButtonMinimap)buttonObj).returnEnumOptions().equals((Object)EnumOptionsMinimap.SHOWWAYPOINTNAMES)) continue;
                button.active = this.options.showWaypoints;
            }
        }
    }

    public void render(int par1, int par2, float par3) {
        for (class_339 buttonObj : this.getButtonList()) {
            if (!(buttonObj instanceof GuiOptionSliderMinimap)) continue;
            GuiOptionSliderMinimap slider = (GuiOptionSliderMinimap)buttonObj;
            EnumOptionsMinimap option = slider.returnEnumOptions();
            float sValue = this.options.getOptionFloatValue(option);
            float fValue = 0.0f;
            switch (option) {
                case MINZOOM: {
                    this.options.getClass();
                    this.options.getClass();
                    this.options.getClass();
                    fValue = (sValue - -3.0f) / (float)(5 - -3);
                    break;
                }
                case MAXZOOM: {
                    this.options.getClass();
                    this.options.getClass();
                    this.options.getClass();
                    fValue = (sValue - -3.0f) / (float)(5 - -3);
                    break;
                }
                case CACHESIZE: {
                    this.options.getClass();
                    fValue = sValue / 5000.0f;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Add code to handle EnumOptionMinimap: " + option.getName() + ". (possibly not a float value applicable to persistent map)");
                }
            }
            if (this.getFocused() == slider) continue;
            slider.setValue(fValue);
        }
        super.drawMap();
        this.renderBackground();
        this.drawCenteredString(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        this.drawCenteredString(this.getFontRenderer(), this.cacheSettings, this.getWidth() / 2, this.getHeight() / 6 + 24, 0xFFFFFF);
        this.drawCenteredString(this.getFontRenderer(), this.warning, this.getWidth() / 2, this.getHeight() / 6 + 34, 0xFFFFFF);
        super.render(par1, par2, par3);
    }
}

