/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import net.minecraft.class_1060;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_311;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class GLUtils {
    private static class_289 tessellator = class_289.method_1348();
    private static class_287 vertexBuffer = tessellator.method_1349();
    public static class_1060 textureManager;
    public static int fboID;
    public static boolean openGL14Enabled;
    private static final boolean fboEnabledExt;
    private static final boolean fboEnabledArb;
    private static final boolean fboEnabledBase;
    public static final boolean fboEnabled;
    public static int fboTextureID;
    private static int previousFBOID;
    public static boolean hasAlphaBits;
    private static final IntBuffer dataBuffer;

    public static void setupFrameBuffer() {
        if (fboEnabledBase) {
            GLUtils.setupFrameBufferBASE();
        } else if (fboEnabledArb) {
            GLUtils.setupFrameBufferARB();
        } else if (fboEnabledExt) {
            GLUtils.setupFrameBufferEXT();
        }
    }

    private static void setupFrameBufferBASE() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = GL30.glGenFramebuffers();
        fboTextureID = GL11.glGenTextures();
        int width = 256;
        int height = 256;
        GL30.glBindFramebuffer((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GLShim.glBindTexture(3553, fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        int depthRenderBufferID = GL30.glGenRenderbuffers();
        GL30.glBindRenderbuffer((int)36161, (int)depthRenderBufferID);
        GL30.glRenderbufferStorage((int)36161, (int)33190, (int)256, (int)256);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)depthRenderBufferID);
        GL30.glBindRenderbuffer((int)36161, (int)0);
        GL30.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void setupFrameBufferARB() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = ARBFramebufferObject.glGenFramebuffers();
        fboTextureID = GL11.glGenTextures();
        int width = 256;
        int height = 256;
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GLShim.glBindTexture(3553, fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        ARBFramebufferObject.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        int depthRenderBufferID = ARBFramebufferObject.glGenRenderbuffers();
        ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)depthRenderBufferID);
        ARBFramebufferObject.glRenderbufferStorage((int)36161, (int)33190, (int)256, (int)256);
        ARBFramebufferObject.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)depthRenderBufferID);
        ARBFramebufferObject.glBindRenderbuffer((int)36161, (int)0);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void setupFrameBufferEXT() {
        previousFBOID = GL11.glGetInteger((int)36006);
        fboID = EXTFramebufferObject.glGenFramebuffersEXT();
        fboTextureID = GL11.glGenTextures();
        int width = 256;
        int height = 256;
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)fboID);
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)(4 * width * height));
        GLShim.glBindTexture(3553, fboTextureID);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)6408, (int)5120, (ByteBuffer)byteBuffer);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)fboTextureID, (int)0);
        int depthRenderBufferID = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)depthRenderBufferID);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)33190, (int)256, (int)256);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)36096, (int)36161, (int)depthRenderBufferID);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)0);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)previousFBOID);
    }

    public static void bindFrameBuffer() {
        if (fboEnabledBase) {
            GLUtils.bindFrameBufferBASE();
        } else if (fboEnabledArb) {
            GLUtils.bindFrameBufferARB();
        } else if (fboEnabledExt) {
            GLUtils.bindFrameBufferEXT();
        }
    }

    private static void bindFrameBufferBASE() {
        previousFBOID = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)fboID);
    }

    private static void bindFrameBufferARB() {
        previousFBOID = GL11.glGetInteger((int)36006);
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)fboID);
    }

    private static void bindFrameBufferEXT() {
        previousFBOID = GL11.glGetInteger((int)36006);
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)fboID);
    }

    public static void unbindFrameBuffer() {
        if (fboEnabledBase) {
            GLUtils.unbindFrameBufferBASE();
        } else if (fboEnabledArb) {
            GLUtils.unbindFrameBufferARB();
        } else if (fboEnabledExt) {
            GLUtils.unbindFrameBufferEXT();
        }
    }

    private static void unbindFrameBufferBASE() {
        GL30.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void unbindFrameBufferARB() {
        ARBFramebufferObject.glBindFramebuffer((int)36160, (int)previousFBOID);
    }

    private static void unbindFrameBufferEXT() {
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)previousFBOID);
    }

    public static void setMap(int x, int y) {
        GLUtils.setMap(x, y, 128);
    }

    public static void setMapWithScale(int x, int y, float scale) {
        GLUtils.setMap(x, y, (int)(128.0f * scale));
    }

    public static void setMap(int x, float y, int imageSize) {
        float scale = (float)imageSize / 4.0f;
        GLUtils.ldrawthree((float)x - scale, y + scale, 1.0, 0.0, 1.0);
        GLUtils.ldrawthree((float)x + scale, y + scale, 1.0, 1.0, 1.0);
        GLUtils.ldrawthree((float)x + scale, y - scale, 1.0, 1.0, 0.0);
        GLUtils.ldrawthree((float)x - scale, y - scale, 1.0, 0.0, 0.0);
    }

    public static void setMap(Sprite icon, int x, float y, float imageSize) {
        float scale = imageSize / 4.0f;
        GLUtils.ldrawthree((float)x - scale, y + scale, 1.0, icon.getMinU(), icon.getMaxV());
        GLUtils.ldrawthree((float)x + scale, y + scale, 1.0, icon.getMaxU(), icon.getMaxV());
        GLUtils.ldrawthree((float)x + scale, y - scale, 1.0, icon.getMaxU(), icon.getMinV());
        GLUtils.ldrawthree((float)x - scale, y - scale, 1.0, icon.getMinU(), icon.getMinV());
    }

    public static int tex(BufferedImage paramImg) {
        int glid = GLShim.glGenTextures();
        int width = paramImg.getWidth();
        int height = paramImg.getHeight();
        int[] imageData = new int[width * height];
        paramImg.getRGB(0, 0, width, height, imageData, 0, width);
        GLShim.glBindTexture(3553, glid);
        dataBuffer.clear();
        dataBuffer.put(imageData, 0, width * height);
        dataBuffer.position(0).limit(width * height);
        GlStateManager.pixelStore((int)3314, (int)0);
        GlStateManager.pixelStore((int)3316, (int)0);
        GlStateManager.pixelStore((int)3315, (int)0);
        GLShim.glTexImage2D(3553, 0, 6408, width, height, 0, 32993, 33639, dataBuffer);
        return glid;
    }

    public static void img(String paramStr) {
        textureManager.method_4618(new class_2960(paramStr));
    }

    public static void img(class_2960 paramResourceLocation) {
        textureManager.method_4618(paramResourceLocation);
    }

    public static void disp(int paramInt) {
        GlStateManager.bindTexture((int)paramInt);
    }

    public static void drawPre() {
        vertexBuffer.method_1328(7, class_290.field_1585);
    }

    public static void drawPre(class_293 vertexFormat) {
        vertexBuffer.method_1328(7, vertexFormat);
    }

    public static void drawPost() {
        tessellator.method_1350();
    }

    public static void glah(int g) {
        GLShim.glDeleteTextures(g);
    }

    public static void ldrawone(int x, int y, double z, double u, double v) {
        vertexBuffer.method_1315((double)x, (double)y, z).method_1312(u, v).method_1344();
    }

    public static void ldrawtwo(double x, double y, double z) {
        vertexBuffer.method_1315(x, y, z).method_1344();
    }

    public static void ldrawthree(double x, double y, double z, double u, double v) {
        vertexBuffer.method_1315(x, y, z).method_1312(u, v).method_1344();
    }

    static {
        fboID = 0;
        openGL14Enabled = GL.getCapabilities().OpenGL14;
        fboEnabledExt = GL.getCapabilities().GL_EXT_framebuffer_object && openGL14Enabled;
        fboEnabledArb = GL.getCapabilities().GL_ARB_framebuffer_object;
        fboEnabledBase = GL.getCapabilities().OpenGL30;
        fboEnabled = fboEnabledExt || fboEnabledArb || fboEnabledBase;
        fboTextureID = 0;
        previousFBOID = 0;
        hasAlphaBits = GL11.glGetInteger((int)3413) > 0;
        dataBuffer = class_311.method_1596((int)0x1000000).asIntBuffer();
    }
}

