/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.google.common.base.Charsets;
import com.mamiyaotaru.voxelmap.ColorManager;
import com.mamiyaotaru.voxelmap.Map;
import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.Radar;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSimple;
import com.mamiyaotaru.voxelmap.SettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.WaypointManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.interfaces.IMap;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.persistent.PersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.DimensionManager;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TickCounter;
import com.mamiyaotaru.voxelmap.util.WorldUpdateListener;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2596;
import net.minecraft.class_2817;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_303;
import net.minecraft.class_310;
import net.minecraft.class_3258;
import net.minecraft.class_3296;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_338;
import net.minecraft.class_3695;
import net.minecraft.class_3902;
import net.minecraft.class_638;

public class VoxelMap
extends AbstractVoxelMap
implements class_3302 {
    private MapSettingsManager mapOptions = null;
    private RadarSettingsManager radarOptions = null;
    private PersistentMapSettingsManager persistentMapOptions = null;
    private IMap map = null;
    private IRadar radar = null;
    private IRadar radarSimple = null;
    private PersistentMap persistentMap = null;
    private ISettingsAndLightingChangeNotifier settingsAndLightingChangeNotifier = null;
    private WorldUpdateListener worldUpdateListener = null;
    private IColorManager colorManager = null;
    private IWaypointManager waypointManager = null;
    private IDimensionManager dimensionManager = null;
    private class_638 world;
    private String worldName = "";
    private Long newServerTime = 0L;
    private boolean checkMOTD = false;
    private class_303 mostRecentLine = null;
    private UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");
    private String passMessage = null;
    private class_3258 zipPack = null;

    public VoxelMap() {
        instance = this;
    }

    public void lateInit(boolean showUnderMenus, boolean isFair) {
        CodeSource src;
        if (!class_310.method_1551().method_1478().method_14487().contains("voxelmap") && (src = VoxelMap.class.getProtectionDomain().getCodeSource()) != null) {
            URL jar = src.getLocation();
            File pack = new File(jar.getFile());
            this.zipPack = new class_3258(pack);
        }
        GLUtils.textureManager = class_310.method_1551().method_1531();
        this.mapOptions = new MapSettingsManager();
        this.mapOptions.showUnderMenus = showUnderMenus;
        this.radarOptions = new RadarSettingsManager();
        this.mapOptions.addSecondaryOptionsManager(this.radarOptions);
        this.persistentMapOptions = new PersistentMapSettingsManager();
        this.mapOptions.addSecondaryOptionsManager(this.persistentMapOptions);
        BiomeRepository.loadBiomeColors();
        this.colorManager = new ColorManager(this);
        this.waypointManager = new WaypointManager(this);
        this.dimensionManager = new DimensionManager(this);
        this.persistentMap = new PersistentMap(this);
        this.mapOptions.loadAll();
        try {
            if (isFair) {
                this.radarOptions.radarAllowed = false;
                this.radarOptions.radarMobsAllowed = false;
                this.radarOptions.radarPlayersAllowed = false;
            } else {
                this.radarOptions.radarAllowed = true;
                this.radarOptions.radarMobsAllowed = true;
                this.radarOptions.radarPlayersAllowed = true;
                this.radar = new Radar(this);
                this.radarSimple = new RadarSimple(this);
            }
        }
        catch (Exception e) {
            this.radarOptions.radarAllowed = false;
            this.radarOptions.radarMobsAllowed = false;
            this.radarOptions.radarPlayersAllowed = false;
            this.radar = null;
            this.radarSimple = null;
        }
        this.map = new Map(this);
        this.settingsAndLightingChangeNotifier = new SettingsAndLightingChangeNotifier();
        this.worldUpdateListener = new WorldUpdateListener();
        this.worldUpdateListener.addListener(this.map);
        this.worldUpdateListener.addListener(this.persistentMap);
        class_3296 resourceManager = (class_3296)class_310.method_1551().method_1478();
        resourceManager.method_14477((class_3302)this);
        this.apply((class_3300)resourceManager);
    }

    public CompletableFuture<Void> reload(class_3302.class_4045 synchronizer, class_3300 resourceManager, class_3695 loadProfiler, class_3695 applyProfiler, Executor loadExecutor, Executor applyExecutor) {
        return synchronizer.method_18352((Object)class_3902.field_17274).thenRunAsync(() -> this.apply(resourceManager), applyExecutor);
    }

    private CompletableFuture<Void> apply(class_3300 resourceManager) {
        this.waypointManager.onResourceManagerReload(resourceManager);
        if (this.radar != null) {
            this.radar.onResourceManagerReload(resourceManager);
        }
        if (this.radarSimple != null) {
            this.radarSimple.onResourceManagerReload(resourceManager);
        }
        this.colorManager.onResourceManagerReload(resourceManager);
        return null;
    }

    public void onTickInGame(class_310 mc) {
        this.map.onTickInGame(mc);
        if (this.passMessage != null) {
            mc.field_1705.method_1743().method_1812((class_2561)new class_2585(this.passMessage));
            this.passMessage = null;
        }
    }

    public void onTick(class_310 mc) {
        if (this.checkMOTD) {
            this.checkPermissionMessages(mc);
        }
        if (GameVariableAccessShim.getWorld() != null && !GameVariableAccessShim.getWorld().equals(this.world) || this.world != null && !this.world.equals(GameVariableAccessShim.getWorld())) {
            this.world = GameVariableAccessShim.getWorld();
            this.waypointManager.newWorld((class_1937)this.world);
            this.persistentMap.newWorld(this.world);
            if (this.world != null) {
                StringBuilder channelList = new StringBuilder();
                channelList.append("worldinfo:world_id");
                class_2540 buffer = new class_2540(Unpooled.buffer());
                buffer.writeBytes(channelList.toString().getBytes(Charsets.UTF_8));
                mc.method_1562().method_2883((class_2596)new class_2817(new class_2960("minecraft:register"), buffer));
                ByteBuf data1 = Unpooled.buffer((int)4);
                data1.writeInt(42);
                class_2540 packetBuffer1 = new class_2540(data1);
                class_2817 packet1 = new class_2817(new class_2960("worldinfo:world_id"), packetBuffer1);
                mc.field_1724.field_3944.method_2883((class_2596)packet1);
                ByteBuf data2 = Unpooled.buffer((int)4);
                data2.writeInt(43);
                class_2540 packetBuffer2 = new class_2540(data2);
                class_2817 packet2 = new class_2817(new class_2960("journeymap:world_info"), packetBuffer2);
                mc.field_1724.method_3117();
                java.util.Map skinMap = mc.method_1582().method_4654(mc.field_1724.method_7334());
                if (skinMap.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    mc.method_1582().method_4656((MinecraftProfileTexture)skinMap.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                }
                if (!this.worldName.equals(this.waypointManager.getCurrentWorldName())) {
                    this.worldName = this.waypointManager.getCurrentWorldName();
                    this.radarOptions.radarPlayersAllowed = this.radarOptions.radarAllowed = Boolean.valueOf(true);
                    this.radarOptions.radarMobsAllowed = this.radarOptions.radarAllowed;
                    this.mapOptions.cavesAllowed = true;
                    if (!mc.method_1496()) {
                        this.newServerTime = System.currentTimeMillis();
                        this.checkMOTD = true;
                    }
                }
                this.map.newWorld(this.world);
            }
        }
        TickCounter.onTick();
        this.persistentMap.onTick(mc);
    }

    private void checkPermissionMessages(class_310 mc) {
        if (GameVariableAccessShim.getWorld() != null && mc.field_1724 != null && mc.field_1705 != null && System.currentTimeMillis() - this.newServerTime < 5000L) {
            UUID playerUUID = mc.field_1724.method_5667();
            class_338 guiNewChat = mc.field_1705.method_1743();
            if (guiNewChat == null) {
                System.out.println("failed to get guiNewChat");
            } else {
                Object chatListObj = ReflectionUtils.getPrivateFieldValueByType(guiNewChat, class_338.class, List.class, 1);
                if (chatListObj == null) {
                    System.out.println("could not get chatlist");
                } else {
                    class_303 checkMe;
                    List chatList = (List)chatListObj;
                    boolean killRadar = false;
                    boolean killCaves = false;
                    for (int t = 0; t < chatList.size() && !(checkMe = (class_303)chatList.get(t)).equals(this.mostRecentLine); ++t) {
                        String msg = checkMe.method_1412().method_10863();
                        String error = "";
                        if ((msg = msg.replaceAll("\u00a7r", "")).contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7d")) {
                            killCaves = true;
                            error = error + "Server disabled cavemapping.  ";
                        }
                        if (msg.contains("\u00a73 \u00a76 \u00a73 \u00a76 \u00a73 \u00a76 \u00a7e")) {
                            killRadar = true;
                            error = error + "Server disabled radar.  ";
                        }
                        if (error.equals("")) continue;
                        this.passMessage = error;
                    }
                    this.radarOptions.radarPlayersAllowed = this.radarOptions.radarAllowed = Boolean.valueOf(this.radarOptions.radarAllowed != false && (!killRadar || this.devUUID.equals(playerUUID)));
                    this.radarOptions.radarMobsAllowed = this.radarOptions.radarAllowed;
                    this.mapOptions.cavesAllowed = this.mapOptions.cavesAllowed != false && (!killCaves || this.devUUID.equals(playerUUID));
                    this.mostRecentLine = chatList.size() > 0 ? (class_303)chatList.get(0) : null;
                }
            }
        } else if (System.currentTimeMillis() - this.newServerTime >= 5000L) {
            this.checkMOTD = false;
        }
    }

    @Override
    public MapSettingsManager getMapOptions() {
        return this.mapOptions;
    }

    @Override
    public RadarSettingsManager getRadarOptions() {
        return this.radarOptions;
    }

    @Override
    public PersistentMapSettingsManager getPersistentMapOptions() {
        return this.persistentMapOptions;
    }

    @Override
    public IMap getMap() {
        return this.map;
    }

    @Override
    public ISettingsAndLightingChangeNotifier getSettingsAndLightingChangeNotifier() {
        return this.settingsAndLightingChangeNotifier;
    }

    @Override
    public IRadar getRadar() {
        if (this.radarOptions.showRadar) {
            if (this.radarOptions.radarMode == this.radarOptions.SIMPLE) {
                return this.radarSimple;
            }
            if (this.radarOptions.radarMode == this.radarOptions.FULL) {
                return this.radar;
            }
        }
        return null;
    }

    @Override
    public IColorManager getColorManager() {
        return this.colorManager;
    }

    @Override
    public IWaypointManager getWaypointManager() {
        return this.waypointManager;
    }

    @Override
    public IDimensionManager getDimensionManager() {
        return this.dimensionManager;
    }

    @Override
    public IPersistentMap getPersistentMap() {
        return this.persistentMap;
    }

    @Override
    public void setPermissions(boolean hasFullRadarPermission, boolean hasPlayersOnRadarPermission, boolean hasMobsOnRadarPermission, boolean hasCavemodePermission) {
        boolean override = false;
        try {
            UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");
            UUID playerUUID = class_310.method_1551().field_1724.method_5667();
            override = playerUUID.equals(devUUID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.radarOptions.radarAllowed = hasFullRadarPermission || override;
        this.radarOptions.radarPlayersAllowed = hasPlayersOnRadarPermission || override;
        this.radarOptions.radarMobsAllowed = hasMobsOnRadarPermission || override;
        this.mapOptions.cavesAllowed = hasCavemodePermission || override;
    }

    @Override
    public synchronized void newSubWorldName(String name, boolean fromServer) {
        this.waypointManager.setSubworldName(name, fromServer);
        this.map.newWorldName();
    }

    @Override
    public synchronized void newSubWorldHash(String hash) {
        this.waypointManager.setSubworldHash(hash);
    }

    @Override
    public String getWorldSeed() {
        if (class_310.method_1551().method_1496()) {
            String seed = "";
            try {
                seed = Long.toString(class_310.method_1551().method_1576().method_3847(class_2874.field_13072).method_8412());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return seed;
        }
        return this.waypointManager.getWorldSeed();
    }

    @Override
    public void setWorldSeed(String newSeed) {
        if (!class_310.method_1551().method_1496()) {
            this.waypointManager.setWorldSeed(newSeed);
        }
    }

    @Override
    public void sendPlayerMessageOnMainThread(String s) {
        this.passMessage = s;
    }

    @Override
    public WorldUpdateListener getWorldUpdateListener() {
        return this.worldUpdateListener;
    }
}

