/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.fabricmod;

import com.mamiyaotaru.voxelmap.VoxelMap;
import com.mamiyaotaru.voxelmap.fabricmod.FabricModVoxelMapBootstrapper;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.nio.charset.StandardCharsets;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2658;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_4587;

public class FabricModVoxelMap
implements ClientModInitializer {
    public static FabricModVoxelMap instance;
    private boolean initialized = false;
    private VoxelMap master = null;

    public FabricModVoxelMap(FabricModVoxelMapBootstrapper riftModVoxelMap) {
        instance = this;
        this.master = new VoxelMap();
    }

    public void onInitializeClient() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("voxelmap", "assets_listener");
            }

            public void method_14491(class_3300 var1) {
                System.out.println("Reloading (should run as #1)");
            }
        });
    }

    public void lateInit() {
        this.initialized = true;
        this.master.lateInit(true, false);
    }

    public void clientTick(class_310 client) {
        if (!this.initialized) {
            boolean OK = true;
            if (I18nUtils.getString("minimap.ui.welcome2", new Object[0]).equals("minimap.ui.welcome2")) {
                OK = false;
            }
            if (class_310.method_1551() == null || client.method_1478() == null || client.method_1531() == null) {
                OK = false;
            }
            if (OK) {
                this.lateInit();
            }
        }
        if (this.initialized) {
            this.master.onTick(client);
        }
    }

    public void renderOverlay() {
        if (!this.initialized) {
            this.lateInit();
        }
        this.master.onTickInGame(class_310.method_1551());
    }

    public boolean onChat(class_2561 chat) {
        return CommandUtils.checkForWaypoints(chat, "");
    }

    public boolean onSendChatMessage(String message) {
        if (message.startsWith("/newWaypoint")) {
            CommandUtils.waypointClicked(message);
            return false;
        }
        if (message.startsWith("/ztp")) {
            CommandUtils.teleport(message);
            return false;
        }
        return true;
    }

    public static void onRenderHand(float partialTicks, long timeSlice, class_4587 matrixStack) {
        try {
            FabricModVoxelMap.instance.master.getWaypointManager().renderWaypoints(partialTicks, matrixStack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onShutDown() {
        System.out.print("Saving all world maps");
        FabricModVoxelMap.instance.master.getPersistentMap().purgeCachedRegions();
        FabricModVoxelMap.instance.master.getMapOptions().saveAll();
        BiomeRepository.saveBiomeColors();
        long shutdownTime = System.currentTimeMillis();
        while (ThreadManager.executorService.getQueue().size() + ThreadManager.executorService.getActiveCount() > 0 && System.currentTimeMillis() - shutdownTime < 10000L) {
            System.out.print(".");
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println();
    }

    public boolean handleCustomPayload(class_2658 packet) {
        if (packet != null && packet.method_11456() != null) {
            String channel = packet.method_11456().method_12832();
            class_2540 buffer = packet.method_11458();
            if (channel.equals("world_info") || channel.equals("world_id")) {
                byte id = buffer.readByte();
                byte length = buffer.readByte();
                byte[] bytes = new byte[length];
                buffer.readBytes(bytes);
                String subWorldName = new String(bytes, StandardCharsets.UTF_8);
                this.master.newSubWorldName(subWorldName, true);
                return true;
            }
        }
        return false;
    }
}

