/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiSelectPlayer;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class GuiButtonRowListPlayers
extends class_350 {
    private final class_310 client = class_310.method_1551();
    private ArrayList<class_640> players;
    private ArrayList<class_640> playersFiltered;
    final GuiSelectPlayer parentGui;
    Row everyoneRow;

    public GuiButtonRowListPlayers(GuiSelectPlayer par1GuiSelectPlayer) {
        super(class_310.method_1551(), par1GuiSelectPlayer.getWidth(), par1GuiSelectPlayer.getHeight(), 89, par1GuiSelectPlayer.getHeight() - 65 + 4, 25);
        this.parentGui = par1GuiSelectPlayer;
        class_634 netHandlerPlayClient = class_310.method_1551().field_1724.field_3944;
        this.players = new ArrayList(netHandlerPlayClient.method_2880());
        this.sort();
        class_4185 everyoneButton = new class_4185(this.parentGui.getWidth() / 2 - 75, 0, 150, 20, I18nUtils.getString("minimap.waypointshare.all", new Object[0]), null){

            public void onPress() {
            }
        };
        this.everyoneRow = new Row(everyoneButton, -1);
        this.updateFilter("");
    }

    public String getPlayerName(class_640 ScoreboardEntryIn) {
        return ScoreboardEntryIn.method_2971() != null ? ScoreboardEntryIn.method_2971().getString() : TextUtils.scrubCodes(ScoreboardEntryIn.method_2966().getName());
    }

    private class_4185 createButtonFor(class_310 mcIn, int x, int y, class_640 ScoreboardEntry) {
        if (ScoreboardEntry == null) {
            return null;
        }
        String name = this.getPlayerName(ScoreboardEntry);
        return new class_4185(x, y, 150, 20, name, null){

            public void onPress() {
            }
        };
    }

    public Row getListEntry(int index) {
        return this.getListEntry(index);
    }

    public int getRowWidth() {
        return 400;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 32;
    }

    protected void sort() {
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(this.players, new Comparator<class_640>(){

            @Override
            public int compare(class_640 player1, class_640 player2) {
                String name1 = GuiButtonRowListPlayers.this.getPlayerName(player1);
                String name2 = GuiButtonRowListPlayers.this.getPlayerName(player2);
                return collator.compare(name1, name2);
            }
        });
    }

    protected void updateFilter(String filterString) {
        this.playersFiltered = new ArrayList<class_640>(this.players);
        Iterator<class_640> iterator = this.playersFiltered.iterator();
        while (iterator.hasNext()) {
            class_640 ScoreboardEntry = iterator.next();
            String name = this.getPlayerName(ScoreboardEntry);
            if (name.toLowerCase().contains(filterString)) continue;
            iterator.remove();
        }
        this.clearEntries();
        this.addEntry(this.everyoneRow);
        for (int i = 0; i < this.playersFiltered.size(); i += 2) {
            class_640 ScoreboardEntry1 = this.playersFiltered.get(i);
            class_640 ScoreboardEntry2 = i < this.playersFiltered.size() - 1 ? this.playersFiltered.get(i + 1) : null;
            class_4185 guibutton1 = this.createButtonFor(this.client, this.parentGui.getWidth() / 2 - 155, 0, ScoreboardEntry1);
            class_4185 guibutton2 = this.createButtonFor(this.client, this.parentGui.getWidth() / 2 - 155 + 160, 0, ScoreboardEntry2);
            this.addEntry(new Row(guibutton1, i, guibutton2, i + 1));
        }
    }

    public void buttonClicked(int id) {
        if (id == -1) {
            this.parentGui.allClicked = true;
            class_2585 title = new class_2585(I18nUtils.getString("minimap.waypointshare.sharewitheveryone", new Object[0]));
            class_2585 explanation = new class_2585(I18nUtils.getString("minimap.waypointshare.sharewitheveryone2", new Object[0]));
            String affirm = I18nUtils.getString("gui.yes", new Object[0]);
            String deny = I18nUtils.getString("gui.cancel", new Object[0]);
            class_410 confirmScreen = new class_410((BooleanConsumer)this.parentGui, (class_2561)title, (class_2561)explanation, affirm, deny);
            this.client.method_1507((class_437)confirmScreen);
        } else {
            class_640 ScoreboardEntry = this.playersFiltered.get(id);
            String name = this.getPlayerName(ScoreboardEntry);
            this.parentGui.sendMessageToPlayer(name);
        }
    }

    public class Row
    extends class_350.class_351 {
        private final class_310 client = class_310.method_1551();
        private class_4185 button = null;
        private class_4185 button1 = null;
        private class_4185 button2 = null;
        private int id = 0;
        private int id1 = 0;
        private int id2 = 0;

        public Row(class_4185 button, int id) {
            this.button = button;
            this.id = id;
        }

        public Row(class_4185 button1, int id1, class_4185 button2, int id2) {
            this.button1 = button1;
            this.id1 = id1;
            this.button2 = button2;
            this.id2 = id2;
        }

        public void render(int slotIndex, int y, int x, int listWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.drawButton(this.button, this.id, slotIndex, x, y, listWidth, itemHeight, mouseX, mouseY, isSelected, partialTicks);
            this.drawButton(this.button1, this.id1, slotIndex, x, y, listWidth, itemHeight, mouseX, mouseY, isSelected, partialTicks);
            this.drawButton(this.button2, this.id2, slotIndex, x, y, listWidth, itemHeight, mouseX, mouseY, isSelected, partialTicks);
        }

        private void drawButton(class_4185 button, int id, int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            if (button != null) {
                button.y = y;
                button.render(mouseX, mouseY, partialTicks);
                if (id != -1) {
                    this.drawIconForButton(button, id);
                }
                if (button.isHovered() && mouseY >= GuiButtonRowListPlayers.this.field_19085 && mouseY <= GuiButtonRowListPlayers.this.field_19086) {
                    String tooltip = I18nUtils.getString("minimap.waypointshare.sharewithname", button.getMessage());
                    GuiSelectPlayer.setTooltip(GuiButtonRowListPlayers.this.parentGui, tooltip);
                }
            }
        }

        private void drawIconForButton(class_4185 button, int id) {
            class_640 networkPlayerInfo = (class_640)GuiButtonRowListPlayers.this.playersFiltered.get(id);
            GameProfile gameProfile = networkPlayerInfo.method_2966();
            class_1657 entityPlayer = this.client.field_1687.method_18470(gameProfile.getId());
            this.client.method_1531().method_22813(networkPlayerInfo.method_2968());
            class_437.blit((int)(button.x + 6), (int)(button.y + 6), (int)8, (int)8, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            if (entityPlayer != null && entityPlayer.method_7348(class_1664.field_7563)) {
                class_437.blit((int)(button.x + 6), (int)(button.y + 6), (int)8, (int)8, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseEvent) {
            if (this.button != null && this.button.mouseClicked(mouseX, mouseY, mouseEvent)) {
                GuiButtonRowListPlayers.this.buttonClicked(this.id);
                return true;
            }
            if (this.button1 != null && this.button1.mouseClicked(mouseX, mouseY, mouseEvent)) {
                GuiButtonRowListPlayers.this.buttonClicked(this.id1);
                return true;
            }
            if (this.button2 != null && this.button2.mouseClicked(mouseX, mouseY, mouseEvent)) {
                GuiButtonRowListPlayers.this.buttonClicked(this.id2);
                return true;
            }
            return false;
        }

        public boolean mouseReleased(double mouseX, double mouseY, int mouseEvent) {
            if (this.button != null) {
                this.button.mouseReleased(mouseX, mouseY, mouseEvent);
                return true;
            }
            if (this.button1 != null) {
                this.button1.mouseReleased(mouseX, mouseY, mouseEvent);
                return true;
            }
            if (this.button2 != null) {
                this.button2.mouseReleased(mouseX, mouseY, mouseEvent);
                return true;
            }
            return false;
        }
    }
}

