/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapOptions;
import com.mamiyaotaru.voxelmap.gui.GuiSubworldsSelect;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiButton;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiScreen;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.persistent.CachedRegion;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BackgroundImageInfo;
import com.mamiyaotaru.voxelmap.util.BiomeMapData;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import net.minecraft.class_1046;
import net.minecraft.class_1068;
import net.minecraft.class_1664;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_2874;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_642;
import net.minecraft.class_742;
import org.lwjgl.glfw.GLFW;

public class GuiPersistentMap
extends PopupGuiScreen
implements IGuiWaypoints {
    private class_310 mc;
    private Random generator = new Random();
    private IVoxelMap master;
    private IPersistentMap persistentMap;
    private IWaypointManager waypointManager;
    private final class_437 parent;
    private final MapSettingsManager mapOptions;
    private final PersistentMapSettingsManager options;
    protected String screenTitle = "World Map";
    protected String worldNameDisplay = "";
    protected int worldNameDisplayLength = 0;
    protected int maxWorldNameDisplayLength = 0;
    private String subworldName = "";
    private PopupGuiButton buttonMultiworld;
    private int top;
    private int bottom;
    private boolean oldNorth = false;
    private boolean lastStill = false;
    private boolean editingCoordinates = false;
    private boolean lastEditingCoordinates = false;
    private class_342 coordinates;
    int centerX = 0;
    int centerY = 0;
    float mapCenterX = 0.0f;
    float mapCenterZ = 0.0f;
    float deltaX = 0.0f;
    float deltaY = 0.0f;
    float deltaXonRelease = 0.0f;
    float deltaYonRelease = 0.0f;
    long timeOfRelease = 0L;
    boolean mouseCursorShown = true;
    long timeAtLastTick = 0L;
    long timeOfLastKBInput = 0L;
    long timeOfLastMouseInput = 0L;
    final float TIME_CONSTANT = 350.0f;
    float lastMouseX = 0.0f;
    float lastMouseY = 0.0f;
    protected int mouseX;
    protected int mouseY;
    boolean leftMouseButtonDown = false;
    float zoom = 4.0f;
    float zoomStart = 4.0f;
    float zoomGoal = 4.0f;
    long timeOfZoom = 0L;
    float zoomDirectX = 0.0f;
    float zoomDirectY = 0.0f;
    private float scScale = 1.0f;
    private float guiToMap = 2.0f;
    private float mapToGui = 0.5f;
    private float mouseDirectToMap = 1.0f;
    private float guiToDirectMouse = 2.0f;
    private static int playerGLID = 0;
    private static boolean gotSkin = false;
    private static int skinTries = 0;
    private boolean closed = false;
    private CachedRegion[] regions = new CachedRegion[0];
    BackgroundImageInfo backGroundImageInfo = null;
    private BiomeMapData biomeMapData = new BiomeMapData(760, 360);
    private float mapPixelsX = 0.0f;
    private float mapPixelsY = 0.0f;
    private final Object closedLock = new Object();
    private class_304 keyBindForward = new class_304("key.forward.fake", 17, "key.categories.movement");
    private class_304 keyBindLeft = new class_304("key.left.fake", 30, "key.categories.movement");
    private class_304 keyBindBack = new class_304("key.back.fake", 31, "key.categories.movement");
    private class_304 keyBindRight = new class_304("key.right.fake", 32, "key.categories.movement");
    private class_304 keyBindSprint = new class_304("key.sprint.fake", 29, "key.categories.movement");
    private class_3675.class_306 forwardCode;
    private class_3675.class_306 leftCode;
    private class_3675.class_306 backCode;
    private class_3675.class_306 rightCode;
    private class_3675.class_306 sprintCode;
    class_3675.class_306 nullInput = class_3675.method_15981((String)"key.keyboard.unknown");
    private final int NEW = 0;
    private final int HIGHLIGHT = 1;
    private final int SHARE = 2;
    private final int TELEPORT = 3;
    private final int EDIT = 4;
    private final int DELETE = 5;
    private String multiworldButtonName = "";
    int sideMargin = 10;
    int buttonCount = 5;
    int buttonSeparation = 4;
    int buttonWidth = 66;
    public boolean editClicked = false;
    public boolean deleteClicked = false;
    public boolean addClicked = false;
    Waypoint newWaypoint;
    Waypoint selectedWaypoint;

    public GuiPersistentMap(class_437 parent, IVoxelMap master) {
        this.mc = class_310.method_1551();
        this.parent = parent;
        this.master = master;
        this.waypointManager = master.getWaypointManager();
        this.mapOptions = master.getMapOptions();
        this.persistentMap = master.getPersistentMap();
        this.options = master.getPersistentMapOptions();
        this.zoom = this.options.zoom;
        this.zoomStart = this.options.zoom;
        this.zoomGoal = this.options.zoom;
        this.persistentMap.setLightMapArray(master.getMap().getLightmapArray());
        if (!gotSkin && skinTries < 5) {
            this.getSkin();
        }
        this.forwardCode = class_3675.method_15981((String)this.mc.field_1690.field_1894.method_1428());
        this.leftCode = class_3675.method_15981((String)this.mc.field_1690.field_1913.method_1428());
        this.backCode = class_3675.method_15981((String)this.mc.field_1690.field_1881.method_1428());
        this.rightCode = class_3675.method_15981((String)this.mc.field_1690.field_1849.method_1428());
        this.sprintCode = class_3675.method_15981((String)this.mc.field_1690.field_1867.method_1428());
    }

    private void getSkin() {
        class_2960 skinLocation = this.mc.field_1724.method_3117();
        class_1046 imageData = null;
        try {
            if (skinLocation != class_1068.method_4648((UUID)this.mc.field_1724.method_5667())) {
                imageData = class_742.method_3120((class_2960)skinLocation, (String)TextUtils.scrubCodes(this.mc.field_1724.method_5477().method_10863()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (imageData != null) {
            gotSkin = true;
            GLUtils.disp(imageData.method_4624());
        } else {
            ++skinTries;
            GLUtils.img(skinLocation);
        }
        BufferedImage skinImage = ImageUtils.createBufferedImageFromCurrentGLImage();
        boolean showHat = this.mc.field_1724.method_7348(class_1664.field_7563);
        skinImage = showHat ? ImageUtils.addImages(ImageUtils.loadImage(skinImage, 8, 8, 8, 8), ImageUtils.loadImage(skinImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8) : ImageUtils.loadImage(skinImage, 8, 8, 8, 8);
        float scale = (float)skinImage.getWidth() / 8.0f;
        skinImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(skinImage, 2.0f / scale)), true, 1);
        if (playerGLID != 0) {
            GLUtils.glah(playerGLID);
        }
        playerGLID = GLUtils.tex(skinImage);
    }

    public void init() {
        this.passEvents = true;
        this.oldNorth = this.mapOptions.oldNorth;
        this.centerAt(this.options.mapX, this.options.mapZ);
        this.mc.field_1774.method_1462(true);
        if (this.getMinecraft().field_1755 == this) {
            this.closed = false;
        }
        this.screenTitle = I18nUtils.getString("worldmap.title", new Object[0]);
        this.buildWorldName();
        this.leftMouseButtonDown = false;
        this.sideMargin = 10;
        this.buttonCount = 5;
        this.buttonSeparation = 4;
        this.buttonWidth = (this.width - this.sideMargin * 2 - this.buttonSeparation * (this.buttonCount - 1)) / this.buttonCount;
        this.addButton((class_339)new PopupGuiButton(this.sideMargin + 0 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, I18nUtils.getString("options.minimap.waypoints", new Object[0]), buttonWidget_1 -> this.getMinecraft().method_1507((class_437)new GuiWaypoints(this, this.master)), this));
        String string = this.multiworldButtonName = this.getMinecraft().method_1589() ? I18nUtils.getString("menu.online", new Object[0]) : I18nUtils.getString("options.worldmap.multiworld", new Object[0]);
        if (!this.getMinecraft().method_1496() && !this.master.getWaypointManager().receivedAutoSubworldName()) {
            this.buttonMultiworld = new PopupGuiButton(this.sideMargin + 1 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, this.multiworldButtonName, buttonWidget_1 -> this.getMinecraft().method_1507((class_437)new GuiSubworldsSelect(this, this.master)), this);
            this.addButton((class_339)this.buttonMultiworld);
        }
        this.addButton((class_339)new PopupGuiButton(this.sideMargin + 3 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, I18nUtils.getString("menu.options", new Object[0]), null, this){

            public void onPress() {
                GuiPersistentMap.this.getMinecraft().method_1507((class_437)new GuiMinimapOptions(GuiPersistentMap.this, GuiPersistentMap.this.master));
            }
        });
        this.addButton((class_339)new PopupGuiButton(this.sideMargin + 4 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, I18nUtils.getString("gui.done", new Object[0]), null, this){

            public void onPress() {
                GuiPersistentMap.this.getMinecraft().method_1507(GuiPersistentMap.this.parent);
            }
        });
        this.coordinates = new class_342(this.getFontRenderer(), this.sideMargin, 10, 140, 20, "");
        this.top = 32;
        this.bottom = this.getHeight() - 32;
        this.centerX = this.getWidth() / 2;
        this.centerY = (this.bottom - this.top) / 2;
        this.scScale = (float)this.mc.method_22683().method_4495();
        this.mapPixelsX = this.mc.method_22683().method_4489();
        this.mapPixelsY = this.mc.method_22683().method_4506() - (int)(64.0f * this.scScale);
        this.lastStill = false;
        this.timeAtLastTick = System.currentTimeMillis();
        this.keyBindForward.method_1422(this.forwardCode);
        this.keyBindLeft.method_1422(this.leftCode);
        this.keyBindBack.method_1422(this.backCode);
        this.keyBindRight.method_1422(this.rightCode);
        this.keyBindSprint.method_1422(this.sprintCode);
        this.mc.field_1690.field_1894.method_1422(this.nullInput);
        this.mc.field_1690.field_1913.method_1422(this.nullInput);
        this.mc.field_1690.field_1881.method_1422(this.nullInput);
        this.mc.field_1690.field_1849.method_1422(this.nullInput);
        this.mc.field_1690.field_1867.method_1422(this.nullInput);
        class_304.method_1426();
    }

    private void centerAt(int x, int z) {
        if (this.oldNorth) {
            this.mapCenterX = -z;
            this.mapCenterZ = x;
        } else {
            this.mapCenterX = x;
            this.mapCenterZ = z;
        }
    }

    private void buildWorldName() {
        String subworldName;
        String worldName = "";
        if (this.mc.method_1496()) {
            worldName = this.mc.method_1576().method_3726();
            if (worldName == null || worldName.equals("")) {
                worldName = "Singleplayer World";
            }
        } else {
            class_642 serverData = this.mc.method_1558();
            if (serverData != null) {
                worldName = serverData.field_3752;
            }
            if (worldName == null || worldName.equals("")) {
                worldName = "Multiplayer Server";
            }
            if (this.minecraft.method_1589()) {
                worldName = "Realms";
            }
        }
        StringBuilder worldNameBuilder = new StringBuilder("\u00a7r").append(worldName);
        this.subworldName = subworldName = this.master.getWaypointManager().getCurrentSubworldDescriptor(true);
        if ((subworldName == null || subworldName.equals("")) && this.master.getWaypointManager().isMultiworld()) {
            subworldName = "???";
        }
        if (subworldName != null && !subworldName.equals("")) {
            worldNameBuilder.append(" - ").append(subworldName);
        }
        this.worldNameDisplay = worldNameBuilder.toString();
        this.worldNameDisplayLength = this.getFontRenderer().method_1727(this.worldNameDisplay);
        this.maxWorldNameDisplayLength = this.getWidth() / 2 - this.getFontRenderer().method_1727(this.screenTitle) / 2 - this.sideMargin * 2;
        while (this.worldNameDisplayLength > this.maxWorldNameDisplayLength && worldName.length() > 5) {
            worldName = worldName.substring(0, worldName.length() - 1);
            worldNameBuilder = new StringBuilder(worldName);
            worldNameBuilder.append("...");
            if (subworldName != null && !subworldName.equals("")) {
                worldNameBuilder.append(" - ").append(subworldName);
            }
            this.worldNameDisplay = worldNameBuilder.toString();
            this.worldNameDisplayLength = this.getFontRenderer().method_1727(this.worldNameDisplay);
        }
        if (subworldName != null && !subworldName.equals("")) {
            while (this.worldNameDisplayLength > this.maxWorldNameDisplayLength && subworldName.length() > 5) {
                worldNameBuilder = new StringBuilder(worldName);
                worldNameBuilder.append("...");
                subworldName = subworldName.substring(0, subworldName.length() - 1);
                worldNameBuilder.append(" - ").append(subworldName);
                this.worldNameDisplay = worldNameBuilder.toString();
                this.worldNameDisplayLength = this.getFontRenderer().method_1727(this.worldNameDisplay);
            }
        }
    }

    private float bindZoom(float zoom) {
        zoom = Math.max(this.options.minZoom, zoom);
        zoom = Math.min(this.options.maxZoom, zoom);
        return zoom;
    }

    private float easeOut(float elapsedTime, float startValue, float finalDelta, float totalTime) {
        float value = elapsedTime == totalTime ? startValue + finalDelta : finalDelta * (-((float)Math.pow(2.0, -10.0f * elapsedTime / totalTime)) + 1.0f) + startValue;
        return value;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double mouseRoll) {
        this.timeOfLastMouseInput = System.currentTimeMillis();
        this.switchToMouseInput();
        float mouseDirectX = (float)this.mc.field_1729.method_1603();
        float mouseDirectY = (float)this.mc.field_1729.method_1604();
        if (mouseRoll != 0.0) {
            if (mouseRoll > 0.0) {
                this.zoomGoal *= 1.26f;
            } else if (mouseRoll < 0.0) {
                this.zoomGoal /= 1.26f;
            }
            this.zoomStart = this.zoom;
            this.zoomGoal = this.bindZoom(this.zoomGoal);
            this.timeOfZoom = System.currentTimeMillis();
            this.zoomDirectX = mouseDirectX;
            this.zoomDirectY = mouseDirectY;
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (mouseY > (double)this.top && mouseY < (double)this.bottom && mouseButton == 1) {
            this.timeOfLastKBInput = 0L;
            int mouseDirectX = (int)this.mc.field_1729.method_1603();
            int mouseDirectY = (int)this.mc.field_1729.method_1604();
            this.createPopup((int)mouseX, (int)mouseY, mouseDirectX, mouseDirectY);
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.popupOpen()) {
            this.coordinates.mouseClicked(mouseX, mouseY, mouseButton);
            this.editingCoordinates = this.coordinates.isFocused();
            if (this.editingCoordinates && !this.lastEditingCoordinates) {
                int x = 0;
                int z = 0;
                if (this.oldNorth) {
                    x = (int)Math.floor(this.mapCenterZ);
                    z = -((int)Math.floor(this.mapCenterX));
                } else {
                    x = (int)Math.floor(this.mapCenterX);
                    z = (int)Math.floor(this.mapCenterZ);
                }
                this.coordinates.method_1852(x + ", " + z);
                this.coordinates.method_1868(0xFFFFFF);
            }
            this.lastEditingCoordinates = this.editingCoordinates;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton) || mouseButton == 1;
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        if (!this.editingCoordinates && (this.mc.field_1690.field_1903.method_1417(keysm, scancode) || this.mc.field_1690.field_1832.method_1417(keysm, scancode))) {
            if (this.mc.field_1690.field_1903.method_1417(keysm, scancode)) {
                this.zoomGoal /= 1.26f;
            }
            if (this.mc.field_1690.field_1832.method_1417(keysm, scancode)) {
                this.zoomGoal *= 1.26f;
            }
            this.zoomStart = this.zoom;
            this.zoomGoal = this.bindZoom(this.zoomGoal);
            this.timeOfZoom = System.currentTimeMillis();
            this.zoomDirectX = this.mc.method_22683().method_4489() / 2;
            this.zoomDirectY = this.mc.method_22683().method_4506() - this.mc.method_22683().method_4506() / 2;
            this.switchToKeyboardInput();
        }
        this.clearPopups();
        if (this.editingCoordinates) {
            this.coordinates.keyPressed(keysm, scancode, b);
            boolean isGood = this.isAcceptable(this.coordinates.method_1882());
            this.coordinates.method_1868(isGood ? 0xFFFFFF : 0xFF0000);
            if ((keysm == 257 || keysm == 335) && this.coordinates.isFocused() && isGood) {
                String[] xz = this.coordinates.method_1882().split(",");
                this.centerAt(Integer.valueOf(xz[0].trim()), Integer.valueOf(xz[1].trim()));
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
            if (keysm == 258 && this.coordinates.isFocused()) {
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
        }
        if (this.master.getMapOptions().keyBindMenu.method_1417(keysm, scancode)) {
            keysm = 256;
            scancode = -1;
            b = -1;
        }
        return super.keyPressed(keysm, scancode, b);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        this.clearPopups();
        if (this.editingCoordinates) {
            this.coordinates.charTyped(typedChar, keyCode);
            boolean isGood = this.isAcceptable(this.coordinates.method_1882());
            this.coordinates.method_1868(isGood ? 0xFFFFFF : 0xFF0000);
            if (typedChar == '\r' && this.coordinates.isFocused() && isGood) {
                String[] xz = this.coordinates.method_1882().split(",");
                this.centerAt(Integer.valueOf(xz[0].trim()), Integer.valueOf(xz[1].trim()));
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
        }
        if (this.master.getMapOptions().keyBindMenu.method_1417(keyCode, -1)) {
            super.keyPressed(256, -1, -1);
        }
        return super.charTyped(typedChar, keyCode);
    }

    private boolean isAcceptable(String input) {
        try {
            String[] xz = this.coordinates.method_1882().split(",");
            Integer.valueOf(xz[0].trim());
            Integer.valueOf(xz[1].trim());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    private void switchToMouseInput() {
        this.timeOfLastKBInput = 0L;
        if (!this.mouseCursorShown) {
            GLFW.glfwSetInputMode((long)this.mc.method_22683().method_4490(), (int)208897, (int)212993);
        }
        this.mouseCursorShown = true;
    }

    private void switchToKeyboardInput() {
        this.timeOfLastKBInput = System.currentTimeMillis();
        this.mouseCursorShown = false;
        GLFW.glfwSetInputMode((long)this.mc.method_22683().method_4490(), (int)208897, (int)212995);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        float cursorCoordZ;
        float cursorCoordX;
        float cursorY;
        float cursorX;
        this.zoomGoal = this.bindZoom(this.zoomGoal);
        if (this.mouseX != mouseX || this.mouseY != mouseY) {
            this.timeOfLastMouseInput = System.currentTimeMillis();
            this.switchToMouseInput();
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        float mouseDirectX = (float)this.mc.field_1729.method_1603();
        float mouseDirectY = (float)this.mc.field_1729.method_1604();
        if (this.zoom != this.zoomGoal) {
            float previousZoom = this.zoom;
            long timeSinceZoom = System.currentTimeMillis() - this.timeOfZoom;
            this.zoom = (float)timeSinceZoom < 700.0f ? this.easeOut(timeSinceZoom, this.zoomStart, this.zoomGoal - this.zoomStart, 700.0f) : this.zoomGoal;
            float scaledZoom = this.zoom;
            if (this.mc.method_22683().method_4489() > 1600) {
                scaledZoom = this.zoom * (float)this.mc.method_22683().method_4489() / 1600.0f;
            }
            float zoomDelta = this.zoom / previousZoom;
            float zoomOffsetX = (float)this.centerX * this.guiToDirectMouse - this.zoomDirectX;
            float zoomOffsetY = (float)(this.top + this.centerY) * this.guiToDirectMouse - this.zoomDirectY;
            float zoomDeltaX = zoomOffsetX - zoomOffsetX * zoomDelta;
            float zoomDeltaY = zoomOffsetY - zoomOffsetY * zoomDelta;
            this.mapCenterX += zoomDeltaX / scaledZoom;
            this.mapCenterZ += zoomDeltaY / scaledZoom;
        }
        this.options.zoom = this.zoomGoal;
        float scaledZoom = this.zoom;
        if (this.mc.method_22683().method_4480() > 1600) {
            scaledZoom = this.zoom * (float)this.mc.method_22683().method_4480() / 1600.0f;
        }
        this.guiToMap = this.scScale / scaledZoom;
        this.mapToGui = 1.0f / this.scScale * scaledZoom;
        this.mouseDirectToMap = 1.0f / scaledZoom;
        this.guiToDirectMouse = this.scScale;
        this.renderBackground();
        if (this.mc.field_1729.method_1608()) {
            if (!this.leftMouseButtonDown && !this.overPopup(mouseX, mouseY)) {
                this.deltaX = 0.0f;
                this.deltaY = 0.0f;
                this.lastMouseX = mouseDirectX;
                this.lastMouseY = mouseDirectY;
                this.leftMouseButtonDown = true;
            } else if (this.leftMouseButtonDown) {
                this.deltaX = (this.lastMouseX - mouseDirectX) * this.mouseDirectToMap;
                this.deltaY = (this.lastMouseY - mouseDirectY) * this.mouseDirectToMap;
                this.lastMouseX = mouseDirectX;
                this.lastMouseY = mouseDirectY;
                this.deltaXonRelease = this.deltaX;
                this.deltaYonRelease = this.deltaY;
                this.timeOfRelease = System.currentTimeMillis();
            }
        } else {
            long timeSinceRelease = System.currentTimeMillis() - this.timeOfRelease;
            if ((float)timeSinceRelease < 700.0f) {
                this.deltaX = this.deltaXonRelease * (float)Math.exp((float)(-timeSinceRelease) / 350.0f);
                this.deltaY = this.deltaYonRelease * (float)Math.exp((float)(-timeSinceRelease) / 350.0f);
            } else {
                this.deltaX = 0.0f;
                this.deltaY = 0.0f;
                this.deltaXonRelease = 0.0f;
                this.deltaYonRelease = 0.0f;
            }
            this.leftMouseButtonDown = false;
        }
        long timeSinceLastTick = System.currentTimeMillis() - this.timeAtLastTick;
        this.timeAtLastTick = System.currentTimeMillis();
        if (!this.editingCoordinates) {
            int kbDelta = 5;
            if (this.keyBindSprint.method_1434()) {
                kbDelta = 10;
            }
            if (this.keyBindForward.method_1434()) {
                this.deltaY -= (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyBindBack.method_1434()) {
                this.deltaY += (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyBindLeft.method_1434()) {
                this.deltaX -= (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyBindRight.method_1434()) {
                this.deltaX += (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
        }
        this.mapCenterX += this.deltaX;
        this.mapCenterZ += this.deltaY;
        if (this.oldNorth) {
            this.options.mapX = (int)this.mapCenterZ;
            this.options.mapZ = -((int)this.mapCenterX);
        } else {
            this.options.mapX = (int)this.mapCenterX;
            this.options.mapZ = (int)this.mapCenterZ;
        }
        this.centerX = this.getWidth() / 2;
        this.centerY = (this.bottom - this.top) / 2;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (this.oldNorth) {
            left = (int)Math.floor((this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0f);
            right = (int)Math.floor((this.mapCenterZ + (float)this.centerY * this.guiToMap) / 256.0f);
            top = (int)Math.floor((-this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0f);
            bottom = (int)Math.floor((-this.mapCenterX + (float)this.centerX * this.guiToMap) / 256.0f);
        } else {
            left = (int)Math.floor((this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0f);
            right = (int)Math.floor((this.mapCenterX + (float)this.centerX * this.guiToMap) / 256.0f);
            top = (int)Math.floor((this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0f);
            bottom = (int)Math.floor((this.mapCenterZ + (float)this.centerY * this.guiToMap) / 256.0f);
        }
        Object zoomDeltaX = this.closedLock;
        synchronized (zoomDeltaX) {
            if (this.closed) {
                return;
            }
            this.regions = this.persistentMap.getRegions(left - 1, right + 1, top - 1, bottom + 1);
        }
        GLShim.glColor3f(1.0f, 1.0f, 1.0f);
        GLShim.glTranslatef((float)this.centerX - this.mapCenterX * this.mapToGui, (float)(this.top + this.centerY) - this.mapCenterZ * this.mapToGui, 0.0f);
        if (this.oldNorth) {
            GLShim.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        }
        this.backGroundImageInfo = this.waypointManager.getBackgroundImageInfo();
        if (this.backGroundImageInfo != null) {
            GLUtils.disp(this.backGroundImageInfo.glid);
            this.drawTexturedModalRect((float)this.backGroundImageInfo.left * this.mapToGui, (float)this.backGroundImageInfo.top * this.mapToGui, (float)this.backGroundImageInfo.width * this.mapToGui, (float)this.backGroundImageInfo.height * this.mapToGui);
        }
        for (int t = 0; t < this.regions.length; ++t) {
            CachedRegion region = this.regions[t];
            int glid = region.getGLID();
            if (glid == 0) continue;
            GLUtils.disp(glid);
            if (this.mapOptions.filtering) {
                GLShim.glTexParameteri(3553, 10241, 9987);
                GLShim.glTexParameteri(3553, 10240, 9729);
            } else {
                GLShim.glTexParameteri(3553, 10241, 9987);
                GLShim.glTexParameteri(3553, 10240, 9728);
            }
            this.drawTexturedModalRect((float)(region.getX() * 256) * this.mapToGui, (float)(region.getZ() * 256) * this.mapToGui, (float)region.getWidth() * this.mapToGui, (float)region.getWidth() * this.mapToGui);
        }
        if (this.mouseCursorShown) {
            cursorX = mouseDirectX;
            cursorY = mouseDirectY - (float)this.top * this.guiToDirectMouse;
        } else {
            cursorX = this.mc.method_22683().method_4489() / 2;
            cursorY = (float)(this.mc.method_22683().method_4506() - this.mc.method_22683().method_4506() / 2) - (float)this.top * this.guiToDirectMouse;
        }
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        GLShim.glEnable(3042);
        if (this.options.showWaypoints) {
            for (Waypoint pt : this.waypointManager.getWaypoints()) {
                this.drawWaypoint(pt, cursorCoordX, cursorCoordZ, null, null, null, null);
            }
            if (this.waypointManager.getHighlightedWaypoint() != null) {
                this.drawWaypoint(this.waypointManager.getHighlightedWaypoint(), cursorCoordX, cursorCoordZ, this.master.getWaypointManager().getTextureAtlas().getAtlasSprite("voxelmap:images/waypoints/target.png"), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
            }
        }
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLUtils.disp(playerGLID);
        GLShim.glTexParameteri(3553, 10241, 9729);
        GLShim.glTexParameteri(3553, 10240, 9729);
        float playerX = (float)GameVariableAccessShim.xCoordDouble();
        float playerZ = (float)GameVariableAccessShim.zCoordDouble();
        if (this.oldNorth) {
            GLShim.glPushMatrix();
            GLShim.glTranslatef(playerX * this.mapToGui, playerZ * this.mapToGui, 0.0f);
            GLShim.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
            GLShim.glTranslatef(-(playerX * this.mapToGui), -(playerZ * this.mapToGui), 0.0f);
        }
        this.drawTexturedModalRect(-10.0f / this.scScale + playerX * this.mapToGui, -10.0f / this.scScale + playerZ * this.mapToGui, 20.0f / this.scScale, 20.0f / this.scScale);
        if (this.oldNorth) {
            GLShim.glPopMatrix();
        }
        if (this.oldNorth) {
            GLShim.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
        }
        GLShim.glTranslatef(-((float)this.centerX - this.mapCenterX * this.mapToGui), -((float)(this.top + this.centerY) - this.mapCenterZ * this.mapToGui), 0.0f);
        int n = this.mapOptions.biomeOverlay;
        this.mapOptions.getClass();
        if (n != 0) {
            float biomeScaleX = this.mapPixelsX / 760.0f;
            float biomeScaleY = this.mapPixelsY / 360.0f;
            boolean still = !this.leftMouseButtonDown;
            still = still && this.zoom == this.zoomGoal;
            still = still && this.deltaX == 0.0f && this.deltaY == 0.0f;
            boolean bl = still = still && ThreadManager.executorService.getActiveCount() == 0;
            if (still && !this.lastStill) {
                int column = 0;
                column = this.oldNorth ? (int)Math.floor(Math.floor(this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0) - (left - 1) : (int)Math.floor(Math.floor(this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0) - (left - 1);
                for (int x = 0; x < this.biomeMapData.getWidth(); ++x) {
                    for (int z = 0; z < this.biomeMapData.getHeight(); ++z) {
                        float floatMapZ;
                        float floatMapX;
                        if (this.oldNorth) {
                            floatMapX = (float)z * biomeScaleY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
                            floatMapZ = -((float)x * biomeScaleX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
                        } else {
                            floatMapX = (float)x * biomeScaleX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
                            floatMapZ = (float)z * biomeScaleY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
                        }
                        int mapX = (int)Math.floor(floatMapX);
                        int mapZ = (int)Math.floor(floatMapZ);
                        int regionX = (int)Math.floor((float)mapX / 256.0f) - (left - 1);
                        int regionZ = (int)Math.floor((float)mapZ / 256.0f) - (top - 1);
                        if (!this.oldNorth && regionX != column || this.oldNorth && regionZ != column) {
                            this.persistentMap.compress();
                        }
                        column = !this.oldNorth ? regionX : regionZ;
                        CachedRegion region = this.regions[regionZ * (right + 1 - (left - 1) + 1) + regionX];
                        int id = -1;
                        if (region.getMapData() != null && region.isLoaded() && !region.isEmpty()) {
                            int inRegionX = mapX - region.getX() * region.getWidth();
                            int inRegionZ = mapZ - region.getZ() * region.getWidth();
                            int height = region.getMapData().getHeight(inRegionX, inRegionZ);
                            int light = region.getMapData().getLight(inRegionX, inRegionZ);
                            if (height != 0 || light != 0) {
                                id = region.getMapData().getBiomeID(inRegionX, inRegionZ);
                            }
                        }
                        this.biomeMapData.setBiomeID(x, z, id);
                    }
                }
                this.persistentMap.compress();
                this.biomeMapData.segmentBiomes();
                this.biomeMapData.findCenterOfSegments(true);
            }
            this.lastStill = still;
            boolean displayStill = !this.leftMouseButtonDown;
            displayStill = displayStill && this.zoom == this.zoomGoal;
            boolean bl2 = displayStill = displayStill && this.deltaX == 0.0f && this.deltaY == 0.0f;
            if (displayStill) {
                int minimumSize = (int)(20.0f * this.scScale / biomeScaleX);
                minimumSize *= minimumSize;
                ArrayList<AbstractMapData.BiomeLabel> labels = this.biomeMapData.getBiomeLabels();
                GLShim.glDisable(2929);
                for (int t = 0; t < labels.size(); ++t) {
                    AbstractMapData.BiomeLabel label = labels.get(t);
                    if (label.segmentSize <= minimumSize) continue;
                    int nameWidth = this.chkLen(label.name);
                    float x = (float)label.x * biomeScaleX / this.scScale;
                    float z = (float)label.z * biomeScaleY / this.scScale;
                    this.write(label.name, x - (float)(nameWidth / 2), (float)this.top + z - 3.0f, 0xFFFFFF);
                }
                GLShim.glEnable(2929);
            }
        }
        if (System.currentTimeMillis() - this.timeOfLastKBInput < 2000L) {
            int scWidth = this.mc.method_22683().method_4486();
            int scHeight = this.mc.method_22683().method_4502();
            this.mc.method_1531().method_22813(GUI_ICONS_LOCATION);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)775, (int)769, (int)1, (int)0);
            RenderSystem.enableAlphaTest();
            this.blit(scWidth / 2 - 7, scHeight / 2 - 7, 0, 0, 16, 16);
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        } else {
            this.switchToMouseInput();
        }
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.getHeight(), 255, 255);
        this.drawCenteredString(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 16, 0xFFFFFF);
        int x = (int)Math.floor(cursorCoordX);
        int z = (int)Math.floor(cursorCoordZ);
        if (this.master.getMapOptions().coords) {
            if (!this.editingCoordinates) {
                this.drawString(this.getFontRenderer(), "X: " + x, this.sideMargin, 16, 0xFFFFFF);
                this.drawString(this.getFontRenderer(), "Z: " + z, this.sideMargin + 64, 16, 0xFFFFFF);
            } else {
                this.coordinates.render(mouseX, mouseY, partialTicks);
            }
        }
        if (this.subworldName != null && !this.subworldName.equals(this.master.getWaypointManager().getCurrentSubworldDescriptor(true)) || this.master.getWaypointManager().getCurrentSubworldDescriptor(true) != null && !this.master.getWaypointManager().getCurrentSubworldDescriptor(true).equals(this.subworldName)) {
            this.buildWorldName();
        }
        this.drawString(this.getFontRenderer(), this.worldNameDisplay, this.getWidth() - this.sideMargin - this.worldNameDisplayLength, 16, 0xFFFFFF);
        if (this.buttonMultiworld != null) {
            if ((this.subworldName == null || this.subworldName.equals("")) && this.master.getWaypointManager().isMultiworld()) {
                String attention = "";
                if ((int)(System.currentTimeMillis() / 1000L % 2L) == 0) {
                    attention = "\u00a7c";
                }
                this.buttonMultiworld.setMessage(attention + this.multiworldButtonName);
            } else {
                this.buttonMultiworld.setMessage(this.multiworldButtonName);
            }
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    private void drawWaypoint(Waypoint pt, float cursorCoordX, float cursorCoordZ, Sprite icon, Float r, Float g, Float b) {
        if (pt.inWorld && pt.inDimension && this.isOnScreen(pt.getX(), pt.getZ())) {
            String name = pt.name;
            if (r == null) {
                r = Float.valueOf(pt.red);
            }
            if (g == null) {
                g = Float.valueOf(pt.green);
            }
            if (b == null) {
                b = Float.valueOf(pt.blue);
            }
            float ptX = pt.getX();
            float ptZ = pt.getZ();
            if (this.backGroundImageInfo != null && this.backGroundImageInfo.isInRange((int)ptX, (int)ptZ) || this.persistentMap.isRegionLoaded((int)ptX, (int)ptZ)) {
                boolean hover = cursorCoordX > (ptX += 0.5f) - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordX < ptX + 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ > (ptZ += 0.5f) - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ < ptZ + 18.0f * this.guiToMap / this.guiToDirectMouse;
                boolean target = false;
                TextureAtlas atlas = this.master.getWaypointManager().getTextureAtlas();
                GLUtils.disp(atlas.method_4624());
                if (icon == null) {
                    icon = atlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
                    if (icon == atlas.getMissingImage()) {
                        icon = atlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
                    }
                } else {
                    name = "";
                    target = true;
                }
                GLShim.glColor4f(r.floatValue(), g.floatValue(), b.floatValue(), pt.enabled || target || hover ? 1.0f : 0.3f);
                GLShim.glTexParameteri(3553, 10241, 9729);
                GLShim.glTexParameteri(3553, 10240, 9729);
                if (this.oldNorth) {
                    GLShim.glPushMatrix();
                    GLShim.glTranslatef(ptX * this.mapToGui, ptZ * this.mapToGui, 0.0f);
                    GLShim.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslatef(-(ptX * this.mapToGui), -(ptZ * this.mapToGui), 0.0f);
                }
                this.drawTexturedModalRect(-16.0f / this.scScale + ptX * this.mapToGui, -16.0f / this.scScale + ptZ * this.mapToGui, icon, 32.0f / this.scScale, 32.0f / this.scScale);
                if (this.oldNorth) {
                    GLShim.glPopMatrix();
                }
                int n = this.mapOptions.biomeOverlay;
                this.mapOptions.getClass();
                if (n == 0 && this.options.showWaypointNames || target || hover) {
                    float fontScale = 2.0f / this.scScale;
                    int m = this.chkLen(name) / 2;
                    GLShim.glPushMatrix();
                    GLShim.glScalef(fontScale, fontScale, 1.0f);
                    if (this.oldNorth) {
                        GLShim.glTranslatef(ptX * this.mapToGui / fontScale, ptZ * this.mapToGui / fontScale, 0.0f);
                        GLShim.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
                        GLShim.glTranslatef(-(ptX * this.mapToGui / fontScale), -(ptZ * this.mapToGui / fontScale), 0.0f);
                    }
                    this.write(name, ptX * this.mapToGui / fontScale - (float)m, ptZ * this.mapToGui / fontScale + 16.0f / this.scScale / fontScale, pt.enabled || target || hover ? 0xFFFFFF : 0x55FFFFFF);
                    GLUtils.disp(0);
                    GLShim.glPopMatrix();
                    GLShim.glEnable(3042);
                }
            }
        }
    }

    private boolean isOnScreen(int x, int z) {
        int bottom;
        int top;
        int right;
        int left;
        if (this.oldNorth) {
            left = (int)Math.floor((double)this.mapCenterZ - (double)((float)this.centerY * this.guiToMap) * 1.1);
            right = (int)Math.floor((double)this.mapCenterZ + (double)((float)this.centerY * this.guiToMap) * 1.1);
            top = (int)Math.floor((double)(-this.mapCenterX) - (double)((float)this.centerX * this.guiToMap) * 1.1);
            bottom = (int)Math.floor((double)(-this.mapCenterX) + (double)((float)this.centerX * this.guiToMap) * 1.1);
        } else {
            left = (int)Math.floor((double)this.mapCenterX - (double)((float)this.centerX * this.guiToMap) * 1.1);
            right = (int)Math.floor((double)this.mapCenterX + (double)((float)this.centerX * this.guiToMap) * 1.1);
            top = (int)Math.floor((double)this.mapCenterZ - (double)((float)this.centerY * this.guiToMap) * 1.1);
            bottom = (int)Math.floor((double)this.mapCenterZ + (double)((float)this.centerY * this.guiToMap) * 1.1);
        }
        return x > left && x < right && z > top && z < bottom;
    }

    public void renderBackground() {
        GuiPersistentMap.fill((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)-16777216);
    }

    protected void overlayBackground(int startY, int endY, int startAlpha, int endAlpha) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        this.mc.method_1531().method_22813(class_437.BACKGROUND_LOCATION);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_22912(0.0, (double)endY, 0.0).method_22913(0.0f, (float)endY / 32.0f).method_1336(64, 64, 64, endAlpha).method_1344();
        vertexBuffer.method_22912((double)(0 + this.getWidth()), (double)endY, 0.0).method_22913((float)this.width / 32.0f, (float)endY / 32.0f).method_1336(64, 64, 64, endAlpha).method_1344();
        vertexBuffer.method_22912((double)(0 + this.getWidth()), (double)startY, 0.0).method_22913((float)this.width / 32.0f, (float)startY / 32.0f).method_1336(64, 64, 64, startAlpha).method_1344();
        vertexBuffer.method_22912(0.0, (double)startY, 0.0).method_22913(0.0f, (float)startY / 32.0f).method_1336(64, 64, 64, startAlpha).method_1344();
        tessellator.method_1350();
    }

    public void tick() {
        this.coordinates.method_1865();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removed() {
        this.mc.field_1690.field_1894.method_1422(this.forwardCode);
        this.mc.field_1690.field_1913.method_1422(this.leftCode);
        this.mc.field_1690.field_1881.method_1422(this.backCode);
        this.mc.field_1690.field_1849.method_1422(this.rightCode);
        this.mc.field_1690.field_1867.method_1422(this.sprintCode);
        this.keyBindForward.method_1422(this.nullInput);
        this.keyBindLeft.method_1422(this.nullInput);
        this.keyBindBack.method_1422(this.nullInput);
        this.keyBindRight.method_1422(this.nullInput);
        this.keyBindSprint.method_1422(this.nullInput);
        class_304.method_1426();
        class_304.method_1437();
        this.mc.field_1774.method_1462(false);
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
            this.persistentMap.getRegions(0, -1, 0, -1);
            this.regions = new CachedRegion[0];
        }
    }

    public void drawTexturedModalRect(float x, float y, float width, float height) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(7, class_290.field_1585);
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + height), (double)this.getBlitOffset()).method_22913(0.0f, 1.0f).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + height), (double)this.getBlitOffset()).method_22913(1.0f, 1.0f).method_1344();
        vertexBuffer.method_22912((double)(x + width), (double)(y + 0.0f), (double)this.getBlitOffset()).method_22913(1.0f, 0.0f).method_1344();
        vertexBuffer.method_22912((double)(x + 0.0f), (double)(y + 0.0f), (double)this.getBlitOffset()).method_22913(0.0f, 0.0f).method_1344();
        tessellator.method_1350();
    }

    public void drawTexturedModalRect(Sprite icon, float x, float y) {
        float width = (float)icon.getIconWidth() / this.scScale;
        float height = (float)icon.getIconHeight() / this.scScale;
        this.drawTexturedModalRect(x, y, icon, width, height);
    }

    public void drawTexturedModalRect(float xCoord, float yCoord, Sprite icon, float widthIn, float heightIn) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        vertexBuffer.method_1328(7, class_290.field_1585);
        vertexBuffer.method_22912((double)(xCoord + 0.0f), (double)(yCoord + heightIn), (double)this.getBlitOffset()).method_22913(icon.getMinU(), icon.getMaxV()).method_1344();
        vertexBuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)this.getBlitOffset()).method_22913(icon.getMaxU(), icon.getMaxV()).method_1344();
        vertexBuffer.method_22912((double)(xCoord + widthIn), (double)(yCoord + 0.0f), (double)this.getBlitOffset()).method_22913(icon.getMaxU(), icon.getMinV()).method_1344();
        vertexBuffer.method_22912((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)this.getBlitOffset()).method_22913(icon.getMinU(), icon.getMinV()).method_1344();
        tessellator.method_1350();
    }

    private void createPopup(int mouseX, int mouseY, int mouseDirectX, int mouseDirectY) {
        float cursorCoordZ;
        float cursorCoordX;
        ArrayList<Popup.PopupEntry> entries = new ArrayList<Popup.PopupEntry>();
        float cursorX = mouseDirectX;
        float cursorY = (float)mouseDirectY - (float)this.top * this.guiToDirectMouse;
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        int x = (int)Math.floor(cursorCoordX);
        int z = (int)Math.floor(cursorCoordZ);
        boolean canTeleport = this.canTeleport();
        canTeleport = canTeleport && (this.persistentMap.isGroundAt(x, z) || this.backGroundImageInfo != null && this.backGroundImageInfo.isGroundAt(x, z));
        Waypoint hovered = this.getHovered(cursorCoordX, cursorCoordZ);
        if (hovered == null || !this.waypointManager.getWaypoints().contains(hovered)) {
            Popup.PopupEntry entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.newwaypoint", new Object[0]), this.NEW, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString(hovered == null ? "minimap.waypoints.highlight" : "minimap.waypoints.removehighlight", new Object[0]), this.HIGHLIGHT, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.teleportto", new Object[0]), this.TELEPORT, true, canTeleport);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.share", new Object[0]), this.SHARE, true, true);
            entries.add(entry);
        } else {
            Popup.PopupEntry entry = new Popup.PopupEntry(I18nUtils.getString("selectServer.edit", new Object[0]), this.EDIT, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("selectServer.delete", new Object[0]), this.DELETE, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString(hovered != this.waypointManager.getHighlightedWaypoint() ? "minimap.waypoints.highlight" : "minimap.waypoints.removehighlight", new Object[0]), this.HIGHLIGHT, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.teleportto", new Object[0]), this.TELEPORT, true, canTeleport);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.share", new Object[0]), this.SHARE, true, true);
            entries.add(entry);
        }
        this.createPopup(mouseX, mouseY, mouseDirectX, mouseDirectY, entries);
    }

    private Waypoint getHovered(float cursorCoordX, float cursorCoordZ) {
        Waypoint pt;
        Waypoint waypoint = null;
        for (Waypoint pt2 : this.waypointManager.getWaypoints()) {
            float ptX = (float)pt2.getX() + 0.5f;
            float ptZ = (float)pt2.getZ() + 0.5f;
            boolean hover = pt2.inDimension && pt2.inWorld && cursorCoordX > ptX - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordX < ptX + 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ > ptZ - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ < ptZ + 18.0f * this.guiToMap / this.guiToDirectMouse;
            if (!hover) continue;
            waypoint = pt2;
        }
        if (waypoint == null && (pt = this.waypointManager.getHighlightedWaypoint()) != null) {
            boolean hover;
            float ptX = (float)pt.getX() + 0.5f;
            float ptZ = (float)pt.getZ() + 0.5f;
            boolean bl = hover = pt.inDimension && pt.inWorld && cursorCoordX > ptX - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordX < ptX + 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ > ptZ - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ < ptZ + 18.0f * this.guiToMap / this.guiToDirectMouse;
            if (hover) {
                waypoint = pt;
            }
        }
        return waypoint;
    }

    @Override
    public void popupAction(Popup popup, int action) {
        float cursorCoordZ;
        float cursorCoordX;
        int mouseDirectX = popup.clickedDirectX;
        int mouseDirectY = popup.clickedDirectY;
        float cursorX = mouseDirectX;
        float cursorY = (float)mouseDirectY - (float)this.top * this.guiToDirectMouse;
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        int x = (int)Math.floor(cursorCoordX);
        int z = (int)Math.floor(cursorCoordZ);
        int y = this.persistentMap.getHeightAt(x, z);
        Waypoint hovered = this.getHovered(cursorCoordX, cursorCoordZ);
        this.editClicked = false;
        this.addClicked = false;
        this.deleteClicked = false;
        switch (action) {
            case 0: {
                float b;
                float g;
                float r;
                if (hovered != null) {
                    x = hovered.getX();
                    z = hovered.getZ();
                }
                this.addClicked = true;
                if (this.waypointManager.getWaypoints().size() == 0) {
                    r = 0.0f;
                    g = 1.0f;
                    b = 0.0f;
                } else {
                    r = this.generator.nextFloat();
                    g = this.generator.nextFloat();
                    b = this.generator.nextFloat();
                }
                TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
                dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(this.mc.field_1687.field_9247));
                this.newWaypoint = new Waypoint("", this.mc.field_1724.field_6026 != class_2874.field_13076 ? x : x * 8, this.mc.field_1724.field_6026 != class_2874.field_13076 ? z : z * 8, y, true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
                this.mc.method_1507((class_437)new GuiAddWaypoint(this, this.master, this.newWaypoint, false));
                break;
            }
            case 4: {
                if (hovered == null) break;
                this.editClicked = true;
                this.selectedWaypoint = hovered;
                this.mc.method_1507((class_437)new GuiAddWaypoint(this, this.master, hovered, true));
                break;
            }
            case 5: {
                if (hovered == null) break;
                this.deleteClicked = true;
                this.selectedWaypoint = hovered;
                String var4 = I18nUtils.getString("minimap.waypoints.deleteconfirm", new Object[0]);
                class_2588 explanation = new class_2588("selectServer.deleteWarning", new Object[]{this.selectedWaypoint.name});
                String var6 = I18nUtils.getString("selectServer.deleteButton", new Object[0]);
                String var7 = I18nUtils.getString("gui.cancel", new Object[0]);
                class_410 var8 = new class_410((BooleanConsumer)this, (class_2561)new class_2585(var4), (class_2561)explanation, var6, var7);
                this.getMinecraft().method_1507((class_437)var8);
                break;
            }
            case 1: {
                if (hovered != null) {
                    this.waypointManager.setHighlightedWaypoint(hovered, true);
                    break;
                }
                y = y > 0 ? y : 64;
                TreeSet<DimensionContainer> dimensions2 = new TreeSet<DimensionContainer>();
                dimensions2.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(this.mc.field_1687.field_9247));
                Waypoint fakePoint = new Waypoint("", this.mc.field_1724.field_6026 != class_2874.field_13076 ? x : x * 8, this.mc.field_1724.field_6026 != class_2874.field_13076 ? z : z * 8, y, true, 1.0f, 0.0f, 0.0f, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions2);
                this.waypointManager.setHighlightedWaypoint(fakePoint, true);
                break;
            }
            case 2: {
                if (hovered != null) {
                    CommandUtils.sendWaypoint(hovered);
                    break;
                }
                y = y > 0 ? y : 64;
                CommandUtils.sendCoordinate(x, y, z);
                break;
            }
            case 3: {
                if (hovered != null) {
                    boolean mp;
                    this.selectedWaypoint = hovered;
                    boolean bl = mp = !this.mc.method_1542();
                    y = this.selectedWaypoint.getY() > 0 ? this.selectedWaypoint.getY() : (this.mc.field_1724.field_6026 != class_2874.field_13076 ? 128 : 64);
                    this.mc.field_1724.method_3142("/tp " + this.mc.field_1724.method_5477().getString() + " " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                    if (mp) {
                        this.mc.field_1724.method_3142("/tppos " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                        break;
                    }
                    this.getMinecraft().method_1507((class_437)null);
                    break;
                }
                if (y == 0) {
                    y = this.mc.field_1724.field_6026 != class_2874.field_13076 ? 255 : 64;
                }
                this.mc.field_1724.method_3142("/tp " + this.mc.field_1724.method_5477().getString() + " " + x + " " + y + " " + z);
                if (this.mc.method_1542()) break;
                this.mc.field_1724.method_3142("/tppos " + x + " " + y + " " + z);
                break;
            }
            default: {
                System.out.println("unimplemented command");
            }
        }
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void accept(boolean confirm) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (confirm) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (confirm) {
                this.waypointManager.saveWaypoints();
            }
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (confirm) {
                this.waypointManager.addWaypoint(this.newWaypoint);
            }
        }
        this.getMinecraft().method_1507((class_437)this);
    }

    public boolean canTeleport() {
        boolean allowed = false;
        boolean singlePlayer = this.mc.method_1542();
        if (singlePlayer) {
            try {
                allowed = this.mc.method_1576().method_3760().method_14569(this.mc.field_1724.method_7334());
            }
            catch (Exception e) {
                allowed = this.mc.method_1576().method_3847(class_2874.field_13072).method_8401().method_194();
            }
        } else {
            allowed = true;
        }
        return allowed;
    }

    private int chkLen(String string) {
        return this.getFontRenderer().method_1727(string);
    }

    private void write(String string, float x, float y, int color) {
        this.getFontRenderer().method_1720(string, x, y, color);
    }
}

