/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.IChangeObserver;
import com.mamiyaotaru.voxelmap.interfaces.IColorManager;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.persistent.CachedRegion;
import com.mamiyaotaru.voxelmap.persistent.GuiPersistentMap;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.persistent.WorldMatcher;
import com.mamiyaotaru.voxelmap.util.BiomeRepository;
import com.mamiyaotaru.voxelmap.util.BlockRepository;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.MapChunkCache;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.TickCounter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2368;
import net.minecraft.class_2378;
import net.minecraft.class_2506;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2902;
import net.minecraft.class_31;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3614;
import net.minecraft.class_4540;
import net.minecraft.class_638;

public class PersistentMap
implements IPersistentMap,
IChangeObserver {
    IVoxelMap master;
    MutableBlockPos blockPos = new MutableBlockPos(0, 0, 0);
    IColorManager colorManager;
    MapSettingsManager mapOptions;
    PersistentMapSettingsManager options;
    WorldMatcher worldMatcher;
    int[] lightmapColors;
    class_638 world;
    String subworldName = "";
    private final int SEAFLOORLAYER = 0;
    private final int GROUNDLAYER = 1;
    private final int FOLIAGELAYER = 2;
    private final int TRANSPARENTLAYER = 3;
    private final int DRAWHEIGHT = 80;
    protected List<CachedRegion> cachedRegionsPool = Collections.synchronizedList(new ArrayList());
    protected ConcurrentHashMap<String, CachedRegion> cachedRegions = new ConcurrentHashMap(150, 0.9f, 2);
    int lastLeft = 0;
    int lastRight = 0;
    int lastTop = 0;
    int lastBottom = 0;
    CachedRegion[] lastRegionsArray = new CachedRegion[0];
    Comparator<CachedRegion> ageThenDistanceSorter = new Comparator<CachedRegion>(){

        @Override
        public int compare(CachedRegion region1, CachedRegion region2) {
            long mostRecentAccess2;
            long mostRecentAccess1 = region1.getMostRecentView();
            if (mostRecentAccess1 < (mostRecentAccess2 = region2.getMostRecentView())) {
                return 1;
            }
            if (mostRecentAccess1 > mostRecentAccess2) {
                return -1;
            }
            double distance1sq = (region1.getX() * 256 + region1.getWidth() / 2 - PersistentMap.this.options.mapX) * (region1.getX() * 256 + region1.getWidth() / 2 - PersistentMap.this.options.mapX) + (region1.getZ() * 256 + region1.getWidth() / 2 - PersistentMap.this.options.mapZ) * (region1.getZ() * 256 + region1.getWidth() / 2 - PersistentMap.this.options.mapZ);
            double distance2sq = (region2.getX() * 256 + region2.getWidth() / 2 - PersistentMap.this.options.mapX) * (region2.getX() * 256 + region2.getWidth() / 2 - PersistentMap.this.options.mapX) + (region2.getZ() * 256 + region2.getWidth() / 2 - PersistentMap.this.options.mapZ) * (region2.getZ() * 256 + region2.getWidth() / 2 - PersistentMap.this.options.mapZ);
            return Double.compare(distance1sq, distance2sq);
        }
    };
    Comparator<RegionCoordinates> distanceSorter = new Comparator<RegionCoordinates>(){

        @Override
        public int compare(RegionCoordinates coordinates1, RegionCoordinates coordinates2) {
            double distance1sq = (coordinates1.x * 256 + 128 - PersistentMap.this.options.mapX) * (coordinates1.x * 256 + 128 - PersistentMap.this.options.mapX) + (coordinates1.z * 256 + 128 - PersistentMap.this.options.mapZ) * (coordinates1.z * 256 + 128 - PersistentMap.this.options.mapZ);
            double distance2sq = (coordinates2.x * 256 + 128 - PersistentMap.this.options.mapX) * (coordinates2.x * 256 + 128 - PersistentMap.this.options.mapX) + (coordinates2.z * 256 + 128 - PersistentMap.this.options.mapZ) * (coordinates2.z * 256 + 128 - PersistentMap.this.options.mapZ);
            return Double.compare(distance1sq, distance2sq);
        }
    };
    private boolean queuedChangedChunks = false;
    private MapChunkCache chunkCache;
    private ConcurrentLinkedQueue<ChunkWithAge> chunkUpdateQueue = new ConcurrentLinkedQueue();

    public PersistentMap(IVoxelMap master) {
        this.master = master;
        this.colorManager = master.getColorManager();
        this.mapOptions = master.getMapOptions();
        this.options = master.getPersistentMapOptions();
        this.lightmapColors = new int[256];
        Arrays.fill(this.lightmapColors, -16777216);
    }

    @Override
    public void newWorld(class_638 world) {
        this.subworldName = "";
        this.purgeCachedRegions();
        this.queuedChangedChunks = false;
        this.chunkUpdateQueue.clear();
        this.world = world;
        if (this.worldMatcher != null) {
            this.worldMatcher.cancel();
        }
        if (world != null) {
            this.newWorldStuff();
        } else if (world == null) {
            Thread pauseForSubworldNamesThread = new Thread(null, null, "VoxelMap Pause for Subworld Name Thread"){

                @Override
                public void run() {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (PersistentMap.this.world != null) {
                        PersistentMap.this.newWorldStuff();
                    }
                }
            };
            pauseForSubworldNamesThread.start();
        }
    }

    private void newWorldStuff() {
        if (this.master.getWaypointManager().isMultiworld() && !class_310.method_1551().method_1542() && !this.master.getWaypointManager().receivedAutoSubworldName()) {
            this.worldMatcher = new WorldMatcher(this.master, this, this.world);
            this.worldMatcher.findMatch();
        }
        this.chunkCache = new MapChunkCache(33, 33, this);
    }

    @Override
    public void onTick(class_310 mc) {
        if (mc.field_1755 == null) {
            this.options.mapX = GameVariableAccessShim.xCoord();
            this.options.mapZ = GameVariableAccessShim.zCoord();
        }
        if (!this.master.getWaypointManager().getCurrentSubworldDescriptor(false).equals(this.subworldName)) {
            this.subworldName = this.master.getWaypointManager().getCurrentSubworldDescriptor(false);
            if (this.worldMatcher != null && !this.subworldName.equals("")) {
                this.worldMatcher.cancel();
            }
            this.purgeCachedRegions();
        }
        if (this.queuedChangedChunks) {
            this.queuedChangedChunks = false;
            this.prunePool();
        }
        if (this.world != null) {
            this.chunkCache.centerChunks(this.blockPos.withXYZ(GameVariableAccessShim.xCoord(), 0, GameVariableAccessShim.zCoord()));
            this.chunkCache.checkIfChunksBecameSurroundedByLoaded();
            while (!this.chunkUpdateQueue.isEmpty() && Math.abs(TickCounter.tickCounter - this.chunkUpdateQueue.peek().tick) >= 20) {
                this.doProcessChunk(((ChunkWithAge)this.chunkUpdateQueue.remove()).chunk);
            }
        }
    }

    @Override
    public PersistentMapSettingsManager getOptions() {
        return this.options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeCachedRegions() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                cachedRegion.cleanup();
            }
            this.cachedRegions.clear();
            this.cachedRegionsPool.clear();
            this.getRegions(0, -1, 0, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameSubworld(String oldName, String newName) {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                cachedRegion.renameSubworld(oldName, newName);
            }
        }
    }

    @Override
    public ISettingsAndLightingChangeNotifier getSettingsAndLightingChangeNotifier() {
        return this.master.getSettingsAndLightingChangeNotifier();
    }

    @Override
    public void setLightMapArray(int[] lightmapColors) {
        boolean changed = false;
        int torchOffset = 0;
        int skylightMultiplier = 16;
        for (int t = 0; t < 16; ++t) {
            if (lightmapColors[t * skylightMultiplier + torchOffset] == this.lightmapColors[t * skylightMultiplier + torchOffset]) continue;
            changed = true;
        }
        System.arraycopy(lightmapColors, 0, this.lightmapColors, 0, 256);
        if (changed) {
            this.getSettingsAndLightingChangeNotifier().notifyOfChanges();
        }
    }

    private static double calcChance(long long_1, int int_1, int int_2, int int_3, double double_1, double double_2, double double_3) {
        long long_2 = class_4540.method_22372((long)long_1, (long)int_1);
        long_2 = class_4540.method_22372((long)long_2, (long)int_2);
        long_2 = class_4540.method_22372((long)long_2, (long)int_3);
        long_2 = class_4540.method_22372((long)long_2, (long)int_1);
        long_2 = class_4540.method_22372((long)long_2, (long)int_2);
        long_2 = class_4540.method_22372((long)long_2, (long)int_3);
        double double_4 = PersistentMap.distribute(long_2);
        long_2 = class_4540.method_22372((long)long_2, (long)long_1);
        double double_5 = PersistentMap.distribute(long_2);
        long_2 = class_4540.method_22372((long)long_2, (long)long_1);
        double double_6 = PersistentMap.distribute(long_2);
        return PersistentMap.sqr(double_3 + double_6) + PersistentMap.sqr(double_2 + double_5) + PersistentMap.sqr(double_1 + double_4);
    }

    private static double distribute(long long_1) {
        double double_1 = (double)((int)Math.floorMod(long_1 >> 24, 1024L)) / 1024.0;
        return (double_1 - 0.5) * 0.9;
    }

    private static double sqr(double double_1) {
        return double_1 * double_1;
    }

    @Override
    public void getAndStoreData(AbstractMapData mapData, class_1937 world, class_2818 chunk, MutableBlockPos blockPos, boolean underground, int startX, int startZ, int imageX, int imageY) {
        int light;
        int surfaceHeight = 0;
        int seafloorHeight = 0;
        int transparentHeight = 0;
        int foliageHeight = 0;
        class_2680 surfaceBlockState = BlockRepository.air.method_9564();
        class_2680 transparentBlockState = BlockRepository.air.method_9564();
        class_2680 foliageBlockState = BlockRepository.air.method_9564();
        class_2680 seafloorBlockState = BlockRepository.air.method_9564();
        blockPos = blockPos.withXYZ(startX + imageX, 64, startZ + imageY);
        int biomeID = 0;
        if (!chunk.method_12223()) {
            int int_15;
            int int_18;
            int int_17;
            int int_14;
            boolean isClient = false;
            long long_1 = isClient ? world.method_8401().method_184() : class_31.method_22418((long)world.method_8401().method_184());
            int int_4 = blockPos.method_10263() - 2;
            int int_5 = blockPos.method_10264() - 2;
            int int_6 = blockPos.method_10260() - 2;
            int int_7 = int_4 >> 2;
            int int_8 = int_5 >> 2;
            int int_9 = int_6 >> 2;
            double double_1 = (double)(int_4 & 3) / 4.0;
            double double_2 = (double)(int_5 & 3) / 4.0;
            double double_3 = (double)(int_6 & 3) / 4.0;
            double[] doubles_1 = new double[8];
            for (int_14 = 0; int_14 < 8; ++int_14) {
                boolean boolean_1 = (int_14 & 4) == 0;
                boolean boolean_2 = (int_14 & 2) == 0;
                boolean boolean_3 = (int_14 & 1) == 0;
                int_17 = boolean_1 ? int_7 : int_7 + 1;
                int_18 = boolean_2 ? int_8 : int_8 + 1;
                int int_13 = boolean_3 ? int_9 : int_9 + 1;
                double double_4 = boolean_1 ? double_1 : 1.0 - double_1;
                double double_5 = boolean_2 ? double_2 : 1.0 - double_2;
                double double_6 = boolean_3 ? double_3 : 1.0 - double_3;
                doubles_1[int_14] = PersistentMap.calcChance(long_1, int_17, int_18, int_13, double_4, double_5, double_6);
            }
            int_14 = 0;
            double double_7 = doubles_1[0];
            for (int_15 = 1; int_15 < 8; ++int_15) {
                if (!(double_7 > doubles_1[int_15])) continue;
                int_14 = int_15;
                double_7 = doubles_1[int_15];
            }
            int_15 = (int_14 & 4) == 0 ? int_7 : int_7 + 1;
            int_17 = (int_14 & 2) == 0 ? int_8 : int_8 + 1;
            int_18 = (int_14 & 1) == 0 ? int_9 : int_9 + 1;
            class_1959 biome = chunk.method_12036().method_16359(int_15, int_17, int_18);
            biomeID = class_2378.field_11153.method_10249((Object)biome);
            biomeID = class_2378.field_11153.method_10249((Object)world.method_23753((class_2338)blockPos));
        } else {
            biomeID = -1;
        }
        mapData.setBiomeID(imageX, imageY, biomeID);
        if (biomeID == -1) {
            return;
        }
        boolean solid = false;
        if (underground) {
            surfaceHeight = this.getNetherHeight(underground, chunk, startX + imageX, startZ + imageY);
            surfaceBlockState = chunk.method_8320((class_2338)blockPos.withXYZ(startX + imageX, surfaceHeight - 1, startZ + imageY));
            if (surfaceHeight != -1) {
                foliageHeight = surfaceHeight + 1;
                blockPos.setXYZ(startX + imageX, foliageHeight - 1, startZ + imageY);
                foliageBlockState = chunk.method_8320((class_2338)blockPos);
                class_3614 material = foliageBlockState.method_11620();
                if (material == class_3614.field_15948 || material == class_3614.field_15959 || material == class_3614.field_15922 || material == class_3614.field_15920) {
                    foliageHeight = 0;
                }
            }
        } else {
            boolean hasOpacity;
            transparentHeight = chunk.method_12005(class_2902.class_2903.field_13197, blockPos.method_10263() & 0xF, blockPos.method_10260() & 0xF) + 1;
            transparentBlockState = chunk.method_8320((class_2338)blockPos.withXYZ(startX + imageX, transparentHeight - 1, startZ + imageY));
            class_3610 fluidState = transparentBlockState.method_11618();
            if (fluidState != class_3612.field_15906.method_15785()) {
                transparentBlockState = fluidState.method_15759();
            }
            surfaceHeight = transparentHeight;
            surfaceBlockState = transparentBlockState;
            class_265 voxelShape = null;
            boolean bl = hasOpacity = surfaceBlockState.method_11581((class_1922)world, (class_2338)blockPos) > 0;
            if (!hasOpacity && surfaceBlockState.method_11619() && surfaceBlockState.method_16386()) {
                voxelShape = surfaceBlockState.method_16384((class_1922)world, (class_2338)blockPos, class_2350.field_11033);
                hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                voxelShape = surfaceBlockState.method_16384((class_1922)world, (class_2338)blockPos, class_2350.field_11036);
                boolean bl2 = hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
            }
            while (!hasOpacity && surfaceHeight > 0) {
                foliageBlockState = surfaceBlockState;
                if ((fluidState = (surfaceBlockState = chunk.method_8320((class_2338)blockPos.withXYZ(startX + imageX, --surfaceHeight - 1, startZ + imageY))).method_11618()) != class_3612.field_15906.method_15785()) {
                    surfaceBlockState = fluidState.method_15759();
                }
                if ((hasOpacity = surfaceBlockState.method_11581((class_1922)world, (class_2338)blockPos) > 0) || !surfaceBlockState.method_11619() || !surfaceBlockState.method_16386()) continue;
                voxelShape = surfaceBlockState.method_16384((class_1922)world, (class_2338)blockPos, class_2350.field_11033);
                hasOpacity = class_259.method_20713((class_265)voxelShape, (class_265)class_259.method_1073());
                voxelShape = surfaceBlockState.method_16384((class_1922)world, (class_2338)blockPos, class_2350.field_11036);
                hasOpacity = hasOpacity || class_259.method_20713((class_265)class_259.method_1073(), (class_265)voxelShape);
            }
            if (surfaceHeight == transparentHeight) {
                transparentHeight = 0;
                transparentBlockState = BlockRepository.air.method_9564();
                foliageBlockState = chunk.method_8320((class_2338)blockPos.withXYZ(startX + imageX, surfaceHeight, startZ + imageY));
            }
            if (foliageBlockState.method_11620() == class_3614.field_15948) {
                surfaceBlockState = foliageBlockState;
                foliageBlockState = BlockRepository.air.method_9564();
            }
            if (foliageBlockState == transparentBlockState) {
                foliageBlockState = BlockRepository.air.method_9564();
            }
            if (foliageBlockState == null || foliageBlockState.method_11620() == class_3614.field_15959) {
                foliageHeight = 0;
                foliageBlockState = BlockRepository.air.method_9564();
            } else {
                foliageHeight = surfaceHeight + 1;
            }
            class_3614 material = surfaceBlockState.method_11620();
            if (material == class_3614.field_15920 || material == class_3614.field_15958) {
                seafloorHeight = surfaceHeight;
                seafloorBlockState = chunk.method_8320((class_2338)blockPos.withXYZ(startX + imageX, seafloorHeight - 1, startZ + imageY));
                while (seafloorBlockState.method_11581((class_1922)world, (class_2338)blockPos) < 5 && seafloorBlockState.method_11620() != class_3614.field_15923 && seafloorHeight > 1) {
                    material = seafloorBlockState.method_11620();
                    if (transparentHeight == 0 && material != class_3614.field_15958 && material != class_3614.field_15920 && material.method_15801()) {
                        transparentHeight = seafloorHeight;
                        transparentBlockState = seafloorBlockState;
                    }
                    if (foliageHeight == 0 && seafloorHeight != transparentHeight && transparentBlockState != seafloorBlockState && material != class_3614.field_15958 && material != class_3614.field_15920 && material != class_3614.field_15959 && material != class_3614.field_15915) {
                        foliageHeight = seafloorHeight;
                        foliageBlockState = seafloorBlockState;
                    }
                    seafloorBlockState = chunk.method_8320((class_2338)blockPos.withXYZ(startX + imageX, --seafloorHeight - 1, startZ + imageY));
                }
                if (seafloorBlockState.method_11620() == class_3614.field_15920) {
                    seafloorBlockState = BlockRepository.air.method_9564();
                }
            }
        }
        mapData.setHeight(imageX, imageY, surfaceHeight);
        mapData.setBlockstate(imageX, imageY, surfaceBlockState);
        mapData.setTransparentHeight(imageX, imageY, transparentHeight);
        mapData.setTransparentBlockstate(imageX, imageY, transparentBlockState);
        mapData.setFoliageHeight(imageX, imageY, foliageHeight);
        mapData.setFoliageBlockstate(imageX, imageY, foliageBlockState);
        mapData.setOceanFloorHeight(imageX, imageY, seafloorHeight);
        mapData.setOceanFloorBlockstate(imageX, imageY, seafloorBlockState);
        if (surfaceHeight == -1) {
            surfaceHeight = 80;
            solid = true;
        }
        if (surfaceBlockState.method_11620() == class_3614.field_15922) {
            solid = false;
        }
        int n = light = solid ? 0 : 255;
        if (!solid) {
            light = this.getLight(surfaceBlockState, world, blockPos, startX + imageX, startZ + imageY, surfaceHeight, solid);
        }
        mapData.setLight(imageX, imageY, light);
        int seafloorLight = 0;
        if (seafloorBlockState != null && seafloorBlockState != BlockRepository.air.method_9564()) {
            seafloorLight = 255;
            seafloorLight = this.getLight(seafloorBlockState, world, blockPos, startX + imageX, startZ + imageY, seafloorHeight, solid);
        }
        mapData.setOceanFloorLight(imageX, imageY, seafloorLight);
        int transparentLight = 0;
        if (transparentBlockState != null && transparentBlockState != BlockRepository.air.method_9564()) {
            transparentLight = 255;
            transparentLight = this.getLight(transparentBlockState, world, blockPos, startX + imageX, startZ + imageY, transparentHeight, solid);
        }
        mapData.setTransparentLight(imageX, imageY, transparentLight);
        int foliageLight = 0;
        if (foliageBlockState != null && foliageBlockState != BlockRepository.air.method_9564()) {
            foliageLight = 255;
            foliageLight = this.getLight(foliageBlockState, world, blockPos, startX + imageX, startZ + imageY, foliageHeight, solid);
        }
        mapData.setFoliageLight(imageX, imageY, foliageLight);
    }

    private int getNetherHeight(boolean nether, class_2818 chunk, int x, int z) {
        int y = 80;
        this.blockPos.setXYZ(x, y, z);
        class_2680 blockState = chunk.method_8320((class_2338)this.blockPos);
        if (blockState.method_11581((class_1922)this.world, (class_2338)this.blockPos) == 0 && blockState.method_11620() != class_3614.field_15922) {
            while (y > 0) {
                this.blockPos.setXYZ(x, --y, z);
                blockState = chunk.method_8320((class_2338)this.blockPos);
                if (blockState.method_11581((class_1922)this.world, (class_2338)this.blockPos) <= 0 && blockState.method_11620() != class_3614.field_15922) continue;
                return y + 1;
            }
            return y;
        }
        while (y <= 90) {
            this.blockPos.setXYZ(x, ++y, z);
            blockState = chunk.method_8320((class_2338)this.blockPos);
            if (blockState.method_11581((class_1922)this.world, (class_2338)this.blockPos) != 0 || blockState.method_11620() == class_3614.field_15922) continue;
            return y;
        }
        return -1;
    }

    private int getLight(class_2680 blockState, class_1937 world, MutableBlockPos blockPos, int x, int z, int height, boolean solid) {
        int i3 = 255;
        if (solid) {
            i3 = 0;
        } else if (blockState != null && blockState.method_11620() != class_3614.field_15959) {
            blockPos.setXYZ(x, Math.max(Math.min(height, 255), 0), z);
            int blockLight = world.method_8314(class_1944.field_9282, (class_2338)blockPos) & 0xF;
            int skyLight = world.method_8314(class_1944.field_9284, (class_2338)blockPos);
            if (blockState.method_11620() == class_3614.field_15922 || blockState.method_11614() == class_2246.field_10092) {
                blockLight = 14;
            }
            i3 = blockLight + skyLight * 16;
        }
        return i3;
    }

    @Override
    public int getPixelColor(AbstractMapData mapData, class_638 world, MutableBlockPos blockPos, MutableBlockPos loopBlockPos, boolean underground, int multi, int startX, int startZ, int imageX, int imageY) {
        int lightValue;
        int tint;
        int mcX = startX + imageX;
        int mcZ = startZ + imageY;
        class_2680 surfaceBlockState = BlockRepository.air.method_9564();
        class_2680 transparentBlockState = BlockRepository.air.method_9564();
        class_2680 foliageBlockState = BlockRepository.air.method_9564();
        class_2680 seafloorBlockState = BlockRepository.air.method_9564();
        int surfaceHeight = 0;
        int seafloorHeight = 0;
        int transparentHeight = 0;
        int foliageHeight = 0;
        int surfaceColor = 0;
        int seafloorColor = 0;
        int transparentColor = 0;
        int foliageColor = 0;
        blockPos = blockPos.withXYZ(mcX, 0, mcZ);
        int color24 = 0;
        int biomeID = mapData.getBiomeID(imageX, imageY);
        surfaceBlockState = mapData.getBlockstate(imageX, imageY);
        if (surfaceBlockState == null || surfaceBlockState.method_11614() == BlockRepository.air && mapData.getLight(imageX, imageY) == 0 && mapData.getHeight(imageX, imageY) == 0 || biomeID == -1 || biomeID == 255) {
            return 0;
        }
        int n = this.mapOptions.biomeOverlay;
        this.mapOptions.getClass();
        if (n == 1) {
            color24 = biomeID >= 0 ? BiomeRepository.getBiomeColor(biomeID) | 0xFF000000 : 0;
            color24 = this.doSlimeAndGrid(color24, mcX, mcZ);
            return color24;
        }
        boolean solid = false;
        int blockStateID = 0;
        surfaceHeight = mapData.getHeight(imageX, imageY);
        blockStateID = BlockRepository.getStateId(surfaceBlockState);
        if (surfaceHeight == -1 || surfaceHeight == 255) {
            surfaceHeight = 80;
            solid = true;
        }
        blockPos.setXYZ(mcX, surfaceHeight - 1, mcZ);
        if (surfaceBlockState.method_11620() == class_3614.field_15922) {
            solid = false;
        }
        if (this.mapOptions.biomes) {
            surfaceColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
            int tint2 = -1;
            tint2 = this.colorManager.getBiomeTint(mapData, (class_1937)world, surfaceBlockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
            if (tint2 != -1) {
                surfaceColor = this.colorManager.colorMultiplier(surfaceColor, tint2);
            }
        } else {
            surfaceColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
        }
        surfaceColor = this.applyHeight(mapData, surfaceColor, underground, multi, imageX, imageY, surfaceHeight, solid, 1);
        int light = mapData.getLight(imageX, imageY);
        if (solid) {
            surfaceColor = 0;
        } else if (this.mapOptions.lightmap) {
            int lightValue2 = this.getLight(light);
            surfaceColor = this.colorManager.colorMultiplier(surfaceColor, lightValue2);
        }
        if (this.mapOptions.waterTransparency && !solid && (seafloorHeight = mapData.getOceanFloorHeight(imageX, imageY)) > 0) {
            blockPos.setXYZ(mcX, seafloorHeight - 1, mcZ);
            seafloorBlockState = mapData.getOceanFloorBlockstate(imageX, imageY);
            if (seafloorBlockState != null && seafloorBlockState != BlockRepository.air.method_9564()) {
                blockStateID = BlockRepository.getStateId(seafloorBlockState);
                if (this.mapOptions.biomes) {
                    seafloorColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                    tint = -1;
                    tint = this.colorManager.getBiomeTint(mapData, (class_1937)world, seafloorBlockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                    if (tint != -1) {
                        seafloorColor = this.colorManager.colorMultiplier(seafloorColor, tint);
                    }
                } else {
                    seafloorColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                }
                seafloorColor = this.applyHeight(mapData, seafloorColor, underground, multi, imageX, imageY, seafloorHeight, solid, 0);
                int seafloorLight = 255;
                seafloorLight = mapData.getOceanFloorLight(imageX, imageY);
                if (this.mapOptions.lightmap) {
                    lightValue = this.getLight(seafloorLight);
                    seafloorColor = this.colorManager.colorMultiplier(seafloorColor, lightValue);
                }
            }
        }
        if (this.mapOptions.blockTransparency && !solid) {
            transparentHeight = mapData.getTransparentHeight(imageX, imageY);
            if (transparentHeight > 0) {
                blockPos.setXYZ(mcX, transparentHeight - 1, mcZ);
                transparentBlockState = mapData.getTransparentBlockstate(imageX, imageY);
                if (transparentBlockState != null && transparentBlockState != BlockRepository.air.method_9564()) {
                    blockStateID = BlockRepository.getStateId(transparentBlockState);
                    if (this.mapOptions.biomes) {
                        transparentColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                        tint = -1;
                        tint = this.colorManager.getBiomeTint(mapData, (class_1937)world, transparentBlockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                        if (tint != -1) {
                            transparentColor = this.colorManager.colorMultiplier(transparentColor, tint);
                        }
                    } else {
                        transparentColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                    }
                    transparentColor = this.applyHeight(mapData, transparentColor, underground, multi, imageX, imageY, transparentHeight, solid, 3);
                    int transparentLight = 255;
                    transparentLight = mapData.getTransparentLight(imageX, imageY);
                    if (this.mapOptions.lightmap) {
                        lightValue = this.getLight(transparentLight);
                        transparentColor = this.colorManager.colorMultiplier(transparentColor, lightValue);
                    }
                }
            }
            if ((foliageHeight = mapData.getFoliageHeight(imageX, imageY)) > 0) {
                blockPos.setXYZ(mcX, foliageHeight - 1, mcZ);
                foliageBlockState = mapData.getFoliageBlockstate(imageX, imageY);
                if (foliageBlockState != null && foliageBlockState != BlockRepository.air.method_9564()) {
                    blockStateID = BlockRepository.getStateId(foliageBlockState);
                    if (this.mapOptions.biomes) {
                        foliageColor = this.colorManager.getBlockColor(blockPos, blockStateID, biomeID);
                        tint = -1;
                        tint = this.colorManager.getBiomeTint(mapData, (class_1937)world, foliageBlockState, blockStateID, blockPos, loopBlockPos, startX, startZ);
                        if (tint != -1) {
                            foliageColor = this.colorManager.colorMultiplier(foliageColor, tint);
                        }
                    } else {
                        foliageColor = this.colorManager.getBlockColorWithDefaultTint(blockPos, blockStateID);
                    }
                    foliageColor = this.applyHeight(mapData, foliageColor, underground, multi, imageX, imageY, foliageHeight, solid, 2);
                    int foliageLight = 255;
                    foliageLight = mapData.getFoliageLight(imageX, imageY);
                    if (this.mapOptions.lightmap) {
                        lightValue = this.getLight(foliageLight);
                        foliageColor = this.colorManager.colorMultiplier(foliageColor, lightValue);
                    }
                }
            }
        }
        if (this.mapOptions.waterTransparency && seafloorHeight > 0) {
            color24 = seafloorColor;
            if (foliageColor != 0 && foliageHeight <= surfaceHeight) {
                color24 = this.colorManager.colorAdder(foliageColor, color24);
            }
            if (transparentColor != 0 && transparentHeight <= surfaceHeight) {
                color24 = this.colorManager.colorAdder(transparentColor, color24);
            }
            color24 = this.colorManager.colorAdder(surfaceColor, color24);
        } else {
            color24 = surfaceColor;
        }
        if (foliageColor != 0 && foliageHeight > surfaceHeight) {
            color24 = this.colorManager.colorAdder(foliageColor, color24);
        }
        if (transparentColor != 0 && transparentHeight > surfaceHeight) {
            color24 = this.colorManager.colorAdder(transparentColor, color24);
        }
        int n2 = this.mapOptions.biomeOverlay;
        this.mapOptions.getClass();
        if (n2 == 2) {
            int bc = 0;
            if (biomeID >= 0) {
                bc = BiomeRepository.getBiomeColor(biomeID);
            }
            bc = 0x7F000000 | bc;
            color24 = this.colorManager.colorAdder(bc, color24);
        }
        color24 = this.doSlimeAndGrid(color24, mcX, mcZ);
        return color24;
    }

    private int doSlimeAndGrid(int color24, int mcX, int mcZ) {
        if (this.mapOptions.slimeChunks && !this.master.getWorldSeed().equals("")) {
            int xPosition = mcX >> 4;
            int zPosition = mcZ >> 4;
            String seedString = this.master.getWorldSeed();
            long seed = 0L;
            try {
                seed = Long.parseLong(seedString);
            }
            catch (NumberFormatException e) {
                seed = seedString.hashCode();
            }
            Random random = new Random(seed + (long)(xPosition * xPosition * 4987142) + (long)(xPosition * 5947611) + (long)(zPosition * zPosition) * 4392871L + (long)(zPosition * 389711) ^ 0x3AD8025FL);
            if (random.nextInt(10) == 0) {
                color24 = this.colorManager.colorAdder(2097217280, color24);
            }
        }
        if (this.mapOptions.chunkGrid) {
            if (mcX % 512 == 0 || mcZ % 512 == 0) {
                color24 = this.colorManager.colorAdder(2113863680, color24);
            } else if (mcX % 16 == 0 || mcZ % 16 == 0) {
                color24 = this.colorManager.colorAdder(0x7D000000, color24);
            }
        }
        return color24;
    }

    private int applyHeight(AbstractMapData mapData, int color24, boolean underground, int multi, int imageX, int imageY, int height, boolean solid, int layer) {
        if (color24 != this.colorManager.getAirColor() && color24 != 0) {
            int heightComp = -1;
            if ((this.mapOptions.heightmap || this.mapOptions.slopemap) && !solid) {
                int diff = 0;
                double sc = 0.0;
                boolean invert = false;
                if (this.mapOptions.slopemap) {
                    class_2248 block;
                    class_2680 transparentBlockState;
                    if (imageX > 0 && imageY < 32 * multi - 1) {
                        if (layer == 0) {
                            heightComp = mapData.getOceanFloorHeight(imageX - 1, imageY + 1);
                        }
                        if (layer == 1) {
                            heightComp = mapData.getHeight(imageX - 1, imageY + 1);
                        }
                        if (layer == 2) {
                            heightComp = height;
                        }
                        if (layer == 3 && (heightComp = mapData.getTransparentHeight(imageX - 1, imageY + 1)) == -1 && (transparentBlockState = mapData.getTransparentBlockstate(imageX, imageY)) != null && transparentBlockState != BlockRepository.air.method_9564() && ((block = transparentBlockState.method_11614()) instanceof class_2368 || block instanceof class_2506)) {
                            heightComp = mapData.getHeight(imageX - 1, imageY + 1);
                        }
                    } else if (imageX < 32 * multi - 1 && imageY > 0) {
                        if (layer == 0) {
                            heightComp = mapData.getOceanFloorHeight(imageX + 1, imageY - 1);
                        }
                        if (layer == 1) {
                            heightComp = mapData.getHeight(imageX + 1, imageY - 1);
                        }
                        if (layer == 2) {
                            heightComp = height;
                        }
                        if (layer == 3 && (heightComp = mapData.getTransparentHeight(imageX + 1, imageY - 1)) == -1 && (transparentBlockState = mapData.getTransparentBlockstate(imageX, imageY)) != null && transparentBlockState != BlockRepository.air.method_9564() && ((block = transparentBlockState.method_11614()) instanceof class_2368 || block instanceof class_2506)) {
                            heightComp = mapData.getHeight(imageX + 1, imageY - 1);
                        }
                        invert = true;
                    } else {
                        heightComp = height;
                    }
                    if (heightComp == -1) {
                        heightComp = height;
                    }
                    if ((diff = !invert ? heightComp - height : height - heightComp) != 0) {
                        sc = diff > 0 ? 1.0 : (diff < 0 ? -1.0 : 0.0);
                        sc /= 8.0;
                    }
                    if (this.mapOptions.heightmap) {
                        diff = height - 80;
                        double heightsc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 3.0;
                        sc = diff > 0 ? sc + heightsc : sc - heightsc;
                    }
                } else if (this.mapOptions.heightmap) {
                    diff = height - 80;
                    sc = Math.log10((double)Math.abs(diff) / 8.0 + 1.0) / 1.8;
                    if (diff < 0) {
                        sc = 0.0 - sc;
                    }
                }
                int alpha = color24 >> 24 & 0xFF;
                int r = color24 >> 16 & 0xFF;
                int g = color24 >> 8 & 0xFF;
                int b = color24 >> 0 & 0xFF;
                if (sc > 0.0) {
                    r = (int)(sc * (double)(255 - r)) + r;
                    g = (int)(sc * (double)(255 - g)) + g;
                    b = (int)(sc * (double)(255 - b)) + b;
                } else if (sc < 0.0) {
                    sc = Math.abs(sc);
                    r -= (int)(sc * (double)r);
                    g -= (int)(sc * (double)g);
                    b -= (int)(sc * (double)b);
                }
                color24 = alpha * 0x1000000 + r * 65536 + g * 256 + b;
            }
        }
        return color24;
    }

    private int getLight(int light) {
        return this.lightmapColors[light];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CachedRegion[] getRegions(int left, int right, int top, int bottom) {
        if (left == this.lastLeft && right == this.lastRight && top == this.lastTop && bottom == this.lastBottom) {
            return this.lastRegionsArray;
        }
        ThreadManager.emptyQueue();
        CachedRegion[] visibleCachedRegionsArray = new CachedRegion[(right - left + 1) * (bottom - top + 1)];
        String worldName = this.master.getWaypointManager().getCurrentWorldName();
        String subWorldName = this.master.getWaypointManager().getCurrentSubworldDescriptor(false);
        ArrayList<RegionCoordinates> regionsToDisplay = new ArrayList<RegionCoordinates>();
        for (int t = left; t <= right; ++t) {
            for (int s = top; s <= bottom; ++s) {
                RegionCoordinates regionCoordinates = new RegionCoordinates(t, s);
                regionsToDisplay.add(regionCoordinates);
            }
        }
        Collections.sort(regionsToDisplay, this.distanceSorter);
        for (RegionCoordinates regionCoordinates : regionsToDisplay) {
            CachedRegion cachedRegion;
            int x = regionCoordinates.x;
            int z = regionCoordinates.z;
            StringBuilder keyBuilder = new StringBuilder("").append(x).append(",").append(z);
            String key = keyBuilder.toString();
            ConcurrentHashMap<String, CachedRegion> concurrentHashMap = this.cachedRegions;
            synchronized (concurrentHashMap) {
                cachedRegion = this.cachedRegions.get(key);
                if (cachedRegion == null) {
                    cachedRegion = new CachedRegion(this, key, this.world, worldName, subWorldName, x, z);
                    this.cachedRegions.put(key, cachedRegion);
                    List<CachedRegion> list = this.cachedRegionsPool;
                    synchronized (list) {
                        this.cachedRegionsPool.add(cachedRegion);
                    }
                }
            }
            cachedRegion.refresh(true);
            visibleCachedRegionsArray[(z - top) * (right - left + 1) + (x - left)] = cachedRegion;
        }
        this.prunePool();
        CachedRegion[] cachedRegionArray = this.lastRegionsArray;
        synchronized (this.lastRegionsArray) {
            this.lastLeft = left;
            this.lastRight = right;
            this.lastTop = top;
            this.lastBottom = bottom;
            this.lastRegionsArray = visibleCachedRegionsArray;
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return visibleCachedRegionsArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prunePool() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            Iterator<CachedRegion> iterator = this.cachedRegionsPool.iterator();
            while (iterator.hasNext()) {
                CachedRegion region = iterator.next();
                if (!region.isLoaded() || !region.isEmpty()) continue;
                this.cachedRegions.put(region.getKey(), CachedRegion.emptyRegion);
                region.cleanup();
                iterator.remove();
            }
            if (this.cachedRegionsPool.size() > this.options.cacheSize) {
                Collections.sort(this.cachedRegionsPool, this.ageThenDistanceSorter);
                List<CachedRegion> toRemove = this.cachedRegionsPool.subList(this.options.cacheSize, this.cachedRegionsPool.size());
                for (CachedRegion cachedRegion : toRemove) {
                    this.cachedRegions.remove(cachedRegion.getKey());
                    cachedRegion.cleanup();
                }
                toRemove.clear();
            }
            this.compress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compress() {
        List<CachedRegion> list = this.cachedRegionsPool;
        synchronized (list) {
            for (CachedRegion cachedRegion : this.cachedRegionsPool) {
                if (System.currentTimeMillis() - cachedRegion.getMostRecentChange() <= 5000L) continue;
                cachedRegion.compress();
            }
        }
    }

    @Override
    public void handleChangeInWorld(int chunkX, int chunkZ) {
        if (this.world == null) {
            return;
        }
        class_2818 chunk = this.world.method_8497(chunkX, chunkZ);
        if (chunk == null || chunk.method_12223()) {
            return;
        }
        if (this.isChunkReady(this.world, chunk)) {
            this.processChunk(chunk);
        }
    }

    @Override
    public void processChunk(class_2818 chunk) {
        this.chunkUpdateQueue.add(new ChunkWithAge(chunk, TickCounter.tickCounter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doProcessChunk(class_2818 chunk) {
        this.queuedChangedChunks = true;
        try {
            if (this.world == null) {
                return;
            }
            if (chunk == null) return;
            if (chunk.method_12223()) {
                return;
            }
            int chunkX = chunk.method_12004().field_9181;
            int chunkZ = chunk.method_12004().field_9180;
            int regionX = (int)Math.floor((double)chunkX / 16.0);
            int regionZ = (int)Math.floor((double)chunkZ / 16.0);
            StringBuilder keyBuilder = new StringBuilder("").append(regionX).append(",").append(regionZ);
            String key = keyBuilder.toString();
            ConcurrentHashMap<String, CachedRegion> concurrentHashMap = this.cachedRegions;
            // MONITORENTER : concurrentHashMap
            CachedRegion cachedRegion = this.cachedRegions.get(key);
            if (cachedRegion == null || cachedRegion == CachedRegion.emptyRegion) {
                String worldName = this.master.getWaypointManager().getCurrentWorldName();
                String subWorldName = this.master.getWaypointManager().getCurrentSubworldDescriptor(false);
                cachedRegion = new CachedRegion(this, key, this.world, worldName, subWorldName, regionX, regionZ);
                this.cachedRegions.put(key, cachedRegion);
                CachedRegion[] cachedRegionArray = this.cachedRegionsPool;
                // MONITORENTER : this.cachedRegionsPool
                this.cachedRegionsPool.add(cachedRegion);
                // MONITOREXIT : cachedRegionArray
                cachedRegionArray = this.lastRegionsArray;
                // MONITORENTER : this.lastRegionsArray
                if (regionX >= this.lastLeft && regionX <= this.lastRight && regionZ >= this.lastTop && regionZ <= this.lastBottom) {
                    this.lastRegionsArray[(regionZ - this.lastTop) * (this.lastRight - this.lastLeft + 1) + (regionX - this.lastLeft)] = cachedRegion;
                }
                // MONITOREXIT : cachedRegionArray
            }
            // MONITOREXIT : concurrentHashMap
            if (class_310.method_1551().field_1755 != null && class_310.method_1551().field_1755 instanceof GuiPersistentMap) {
                cachedRegion.registerChangeAt(chunkX, chunkZ);
                cachedRegion.refresh(false);
                return;
            }
            cachedRegion.handleChangedChunk(chunk);
            return;
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private boolean isChunkReady(class_638 world, class_2818 chunk) {
        return this.chunkCache.isChunkSurroundedByLoaded(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
    }

    @Override
    public boolean isRegionLoaded(int blockX, int blockZ) {
        int x = (int)Math.floor((float)blockX / 256.0f);
        int z = (int)Math.floor((float)blockZ / 256.0f);
        CachedRegion cachedRegion = this.cachedRegions.get("" + x + "," + z);
        if (cachedRegion == null) {
            return false;
        }
        return cachedRegion.isLoaded();
    }

    @Override
    public boolean isGroundAt(int blockX, int blockZ) {
        int x = (int)Math.floor((float)blockX / 256.0f);
        int z = (int)Math.floor((float)blockZ / 256.0f);
        CachedRegion cachedRegion = this.cachedRegions.get("" + x + "," + z);
        if (cachedRegion == null) {
            return false;
        }
        return cachedRegion.isGroundAt(blockX, blockZ);
    }

    @Override
    public int getHeightAt(int blockX, int blockZ) {
        int x = (int)Math.floor((float)blockX / 256.0f);
        int z = (int)Math.floor((float)blockZ / 256.0f);
        CachedRegion cachedRegion = this.cachedRegions.get("" + x + "," + z);
        if (cachedRegion == null) {
            return 64;
        }
        return cachedRegion.getHeightAt(blockX, blockZ);
    }

    private class ChunkWithAge {
        class_2818 chunk;
        int tick;

        public ChunkWithAge(class_2818 chunk, int tick) {
            this.chunk = chunk;
            this.tick = tick;
        }
    }

    private class RegionCoordinates {
        int x;
        int z;

        public RegionCoordinates(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }
}

