/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.class_2378;
import net.minecraft.class_2869;
import net.minecraft.class_2874;
import net.minecraft.class_2960;

public class DimensionManager
implements IDimensionManager {
    IVoxelMap master;
    public ArrayList<DimensionContainer> dimensions;
    public static final int NOT_LOADED_ID = -9999;
    public static final String NOT_LOADED = "Unknown Dimension";
    public static final String FAILED_TO_LOAD = "Failed Dimension";

    public DimensionManager(IVoxelMap master) {
        this.master = master;
        this.dimensions = new ArrayList();
    }

    @Override
    public ArrayList<DimensionContainer> getDimensions() {
        return this.dimensions;
    }

    @Override
    public void populateDimensions() {
        this.dimensions.clear();
        for (class_2874 dimensionType : class_2378.field_11155) {
            int id = dimensionType.method_12484();
            String name = class_2874.method_12485((class_2874)dimensionType).method_12832();
            class_2960 resourceLocation = class_2874.method_12485((class_2874)dimensionType);
            DimensionContainer dim = new DimensionContainer(dimensionType, name, id, resourceLocation);
            this.dimensions.add(dim);
        }
        this.sort();
    }

    @Override
    public void enteredDimension(class_2869 dimension) {
        int id = dimension.method_12460().method_12484();
        DimensionContainer dim = this.getDimensionContainerByID(id);
        if (dim == null) {
            dim = this.getDimensionContainerByResourceLocation(class_2874.method_12485((class_2874)dimension.method_12460()));
        }
        if (dim == null) {
            dim = new DimensionContainer(dimension.method_12460(), NOT_LOADED, id, null);
            this.dimensions.add(dim);
            this.sort();
        }
        if (dim.name.equals(NOT_LOADED) || dim.name.equals(FAILED_TO_LOAD)) {
            class_2874 type;
            dim.type = type = dimension.method_12460();
            dim.id = id;
            try {
                dim.name = class_2874.method_12485((class_2874)type).method_12832();
                dim.resourceLocation = class_2874.method_12485((class_2874)type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sort() {
        Collections.sort(this.dimensions, new Comparator<DimensionContainer>(){

            @Override
            public int compare(DimensionContainer dim1, DimensionContainer dim2) {
                return dim1.id - dim2.id;
            }
        });
    }

    @Override
    public DimensionContainer getDimensionContainerByDimension(class_2869 dimension) {
        int id = dimension.method_12460().method_12484();
        DimensionContainer dim = this.getDimensionContainerByID(id);
        if (dim == null) {
            class_2874 type = dimension.method_12460();
            class_2960 resourceLocation = class_2874.method_12485((class_2874)type);
            dim = new DimensionContainer(type, resourceLocation.method_12832(), id, resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    @Override
    public DimensionContainer getDimensionContainerByIdentifier(String ident) {
        DimensionContainer dim = null;
        int id = -9999;
        class_2960 resourceLocation = null;
        try {
            id = Integer.parseInt(ident);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id != -9999) {
            dim = this.getDimensionContainerByID(id);
        } else if (ident.contains(" ")) {
            String[] parts = ident.split(" ");
            resourceLocation = new class_2960(parts[0]);
            try {
                id = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            dim = id != -9999 ? this.getDimensionContainerByID(id) : this.getDimensionContainerByResourceLocation(resourceLocation);
        } else {
            resourceLocation = new class_2960(ident);
            dim = this.getDimensionContainerByResourceLocation(new class_2960(ident));
        }
        if (dim == null) {
            dim = new DimensionContainer(null, NOT_LOADED, id, resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    private DimensionContainer getDimensionContainerByID(int id) {
        for (DimensionContainer dim : this.dimensions) {
            if (dim.id != id) continue;
            return dim;
        }
        return null;
    }

    private DimensionContainer getDimensionContainerByResourceLocation(class_2960 resourceLocation) {
        for (DimensionContainer dim : this.dimensions) {
            if (!resourceLocation.equals((Object)dim.resourceLocation)) continue;
            return dim;
        }
        return null;
    }
}

