/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.class_1159;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2818;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_316;
import net.minecraft.class_327;
import net.minecraft.class_380;
import net.minecraft.class_384;
import net.minecraft.class_4587;
import net.minecraft.class_4590;
import net.minecraft.class_4597;

public class WaypointContainer {
    private ArrayList<Waypoint> wayPts = new ArrayList();
    private Waypoint highlightedWaypoint = null;
    private class_310 mc = class_310.method_1551();
    public MapSettingsManager options = null;
    private final String TARGETFLAG = "*&^TARget%$^";
    private static final class_384 EMPTY_GLYPH_RENDERER = new class_384();
    private static final class_380 atlas = new class_380(new class_2960("missingno"), true);

    public WaypointContainer(MapSettingsManager options) {
        this.options = options;
    }

    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.wayPts.remove(waypoint);
    }

    public void setHighlightedWaypoint(Waypoint highlightedWaypoint) {
        this.highlightedWaypoint = highlightedWaypoint;
    }

    private void sortWaypoints() {
        Collections.sort(this.wayPts, Collections.reverseOrder());
    }

    public void renderWaypoints(float partialTicks, class_4587 matrixStack) {
        this.sortWaypoints();
        class_1297 cameraEntity = this.options.game.method_1560();
        double renderPosX = cameraEntity.field_6038 + (cameraEntity.method_23317() - cameraEntity.field_6038) * (double)partialTicks;
        double renderPosY = cameraEntity.field_5971 + (cameraEntity.method_23318() - cameraEntity.field_5971) * (double)partialTicks;
        double renderPosZ = cameraEntity.field_5989 + (cameraEntity.method_23321() - cameraEntity.field_5989) * (double)partialTicks;
        GLShim.glEnable(2884);
        GLShim.glPushMatrix();
        GLShim.glRotatef(this.mc.method_1561().field_4686.method_19329(), 1.0f, 0.0f, 0.0f);
        GLShim.glRotatef(this.mc.method_1561().field_4686.method_19330() - 180.0f, 0.0f, 1.0f, 0.0f);
        for (Waypoint pt : this.wayPts) {
            double distance;
            if (!pt.isActive() && pt != this.highlightedWaypoint) continue;
            int x = pt.getX();
            int z = pt.getZ();
            int y = pt.getY();
            class_2818 chunk = this.mc.field_1687.method_8497(x >> 4, z >> 4);
            if (this.options.showBeacons && chunk != null && !chunk.method_12223() && this.mc.field_1687.method_8393(x >> 4, z >> 4)) {
                double bottomOfWorld = 0.0 - renderPosY;
                this.renderBeam(pt, (double)x - renderPosX, bottomOfWorld, (double)z - renderPosZ, 64.0f);
            }
            if (!((distance = Math.sqrt(pt.getDistanceSqToEntity(cameraEntity))) < (double)this.options.maxWaypointDisplayDistance) && this.options.maxWaypointDisplayDistance >= 0 && pt != this.highlightedWaypoint || !this.options.showWaypoints || this.options.game.field_1690.field_1842) continue;
            boolean isPointedAt = this.isPointedAt(pt, distance, cameraEntity, Float.valueOf(partialTicks));
            String label = pt.name;
            this.renderLabel(pt, distance, isPointedAt, label, (double)x - renderPosX, (double)y - renderPosY - 0.5, (double)z - renderPosZ, 64);
        }
        if (this.highlightedWaypoint != null && this.options.showWaypoints && !this.options.game.field_1690.field_1842) {
            int x = this.highlightedWaypoint.getX();
            int z = this.highlightedWaypoint.getZ();
            int y = this.highlightedWaypoint.getY();
            double distance = Math.sqrt(this.highlightedWaypoint.getDistanceSqToEntity(cameraEntity));
            boolean isPointedAt = this.isPointedAt(this.highlightedWaypoint, distance, cameraEntity, Float.valueOf(partialTicks));
            this.renderLabel(this.highlightedWaypoint, distance, isPointedAt, "*&^TARget%$^", (double)x - renderPosX, (double)y - renderPosY - 0.5, (double)z - renderPosZ, 64);
        }
        GLShim.glPopMatrix();
    }

    private boolean isPointedAt(Waypoint waypoint, double distance, class_1297 cameraEntity, Float partialTicks) {
        class_243 cameraPos = cameraEntity.method_5836(partialTicks.floatValue());
        double degrees = 5.0 + Math.min(5.0 / distance, 5.0);
        double angle = degrees * 0.0174533;
        double size = Math.sin(angle) * distance;
        class_243 cameraPosPlusDirection = cameraEntity.method_5828(partialTicks.floatValue());
        class_243 cameraPosPlusDirectionTimesDistance = cameraPos.method_1031(cameraPosPlusDirection.field_1352 * distance, cameraPosPlusDirection.field_1351 * distance, cameraPosPlusDirection.field_1350 * distance);
        class_238 axisalignedbb = new class_238((double)((float)waypoint.getX() + 0.5f) - size, (double)((float)waypoint.getY() + 1.5f) - size, (double)((float)waypoint.getZ() + 0.5f) - size, (double)((float)waypoint.getX() + 0.5f) + size, (double)((float)waypoint.getY() + 1.5f) + size, (double)((float)waypoint.getZ() + 0.5f) + size);
        Optional raytraceresult = axisalignedbb.method_992(cameraPos, cameraPosPlusDirectionTimesDistance);
        return axisalignedbb.method_1006(cameraPos) ? distance >= 1.0 : raytraceresult.isPresent();
    }

    private void renderBeam(Waypoint par1EntityWaypoint, double baseX, double baseY, double baseZ, float par8) {
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        GLShim.glDisable(3553);
        GLShim.glDisable(2896);
        GLShim.glDisable(2912);
        GLShim.glEnable(2929);
        GLShim.glDepthMask(false);
        GLShim.glEnable(3042);
        GLShim.glBlendFunc(770, 1);
        int height = 256;
        float brightness = 0.06f;
        double topWidthFactor = 1.05;
        double bottomWidthFactor = 1.05;
        float r = par1EntityWaypoint.red;
        float b = par1EntityWaypoint.blue;
        float g = par1EntityWaypoint.green;
        for (int width = 0; width < 4; ++width) {
            vertexBuffer.method_1328(5, class_290.field_1576);
            double d6 = 0.1 + (double)width * 0.2;
            d6 *= topWidthFactor;
            double d7 = 0.1 + (double)width * 0.2;
            d7 *= bottomWidthFactor;
            for (int side = 0; side < 5; ++side) {
                double vertX2 = baseX + 0.5 - d6;
                double vertZ2 = baseZ + 0.5 - d6;
                if (side == 1 || side == 2) {
                    vertX2 += d6 * 2.0;
                }
                if (side == 2 || side == 3) {
                    vertZ2 += d6 * 2.0;
                }
                double vertX1 = baseX + 0.5 - d7;
                double vertZ1 = baseZ + 0.5 - d7;
                if (side == 1 || side == 2) {
                    vertX1 += d7 * 2.0;
                }
                if (side == 2 || side == 3) {
                    vertZ1 += d7 * 2.0;
                }
                vertexBuffer.method_22912(vertX1, baseY + 0.0, vertZ1).method_22915(r * brightness, g * brightness, b * brightness, 0.8f).method_1344();
                vertexBuffer.method_22912(vertX2, baseY + (double)height, vertZ2).method_22915(r * brightness, g * brightness, b * brightness, 0.8f).method_1344();
            }
            tessellator.method_1350();
        }
        GLShim.glDisable(3042);
        GLShim.glEnable(2912);
        GLShim.glEnable(2896);
        GLShim.glEnable(3553);
        GLShim.glDepthMask(true);
    }

    private void renderLabel(Waypoint pt, double distance, boolean isPointedAt, String name, double par3, double par5, double par7, int par9) {
        Sprite icon;
        boolean target;
        GLShim.glAlphaFunc(516, 0.1f);
        boolean bl = target = name == "*&^TARget%$^";
        if (target) {
            if (pt.red == 2.0f && pt.green == 0.0f && pt.blue == 0.0f) {
                name = "X:" + pt.getX() + ", Y:" + pt.getY() + ", Z:" + pt.getZ();
            } else {
                isPointedAt = false;
            }
        }
        name = name + " (" + (int)distance + "m)";
        double maxDistance = class_316.field_1933.method_18613(this.options.game.field_1690) * 16.0 * 0.99;
        double adjustedDistance = distance;
        if (distance > maxDistance) {
            par3 = par3 / distance * maxDistance;
            par5 = par5 / distance * maxDistance;
            par7 = par7 / distance * maxDistance;
            adjustedDistance = maxDistance;
        }
        float var14 = ((float)adjustedDistance * 0.1f + 1.0f) * 0.0266f;
        GLShim.glPushMatrix();
        GLShim.glTranslatef((float)par3 + 0.5f, (float)par5 + 0.5f, (float)par7 + 0.5f);
        GLShim.glNormal3f(0.0f, 1.0f, 0.0f);
        GLShim.glRotatef(-this.mc.method_1561().field_4686.method_19330(), 0.0f, 1.0f, 0.0f);
        GLShim.glRotatef(this.mc.method_1561().field_4686.method_19329(), 1.0f, 0.0f, 0.0f);
        GLShim.glScalef(-var14, -var14, var14);
        GLShim.glDisable(2896);
        GLShim.glDisable(2912);
        GLShim.glEnable(3042);
        GLShim.glBlendFunc(770, 771);
        class_289 tessellator = class_289.method_1348();
        class_287 vertexBuffer = tessellator.method_1349();
        float fade = distance > 5.0 ? 1.0f : (float)distance / 5.0f;
        fade = Math.min(fade, pt.enabled || target ? 1.0f : 0.3f);
        if (distance < maxDistance) {
            GLShim.glDepthMask(true);
        }
        GLShim.glEnable(3553);
        double width = 10.0;
        float r = target ? 1.0f : pt.red;
        float g = target ? 0.0f : pt.green;
        float b = target ? 0.0f : pt.blue;
        TextureAtlas textureAtlas = AbstractVoxelMap.getInstance().getWaypointManager().getTextureAtlas();
        Sprite sprite = icon = target ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
        if (icon == textureAtlas.getMissingImage()) {
            icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
        }
        GLUtils.disp(textureAtlas.method_4624());
        GLShim.glEnable(2929);
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_22912(-width, -width, 0.0).method_22913(icon.getMinU(), icon.getMinV()).method_22915(r, g, b, 1.0f * fade).method_1344();
        vertexBuffer.method_22912(-width, width, 0.0).method_22913(icon.getMinU(), icon.getMaxV()).method_22915(r, g, b, 1.0f * fade).method_1344();
        vertexBuffer.method_22912(width, width, 0.0).method_22913(icon.getMaxU(), icon.getMaxV()).method_22915(r, g, b, 1.0f * fade).method_1344();
        vertexBuffer.method_22912(width, -width, 0.0).method_22913(icon.getMaxU(), icon.getMinV()).method_22915(r, g, b, 1.0f * fade).method_1344();
        tessellator.method_1350();
        GLShim.glDisable(2929);
        GLShim.glDepthMask(false);
        vertexBuffer.method_1328(7, class_290.field_1575);
        vertexBuffer.method_22912(-width, -width, 0.0).method_22913(icon.getMinU(), icon.getMinV()).method_22915(r, g, b, 0.3f * fade).method_1344();
        vertexBuffer.method_22912(-width, width, 0.0).method_22913(icon.getMinU(), icon.getMaxV()).method_22915(r, g, b, 0.3f * fade).method_1344();
        vertexBuffer.method_22912(width, width, 0.0).method_22913(icon.getMaxU(), icon.getMaxV()).method_22915(r, g, b, 0.3f * fade).method_1344();
        vertexBuffer.method_22912(width, -width, 0.0).method_22913(icon.getMaxU(), icon.getMinV()).method_22915(r, g, b, 0.3f * fade).method_1344();
        tessellator.method_1350();
        GLShim.glDepthMask(false);
        GLShim.glDisable(2929);
        int elevateBy = -19;
        class_327 fontRenderer = this.mc.method_1561().method_3949();
        if (isPointedAt && fontRenderer != null) {
            GLShim.glDisable(3553);
            int halfStringWidth = fontRenderer.method_1727(name) / 2;
            GLShim.glEnable(2929);
            if (distance < maxDistance) {
                GLShim.glDepthMask(true);
            }
            GLShim.glEnable(32823);
            GLShim.glPolygonOffset(1.0f, 3.0f);
            vertexBuffer.method_1328(7, class_290.field_1576);
            vertexBuffer.method_22912((double)(-halfStringWidth - 2), (double)(-2 + elevateBy), 0.0).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade).method_1344();
            vertexBuffer.method_22912((double)(-halfStringWidth - 2), (double)(9 + elevateBy), 0.0).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade).method_1344();
            vertexBuffer.method_22912((double)(halfStringWidth + 2), (double)(9 + elevateBy), 0.0).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade).method_1344();
            vertexBuffer.method_22912((double)(halfStringWidth + 2), (double)(-2 + elevateBy), 0.0).method_22915(pt.red, pt.green, pt.blue, 0.6f * fade).method_1344();
            tessellator.method_1350();
            GLShim.glPolygonOffset(1.0f, 1.0f);
            vertexBuffer.method_1328(7, class_290.field_1576);
            vertexBuffer.method_22912((double)(-halfStringWidth - 1), (double)(-1 + elevateBy), 0.0).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade).method_1344();
            vertexBuffer.method_22912((double)(-halfStringWidth - 1), (double)(8 + elevateBy), 0.0).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade).method_1344();
            vertexBuffer.method_22912((double)(halfStringWidth + 1), (double)(8 + elevateBy), 0.0).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade).method_1344();
            vertexBuffer.method_22912((double)(halfStringWidth + 1), (double)(-1 + elevateBy), 0.0).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade).method_1344();
            tessellator.method_1350();
            GLShim.glDisable(2929);
            GLShim.glDepthMask(false);
            GLShim.glPolygonOffset(1.0f, 7.0f);
            vertexBuffer.method_1328(7, class_290.field_1576);
            vertexBuffer.method_22912((double)(-halfStringWidth - 2), (double)(-2 + elevateBy), 0.0).method_22915(pt.red, pt.green, pt.blue, 0.15f * fade).method_1344();
            vertexBuffer.method_22912((double)(-halfStringWidth - 2), (double)(9 + elevateBy), 0.0).method_22915(pt.red, pt.green, pt.blue, 0.15f * fade).method_1344();
            vertexBuffer.method_22912((double)(halfStringWidth + 2), (double)(9 + elevateBy), 0.0).method_22915(pt.red, pt.green, pt.blue, 0.15f * fade).method_1344();
            vertexBuffer.method_22912((double)(halfStringWidth + 2), (double)(-2 + elevateBy), 0.0).method_22915(pt.red, pt.green, pt.blue, 0.15f * fade).method_1344();
            tessellator.method_1350();
            GLShim.glPolygonOffset(1.0f, 5.0f);
            vertexBuffer.method_1328(7, class_290.field_1576);
            vertexBuffer.method_22912((double)(-halfStringWidth - 1), (double)(-1 + elevateBy), 0.0).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade).method_1344();
            vertexBuffer.method_22912((double)(-halfStringWidth - 1), (double)(8 + elevateBy), 0.0).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade).method_1344();
            vertexBuffer.method_22912((double)(halfStringWidth + 1), (double)(8 + elevateBy), 0.0).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade).method_1344();
            vertexBuffer.method_22912((double)(halfStringWidth + 1), (double)(-1 + elevateBy), 0.0).method_22915(0.0f, 0.0f, 0.0f, 0.15f * fade).method_1344();
            tessellator.method_1350();
            GLShim.glDisable(32823);
            GLShim.glEnable(3553);
            int textColor = (int)(255.0f * fade) << 24 | 0xCCCCCC;
            class_1159 matrix4f = class_4590.method_22931().method_22936();
            class_4597.class_4598 vertexConsumerProvider = this.mc.method_22940().method_23000();
            fontRenderer.method_22942(name, (float)(-fontRenderer.method_1727(name) / 2), (float)elevateBy, textColor, false, matrix4f, (class_4597)vertexConsumerProvider, true, 0, 0xF000F0);
            vertexConsumerProvider.method_22993();
            GLShim.glEnable(2929);
            textColor = (int)(255.0f * fade) << 24 | 0xFFFFFF;
            fontRenderer.method_1729(name, (float)(-fontRenderer.method_1727(name) / 2), (float)elevateBy, textColor);
        }
        GLShim.glEnable(2929);
        GLShim.glDepthMask(true);
        GLShim.glEnable(2912);
        GLShim.glEnable(2896);
        GLShim.glDisable(3042);
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLShim.glPopMatrix();
    }
}

