/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiSelectPlayer;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mojang.authlib.GameProfile;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;

public class GuiButtonRowListPlayers
extends GuiListExtended {
    private final ArrayList<Row> rows = new ArrayList();
    private final Minecraft mc = Minecraft.func_71410_x();
    private ArrayList<NetworkPlayerInfo> players;
    private ArrayList<NetworkPlayerInfo> playersFiltered;
    final GuiSelectPlayer parentGui;
    Row everyoneRow;

    public GuiButtonRowListPlayers(GuiSelectPlayer par1GuiSelectPlayer) {
        super(Minecraft.func_71410_x(), par1GuiSelectPlayer.getWidth(), par1GuiSelectPlayer.getHeight(), 89, par1GuiSelectPlayer.getHeight() - 65 + 4, 25);
        this.parentGui = par1GuiSelectPlayer;
        NetHandlerPlayClient netHandlerPlayClient = Minecraft.func_71410_x().field_71439_g.field_71174_a;
        this.players = new ArrayList(netHandlerPlayClient.func_175106_d());
        this.sort();
        GuiButton everyoneButton = new GuiButton(-1, this.parentGui.getWidth() / 2 - 75, 0, 150, 20, I18nUtils.getString("minimap.waypointshare.all", new Object[0]));
        this.everyoneRow = new Row(everyoneButton);
        this.updateFilter("");
    }

    public String getPlayerName(NetworkPlayerInfo networkPlayerInfoIn) {
        return networkPlayerInfoIn.func_178854_k() != null ? networkPlayerInfoIn.func_178854_k().func_150260_c() : TextFormatting.func_110646_a((String)networkPlayerInfoIn.func_178845_a().getName());
    }

    private GuiButton createButtonFor(Minecraft mcIn, int x, int y, NetworkPlayerInfo networkPlayerInfo, int index) {
        if (networkPlayerInfo == null) {
            return null;
        }
        String name = this.getPlayerName(networkPlayerInfo);
        return new GuiButton(index, x, y, 150, 20, name);
    }

    public Row getListEntry(int index) {
        return this.rows.get(index);
    }

    protected int func_148127_b() {
        return this.rows.size();
    }

    public int func_148139_c() {
        return 400;
    }

    protected int func_148137_d() {
        return super.func_148137_d() + 32;
    }

    protected void sort() {
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(this.players, new Comparator<NetworkPlayerInfo>(){

            @Override
            public int compare(NetworkPlayerInfo player1, NetworkPlayerInfo player2) {
                String name1 = GuiButtonRowListPlayers.this.getPlayerName(player1);
                String name2 = GuiButtonRowListPlayers.this.getPlayerName(player2);
                return collator.compare(name1, name2);
            }
        });
    }

    protected void updateFilter(String filterString) {
        this.playersFiltered = new ArrayList<NetworkPlayerInfo>(this.players);
        Iterator<NetworkPlayerInfo> iterator = this.playersFiltered.iterator();
        while (iterator.hasNext()) {
            NetworkPlayerInfo networkPlayerInfo = iterator.next();
            String name = this.getPlayerName(networkPlayerInfo);
            if (name.toLowerCase().contains(filterString)) continue;
            iterator.remove();
        }
        this.rows.clear();
        this.rows.add(this.everyoneRow);
        for (int i = 0; i < this.playersFiltered.size(); i += 2) {
            NetworkPlayerInfo networkPlayerInfo1 = this.playersFiltered.get(i);
            NetworkPlayerInfo networkPlayerInfo2 = i < this.playersFiltered.size() - 1 ? this.playersFiltered.get(i + 1) : null;
            GuiButton guibutton1 = this.createButtonFor(this.mc, this.parentGui.getWidth() / 2 - 155, 0, networkPlayerInfo1, i);
            GuiButton guibutton2 = this.createButtonFor(this.mc, this.parentGui.getWidth() / 2 - 155 + 160, 0, networkPlayerInfo2, i + 1);
            this.rows.add(new Row(guibutton1, guibutton2));
        }
    }

    public void buttonClicked(int id) {
        if (id == -1) {
            this.parentGui.allClicked = true;
            String title = I18nUtils.getString("minimap.waypointshare.sharewitheveryone", new Object[0]);
            String explanation = I18nUtils.getString("minimap.waypointshare.sharewitheveryone2", new Object[0]);
            String affirm = I18nUtils.getString("gui.yes", new Object[0]);
            String deny = I18nUtils.getString("gui.cancel", new Object[0]);
            GuiYesNo confirmScreen = new GuiYesNo((GuiYesNoCallback)this.parentGui, title, explanation, affirm, deny, 0);
            this.mc.func_147108_a((GuiScreen)confirmScreen);
        } else {
            Mouse.next();
            NetworkPlayerInfo networkPlayerInfo = this.playersFiltered.get(id);
            String name = this.getPlayerName(networkPlayerInfo);
            this.parentGui.sendMessageToPlayer(name);
        }
    }

    public class Row
    implements GuiListExtended.IGuiListEntry {
        private final Minecraft client = Minecraft.func_71410_x();
        private GuiButton button = null;
        private GuiButton button1 = null;
        private GuiButton button2 = null;

        public Row(GuiButton button) {
            this.button = button;
        }

        public Row(GuiButton button1, GuiButton button2) {
            this.button1 = button1;
            this.button2 = button2;
        }

        public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            this.drawButton(this.button, slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partialTicks);
            this.drawButton(this.button1, slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partialTicks);
            this.drawButton(this.button2, slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partialTicks);
        }

        private void drawButton(GuiButton button, int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
            if (button != null) {
                button.field_146129_i = y;
                button.func_191745_a(this.client, mouseX, mouseY, partialTicks);
                if (button.field_146127_k != -1) {
                    this.drawIconForButton(button);
                }
                if (button.func_146115_a() && mouseY >= GuiButtonRowListPlayers.this.field_148153_b && mouseY <= GuiButtonRowListPlayers.this.field_148154_c) {
                    String tooltip = I18nUtils.getString("minimap.waypointshare.sharewithname", button.field_146126_j);
                    GuiSelectPlayer.setTooltip(GuiButtonRowListPlayers.this.parentGui, tooltip);
                }
            }
        }

        private void drawIconForButton(GuiButton button) {
            NetworkPlayerInfo networkPlayerInfo = (NetworkPlayerInfo)GuiButtonRowListPlayers.this.playersFiltered.get(button.field_146127_k);
            GameProfile gameProfile = networkPlayerInfo.func_178845_a();
            EntityPlayer entityPlayer = ((GuiButtonRowListPlayers)GuiButtonRowListPlayers.this).mc.field_71441_e.func_152378_a(gameProfile.getId());
            GuiButtonRowListPlayers.this.mc.func_110434_K().func_110577_a(networkPlayerInfo.func_178837_g());
            Gui.func_152125_a((int)(button.field_146128_h + 6), (int)(button.field_146129_i + 6), (float)8.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
            if (entityPlayer != null && entityPlayer.func_175148_a(EnumPlayerModelParts.HAT)) {
                Gui.func_152125_a((int)(button.field_146128_h + 6), (int)(button.field_146129_i + 6), (float)40.0f, (float)8.0f, (int)8, (int)8, (int)8, (int)8, (float)64.0f, (float)64.0f);
            }
        }

        public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
            if (this.button != null && this.button.func_146116_c(this.client, mouseX, mouseY)) {
                GuiButtonRowListPlayers.this.buttonClicked(this.button.field_146127_k);
                return true;
            }
            if (this.button1 != null && this.button1.func_146116_c(this.client, mouseX, mouseY)) {
                GuiButtonRowListPlayers.this.buttonClicked(this.button1.field_146127_k);
                return true;
            }
            if (this.button2 != null && this.button2.func_146116_c(this.client, mouseX, mouseY)) {
                GuiButtonRowListPlayers.this.buttonClicked(this.button2.field_146127_k);
                return true;
            }
            return false;
        }

        public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
            if (this.button != null) {
                this.button.func_146118_a(x, y);
            }
            if (this.button1 != null) {
                this.button1.func_146118_a(x, y);
            }
            if (this.button2 != null) {
                this.button2.func_146118_a(x, y);
            }
        }

        public void func_192633_a(int p_178011_1_, int p_178011_2_, int p_178011_3_, float partialTicks) {
        }
    }
}

