/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Mouse;

class GuiSlotWaypoints
extends GuiSlotMinimap {
    private ArrayList<Waypoint> waypoints;
    private ArrayList<Waypoint> waypointsFiltered;
    final GuiWaypoints parentGui;
    private String filterString = "";

    public GuiSlotWaypoints(GuiWaypoints par1GuiWaypoints) {
        super(par1GuiWaypoints.options.game, par1GuiWaypoints.getWidth(), par1GuiWaypoints.getHeight(), 54, par1GuiWaypoints.getHeight() - 90 + 4, 18);
        this.parentGui = par1GuiWaypoints;
        this.waypoints = new ArrayList();
        for (Waypoint pt : this.parentGui.waypointManager.getWaypoints()) {
            if (!pt.inWorld || !pt.inDimension) continue;
            this.waypoints.add(pt);
        }
        this.waypointsFiltered = new ArrayList<Waypoint>(this.waypoints);
    }

    @Override
    protected int getSize() {
        return this.waypointsFiltered.size();
    }

    @Override
    protected void elementClicked(int par1, boolean par2, int par3, int par4) {
        this.parentGui.setSelectedWaypoint(this.waypointsFiltered.get(par1));
        int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
        int padding = 3;
        int width = 215;
        if (this.mouseX >= leftEdge + width - 16 - padding && this.mouseX <= leftEdge + width + padding) {
            if (par2) {
                this.parentGui.setHighlightedWaypoint();
            } else {
                this.parentGui.toggleWaypointVisibility();
            }
        } else if (par2) {
            Mouse.next();
            this.parentGui.editWaypoint(this.parentGui.selectedWaypoint);
            return;
        }
    }

    @Override
    protected boolean isSelected(int par1) {
        return this.waypointsFiltered.get(par1).equals(this.parentGui.selectedWaypoint);
    }

    @Override
    protected int getContentHeight() {
        return this.getSize() * this.slotHeight;
    }

    @Override
    protected void drawBackground() {
        this.parentGui.func_146276_q_();
    }

    @Override
    protected void drawSlot(int slotIndex, int leftEdge, int slotYPos, int topFudge, int mouseX, int mouseY, float partialTicks) {
        Waypoint waypoint = this.waypointsFiltered.get(slotIndex);
        this.parentGui.func_73732_a(this.parentGui.getFontRenderer(), waypoint.name, this.parentGui.getWidth() / 2, slotYPos + 3, waypoint.getUnified());
        int padding = 3;
        if (this.mouseX >= leftEdge - padding && this.mouseY >= slotYPos && this.mouseX <= leftEdge + 215 + padding && this.mouseY <= slotYPos + this.slotHeight) {
            String tooltip;
            if (this.mouseX >= leftEdge + 215 - 16 - padding && this.mouseX <= leftEdge + 215 + padding) {
                tooltip = waypoint.enabled ? I18nUtils.getString("minimap.waypoints.disable", new Object[0]) : I18nUtils.getString("minimap.waypoints.enable", new Object[0]);
            } else {
                tooltip = "X: " + waypoint.getX() + " Z: " + waypoint.getZ();
                if (waypoint.getY() > 0) {
                    tooltip = tooltip + " Y: " + waypoint.getY();
                }
            }
            if (this.mouseX >= this.left && this.mouseX <= this.right && this.mouseY >= this.top && this.mouseY <= this.bottom) {
                GuiWaypoints.setTooltip(this.parentGui, tooltip);
            }
        }
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLUtils.img("textures/gui/container/inventory.png");
        int xOffset = waypoint.enabled ? 72 : 90;
        int yOffset = 216;
        this.parentGui.func_73729_b(leftEdge + 198, slotYPos - 2, xOffset, yOffset, 16, 16);
        if (waypoint == this.parentGui.highlightedWaypoint) {
            int x = leftEdge + 199;
            int y = slotYPos - 1;
            GLShim.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
            TextureAtlas textureAtlas = this.parentGui.waypointManager.getTextureAtlas();
            GLUtils.disp(textureAtlas.func_110552_b());
            Sprite icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png");
            this.drawTexturedModalRect(x, y, icon, 16, 16);
        }
    }

    public void drawTexturedModalRect(int xCoord, int yCoord, Sprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), 1.0).func_187315_a((double)textureSprite.getMinU(), (double)textureSprite.getMaxV()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), 1.0).func_187315_a((double)textureSprite.getMaxU(), (double)textureSprite.getMaxV()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), 1.0).func_187315_a((double)textureSprite.getMaxU(), (double)textureSprite.getMinV()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), 1.0).func_187315_a((double)textureSprite.getMinU(), (double)textureSprite.getMinV()).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void sortBy(int sortKey, boolean ascending) {
        final int order = ascending ? 1 : -1;
        this.parentGui.options.getClass();
        if (sortKey == 1) {
            final ArrayList<Waypoint> masterWaypointsList = this.parentGui.waypointManager.getWaypoints();
            Collections.sort(this.waypoints, new Comparator<Waypoint>(){

                @Override
                public int compare(Waypoint waypoint1, Waypoint waypoint2) {
                    return Double.compare(masterWaypointsList.indexOf(waypoint1), masterWaypointsList.indexOf(waypoint2)) * order;
                }
            });
        } else {
            this.parentGui.options.getClass();
            if (sortKey == 3) {
                if (ascending) {
                    Collections.sort(this.waypoints);
                } else {
                    Collections.sort(this.waypoints, Collections.reverseOrder());
                }
            } else {
                this.parentGui.options.getClass();
                if (sortKey == 2) {
                    final Collator collator = I18nUtils.getLocaleAwareCollator();
                    Collections.sort(this.waypoints, new Comparator<Waypoint>(){

                        @Override
                        public int compare(Waypoint waypoint1, Waypoint waypoint2) {
                            return collator.compare(waypoint1.name, waypoint2.name) * order;
                        }
                    });
                } else {
                    this.parentGui.options.getClass();
                    if (sortKey == 4) {
                        Collections.sort(this.waypoints, new Comparator<Waypoint>(){

                            @Override
                            public int compare(Waypoint waypoint1, Waypoint waypoint2) {
                                float hue1 = Color.RGBtoHSB((int)(waypoint1.red * 255.0f), (int)(waypoint1.green * 255.0f), (int)(waypoint1.blue * 255.0f), null)[0];
                                float hue2 = Color.RGBtoHSB((int)(waypoint2.red * 255.0f), (int)(waypoint2.green * 255.0f), (int)(waypoint2.blue * 255.0f), null)[0];
                                return Double.compare(hue1, hue2) * order;
                            }
                        });
                    }
                }
            }
        }
        this.updateFilter(this.filterString);
    }

    protected void updateFilter(String filterString) {
        this.filterString = filterString;
        this.waypointsFiltered = new ArrayList<Waypoint>(this.waypoints);
        Iterator<Waypoint> iterator = this.waypointsFiltered.iterator();
        while (iterator.hasNext()) {
            Waypoint waypoint = iterator.next();
            if (TextFormatting.func_110646_a((String)waypoint.name).toLowerCase().contains(filterString)) continue;
            if (waypoint == this.parentGui.selectedWaypoint) {
                this.parentGui.setSelectedWaypoint(null);
            }
            iterator.remove();
        }
    }
}

