/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiMobs;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

class GuiSlotMobs
extends GuiSlotMinimap {
    private ArrayList<String> mobNames;
    private ArrayList<String> mobNamesFiltered;
    private RadarSettingsManager options;
    final GuiMobs parentGui;

    public GuiSlotMobs(GuiMobs par1GuiMobs) {
        super(par1GuiMobs.options.game, par1GuiMobs.getWidth(), par1GuiMobs.getHeight(), 32, par1GuiMobs.getHeight() - 65 + 4, 18);
        this.parentGui = par1GuiMobs;
        this.options = this.parentGui.options;
        this.mobNames = new ArrayList();
        for (EnumMobs mob : EnumMobs.values()) {
            if (!mob.isTopLevelUnit || (!mob.isHostile || !this.options.showHostiles) && (!mob.isNeutral || !this.options.showNeutrals)) continue;
            this.mobNames.add(mob.id);
        }
        for (CustomMob mob : CustomMobsManager.mobs) {
            if ((!mob.isHostile || !this.options.showHostiles) && (!mob.isNeutral || !this.options.showNeutrals)) continue;
            this.mobNames.add(mob.id);
        }
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(this.mobNames, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                name1 = GuiSlotMobs.getTranslatedName(name1);
                name2 = GuiSlotMobs.getTranslatedName(name2);
                return collator.compare(name1, name2);
            }
        });
        this.mobNamesFiltered = new ArrayList<String>(this.mobNames);
    }

    private static String getTranslatedName(String name) {
        if (name.indexOf(".") == -1) {
            name = "entity.minecraft." + name.toLowerCase();
        }
        name = I18nUtils.getString(name, new Object[0]);
        name = name.replaceAll("^entity.minecraft.", "");
        name = name.replace("_", " ");
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        return name;
    }

    protected int func_148127_b() {
        return this.mobNamesFiltered.size();
    }

    protected boolean func_195078_a(int index, int mouseEvent, double mouseX, double mouseY) {
        this.parentGui.setSelectedMob(this.mobNamesFiltered.get(index));
        int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
        int padding = 3;
        int width = 215;
        if (mouseX >= (double)(leftEdge + width - 16 - padding) && mouseX <= (double)(leftEdge + width + padding)) {
            this.parentGui.toggleMobVisibility();
        } else if (this.doubleclick) {
            this.parentGui.toggleMobVisibility();
        }
        return true;
    }

    protected boolean func_148131_a(int par1) {
        return this.mobNamesFiltered.get(par1).equals(this.parentGui.selectedMobName);
    }

    protected int func_148138_e() {
        return this.func_148127_b() * this.field_148149_f;
    }

    protected void func_148123_a() {
        this.parentGui.func_146276_q_();
    }

    protected void func_192637_a(int slotIndex, int leftEdge, int slotYPos, int topFudgeorHeightIn, int mouseX, int mouseY, float partialTicks) {
        String name = this.mobNamesFiltered.get(slotIndex);
        boolean isHostile = false;
        boolean isNeutral = false;
        boolean isEnabled = true;
        EnumMobs mob = EnumMobs.getMobByName(name);
        if (mob != null) {
            isHostile = mob.isHostile;
            isNeutral = mob.isNeutral;
            isEnabled = mob.enabled;
        } else {
            CustomMob customMob = CustomMobsManager.getCustomMobByType(name);
            if (customMob != null) {
                isHostile = customMob.isHostile;
                isNeutral = customMob.isNeutral;
                isEnabled = customMob.enabled;
            }
        }
        int red = isHostile ? 255 : 0;
        int green = isNeutral ? 255 : 0;
        int color = -16777216 + (red << 16) + (green << 8) + 0;
        this.parentGui.func_73732_a(this.parentGui.getFontRenderer(), GuiSlotMobs.getTranslatedName(name), this.parentGui.getWidth() / 2, slotYPos + 3, color);
        int padding = 3;
        if (mouseX >= leftEdge - padding && mouseY >= slotYPos && mouseX <= leftEdge + 215 + padding && mouseY <= slotYPos + this.field_148149_f) {
            String tooltip = mouseX >= leftEdge + 215 - 16 - padding && mouseX <= leftEdge + 215 + padding ? (isEnabled ? I18nUtils.getString("options.minimap.mobs.disable", new Object[0]) : I18nUtils.getString("options.minimap.mobs.enable", new Object[0])) : (isEnabled ? I18nUtils.getString("options.minimap.mobs.enabled", new Object[0]) : I18nUtils.getString("options.minimap.mobs.disabled", new Object[0]));
            GuiMobs.setTooltip(this.parentGui, tooltip);
        }
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLUtils.img("textures/gui/container/inventory.png");
        int xOffset = isEnabled ? 72 : 90;
        int yOffset = 216;
        this.parentGui.func_73729_b(leftEdge + 198, slotYPos - 2, xOffset, yOffset, 16, 16);
    }

    protected void updateFilter(String filterString) {
        this.mobNamesFiltered = new ArrayList<String>(this.mobNames);
        Iterator<String> iterator = this.mobNamesFiltered.iterator();
        while (iterator.hasNext()) {
            String mobName = iterator.next();
            if (GuiSlotMobs.getTranslatedName(mobName).toLowerCase().contains(filterString)) continue;
            if (mobName == this.parentGui.selectedMobName) {
                this.parentGui.setSelectedMob(null);
            }
            iterator.remove();
        }
    }
}

