/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;

class GuiSlotWaypoints
extends GuiSlotMinimap {
    private ArrayList<Waypoint> waypoints;
    private ArrayList<Waypoint> waypointsFiltered;
    final GuiWaypoints parentGui;
    private String filterString = "";

    public GuiSlotWaypoints(GuiWaypoints par1GuiWaypoints) {
        super(par1GuiWaypoints.options.game, par1GuiWaypoints.getWidth(), par1GuiWaypoints.getHeight(), 54, par1GuiWaypoints.getHeight() - 90 + 4, 18);
        this.parentGui = par1GuiWaypoints;
        this.waypoints = new ArrayList();
        for (Waypoint pt : this.parentGui.waypointManager.getWaypoints()) {
            if (!pt.inWorld || !pt.inDimension) continue;
            this.waypoints.add(pt);
        }
        this.waypointsFiltered = new ArrayList<Waypoint>(this.waypoints);
    }

    protected int func_148127_b() {
        return this.waypointsFiltered.size();
    }

    protected boolean func_195078_a(int index, int mouseEvent, double mouseX, double mouseY) {
        this.parentGui.setSelectedWaypoint(this.waypointsFiltered.get(index));
        int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
        int padding = 3;
        int width = 215;
        if (mouseX >= (double)(leftEdge + width - 16 - padding) && mouseX <= (double)(leftEdge + width + padding)) {
            if (this.doubleclick) {
                this.parentGui.setHighlightedWaypoint();
            }
            this.parentGui.toggleWaypointVisibility();
        } else if (this.doubleclick) {
            this.parentGui.editWaypoint(this.parentGui.selectedWaypoint);
        }
        return true;
    }

    protected boolean func_148131_a(int par1) {
        return this.waypointsFiltered.get(par1).equals(this.parentGui.selectedWaypoint);
    }

    protected int func_148138_e() {
        return this.func_148127_b() * this.field_148149_f;
    }

    protected void func_148123_a() {
        this.parentGui.func_146276_q_();
    }

    protected void func_192637_a(int slotIndex, int leftEdge, int slotYPos, int topFudge, int mouseX, int mouseY, float partialTicks) {
        Waypoint waypoint = this.waypointsFiltered.get(slotIndex);
        this.parentGui.func_73732_a(this.parentGui.getFontRenderer(), waypoint.name, this.parentGui.getWidth() / 2, slotYPos + 3, waypoint.getUnified());
        int padding = 3;
        if (mouseX >= leftEdge - padding && mouseY >= slotYPos && mouseX <= leftEdge + 215 + padding && mouseY <= slotYPos + this.field_148149_f) {
            String tooltip;
            if (mouseX >= leftEdge + 215 - 16 - padding && mouseX <= leftEdge + 215 + padding) {
                tooltip = waypoint.enabled ? I18nUtils.getString("minimap.waypoints.disable", new Object[0]) : I18nUtils.getString("minimap.waypoints.enable", new Object[0]);
            } else {
                tooltip = "X: " + waypoint.getX() + " Z: " + waypoint.getZ();
                if (waypoint.getY() > 0) {
                    tooltip = tooltip + " Y: " + waypoint.getY();
                }
            }
            if (mouseX >= this.field_148152_e && mouseX <= this.field_148151_d && mouseY >= this.field_148153_b && mouseY <= this.field_148154_c) {
                GuiWaypoints.setTooltip(this.parentGui, tooltip);
            }
        }
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLUtils.img("textures/gui/container/inventory.png");
        int xOffset = waypoint.enabled ? 72 : 90;
        int yOffset = 216;
        this.parentGui.func_73729_b(leftEdge + 198, slotYPos - 2, xOffset, yOffset, 16, 16);
        if (waypoint == this.parentGui.highlightedWaypoint) {
            int x = leftEdge + 199;
            int y = slotYPos - 1;
            GLShim.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
            TextureAtlas textureAtlas = this.parentGui.waypointManager.getTextureAtlas();
            GLUtils.disp(textureAtlas.func_110552_b());
            Sprite icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png");
            this.drawTexturedModalRect(x, y, icon, 16, 16);
        }
    }

    public void drawTexturedModalRect(int xCoord, int yCoord, Sprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), 1.0).func_187315_a((double)textureSprite.getMinU(), (double)textureSprite.getMaxV()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), 1.0).func_187315_a((double)textureSprite.getMaxU(), (double)textureSprite.getMaxV()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), 1.0).func_187315_a((double)textureSprite.getMaxU(), (double)textureSprite.getMinV()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), 1.0).func_187315_a((double)textureSprite.getMinU(), (double)textureSprite.getMinV()).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void sortBy(int sortKey, boolean ascending) {
        final int order = ascending ? 1 : -1;
        this.parentGui.options.getClass();
        if (sortKey == 1) {
            final ArrayList<Waypoint> masterWaypointsList = this.parentGui.waypointManager.getWaypoints();
            Collections.sort(this.waypoints, new Comparator<Waypoint>(){

                @Override
                public int compare(Waypoint waypoint1, Waypoint waypoint2) {
                    return Double.compare(masterWaypointsList.indexOf(waypoint1), masterWaypointsList.indexOf(waypoint2)) * order;
                }
            });
        } else {
            this.parentGui.options.getClass();
            if (sortKey == 3) {
                if (ascending) {
                    Collections.sort(this.waypoints);
                } else {
                    Collections.sort(this.waypoints, Collections.reverseOrder());
                }
            } else {
                this.parentGui.options.getClass();
                if (sortKey == 2) {
                    final Collator collator = I18nUtils.getLocaleAwareCollator();
                    Collections.sort(this.waypoints, new Comparator<Waypoint>(){

                        @Override
                        public int compare(Waypoint waypoint1, Waypoint waypoint2) {
                            return collator.compare(waypoint1.name, waypoint2.name) * order;
                        }
                    });
                } else {
                    this.parentGui.options.getClass();
                    if (sortKey == 4) {
                        Collections.sort(this.waypoints, new Comparator<Waypoint>(){

                            @Override
                            public int compare(Waypoint waypoint1, Waypoint waypoint2) {
                                float hue1 = Color.RGBtoHSB((int)(waypoint1.red * 255.0f), (int)(waypoint1.green * 255.0f), (int)(waypoint1.blue * 255.0f), null)[0];
                                float hue2 = Color.RGBtoHSB((int)(waypoint2.red * 255.0f), (int)(waypoint2.green * 255.0f), (int)(waypoint2.blue * 255.0f), null)[0];
                                return Double.compare(hue1, hue2) * order;
                            }
                        });
                    }
                }
            }
        }
        this.updateFilter(this.filterString);
    }

    protected void updateFilter(String filterString) {
        this.filterString = filterString;
        this.waypointsFiltered = new ArrayList<Waypoint>(this.waypoints);
        Iterator<Waypoint> iterator = this.waypointsFiltered.iterator();
        while (iterator.hasNext()) {
            Waypoint waypoint = iterator.next();
            if (TextUtils.scrubCodes(waypoint.name).toLowerCase().contains(filterString)) continue;
            if (waypoint == this.parentGui.selectedWaypoint) {
                this.parentGui.setSelectedWaypoint(null);
            }
            iterator.remove();
        }
    }
}

