/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;

public class GuiSubworldEdit
extends GuiScreenMinimap
implements GuiYesNoCallback {
    private GuiScreen parent;
    private IWaypointManager waypointManager;
    private ArrayList<String> knownSubworldNames;
    private String originalSubworldName = "";
    private String currentSubworldName = "";
    private GuiTextField subworldNameField;
    private boolean deleteClicked = false;

    public GuiSubworldEdit(GuiScreen parent, IVoxelMap master, String subworldName) {
        this.parent = parent;
        this.waypointManager = master.getWaypointManager();
        this.originalSubworldName = subworldName;
        this.knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
    }

    public void func_73876_c() {
        this.subworldNameField.func_146178_a();
    }

    public void func_73866_w_() {
        this.field_146297_k.field_195559_v.func_197967_a(true);
        this.getButtonList().clear();
        this.func_189646_b(new GuiButton(0, this.getWidth() / 2 - 155, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("gui.done", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiSubworldEdit.this.actionPerformed(this);
            }
        });
        this.func_189646_b(new GuiButton(1, this.getWidth() / 2 + 5, this.getHeight() / 6 + 168, 150, 20, I18nUtils.getString("gui.cancel", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiSubworldEdit.this.actionPerformed(this);
            }
        });
        this.subworldNameField = new GuiTextField(2, this.getFontRenderer(), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0 + 13, 200, 20);
        this.subworldNameField.func_146195_b(true);
        this.subworldNameField.func_146180_a(this.originalSubworldName);
        int buttonListY = this.getHeight() / 6 + 82 + 6;
        this.func_189646_b(new GuiButton(7, this.getWidth() / 2 - 50, buttonListY + 24, 100, 20, I18nUtils.getString("selectServer.delete", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiSubworldEdit.this.actionPerformed(this);
            }
        });
        this.getButtonList().get((int)0).field_146124_l = this.isNameAcceptable();
        this.getButtonList().get((int)2).field_146124_l = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
    }

    @Override
    public void func_146281_b() {
        this.field_146297_k.field_195559_v.func_197967_a(false);
    }

    protected void actionPerformed(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            if (par1GuiButton.field_146127_k == 0) {
                if (!this.currentSubworldName.equals(this.originalSubworldName)) {
                    this.waypointManager.changeSubworldName(this.originalSubworldName, this.currentSubworldName);
                }
                this.getMinecraft().func_147108_a(this.parent);
            } else if (par1GuiButton.field_146127_k == 1) {
                this.getMinecraft().func_147108_a(this.parent);
            } else if (par1GuiButton.field_146127_k == 7) {
                this.deleteClicked = true;
                String var4 = I18nUtils.getString("worldmap.subworld.deleteconfirm", new Object[0]);
                String var5 = "'" + this.originalSubworldName + "' " + I18nUtils.getString("selectServer.deleteWarning", new Object[0]);
                String var6 = I18nUtils.getString("selectServer.deleteButton", new Object[0]);
                String var7 = I18nUtils.getString("gui.cancel", new Object[0]);
                GuiYesNo var8 = new GuiYesNo((GuiYesNoCallback)this, var4, var5, var6, var7, 0);
                this.getMinecraft().func_147108_a((GuiScreen)var8);
            }
        }
    }

    public void confirmResult(boolean par1, int par2) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteSubworld(this.originalSubworldName);
            }
            this.getMinecraft().func_147108_a(this.parent);
        }
    }

    public boolean charTyped(char character, int keycode) {
        this.subworldNameField.charTyped(character, keycode);
        boolean acceptable = this.isNameAcceptable();
        if (character == '\r' && acceptable) {
            this.actionPerformed(this.getButtonList().get(0));
        }
        this.getButtonList().get((int)0).field_146124_l = acceptable;
        this.getButtonList().get((int)2).field_146124_l = this.originalSubworldName.equals(this.subworldNameField.func_146179_b());
        return super.charTyped(character, keycode);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int par3) {
        this.subworldNameField.mouseClicked(mouseX, mouseY, par3);
        return super.mouseClicked(mouseX, mouseY, par3);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.func_146276_q_();
        this.func_73732_a(this.getFontRenderer(), I18nUtils.getString("worldmap.subworld.edit", new Object[0]), this.getWidth() / 2, 20, 0xFFFFFF);
        this.func_73731_b(this.getFontRenderer(), I18nUtils.getString("worldmap.subworld.name", new Object[0]), this.getWidth() / 2 - 100, this.getHeight() / 6 + 0, 0xA0A0A0);
        this.subworldNameField.func_195608_a(mouseX, mouseY, partialTicks);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private boolean isNameAcceptable() {
        boolean acceptable = true;
        this.currentSubworldName = this.subworldNameField.func_146179_b();
        acceptable = acceptable && this.currentSubworldName.length() > 0;
        acceptable = acceptable && (this.currentSubworldName.equals(this.originalSubworldName) || !this.knownSubworldNames.contains(this.currentSubworldName));
        return acceptable;
    }
}

