/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiSubworldEdit;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.entity.Entity;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.world.World;

public class GuiSubworldsSelect
extends GuiScreenMinimap
implements GuiYesNoCallback {
    private String title = "VoxelMap - Multiworld Selection";
    private String select = "Which world are you in?";
    private boolean multiworld = false;
    private GuiButton cancelBtn;
    private GuiTextField newNameField;
    private boolean newWorld = false;
    private float yaw;
    private int thirdPersonViewOrig;
    private GuiButton[] selectButtons;
    private GuiButton[] editButtons;
    private String[] worlds;
    private GuiScreen parent;
    EntityPlayerSP thePlayer;
    EntityPlayerSP camera;
    private IVoxelMap master;
    private IWaypointManager waypointManager;

    public GuiSubworldsSelect(GuiScreen parent, IVoxelMap master) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.parent = parent;
        this.thePlayer = this.getMinecraft().field_71439_g;
        this.camera = new EntityPlayerSP(this.getMinecraft(), (World)this.getMinecraft().field_71441_e, this.getMinecraft().func_147114_u(), this.thePlayer.func_146107_m(), new RecipeBookClient(null));
        this.camera.field_71158_b = new MovementInputFromOptions(this.getMinecraft().field_71474_y);
        this.camera.func_70012_b(this.thePlayer.field_70165_t, this.thePlayer.field_70163_u - this.thePlayer.func_70033_W(), this.thePlayer.field_70161_v, this.thePlayer.field_70177_z, 0.0f);
        this.yaw = this.thePlayer.field_70177_z;
        this.thirdPersonViewOrig = this.getMinecraft().field_71474_y.field_74320_O;
        this.master = master;
        this.waypointManager = master.getWaypointManager();
    }

    public void func_73866_w_() {
        ArrayList<String> knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
        if (!this.multiworld && !this.waypointManager.isMultiworld()) {
            GuiYesNo var8 = new GuiYesNo((GuiYesNoCallback)this, I18nUtils.getString("worldmap.multiworld.isthismultiworld", new Object[0]), I18nUtils.getString("worldmap.multiworld.explanation", new Object[0]), I18nUtils.getString("gui.yes", new Object[0]), I18nUtils.getString("gui.no", new Object[0]), 0);
            this.getMinecraft().func_147108_a((GuiScreen)var8);
        } else {
            this.getMinecraft().field_71474_y.field_74320_O = 0;
            this.getMinecraft().func_175607_a((Entity)this.camera);
        }
        this.title = I18nUtils.getString("worldmap.multiworld.title", new Object[0]);
        this.select = I18nUtils.getString("worldmap.multiworld.select", new Object[0]);
        this.getButtonList().clear();
        int centerX = this.field_146294_l / 2;
        int buttonsPerRow = this.field_146294_l / 150;
        if (buttonsPerRow == 0) {
            buttonsPerRow = 1;
        }
        int buttonWidth = this.field_146294_l / buttonsPerRow - 5;
        int xSpacing = (this.field_146294_l - buttonsPerRow * buttonWidth) / 2;
        this.cancelBtn = new GuiButton(0, centerX - 100, this.field_146295_m - 30, I18nUtils.getString("gui.cancel", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiSubworldsSelect.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.cancelBtn);
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(knownSubworldNames, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                return -collator.compare(name1, name2);
            }
        });
        int numKnownSubworlds = knownSubworldNames.size();
        int completeRows = (int)Math.floor((float)(numKnownSubworlds + 1) / (float)buttonsPerRow);
        int lastRowShiftBy = (int)(Math.ceil((float)(numKnownSubworlds + 1) / (float)buttonsPerRow) * (double)buttonsPerRow - (double)(numKnownSubworlds + 1));
        this.worlds = new String[numKnownSubworlds];
        this.selectButtons = new GuiButton[numKnownSubworlds + 1];
        this.editButtons = new GuiButton[numKnownSubworlds + 1];
        for (int t = 0; t < numKnownSubworlds; ++t) {
            int shiftBy = 1;
            if (t / buttonsPerRow >= completeRows) {
                shiftBy = lastRowShiftBy + 1;
            }
            this.worlds[t] = knownSubworldNames.get(t);
            this.selectButtons[t] = new GuiButton(t + 1, (buttonsPerRow - shiftBy - t % buttonsPerRow) * buttonWidth + xSpacing, this.field_146295_m - 60 - t / buttonsPerRow * 21, buttonWidth - 32, 20, this.worlds[t]){

                public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                    GuiSubworldsSelect.this.actionPerformed(this);
                }
            };
            this.editButtons[t] = new GuiButton(-(t + 1), (buttonsPerRow - shiftBy - t % buttonsPerRow) * buttonWidth + xSpacing + buttonWidth - 32, this.field_146295_m - 60 - t / buttonsPerRow * 21, 30, 20, "\u2692"){

                public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                    GuiSubworldsSelect.this.actionPerformed(this);
                }
            };
            this.func_189646_b(this.selectButtons[t]);
            this.func_189646_b(this.editButtons[t]);
        }
        int numButtons = this.selectButtons.length - 1;
        if (!this.newWorld) {
            this.selectButtons[numButtons] = new GuiButton(numButtons + 1, (buttonsPerRow - 1 - lastRowShiftBy - numButtons % buttonsPerRow) * buttonWidth + xSpacing, this.field_146295_m - 60 - numButtons / buttonsPerRow * 21, buttonWidth - 2, 20, "< " + I18nUtils.getString("worldmap.multiworld.newname", new Object[0]) + " >"){

                public void func_194829_a(double mouseX, double mouseY) {
                    GuiSubworldsSelect.this.actionPerformed(this);
                }
            };
            this.func_189646_b(this.selectButtons[numButtons]);
        }
        this.newNameField = new GuiTextField(0, this.getFontRenderer(), (buttonsPerRow - 1 - lastRowShiftBy - numButtons % buttonsPerRow) * buttonWidth + xSpacing + 1, this.field_146295_m - 60 - numButtons / buttonsPerRow * 21 + 1, buttonWidth - 4, 18);
    }

    protected void actionPerformed(GuiButton button) {
        if (button.field_146124_l) {
            this.newWorld = false;
            if (button.field_146127_k == this.worlds.length + 1) {
                this.newWorld = true;
                this.func_189646_b(this.selectButtons[this.worlds.length]);
                this.newNameField.func_146195_b(true);
            } else if (button.field_146127_k == 0) {
                this.getMinecraft().func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k > 0) {
                this.worldSelected(this.worlds[button.field_146127_k - 1]);
            } else {
                this.editWorld(this.worlds[-button.field_146127_k - 1]);
            }
        }
    }

    public void confirmResult(boolean par1, int par2) {
        if (!par1) {
            this.getMinecraft().func_147108_a(this.parent);
        } else {
            this.multiworld = true;
            this.getMinecraft().func_147108_a((GuiScreen)this);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.newWorld) {
            this.newNameField.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        if (this.newNameField.func_146206_l()) {
            String newName;
            this.newNameField.keyPressed(keysm, scancode, b);
            if ((keysm == 257 || keysm == 335) && this.newNameField.func_146206_l() && (newName = this.newNameField.func_146179_b()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.keyPressed(keysm, scancode, b);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.newNameField.func_146206_l()) {
            String newName;
            this.newNameField.charTyped(typedChar, keyCode);
            if (keyCode == 28 && (newName = this.newNameField.func_146179_b()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.charTyped(typedChar, keyCode);
    }

    public void func_73876_c() {
        this.newNameField.func_146178_a();
        super.func_73876_c();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int titleStringWidth = this.getFontRenderer().func_78256_a(this.title);
        titleStringWidth = Math.max(titleStringWidth, this.getFontRenderer().func_78256_a(this.select));
        GuiSubworldsSelect.func_73734_a((int)(this.field_146294_l / 2 - titleStringWidth / 2 - 5), (int)0, (int)(this.field_146294_l / 2 + titleStringWidth / 2 + 5), (int)27, (int)-1073741824);
        this.func_73732_a(this.getFontRenderer(), this.title, this.field_146294_l / 2, 5, 0xFFFFFF);
        this.func_73732_a(this.getFontRenderer(), this.select, this.field_146294_l / 2, 15, 0xFF0000);
        this.camera.field_70125_A = 0.0f;
        this.camera.field_70127_C = 0.0f;
        this.camera.field_70126_B = this.camera.field_70177_z = this.yaw;
        float var4 = 0.475f;
        this.camera.field_70167_r = this.camera.field_70163_u = this.thePlayer.field_70163_u;
        this.camera.field_70137_T = this.camera.field_70163_u;
        this.camera.field_70169_q = this.camera.field_70165_t = this.thePlayer.field_70165_t - (double)var4 * Math.sin((double)this.yaw / 180.0 * Math.PI);
        this.camera.field_70142_S = this.camera.field_70165_t;
        this.camera.field_70166_s = this.camera.field_70161_v = this.thePlayer.field_70161_v + (double)var4 * Math.cos((double)this.yaw / 180.0 * Math.PI);
        this.camera.field_70136_U = this.camera.field_70161_v;
        float var5 = 1.0f;
        this.yaw = (float)((double)this.yaw + (double)var5 * (1.0 + (double)0.7f * Math.cos((double)(this.yaw + 45.0f) / 45.0 * Math.PI)));
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.newWorld) {
            this.newNameField.func_195608_a(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        this.getMinecraft().field_71474_y.field_74320_O = this.thirdPersonViewOrig;
        this.getMinecraft().func_175607_a((Entity)this.thePlayer);
    }

    private void worldSelected(String selectedSubworldName) {
        this.waypointManager.setSubworldName(selectedSubworldName, false);
        if (this.parent == null) {
            this.getMinecraft().func_147108_a((GuiScreen)null);
        } else {
            this.getMinecraft().func_147108_a(this.parent);
        }
    }

    private void editWorld(String subworldNameToEdit) {
        this.getMinecraft().func_147108_a((GuiScreen)new GuiSubworldEdit(this, this.master, subworldNameToEdit));
    }
}

