/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiSlotWaypoints;
import com.mamiyaotaru.voxelmap.gui.GuiWaypointsOptions;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.util.Random;
import java.util.TreeSet;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.world.dimension.DimensionType;

public class GuiWaypoints
extends GuiScreenMinimap
implements IGuiWaypoints {
    private final GuiScreen parentScreen;
    private IVoxelMap master;
    protected final MapSettingsManager options;
    protected final IWaypointManager waypointManager;
    protected String screenTitle = "Waypoints";
    private GuiSlotWaypoints waypointList;
    private GuiButton buttonEdit;
    private boolean editClicked = false;
    private GuiButton buttonDelete;
    private boolean deleteClicked = false;
    private GuiButton buttonHighlight;
    private GuiButton buttonShare;
    private GuiButton buttonTeleport;
    private GuiButton buttonSortName;
    private GuiButton buttonSortCreated;
    private GuiButton buttonSortDistance;
    private GuiButton buttonSortColor;
    protected GuiTextField filter;
    private boolean addClicked = false;
    private String tooltip = null;
    protected Waypoint selectedWaypoint = null;
    protected Waypoint highlightedWaypoint = null;
    protected Waypoint newWaypoint = null;
    private Random generator = new Random();
    private boolean changedSort = false;
    private final int EDIT = -1;
    private final int DELETE = -2;
    private final int HIGHLIGHT = -3;
    private final int TELEPORT = -4;
    private final int SHARE = -5;
    private final int NEW = -6;
    private final int OPTIONS = -7;

    public GuiWaypoints(GuiScreen parentScreen, IVoxelMap master) {
        this.master = master;
        this.parentScreen = parentScreen;
        this.options = master.getMapOptions();
        this.waypointManager = master.getWaypointManager();
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
    }

    public void func_73876_c() {
        this.filter.func_146178_a();
    }

    public void func_73866_w_() {
        boolean isSomethingSelected;
        this.screenTitle = I18nUtils.getString("minimap.waypoints.title", new Object[0]);
        this.field_146297_k.field_195559_v.func_197967_a(true);
        this.waypointList = new GuiSlotWaypoints(this);
        this.options.getClass();
        this.buttonSortName = new GuiButton(2, this.getWidth() / 2 - 154, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.buttonSortName);
        this.options.getClass();
        this.buttonSortDistance = new GuiButton(3, this.getWidth() / 2 - 77, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.buttonSortDistance);
        this.options.getClass();
        this.buttonSortCreated = new GuiButton(1, this.getWidth() / 2, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.buttonSortCreated);
        this.options.getClass();
        this.buttonSortColor = new GuiButton(4, this.getWidth() / 2 + 77, 34, 77, 20, I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.buttonSortColor);
        int filterStringWidth = this.getFontRenderer().func_78256_a(I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":");
        this.filter = new GuiTextField(2, this.getFontRenderer(), this.getWidth() / 2 - 153 + filterStringWidth + 5, this.getHeight() - 80, 305 - filterStringWidth - 5, 20);
        this.filter.func_146203_f(35);
        this.filter.func_146195_b(true);
        this.buttonEdit = new GuiButton(-1, this.getWidth() / 2 - 154, this.getHeight() - 52, 74, 20, I18nUtils.getString("selectServer.edit", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.buttonEdit);
        this.buttonDelete = new GuiButton(-2, this.getWidth() / 2 - 76, this.getHeight() - 52, 74, 20, I18nUtils.getString("selectServer.delete", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.buttonDelete);
        this.buttonHighlight = new GuiButton(-3, this.getWidth() / 2 + 2, this.getHeight() - 52, 74, 20, I18nUtils.getString("minimap.waypoints.highlight", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.buttonHighlight);
        this.buttonTeleport = new GuiButton(-4, this.getWidth() / 2 + 80, this.getHeight() - 52, 74, 20, I18nUtils.getString("minimap.waypoints.teleportto", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.buttonTeleport);
        this.buttonShare = new GuiButton(-5, this.getWidth() / 2 - 154, this.getHeight() - 28, 74, 20, I18nUtils.getString("minimap.waypoints.share", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.buttonShare);
        this.func_189646_b(new GuiButton(-6, this.getWidth() / 2 - 76, this.getHeight() - 28, 74, 20, I18nUtils.getString("minimap.waypoints.newwaypoint", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        });
        this.func_189646_b(new GuiButton(-7, this.getWidth() / 2 + 2, this.getHeight() - 28, 74, 20, I18nUtils.getString("menu.options", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        });
        this.func_189646_b(new GuiButton(-200, this.getWidth() / 2 + 80, this.getHeight() - 28, 74, 20, I18nUtils.getString("gui.done", new Object[0])){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiWaypoints.this.actionPerformed(this);
            }
        });
        this.buttonEdit.field_146124_l = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.field_146124_l = isSomethingSelected;
        this.buttonHighlight.field_146124_l = isSomethingSelected;
        this.buttonShare.field_146124_l = isSomethingSelected;
        this.buttonTeleport.field_146124_l = isSomethingSelected && this.canTeleport();
        this.sort();
    }

    private void sort() {
        int sortKey = Math.abs(this.options.sort);
        boolean ascending = this.options.sort > 0;
        this.waypointList.sortBy(sortKey, ascending);
        String arrow = ascending ? "\u2191" : "\u2193";
        this.options.getClass();
        this.buttonSortName.field_146126_j = sortKey == 2 ? arrow + " " + I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]) + " " + arrow : I18nUtils.getString("minimap.waypoints.sortbyname", new Object[0]);
        this.options.getClass();
        this.buttonSortDistance.field_146126_j = sortKey == 3 ? arrow + " " + I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]) + " " + arrow : I18nUtils.getString("minimap.waypoints.sortbydistance", new Object[0]);
        this.options.getClass();
        this.buttonSortCreated.field_146126_j = sortKey == 1 ? arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]) + " " + arrow : I18nUtils.getString("minimap.waypoints.sortbycreated", new Object[0]);
        this.options.getClass();
        this.buttonSortColor.field_146126_j = sortKey == 4 ? arrow + " " + I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]) + " " + arrow : I18nUtils.getString("minimap.waypoints.sortbycolor", new Object[0]);
    }

    protected void actionPerformed(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            String var2;
            if (par1GuiButton.field_146127_k > 0) {
                this.options.setSort(par1GuiButton.field_146127_k);
                this.changedSort = true;
                this.sort();
            }
            if (par1GuiButton.field_146127_k == -1) {
                this.editWaypoint(this.selectedWaypoint);
            }
            if (par1GuiButton.field_146127_k == -2 && (var2 = this.selectedWaypoint.name) != null) {
                this.deleteClicked = true;
                String title = I18nUtils.getString("minimap.waypoints.deleteconfirm", new Object[0]);
                String explanation = "'" + var2 + "' " + I18nUtils.getString("selectServer.deleteWarning", new Object[0]);
                String affirm = I18nUtils.getString("selectServer.deleteButton", new Object[0]);
                String deny = I18nUtils.getString("gui.cancel", new Object[0]);
                GuiYesNo var8 = new GuiYesNo((GuiYesNoCallback)this, title, explanation, affirm, deny, this.waypointManager.getWaypoints().indexOf(this.selectedWaypoint));
                this.getMinecraft().func_147108_a((GuiScreen)var8);
            }
            if (par1GuiButton.field_146127_k == -3) {
                this.setHighlightedWaypoint();
            }
            if (par1GuiButton.field_146127_k == -5) {
                CommandUtils.sendWaypoint(this.selectedWaypoint);
            }
            if (par1GuiButton.field_146127_k == -4) {
                boolean mp;
                boolean bl = mp = !this.field_146297_k.func_71387_A();
                int y = this.selectedWaypoint.getY() > 0 ? this.selectedWaypoint.getY() : (this.options.game.field_71439_g.field_71093_bK != DimensionType.NETHER ? 128 : 64);
                this.options.game.field_71439_g.func_71165_d("/tp " + this.options.game.field_71439_g.func_200200_C_().getString() + " " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                if (mp) {
                    this.options.game.field_71439_g.func_71165_d("/tppos " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                }
                this.getMinecraft().func_147108_a((GuiScreen)null);
            }
            if (par1GuiButton.field_146127_k == -6) {
                this.addWaypoint();
            }
            if (par1GuiButton.field_146127_k == -7) {
                this.getMinecraft().func_147108_a((GuiScreen)new GuiWaypointsOptions(this, this.options));
            }
            if (par1GuiButton.field_146127_k == -200) {
                this.getMinecraft().func_147108_a(this.parentScreen);
            }
        }
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        if (this.filter.keyPressed(keysm, scancode, b)) {
            this.waypointList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return super.keyPressed(keysm, scancode, b);
    }

    public boolean charTyped(char character, int keycode) {
        if (this.filter.charTyped(character, keycode)) {
            this.waypointList.updateFilter(this.filter.func_146179_b().toLowerCase());
        }
        return super.charTyped(character, keycode);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.filter.mouseClicked(mouseX, mouseY, mouseButton);
        this.waypointList.mouseClicked(mouseX, mouseY, mouseButton);
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.filter.mouseReleased(mouseX, mouseY, mouseButton);
        this.waypointList.mouseReleased(mouseX, mouseY, mouseButton);
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int mouseEvent, double deltaX, double deltaY) {
        return this.waypointList.mouseDragged(mouseX, mouseY, mouseEvent, deltaX, deltaY);
    }

    public boolean mouseScrolled(double amount) {
        return this.waypointList.mouseScrolled(amount);
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void confirmResult(boolean par1, int par2) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (par1) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
            this.getMinecraft().func_147108_a((GuiScreen)this);
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (par1) {
                this.waypointManager.saveWaypoints();
            }
            this.getMinecraft().func_147108_a((GuiScreen)this);
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (par1) {
                this.waypointManager.addWaypoint(this.newWaypoint);
                this.setSelectedWaypoint(this.newWaypoint);
            }
            this.getMinecraft().func_147108_a((GuiScreen)this);
        }
    }

    protected void setSelectedWaypoint(Waypoint waypoint) {
        boolean isSomethingSelected;
        this.selectedWaypoint = waypoint;
        this.buttonEdit.field_146124_l = isSomethingSelected = this.selectedWaypoint != null;
        this.buttonDelete.field_146124_l = isSomethingSelected;
        this.buttonHighlight.field_146124_l = isSomethingSelected;
        this.buttonHighlight.field_146126_j = I18nUtils.getString(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight", new Object[0]);
        this.buttonShare.field_146124_l = isSomethingSelected;
        this.buttonTeleport.field_146124_l = isSomethingSelected && this.canTeleport();
    }

    protected void setHighlightedWaypoint() {
        this.waypointManager.setHighlightedWaypoint(this.selectedWaypoint, true);
        this.highlightedWaypoint = this.waypointManager.getHighlightedWaypoint();
        boolean isSomethingSelected = this.selectedWaypoint != null;
        this.buttonHighlight.field_146126_j = I18nUtils.getString(isSomethingSelected && this.selectedWaypoint == this.highlightedWaypoint ? "minimap.waypoints.removehighlight" : "minimap.waypoints.highlight", new Object[0]);
    }

    protected void editWaypoint(Waypoint waypoint) {
        this.editClicked = true;
        this.getMinecraft().func_147108_a((GuiScreen)new GuiAddWaypoint(this, this.master, waypoint, true));
    }

    protected void addWaypoint() {
        float b;
        float g;
        float r;
        this.addClicked = true;
        if (this.waypointManager.getWaypoints().size() == 0) {
            r = 0.0f;
            g = 1.0f;
            b = 0.0f;
        } else {
            r = this.generator.nextFloat();
            g = this.generator.nextFloat();
            b = this.generator.nextFloat();
        }
        TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
        dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(this.field_146297_k.field_71441_e.field_73011_w));
        this.newWaypoint = new Waypoint("", this.options.game.field_71439_g.field_71093_bK != DimensionType.NETHER ? GameVariableAccessShim.xCoord() : GameVariableAccessShim.xCoord() * 8, this.options.game.field_71439_g.field_71093_bK != DimensionType.NETHER ? GameVariableAccessShim.zCoord() : GameVariableAccessShim.zCoord() * 8, GameVariableAccessShim.yCoord(), true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
        this.getMinecraft().func_147108_a((GuiScreen)new GuiAddWaypoint(this, this.master, this.newWaypoint, false));
    }

    protected void toggleWaypointVisibility() {
        this.selectedWaypoint.enabled = !this.selectedWaypoint.enabled;
        this.waypointManager.saveWaypoints();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.drawMap();
        this.tooltip = null;
        this.waypointList.func_148128_a(mouseX, mouseY, partialTicks);
        this.func_73732_a(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 20, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_73731_b(this.getFontRenderer(), I18nUtils.getString("minimap.waypoints.filter", new Object[0]) + ":", this.getWidth() / 2 - 153, this.getHeight() - 75, 0xA0A0A0);
        this.filter.func_195608_a(mouseX, mouseY, partialTicks);
        if (this.tooltip != null) {
            this.drawTooltip(this.tooltip, mouseX, mouseY);
        }
    }

    protected void drawTooltip(String par1Str, int par2, int par3) {
        if (par1Str != null) {
            int var4 = par2 + 12;
            int var5 = par3 - 12;
            int var6 = this.getFontRenderer().func_78256_a(par1Str);
            this.func_73733_a(var4 - 3, var5 - 3, var4 + var6 + 3, var5 + 8 + 3, -1073741824, -1073741824);
            this.getFontRenderer().func_175063_a(par1Str, (float)var4, (float)var5, -1);
        }
    }

    static String setTooltip(GuiWaypoints par0GuiWaypoints, String par1Str) {
        par0GuiWaypoints.tooltip = par1Str;
        return par0GuiWaypoints.tooltip;
    }

    public boolean canTeleport() {
        boolean allowed = false;
        boolean singlePlayer = this.options.game.func_71387_A();
        if (singlePlayer) {
            try {
                allowed = this.field_146297_k.func_71401_C().func_184103_al().func_152596_g(this.field_146297_k.field_71439_g.func_146103_bH());
            }
            catch (Exception e) {
                allowed = this.field_146297_k.func_71401_C().func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_76086_u();
            }
        } else {
            allowed = true;
        }
        return allowed;
    }

    @Override
    public void func_146281_b() {
        this.field_146297_k.field_195559_v.func_197967_a(false);
        if (this.changedSort) {
            super.func_146281_b();
        }
    }
}

