/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiMinimapOptions;
import com.mamiyaotaru.voxelmap.gui.GuiSubworldsSelect;
import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.IGuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.Popup;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiButton;
import com.mamiyaotaru.voxelmap.gui.overridden.PopupGuiScreen;
import com.mamiyaotaru.voxelmap.interfaces.AbstractMapData;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.persistent.CachedRegion;
import com.mamiyaotaru.voxelmap.persistent.PersistentMapSettingsManager;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.BackgroundImageInfo;
import com.mamiyaotaru.voxelmap.util.BiomeMapData;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.ThreadDownloadImageData;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.EnumPlayerModelParts;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.dimension.DimensionType;
import org.lwjgl.glfw.GLFW;

public class GuiPersistentMap
extends PopupGuiScreen
implements IGuiWaypoints {
    private Minecraft mc;
    private Random generator = new Random();
    private IVoxelMap master;
    private IPersistentMap persistentMap;
    private IWaypointManager waypointManager;
    private final GuiScreen parent;
    private final MapSettingsManager mapOptions;
    private final PersistentMapSettingsManager options;
    protected String screenTitle = "World Map";
    protected String worldNameDisplay = "";
    protected int worldNameDisplayLength = 0;
    protected int maxWorldNameDisplayLength = 0;
    private String subworldName = "";
    private PopupGuiButton buttonMultiworld;
    private int top;
    private int bottom;
    private boolean oldNorth = false;
    private boolean lastStill = false;
    private boolean editingCoordinates = false;
    private boolean lastEditingCoordinates = false;
    private GuiTextField coordinates;
    int centerX = 0;
    int centerY = 0;
    float mapCenterX = 0.0f;
    float mapCenterZ = 0.0f;
    float deltaX = 0.0f;
    float deltaY = 0.0f;
    float deltaXonRelease = 0.0f;
    float deltaYonRelease = 0.0f;
    long timeOfRelease = 0L;
    boolean mouseCursorShown = true;
    long timeAtLastTick = 0L;
    long timeOfLastKBInput = 0L;
    long timeOfLastMouseInput = 0L;
    final float TIME_CONSTANT = 350.0f;
    float lastMouseX = 0.0f;
    float lastMouseY = 0.0f;
    protected int mouseX;
    protected int mouseY;
    boolean leftMouseButtonDown = false;
    float zoom = 4.0f;
    float zoomStart = 4.0f;
    float zoomGoal = 4.0f;
    long timeOfZoom = 0L;
    float zoomDirectX = 0.0f;
    float zoomDirectY = 0.0f;
    private float scScale = 1.0f;
    private float guiToMap = 2.0f;
    private float mapToGui = 0.5f;
    private float mouseDirectToMap = 1.0f;
    private float guiToDirectMouse = 2.0f;
    private static int playerGLID = 0;
    private static boolean gotSkin = false;
    private static int skinTries = 0;
    private boolean closed = false;
    private CachedRegion[] regions = new CachedRegion[0];
    BackgroundImageInfo backGroundImageInfo = null;
    private BiomeMapData biomeMapData = new BiomeMapData(760, 360);
    private float mapPixelsX = 0.0f;
    private float mapPixelsY = 0.0f;
    private final Object closedLock = new Object();
    private KeyBinding keyBindForward = new KeyBinding("key.forward.fake", 17, "key.categories.movement");
    private KeyBinding keyBindLeft = new KeyBinding("key.left.fake", 30, "key.categories.movement");
    private KeyBinding keyBindBack = new KeyBinding("key.back.fake", 31, "key.categories.movement");
    private KeyBinding keyBindRight = new KeyBinding("key.right.fake", 32, "key.categories.movement");
    private KeyBinding keyBindSprint = new KeyBinding("key.sprint.fake", 29, "key.categories.movement");
    private InputMappings.Input forwardCode;
    private InputMappings.Input leftCode;
    private InputMappings.Input backCode;
    private InputMappings.Input rightCode;
    private InputMappings.Input sprintCode;
    InputMappings.Input nullInput = InputMappings.func_197955_a((String)"key.keyboard.unknown");
    private final int NEW = 0;
    private final int HIGHLIGHT = 1;
    private final int SHARE = 2;
    private final int TELEPORT = 3;
    private final int EDIT = 4;
    private final int DELETE = 5;
    int sideMargin = 10;
    int buttonCount = 5;
    int buttonSeparation = 4;
    int buttonWidth = 66;
    public boolean editClicked = false;
    public boolean deleteClicked = false;
    public boolean addClicked = false;
    Waypoint newWaypoint;
    Waypoint selectedWaypoint;

    public GuiPersistentMap(GuiScreen parent, IVoxelMap master) {
        this.mc = Minecraft.func_71410_x();
        this.parent = parent;
        this.master = master;
        this.waypointManager = master.getWaypointManager();
        this.mapOptions = master.getMapOptions();
        this.persistentMap = master.getPersistentMap();
        this.options = master.getPersistentMapOptions();
        this.zoom = this.options.zoom;
        this.zoomStart = this.options.zoom;
        this.zoomGoal = this.options.zoom;
        this.persistentMap.setLightMapArray(master.getMap().getLightmapArray());
        if (!gotSkin && skinTries < 5) {
            this.getSkin();
        }
        this.forwardCode = InputMappings.func_197955_a((String)this.mc.field_71474_y.field_74351_w.func_197982_m());
        this.leftCode = InputMappings.func_197955_a((String)this.mc.field_71474_y.field_74370_x.func_197982_m());
        this.backCode = InputMappings.func_197955_a((String)this.mc.field_71474_y.field_74368_y.func_197982_m());
        this.rightCode = InputMappings.func_197955_a((String)this.mc.field_71474_y.field_74366_z.func_197982_m());
        this.sprintCode = InputMappings.func_197955_a((String)this.mc.field_71474_y.field_151444_V.func_197982_m());
    }

    private void getSkin() {
        ResourceLocation skinLocation = this.mc.field_71439_g.func_110306_p();
        ThreadDownloadImageData imageData = null;
        try {
            if (skinLocation != DefaultPlayerSkin.func_177334_a((UUID)this.mc.field_71439_g.func_110124_au())) {
                imageData = AbstractClientPlayer.func_110304_a((ResourceLocation)skinLocation, (String)TextUtils.scrubCodes(this.mc.field_71439_g.func_200200_C_().func_150254_d()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (imageData != null) {
            gotSkin = true;
            GLUtils.disp(imageData.func_110552_b());
        } else {
            ++skinTries;
            GLUtils.img(skinLocation);
        }
        BufferedImage skinImage = ImageUtils.createBufferedImageFromCurrentGLImage();
        boolean showHat = this.mc.field_71439_g.func_175148_a(EnumPlayerModelParts.HAT);
        skinImage = showHat ? ImageUtils.addImages(ImageUtils.loadImage(skinImage, 8, 8, 8, 8), ImageUtils.loadImage(skinImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8) : ImageUtils.loadImage(skinImage, 8, 8, 8, 8);
        float scale = (float)skinImage.getWidth() / 8.0f;
        skinImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(skinImage, 2.0f / scale)), true);
        if (playerGLID != 0) {
            GLUtils.glah(playerGLID);
        }
        playerGLID = GLUtils.tex(skinImage);
    }

    public void func_73866_w_() {
        this.field_146291_p = true;
        this.oldNorth = this.mapOptions.oldNorth;
        this.centerAt(this.options.mapX, this.options.mapZ);
        this.mc.field_195559_v.func_197967_a(true);
        if (this.getMinecraft().field_71462_r == this) {
            this.closed = false;
        }
        this.screenTitle = I18nUtils.getString("worldmap.title", new Object[0]);
        this.buildWorldName();
        this.leftMouseButtonDown = false;
        this.sideMargin = 10;
        this.buttonCount = 5;
        this.buttonSeparation = 4;
        this.buttonWidth = (this.field_146294_l - this.sideMargin * 2 - this.buttonSeparation * (this.buttonCount - 1)) / this.buttonCount;
        this.func_189646_b(new PopupGuiButton(100, this.sideMargin + 0 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, I18nUtils.getString("options.minimap.waypoints", new Object[0]), this){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiPersistentMap.this.getMinecraft().func_147108_a((GuiScreen)new GuiWaypoints(GuiPersistentMap.this, GuiPersistentMap.this.master));
            }
        });
        if (!this.getMinecraft().func_71387_A() && !this.master.getWaypointManager().receivedAutoSubworldName()) {
            this.buttonMultiworld = new PopupGuiButton(104, this.sideMargin + 1 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, I18nUtils.getString("options.worldmap.multiworld", new Object[0]), this){

                public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                    GuiPersistentMap.this.getMinecraft().func_147108_a((GuiScreen)new GuiSubworldsSelect(GuiPersistentMap.this, GuiPersistentMap.this.master));
                }
            };
            this.func_189646_b(this.buttonMultiworld);
        }
        this.func_189646_b(new PopupGuiButton(103, this.sideMargin + 3 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, I18nUtils.getString("menu.options", new Object[0]), this){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiPersistentMap.this.getMinecraft().func_147108_a((GuiScreen)new GuiMinimapOptions(GuiPersistentMap.this, GuiPersistentMap.this.master));
            }
        });
        this.func_189646_b(new PopupGuiButton(200, this.sideMargin + 4 * (this.buttonWidth + this.buttonSeparation), this.getHeight() - 28, this.buttonWidth, 20, I18nUtils.getString("gui.done", new Object[0]), this){

            public void func_194829_a(double p_onClick_1_, double p_onClick_3_) {
                GuiPersistentMap.this.getMinecraft().func_147108_a(GuiPersistentMap.this.parent);
            }
        });
        this.coordinates = new GuiTextField(1, this.getFontRenderer(), this.sideMargin, 10, 140, 20);
        this.top = 32;
        this.bottom = this.getHeight() - 32;
        this.centerX = this.getWidth() / 2;
        this.centerY = (this.bottom - this.top) / 2;
        this.scScale = (float)this.mc.field_195558_d.func_198100_s();
        this.mapPixelsX = this.mc.field_195558_d.func_198109_k();
        this.mapPixelsY = this.mc.field_195558_d.func_198091_l() - (int)(64.0f * this.scScale);
        this.lastStill = false;
        this.timeAtLastTick = System.currentTimeMillis();
        this.keyBindForward.func_197979_b(this.forwardCode);
        this.keyBindLeft.func_197979_b(this.leftCode);
        this.keyBindBack.func_197979_b(this.backCode);
        this.keyBindRight.func_197979_b(this.rightCode);
        this.keyBindSprint.func_197979_b(this.sprintCode);
        this.mc.field_71474_y.field_74351_w.func_197979_b(this.nullInput);
        this.mc.field_71474_y.field_74370_x.func_197979_b(this.nullInput);
        this.mc.field_71474_y.field_74368_y.func_197979_b(this.nullInput);
        this.mc.field_71474_y.field_74366_z.func_197979_b(this.nullInput);
        this.mc.field_71474_y.field_151444_V.func_197979_b(this.nullInput);
        KeyBinding.func_74508_b();
    }

    private void centerAt(int x, int z) {
        if (this.oldNorth) {
            this.mapCenterX = -z;
            this.mapCenterZ = x;
        } else {
            this.mapCenterX = x;
            this.mapCenterZ = z;
        }
    }

    private void buildWorldName() {
        String subworldName;
        String worldName = "";
        if (this.mc.func_71387_A()) {
            worldName = this.mc.func_71401_C().func_71221_J();
            if (worldName == null || worldName.equals("")) {
                worldName = "Singleplayer World";
            }
        } else {
            ServerData serverData = this.mc.func_147104_D();
            if (serverData != null) {
                worldName = serverData.field_78847_a;
            }
            if (worldName == null || worldName.equals("")) {
                worldName = "Multiplayer Server";
            }
        }
        StringBuilder worldNameBuilder = new StringBuilder("\u00a7r").append(worldName);
        this.subworldName = subworldName = this.master.getWaypointManager().getCurrentSubworldDescriptor(true);
        if ((subworldName == null || subworldName.equals("")) && this.master.getWaypointManager().isMultiworld()) {
            subworldName = "???";
        }
        if (subworldName != null && !subworldName.equals("")) {
            worldNameBuilder.append(" - ").append(subworldName);
        }
        this.worldNameDisplay = worldNameBuilder.toString();
        this.worldNameDisplayLength = this.getFontRenderer().func_78256_a(this.worldNameDisplay);
        this.maxWorldNameDisplayLength = this.getWidth() / 2 - this.getFontRenderer().func_78256_a(this.screenTitle) / 2 - this.sideMargin * 2;
        while (this.worldNameDisplayLength > this.maxWorldNameDisplayLength && worldName.length() > 5) {
            worldName = worldName.substring(0, worldName.length() - 1);
            worldNameBuilder = new StringBuilder(worldName);
            worldNameBuilder.append("...");
            if (subworldName != null && !subworldName.equals("")) {
                worldNameBuilder.append(" - ").append(subworldName);
            }
            this.worldNameDisplay = worldNameBuilder.toString();
            this.worldNameDisplayLength = this.getFontRenderer().func_78256_a(this.worldNameDisplay);
        }
        if (subworldName != null && !subworldName.equals("")) {
            while (this.worldNameDisplayLength > this.maxWorldNameDisplayLength && subworldName.length() > 5) {
                worldNameBuilder = new StringBuilder(worldName);
                worldNameBuilder.append("...");
                subworldName = subworldName.substring(0, subworldName.length() - 1);
                worldNameBuilder.append(" - ").append(subworldName);
                this.worldNameDisplay = worldNameBuilder.toString();
                this.worldNameDisplayLength = this.getFontRenderer().func_78256_a(this.worldNameDisplay);
            }
        }
    }

    private float bindZoom(float zoom) {
        zoom = Math.max(this.options.minZoom, zoom);
        zoom = Math.min(this.options.maxZoom, zoom);
        return zoom;
    }

    private float easeOut(float elapsedTime, float startValue, float finalDelta, float totalTime) {
        float value = elapsedTime == totalTime ? startValue + finalDelta : finalDelta * (-((float)Math.pow(2.0, -10.0f * elapsedTime / totalTime)) + 1.0f) + startValue;
        return value;
    }

    public boolean mouseScrolled(double mouseRoll) {
        this.timeOfLastMouseInput = System.currentTimeMillis();
        this.switchToMouseInput();
        float mouseDirectX = (float)this.mc.field_71417_B.func_198024_e();
        float mouseDirectY = (float)this.mc.field_71417_B.func_198026_f();
        if (mouseRoll != 0.0) {
            if (mouseRoll > 0.0) {
                this.zoomGoal *= 1.26f;
            } else if (mouseRoll < 0.0) {
                this.zoomGoal /= 1.26f;
            }
            this.zoomStart = this.zoom;
            this.zoomGoal = this.bindZoom(this.zoomGoal);
            this.timeOfZoom = System.currentTimeMillis();
            this.zoomDirectX = mouseDirectX;
            this.zoomDirectY = mouseDirectY;
        }
        return true;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (mouseY > (double)this.top && mouseY < (double)this.bottom && mouseButton == 1) {
            this.timeOfLastKBInput = 0L;
            int mouseDirectX = (int)this.mc.field_71417_B.func_198024_e();
            int mouseDirectY = (int)this.mc.field_71417_B.func_198026_f();
            this.createPopup((int)mouseX, (int)mouseY, mouseDirectX, mouseDirectY);
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (!this.popupOpen()) {
            this.coordinates.mouseClicked(mouseX, mouseY, mouseButton);
            this.editingCoordinates = this.coordinates.func_146206_l();
            if (this.editingCoordinates && !this.lastEditingCoordinates) {
                int x = 0;
                int z = 0;
                if (this.oldNorth) {
                    x = (int)Math.floor(this.mapCenterZ);
                    z = -((int)Math.floor(this.mapCenterX));
                } else {
                    x = (int)Math.floor(this.mapCenterX);
                    z = (int)Math.floor(this.mapCenterZ);
                }
                this.coordinates.func_146180_a(x + ", " + z);
                this.coordinates.func_146193_g(0xFFFFFF);
            }
            this.lastEditingCoordinates = this.editingCoordinates;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton) || mouseButton == 1;
    }

    public void func_195073_a(@Nullable IGuiEventListener p_setFocused_1) {
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        if (!this.editingCoordinates && (this.mc.field_71474_y.field_74314_A.func_197976_a(keysm, scancode) || this.mc.field_71474_y.field_74311_E.func_197976_a(keysm, scancode))) {
            if (this.mc.field_71474_y.field_74314_A.func_197976_a(keysm, scancode)) {
                this.zoomGoal /= 1.26f;
            }
            if (this.mc.field_71474_y.field_74311_E.func_197976_a(keysm, scancode)) {
                this.zoomGoal *= 1.26f;
            }
            this.zoomStart = this.zoom;
            this.zoomGoal = this.bindZoom(this.zoomGoal);
            this.timeOfZoom = System.currentTimeMillis();
            this.zoomDirectX = this.mc.field_195558_d.func_198109_k() / 2;
            this.zoomDirectY = this.mc.field_195558_d.func_198091_l() - this.mc.field_195558_d.func_198091_l() / 2;
            this.switchToKeyboardInput();
        }
        this.clearPopups();
        if (this.editingCoordinates) {
            this.coordinates.keyPressed(keysm, scancode, b);
            boolean isGood = this.isAcceptable(this.coordinates.func_146179_b());
            this.coordinates.func_146193_g(isGood ? 0xFFFFFF : 0xFF0000);
            if ((keysm == 257 || keysm == 335) && this.coordinates.func_146206_l() && isGood) {
                String[] xz = this.coordinates.func_146179_b().split(",");
                this.centerAt(Integer.valueOf(xz[0].trim()), Integer.valueOf(xz[1].trim()));
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
        }
        if (this.master.getMapOptions().keyBindMenu.func_197976_a(keysm, scancode)) {
            keysm = 256;
            scancode = -1;
            b = -1;
        }
        return super.keyPressed(keysm, scancode, b);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        this.clearPopups();
        if (this.editingCoordinates) {
            this.coordinates.charTyped(typedChar, keyCode);
            boolean isGood = this.isAcceptable(this.coordinates.func_146179_b());
            this.coordinates.func_146193_g(isGood ? 0xFFFFFF : 0xFF0000);
            if (typedChar == '\r' && this.coordinates.func_146206_l() && isGood) {
                String[] xz = this.coordinates.func_146179_b().split(",");
                this.centerAt(Integer.valueOf(xz[0].trim()), Integer.valueOf(xz[1].trim()));
                this.editingCoordinates = false;
                this.lastEditingCoordinates = false;
                this.switchToKeyboardInput();
            }
        }
        if (this.master.getMapOptions().keyBindMenu.func_197976_a(keyCode, -1)) {
            super.keyPressed(256, -1, -1);
        }
        return super.charTyped(typedChar, keyCode);
    }

    private boolean isAcceptable(String input) {
        try {
            String[] xz = this.coordinates.func_146179_b().split(",");
            Integer.valueOf(xz[0].trim());
            Integer.valueOf(xz[1].trim());
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    private void switchToMouseInput() {
        this.timeOfLastKBInput = 0L;
        if (!this.mouseCursorShown) {
            GLFW.glfwSetInputMode((long)this.mc.field_195558_d.func_198092_i(), (int)208897, (int)212993);
        }
        this.mouseCursorShown = true;
    }

    private void switchToKeyboardInput() {
        this.timeOfLastKBInput = System.currentTimeMillis();
        this.mouseCursorShown = false;
        GLFW.glfwSetInputMode((long)this.mc.field_195558_d.func_198092_i(), (int)208897, (int)212995);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        float cursorCoordZ;
        float cursorCoordX;
        float cursorY;
        float cursorX;
        this.zoomGoal = this.bindZoom(this.zoomGoal);
        if (this.mouseX != mouseX || this.mouseY != mouseY) {
            this.timeOfLastMouseInput = System.currentTimeMillis();
            this.switchToMouseInput();
        }
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        float mouseDirectX = (float)this.mc.field_71417_B.func_198024_e();
        float mouseDirectY = (float)this.mc.field_71417_B.func_198026_f();
        if (this.zoom != this.zoomGoal) {
            float previousZoom = this.zoom;
            long timeSinceZoom = System.currentTimeMillis() - this.timeOfZoom;
            this.zoom = (float)timeSinceZoom < 700.0f ? this.easeOut(timeSinceZoom, this.zoomStart, this.zoomGoal - this.zoomStart, 700.0f) : this.zoomGoal;
            float scaledZoom = this.zoom;
            if (this.mc.field_195558_d.func_198109_k() > 1600) {
                scaledZoom = this.zoom * (float)this.mc.field_195558_d.func_198109_k() / 1600.0f;
            }
            float zoomDelta = this.zoom / previousZoom;
            float zoomOffsetX = (float)this.centerX * this.guiToDirectMouse - this.zoomDirectX;
            float zoomOffsetY = (float)(this.top + this.centerY) * this.guiToDirectMouse - this.zoomDirectY;
            float zoomDeltaX = zoomOffsetX - zoomOffsetX * zoomDelta;
            float zoomDeltaY = zoomOffsetY - zoomOffsetY * zoomDelta;
            this.mapCenterX += zoomDeltaX / scaledZoom;
            this.mapCenterZ += zoomDeltaY / scaledZoom;
        }
        this.options.zoom = this.zoomGoal;
        float scaledZoom = this.zoom;
        if (this.mc.field_195558_d.func_198109_k() > 1600) {
            scaledZoom = this.zoom * (float)this.mc.field_195558_d.func_198109_k() / 1600.0f;
        }
        this.guiToMap = this.scScale / scaledZoom;
        this.mapToGui = 1.0f / this.scScale * scaledZoom;
        this.mouseDirectToMap = 1.0f / scaledZoom;
        this.guiToDirectMouse = this.scScale;
        this.func_146276_q_();
        if (this.mc.field_71417_B.func_198030_b()) {
            if (!this.leftMouseButtonDown && !this.overPopup(mouseX, mouseY)) {
                this.deltaX = 0.0f;
                this.deltaY = 0.0f;
                this.lastMouseX = mouseDirectX;
                this.lastMouseY = mouseDirectY;
                this.leftMouseButtonDown = true;
            } else if (this.leftMouseButtonDown) {
                this.deltaX = (this.lastMouseX - mouseDirectX) * this.mouseDirectToMap;
                this.deltaY = (this.lastMouseY - mouseDirectY) * this.mouseDirectToMap;
                this.lastMouseX = mouseDirectX;
                this.lastMouseY = mouseDirectY;
                this.deltaXonRelease = this.deltaX;
                this.deltaYonRelease = this.deltaY;
                this.timeOfRelease = System.currentTimeMillis();
            }
        } else {
            long timeSinceRelease = System.currentTimeMillis() - this.timeOfRelease;
            if ((float)timeSinceRelease < 700.0f) {
                this.deltaX = this.deltaXonRelease * (float)Math.exp((float)(-timeSinceRelease) / 350.0f);
                this.deltaY = this.deltaYonRelease * (float)Math.exp((float)(-timeSinceRelease) / 350.0f);
            } else {
                this.deltaX = 0.0f;
                this.deltaY = 0.0f;
                this.deltaXonRelease = 0.0f;
                this.deltaYonRelease = 0.0f;
            }
            this.leftMouseButtonDown = false;
        }
        long timeSinceLastTick = System.currentTimeMillis() - this.timeAtLastTick;
        this.timeAtLastTick = System.currentTimeMillis();
        if (!this.editingCoordinates) {
            int kbDelta = 5;
            if (this.keyBindSprint.func_151470_d()) {
                kbDelta = 10;
            }
            if (this.keyBindForward.func_151470_d()) {
                this.deltaY -= (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyBindBack.func_151470_d()) {
                this.deltaY += (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyBindLeft.func_151470_d()) {
                this.deltaX -= (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
            if (this.keyBindRight.func_151470_d()) {
                this.deltaX += (float)kbDelta / scaledZoom * (float)timeSinceLastTick / 12.0f;
                this.switchToKeyboardInput();
            }
        }
        this.mapCenterX += this.deltaX;
        this.mapCenterZ += this.deltaY;
        if (this.oldNorth) {
            this.options.mapX = (int)this.mapCenterZ;
            this.options.mapZ = -((int)this.mapCenterX);
        } else {
            this.options.mapX = (int)this.mapCenterX;
            this.options.mapZ = (int)this.mapCenterZ;
        }
        this.centerX = this.getWidth() / 2;
        this.centerY = (this.bottom - this.top) / 2;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (this.oldNorth) {
            left = (int)Math.floor((this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0f);
            right = (int)Math.floor((this.mapCenterZ + (float)this.centerY * this.guiToMap) / 256.0f);
            top = (int)Math.floor((-this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0f);
            bottom = (int)Math.floor((-this.mapCenterX + (float)this.centerX * this.guiToMap) / 256.0f);
        } else {
            left = (int)Math.floor((this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0f);
            right = (int)Math.floor((this.mapCenterX + (float)this.centerX * this.guiToMap) / 256.0f);
            top = (int)Math.floor((this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0f);
            bottom = (int)Math.floor((this.mapCenterZ + (float)this.centerY * this.guiToMap) / 256.0f);
        }
        Object zoomDeltaX = this.closedLock;
        synchronized (zoomDeltaX) {
            if (this.closed) {
                return;
            }
            this.regions = this.persistentMap.getRegions(left - 1, right + 1, top - 1, bottom + 1);
        }
        GLShim.glColor3f(1.0f, 1.0f, 1.0f);
        GLShim.glTranslatef((float)this.centerX - this.mapCenterX * this.mapToGui, (float)(this.top + this.centerY) - this.mapCenterZ * this.mapToGui, 0.0f);
        if (this.oldNorth) {
            GLShim.glRotatef(90.0f, 0.0f, 0.0f, 1.0f);
        }
        this.backGroundImageInfo = this.waypointManager.getBackgroundImageInfo();
        if (this.backGroundImageInfo != null) {
            GLUtils.disp(this.backGroundImageInfo.glid);
            this.drawTexturedModalRect((float)this.backGroundImageInfo.left * this.mapToGui, (float)this.backGroundImageInfo.top * this.mapToGui, (float)this.backGroundImageInfo.width * this.mapToGui, (float)this.backGroundImageInfo.height * this.mapToGui);
        }
        for (int t = 0; t < this.regions.length; ++t) {
            CachedRegion region = this.regions[t];
            int glid = region.getGLID();
            if (glid == 0) continue;
            GLUtils.disp(glid);
            if (this.mapOptions.filtering) {
                if (GLUtils.openGL14Enabled) {
                    GLShim.glTexParameteri(3553, 10241, 9987);
                } else {
                    GLShim.glTexParameteri(3553, 10241, 9729);
                }
                GLShim.glTexParameteri(3553, 10240, 9729);
            } else {
                if (GLUtils.openGL14Enabled) {
                    GLShim.glTexParameteri(3553, 10241, 9987);
                } else {
                    GLShim.glTexParameteri(3553, 10241, 9728);
                }
                GLShim.glTexParameteri(3553, 10240, 9728);
            }
            this.drawTexturedModalRect((float)(region.getX() * 256) * this.mapToGui, (float)(region.getZ() * 256) * this.mapToGui, (float)region.getWidth() * this.mapToGui, (float)region.getWidth() * this.mapToGui);
        }
        if (this.mouseCursorShown) {
            cursorX = mouseDirectX;
            cursorY = mouseDirectY - (float)this.top * this.guiToDirectMouse;
        } else {
            cursorX = this.mc.field_195558_d.func_198105_m() / 2;
            cursorY = (float)(this.mc.field_195558_d.func_198083_n() - this.mc.field_195558_d.func_198083_n() / 2) - (float)this.top * this.guiToDirectMouse;
        }
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        GLShim.glEnable(3042);
        if (this.options.showWaypoints) {
            for (Waypoint pt : this.waypointManager.getWaypoints()) {
                this.drawWaypoint(pt, cursorCoordX, cursorCoordZ, null, null, null, null);
            }
            if (this.waypointManager.getHighlightedWaypoint() != null) {
                this.drawWaypoint(this.waypointManager.getHighlightedWaypoint(), cursorCoordX, cursorCoordZ, this.master.getWaypointManager().getTextureAtlas().getAtlasSprite("voxelmap:images/waypoints/target.png"), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(0.0f));
            }
        }
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLUtils.disp(playerGLID);
        GLShim.glTexParameteri(3553, 10241, 9729);
        GLShim.glTexParameteri(3553, 10240, 9729);
        float playerX = (float)GameVariableAccessShim.xCoordDouble();
        float playerZ = (float)GameVariableAccessShim.zCoordDouble();
        if (this.oldNorth) {
            GLShim.glPushMatrix();
            GLShim.glTranslatef(playerX * this.mapToGui, playerZ * this.mapToGui, 0.0f);
            GLShim.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
            GLShim.glTranslatef(-(playerX * this.mapToGui), -(playerZ * this.mapToGui), 0.0f);
        }
        this.drawTexturedModalRect(-10.0f / this.scScale + playerX * this.mapToGui, -10.0f / this.scScale + playerZ * this.mapToGui, 20.0f / this.scScale, 20.0f / this.scScale);
        if (this.oldNorth) {
            GLShim.glPopMatrix();
        }
        if (this.oldNorth) {
            GLShim.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
        }
        GLShim.glTranslatef(-((float)this.centerX - this.mapCenterX * this.mapToGui), -((float)(this.top + this.centerY) - this.mapCenterZ * this.mapToGui), 0.0f);
        int n = this.mapOptions.biomeOverlay;
        this.mapOptions.getClass();
        if (n != 0) {
            float biomeScaleX = this.mapPixelsX / 760.0f;
            float biomeScaleY = this.mapPixelsY / 360.0f;
            boolean still = !this.leftMouseButtonDown;
            still = still && this.zoom == this.zoomGoal;
            still = still && this.deltaX == 0.0f && this.deltaY == 0.0f;
            boolean bl = still = still && ThreadManager.executorService.getActiveCount() == 0;
            if (still && !this.lastStill) {
                int column = 0;
                column = this.oldNorth ? (int)Math.floor(Math.floor(this.mapCenterZ - (float)this.centerY * this.guiToMap) / 256.0) - (left - 1) : (int)Math.floor(Math.floor(this.mapCenterX - (float)this.centerX * this.guiToMap) / 256.0) - (left - 1);
                for (int x = 0; x < this.biomeMapData.getWidth(); ++x) {
                    for (int z = 0; z < this.biomeMapData.getHeight(); ++z) {
                        float floatMapZ;
                        float floatMapX;
                        if (this.oldNorth) {
                            floatMapX = (float)z * biomeScaleY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
                            floatMapZ = -((float)x * biomeScaleX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
                        } else {
                            floatMapX = (float)x * biomeScaleX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
                            floatMapZ = (float)z * biomeScaleY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
                        }
                        int mapX = (int)Math.floor(floatMapX);
                        int mapZ = (int)Math.floor(floatMapZ);
                        int regionX = (int)Math.floor((float)mapX / 256.0f) - (left - 1);
                        int regionZ = (int)Math.floor((float)mapZ / 256.0f) - (top - 1);
                        if (!this.oldNorth && regionX != column || this.oldNorth && regionZ != column) {
                            this.persistentMap.compress();
                        }
                        column = !this.oldNorth ? regionX : regionZ;
                        CachedRegion region = this.regions[regionZ * (right + 1 - (left - 1) + 1) + regionX];
                        int id = -1;
                        if (region.getMapData() != null && region.isLoaded() && !region.isEmpty()) {
                            int inRegionX = mapX - region.getX() * region.getWidth();
                            int inRegionZ = mapZ - region.getZ() * region.getWidth();
                            int height = region.getMapData().getHeight(inRegionX, inRegionZ);
                            int light = region.getMapData().getLight(inRegionX, inRegionZ);
                            if (height != 0 || light != 0) {
                                id = region.getMapData().getBiomeID(inRegionX, inRegionZ);
                            }
                        }
                        this.biomeMapData.setBiomeID(x, z, id);
                    }
                }
                this.persistentMap.compress();
                this.biomeMapData.segmentBiomes();
                this.biomeMapData.findCenterOfSegments(true);
            }
            this.lastStill = still;
            boolean displayStill = !this.leftMouseButtonDown;
            displayStill = displayStill && this.zoom == this.zoomGoal;
            boolean bl2 = displayStill = displayStill && this.deltaX == 0.0f && this.deltaY == 0.0f;
            if (displayStill) {
                int minimumSize = (int)(20.0f * this.scScale / biomeScaleX);
                minimumSize *= minimumSize;
                ArrayList<AbstractMapData.BiomeLabel> labels = this.biomeMapData.getBiomeLabels();
                GLShim.glDisable(2929);
                for (int t = 0; t < labels.size(); ++t) {
                    AbstractMapData.BiomeLabel label = labels.get(t);
                    if (label.segmentSize <= minimumSize) continue;
                    int nameWidth = this.chkLen(label.name);
                    float x = (float)label.x * biomeScaleX / this.scScale;
                    float z = (float)label.z * biomeScaleY / this.scScale;
                    this.write(label.name, x - (float)(nameWidth / 2), (float)this.top + z - 3.0f, 0xFFFFFF);
                }
                GLShim.glEnable(2929);
            }
        }
        if (System.currentTimeMillis() - this.timeOfLastKBInput < 2000L) {
            int scWidth = this.mc.field_195558_d.func_198107_o();
            int scHeight = this.mc.field_195558_d.func_198087_p();
            this.mc.func_110434_K().func_110577_a(field_110324_m);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)775, (int)769, (int)1, (int)0);
            GlStateManager.func_179141_d();
            this.func_73729_b(scWidth / 2 - 7, scHeight / 2 - 7, 0, 0, 16, 16);
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        } else {
            this.switchToMouseInput();
        }
        this.overlayBackground(0, this.top, 255, 255);
        this.overlayBackground(this.bottom, this.getHeight(), 255, 255);
        this.func_73732_a(this.getFontRenderer(), this.screenTitle, this.getWidth() / 2, 16, 0xFFFFFF);
        int x = (int)Math.floor(cursorCoordX);
        int z = (int)Math.floor(cursorCoordZ);
        if (this.master.getMapOptions().coords) {
            if (!this.editingCoordinates) {
                this.func_73731_b(this.getFontRenderer(), "X: " + x, this.sideMargin, 16, 0xFFFFFF);
                this.func_73731_b(this.getFontRenderer(), "Z: " + z, this.sideMargin + 64, 16, 0xFFFFFF);
            } else {
                this.coordinates.func_195608_a(mouseX, mouseY, partialTicks);
            }
        }
        if (this.subworldName != null && !this.subworldName.equals(this.master.getWaypointManager().getCurrentSubworldDescriptor(true)) || this.master.getWaypointManager().getCurrentSubworldDescriptor(true) != null && !this.master.getWaypointManager().getCurrentSubworldDescriptor(true).equals(this.subworldName)) {
            this.buildWorldName();
        }
        this.func_73731_b(this.getFontRenderer(), this.worldNameDisplay, this.getWidth() - this.sideMargin - this.worldNameDisplayLength, 16, 0xFFFFFF);
        if (this.buttonMultiworld != null) {
            if ((this.subworldName == null || this.subworldName.equals("")) && this.master.getWaypointManager().isMultiworld()) {
                String attention = "";
                if ((int)(System.currentTimeMillis() / 1000L % 2L) == 0) {
                    attention = "\u00a7c";
                }
                this.buttonMultiworld.field_146126_j = attention + I18nUtils.getString("options.worldmap.multiworld", new Object[0]);
            } else {
                this.buttonMultiworld.field_146126_j = I18nUtils.getString("options.worldmap.multiworld", new Object[0]);
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawWaypoint(Waypoint pt, float cursorCoordX, float cursorCoordZ, Sprite icon, Float r, Float g, Float b) {
        if (pt.inWorld && pt.inDimension && this.isOnScreen(pt.getX(), pt.getZ())) {
            String name = pt.name;
            if (r == null) {
                r = Float.valueOf(pt.red);
            }
            if (g == null) {
                g = Float.valueOf(pt.green);
            }
            if (b == null) {
                b = Float.valueOf(pt.blue);
            }
            float ptX = pt.getX();
            float ptZ = pt.getZ();
            if (this.backGroundImageInfo != null && this.backGroundImageInfo.isInRange((int)ptX, (int)ptZ) || this.persistentMap.isRegionLoaded((int)ptX, (int)ptZ)) {
                boolean hover = cursorCoordX > (ptX += 0.5f) - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordX < ptX + 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ > (ptZ += 0.5f) - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ < ptZ + 18.0f * this.guiToMap / this.guiToDirectMouse;
                boolean target = false;
                TextureAtlas atlas = this.master.getWaypointManager().getTextureAtlas();
                GLUtils.disp(atlas.func_110552_b());
                if (icon == null) {
                    icon = atlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
                    if (icon == atlas.getMissingImage()) {
                        icon = atlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
                    }
                } else {
                    name = "";
                    target = true;
                }
                GLShim.glColor4f(r.floatValue(), g.floatValue(), b.floatValue(), pt.enabled || target || hover ? 1.0f : 0.3f);
                GLShim.glTexParameteri(3553, 10241, 9729);
                GLShim.glTexParameteri(3553, 10240, 9729);
                if (this.oldNorth) {
                    GLShim.glPushMatrix();
                    GLShim.glTranslatef(ptX * this.mapToGui, ptZ * this.mapToGui, 0.0f);
                    GLShim.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslatef(-(ptX * this.mapToGui), -(ptZ * this.mapToGui), 0.0f);
                }
                this.drawTexturedModalRect(-16.0f / this.scScale + ptX * this.mapToGui, -16.0f / this.scScale + ptZ * this.mapToGui, icon, 32.0f / this.scScale, 32.0f / this.scScale);
                if (this.oldNorth) {
                    GLShim.glPopMatrix();
                }
                int n = this.mapOptions.biomeOverlay;
                this.mapOptions.getClass();
                if (n == 0 && this.options.showWaypointNames || target || hover) {
                    float fontScale = 2.0f / this.scScale;
                    int m = this.chkLen(name) / 2;
                    GLShim.glPushMatrix();
                    GLShim.glScalef(fontScale, fontScale, 1.0f);
                    if (this.oldNorth) {
                        GLShim.glTranslatef(ptX * this.mapToGui / fontScale, ptZ * this.mapToGui / fontScale, 0.0f);
                        GLShim.glRotatef(-90.0f, 0.0f, 0.0f, 1.0f);
                        GLShim.glTranslatef(-(ptX * this.mapToGui / fontScale), -(ptZ * this.mapToGui / fontScale), 0.0f);
                    }
                    this.write(name, ptX * this.mapToGui / fontScale - (float)m, ptZ * this.mapToGui / fontScale + 16.0f / this.scScale / fontScale, pt.enabled || target || hover ? 0xFFFFFF : 0x55FFFFFF);
                    GLUtils.disp(0);
                    GLShim.glPopMatrix();
                }
            }
        }
    }

    private boolean isOnScreen(int x, int z) {
        int bottom;
        int top;
        int right;
        int left;
        if (this.oldNorth) {
            left = (int)Math.floor((double)this.mapCenterZ - (double)((float)this.centerY * this.guiToMap) * 1.1);
            right = (int)Math.floor((double)this.mapCenterZ + (double)((float)this.centerY * this.guiToMap) * 1.1);
            top = (int)Math.floor((double)(-this.mapCenterX) - (double)((float)this.centerX * this.guiToMap) * 1.1);
            bottom = (int)Math.floor((double)(-this.mapCenterX) + (double)((float)this.centerX * this.guiToMap) * 1.1);
        } else {
            left = (int)Math.floor((double)this.mapCenterX - (double)((float)this.centerX * this.guiToMap) * 1.1);
            right = (int)Math.floor((double)this.mapCenterX + (double)((float)this.centerX * this.guiToMap) * 1.1);
            top = (int)Math.floor((double)this.mapCenterZ - (double)((float)this.centerY * this.guiToMap) * 1.1);
            bottom = (int)Math.floor((double)this.mapCenterZ + (double)((float)this.centerY * this.guiToMap) * 1.1);
        }
        return x > left && x < right && z > top && z < bottom;
    }

    public void func_146276_q_() {
        GuiPersistentMap.func_73734_a((int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)-16777216);
    }

    protected void overlayBackground(int startY, int endY, int startAlpha, int endAlpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        this.mc.func_110434_K().func_110577_a(Gui.field_110325_k);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexBuffer.func_181662_b(0.0, (double)endY, 0.0).func_187315_a(0.0, (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(0 + this.getWidth()), (double)endY, 0.0).func_187315_a((double)((float)this.field_146294_l / 32.0f), (double)((float)endY / 32.0f)).func_181669_b(64, 64, 64, endAlpha).func_181675_d();
        vertexBuffer.func_181662_b((double)(0 + this.getWidth()), (double)startY, 0.0).func_187315_a((double)((float)this.field_146294_l / 32.0f), (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
        vertexBuffer.func_181662_b(0.0, (double)startY, 0.0).func_187315_a(0.0, (double)((float)startY / 32.0f)).func_181669_b(64, 64, 64, startAlpha).func_181675_d();
        tessellator.func_78381_a();
    }

    public void func_73876_c() {
        this.coordinates.func_146178_a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_146281_b() {
        this.mc.field_71474_y.field_74351_w.func_197979_b(this.forwardCode);
        this.mc.field_71474_y.field_74370_x.func_197979_b(this.leftCode);
        this.mc.field_71474_y.field_74368_y.func_197979_b(this.backCode);
        this.mc.field_71474_y.field_74366_z.func_197979_b(this.rightCode);
        this.mc.field_71474_y.field_151444_V.func_197979_b(this.sprintCode);
        this.keyBindForward.func_197979_b(this.nullInput);
        this.keyBindLeft.func_197979_b(this.nullInput);
        this.keyBindBack.func_197979_b(this.nullInput);
        this.keyBindRight.func_197979_b(this.nullInput);
        this.keyBindSprint.func_197979_b(this.nullInput);
        KeyBinding.func_74508_b();
        KeyBinding.func_74506_a();
        this.mc.field_195559_v.func_197967_a(false);
        Object object = this.closedLock;
        synchronized (object) {
            this.closed = true;
            this.persistentMap.getRegions(0, -1, 0, -1);
            this.regions = new CachedRegion[0];
        }
    }

    public void drawTexturedModalRect(float x, float y, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), (double)this.field_73735_i).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), (double)this.field_73735_i).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), (double)this.field_73735_i).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), (double)this.field_73735_i).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawTexturedModalRect(Sprite icon, float x, float y) {
        float width = (float)icon.getIconWidth() / this.scScale;
        float height = (float)icon.getIconHeight() / this.scScale;
        this.drawTexturedModalRect(x, y, icon, width, height);
    }

    public void drawTexturedModalRect(float xCoord, float yCoord, Sprite icon, float widthIn, float heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + heightIn), (double)this.field_73735_i).func_187315_a((double)icon.getMinU(), (double)icon.getMaxV()).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), (double)this.field_73735_i).func_187315_a((double)icon.getMaxU(), (double)icon.getMaxV()).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0.0f), (double)this.field_73735_i).func_187315_a((double)icon.getMaxU(), (double)icon.getMinV()).func_181675_d();
        vertexBuffer.func_181662_b((double)(xCoord + 0.0f), (double)(yCoord + 0.0f), (double)this.field_73735_i).func_187315_a((double)icon.getMinU(), (double)icon.getMinV()).func_181675_d();
        tessellator.func_78381_a();
    }

    private void createPopup(int mouseX, int mouseY, int mouseDirectX, int mouseDirectY) {
        float cursorCoordZ;
        float cursorCoordX;
        ArrayList<Popup.PopupEntry> entries = new ArrayList<Popup.PopupEntry>();
        float cursorX = mouseDirectX;
        float cursorY = (float)mouseDirectY - (float)this.top * this.guiToDirectMouse;
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        int x = (int)Math.floor(cursorCoordX);
        int z = (int)Math.floor(cursorCoordZ);
        boolean canTeleport = this.canTeleport();
        canTeleport = canTeleport && (this.persistentMap.isGroundAt(x, z) || this.backGroundImageInfo != null && this.backGroundImageInfo.isGroundAt(x, z));
        Waypoint hovered = this.getHovered(cursorCoordX, cursorCoordZ);
        if (hovered == null || !this.waypointManager.getWaypoints().contains(hovered)) {
            Popup.PopupEntry entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.newwaypoint", new Object[0]), this.NEW, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString(hovered == null ? "minimap.waypoints.highlight" : "minimap.waypoints.removehighlight", new Object[0]), this.HIGHLIGHT, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.teleportto", new Object[0]), this.TELEPORT, true, canTeleport);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.share", new Object[0]), this.SHARE, true, true);
            entries.add(entry);
        } else {
            Popup.PopupEntry entry = new Popup.PopupEntry(I18nUtils.getString("selectServer.edit", new Object[0]), this.EDIT, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("selectServer.delete", new Object[0]), this.DELETE, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString(hovered != this.waypointManager.getHighlightedWaypoint() ? "minimap.waypoints.highlight" : "minimap.waypoints.removehighlight", new Object[0]), this.HIGHLIGHT, true, true);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.teleportto", new Object[0]), this.TELEPORT, true, canTeleport);
            entries.add(entry);
            entry = new Popup.PopupEntry(I18nUtils.getString("minimap.waypoints.share", new Object[0]), this.SHARE, true, true);
            entries.add(entry);
        }
        this.createPopup(mouseX, mouseY, mouseDirectX, mouseDirectY, entries);
    }

    private Waypoint getHovered(float cursorCoordX, float cursorCoordZ) {
        Waypoint pt;
        Waypoint waypoint = null;
        for (Waypoint pt2 : this.waypointManager.getWaypoints()) {
            float ptX = (float)pt2.getX() + 0.5f;
            float ptZ = (float)pt2.getZ() + 0.5f;
            boolean hover = pt2.inDimension && pt2.inWorld && cursorCoordX > ptX - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordX < ptX + 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ > ptZ - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ < ptZ + 18.0f * this.guiToMap / this.guiToDirectMouse;
            if (!hover) continue;
            waypoint = pt2;
        }
        if (waypoint == null && (pt = this.waypointManager.getHighlightedWaypoint()) != null) {
            boolean hover;
            float ptX = (float)pt.getX() + 0.5f;
            float ptZ = (float)pt.getZ() + 0.5f;
            boolean bl = hover = pt.inDimension && pt.inWorld && cursorCoordX > ptX - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordX < ptX + 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ > ptZ - 18.0f * this.guiToMap / this.guiToDirectMouse && cursorCoordZ < ptZ + 18.0f * this.guiToMap / this.guiToDirectMouse;
            if (hover) {
                waypoint = pt;
            }
        }
        return waypoint;
    }

    @Override
    public void popupAction(Popup popup, int action) {
        float cursorCoordZ;
        float cursorCoordX;
        int mouseDirectX = popup.clickedDirectX;
        int mouseDirectY = popup.clickedDirectY;
        float cursorX = mouseDirectX;
        float cursorY = (float)mouseDirectY - (float)this.top * this.guiToDirectMouse;
        if (this.oldNorth) {
            cursorCoordX = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
            cursorCoordZ = -(cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap));
        } else {
            cursorCoordX = cursorX * this.mouseDirectToMap + (this.mapCenterX - (float)this.centerX * this.guiToMap);
            cursorCoordZ = cursorY * this.mouseDirectToMap + (this.mapCenterZ - (float)this.centerY * this.guiToMap);
        }
        int x = (int)Math.floor(cursorCoordX);
        int z = (int)Math.floor(cursorCoordZ);
        int y = this.persistentMap.getHeightAt(x, z);
        Waypoint hovered = this.getHovered(cursorCoordX, cursorCoordZ);
        this.editClicked = false;
        this.addClicked = false;
        this.deleteClicked = false;
        switch (action) {
            case 0: {
                float b;
                float g;
                float r;
                if (hovered != null) {
                    x = hovered.getX();
                    z = hovered.getZ();
                }
                this.addClicked = true;
                if (this.waypointManager.getWaypoints().size() == 0) {
                    r = 0.0f;
                    g = 1.0f;
                    b = 0.0f;
                } else {
                    r = this.generator.nextFloat();
                    g = this.generator.nextFloat();
                    b = this.generator.nextFloat();
                }
                TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
                dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(this.mc.field_71441_e.field_73011_w));
                this.newWaypoint = new Waypoint("", this.mc.field_71439_g.field_71093_bK != DimensionType.NETHER ? x : x * 8, this.mc.field_71439_g.field_71093_bK != DimensionType.NETHER ? z : z * 8, y, true, r, g, b, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions);
                this.mc.func_147108_a((GuiScreen)new GuiAddWaypoint(this, this.master, this.newWaypoint, false));
                break;
            }
            case 4: {
                if (hovered == null) break;
                this.editClicked = true;
                this.selectedWaypoint = hovered;
                this.mc.func_147108_a((GuiScreen)new GuiAddWaypoint(this, this.master, hovered, true));
                break;
            }
            case 5: {
                if (hovered == null) break;
                this.deleteClicked = true;
                this.selectedWaypoint = hovered;
                String var4 = I18nUtils.getString("minimap.waypoints.deleteconfirm", new Object[0]);
                String var5 = "'" + this.selectedWaypoint.name + "' " + I18nUtils.getString("selectServer.deleteWarning", new Object[0]);
                String var6 = I18nUtils.getString("selectServer.deleteButton", new Object[0]);
                String var7 = I18nUtils.getString("gui.cancel", new Object[0]);
                GuiYesNo var8 = new GuiYesNo((GuiYesNoCallback)this, var4, var5, var6, var7, this.waypointManager.getWaypoints().indexOf(this.selectedWaypoint));
                this.getMinecraft().func_147108_a((GuiScreen)var8);
                break;
            }
            case 1: {
                if (hovered != null) {
                    this.waypointManager.setHighlightedWaypoint(hovered, true);
                    break;
                }
                y = y > 0 ? y : 64;
                TreeSet<DimensionContainer> dimensions2 = new TreeSet<DimensionContainer>();
                dimensions2.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(this.mc.field_71441_e.field_73011_w));
                Waypoint fakePoint = new Waypoint("", this.mc.field_71439_g.field_71093_bK != DimensionType.NETHER ? x : x * 8, this.mc.field_71439_g.field_71093_bK != DimensionType.NETHER ? z : z * 8, y, true, 1.0f, 0.0f, 0.0f, "", this.master.getWaypointManager().getCurrentSubworldDescriptor(false), dimensions2);
                this.waypointManager.setHighlightedWaypoint(fakePoint, true);
                break;
            }
            case 2: {
                if (hovered != null) {
                    CommandUtils.sendWaypoint(hovered);
                    break;
                }
                y = y > 0 ? y : 64;
                CommandUtils.sendCoordinate(x, y, z);
                break;
            }
            case 3: {
                if (hovered != null) {
                    boolean mp;
                    this.selectedWaypoint = hovered;
                    boolean bl = mp = !this.mc.func_71387_A();
                    y = this.selectedWaypoint.getY() > 0 ? this.selectedWaypoint.getY() : (this.mc.field_71439_g.field_71093_bK != DimensionType.NETHER ? 128 : 64);
                    this.mc.field_71439_g.func_71165_d("/tp " + this.mc.field_71439_g.func_200200_C_().getString() + " " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                    if (mp) {
                        this.mc.field_71439_g.func_71165_d("/tppos " + this.selectedWaypoint.getX() + " " + y + " " + this.selectedWaypoint.getZ());
                        break;
                    }
                    this.getMinecraft().func_147108_a((GuiScreen)null);
                    break;
                }
                if (y == 0) {
                    y = this.mc.field_71439_g.field_71093_bK != DimensionType.NETHER ? 255 : 64;
                }
                this.mc.field_71439_g.func_71165_d("/tp " + this.mc.field_71439_g.func_200200_C_().getString() + " " + x + " " + y + " " + z);
                if (this.mc.func_71387_A()) break;
                this.mc.field_71439_g.func_71165_d("/tppos " + x + " " + y + " " + z);
                break;
            }
            default: {
                System.out.println("unimplemented command");
            }
        }
    }

    @Override
    public boolean isEditing() {
        return this.editClicked;
    }

    public void confirmResult(boolean confirm, int par2) {
        if (this.deleteClicked) {
            this.deleteClicked = false;
            if (confirm) {
                this.waypointManager.deleteWaypoint(this.selectedWaypoint);
                this.selectedWaypoint = null;
            }
        }
        if (this.editClicked) {
            this.editClicked = false;
            if (confirm) {
                this.waypointManager.saveWaypoints();
            }
        }
        if (this.addClicked) {
            this.addClicked = false;
            if (confirm) {
                this.waypointManager.addWaypoint(this.newWaypoint);
            }
        }
        this.getMinecraft().func_147108_a((GuiScreen)this);
    }

    public boolean canTeleport() {
        boolean allowed = false;
        boolean singlePlayer = this.mc.func_71387_A();
        if (singlePlayer) {
            try {
                allowed = this.mc.func_71401_C().func_184103_al().func_152596_g(this.mc.field_71439_g.func_146103_bH());
            }
            catch (Exception e) {
                allowed = this.mc.func_71401_C().func_71218_a(DimensionType.OVERWORLD).func_72912_H().func_76086_u();
            }
        } else {
            allowed = true;
        }
        return allowed;
    }

    private int chkLen(String string) {
        return this.getFontRenderer().func_78256_a(string);
    }

    private void write(String string, float x, float y, int color) {
        this.getFontRenderer().func_175063_a(string, x, y, color);
    }
}

