/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.interfaces.IDimensionManager;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;

public class DimensionManager
implements IDimensionManager {
    IVoxelMap master;
    public ArrayList<DimensionContainer> dimensions;
    public static final int NOT_LOADED_ID = -9999;
    public static final String NOT_LOADED = "Unknown Dimension";
    public static final String FAILED_TO_LOAD = "Failed Dimension";

    public DimensionManager(IVoxelMap master) {
        this.master = master;
        this.dimensions = new ArrayList();
    }

    @Override
    public ArrayList<DimensionContainer> getDimensions() {
        return this.dimensions;
    }

    @Override
    public void populateDimensions() {
        this.dimensions.clear();
        for (DimensionType dimensionType : IRegistry.field_212622_k) {
            int id = dimensionType.func_186068_a();
            String name = DimensionType.func_212678_a((DimensionType)dimensionType).func_110623_a();
            ResourceLocation resourceLocation = DimensionType.func_212678_a((DimensionType)dimensionType);
            DimensionContainer dim = new DimensionContainer(dimensionType, name, id, resourceLocation);
            this.dimensions.add(dim);
        }
        this.sort();
    }

    @Override
    public void enteredDimension(Dimension dimension) {
        int id = dimension.func_186058_p().func_186068_a();
        DimensionContainer dim = this.getDimensionContainerByID(id);
        if (dim == null) {
            dim = this.getDimensionContainerByResourceLocation(DimensionType.func_212678_a((DimensionType)dimension.func_186058_p()));
        }
        if (dim == null) {
            dim = new DimensionContainer(dimension.func_186058_p(), NOT_LOADED, id, null);
            this.dimensions.add(dim);
            this.sort();
        }
        if (dim.name.equals(NOT_LOADED) || dim.name.equals(FAILED_TO_LOAD)) {
            DimensionType type;
            dim.type = type = dimension.func_186058_p();
            dim.id = id;
            try {
                dim.name = DimensionType.func_212678_a((DimensionType)type).func_110623_a();
                dim.resourceLocation = DimensionType.func_212678_a((DimensionType)type);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sort() {
        Collections.sort(this.dimensions, new Comparator<DimensionContainer>(){

            @Override
            public int compare(DimensionContainer dim1, DimensionContainer dim2) {
                return dim1.id - dim2.id;
            }
        });
    }

    @Override
    public DimensionContainer getDimensionContainerByDimension(Dimension dimension) {
        int id = dimension.func_186058_p().func_186068_a();
        DimensionContainer dim = this.getDimensionContainerByID(id);
        if (dim == null) {
            DimensionType type = dimension.func_186058_p();
            ResourceLocation resourceLocation = DimensionType.func_212678_a((DimensionType)type);
            dim = new DimensionContainer(dimension.func_186058_p(), DimensionType.func_212678_a((DimensionType)type).func_110623_a(), id, resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    @Override
    public DimensionContainer getDimensionContainerByIdentifier(String ident) {
        DimensionContainer dim = null;
        int id = -9999;
        ResourceLocation resourceLocation = null;
        try {
            id = Integer.parseInt(ident);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (id != -9999) {
            dim = this.getDimensionContainerByID(id);
        } else if (ident.contains(" ")) {
            String[] parts = ident.split(" ");
            resourceLocation = new ResourceLocation(parts[0]);
            try {
                id = Integer.parseInt(parts[1]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            dim = id != -9999 ? this.getDimensionContainerByID(id) : this.getDimensionContainerByResourceLocation(resourceLocation);
        } else {
            resourceLocation = new ResourceLocation(ident);
            dim = this.getDimensionContainerByResourceLocation(new ResourceLocation(ident));
        }
        if (dim == null) {
            dim = new DimensionContainer(null, NOT_LOADED, id, resourceLocation);
            this.dimensions.add(dim);
            this.sort();
        }
        return dim;
    }

    private DimensionContainer getDimensionContainerByID(int id) {
        for (DimensionContainer dim : this.dimensions) {
            if (dim.id != id) continue;
            return dim;
        }
        return null;
    }

    private DimensionContainer getDimensionContainerByResourceLocation(ResourceLocation resourceLocation) {
        for (DimensionContainer dim : this.dimensions) {
            if (!resourceLocation.equals((Object)dim.resourceLocation)) continue;
            return dim;
        }
        return null;
    }
}

