/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.textures.FontRendererWithAtlas;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.StitcherException;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.Contact;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.model.BatModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.BlazeModel;
import net.minecraft.client.renderer.entity.model.ChickenModel;
import net.minecraft.client.renderer.entity.model.CowModel;
import net.minecraft.client.renderer.entity.model.CreeperModel;
import net.minecraft.client.renderer.entity.model.DolphinModel;
import net.minecraft.client.renderer.entity.model.EnderDragonModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.GhastModel;
import net.minecraft.client.renderer.entity.model.GuardianModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.IllagerModel;
import net.minecraft.client.renderer.entity.model.IronGolemModel;
import net.minecraft.client.renderer.entity.model.OcelotModel;
import net.minecraft.client.renderer.entity.model.PhantomModel;
import net.minecraft.client.renderer.entity.model.PigModel;
import net.minecraft.client.renderer.entity.model.PolarBearModel;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.RabbitModel;
import net.minecraft.client.renderer.entity.model.RavagerModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.entity.model.SilverfishModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.entity.model.SnowManModel;
import net.minecraft.client.renderer.entity.model.SpiderModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.client.renderer.entity.model.TropicalFishAModel;
import net.minecraft.client.renderer.entity.model.TropicalFishBModel;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.entity.model.WolfModel;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.src.VoxelMapProtectedFieldsHelper;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class Radar
implements IRadar {
    private Minecraft game;
    private IVoxelMap master = null;
    private LayoutVariables layoutVariables = null;
    public MapSettingsManager minimapOptions = null;
    public RadarSettingsManager options = null;
    private FontRendererWithAtlas fontRenderer;
    private TextureAtlas textureAtlas;
    private boolean newMobs = false;
    private boolean enabled = true;
    private boolean completedLoading = false;
    private int timer = 500;
    private float direction = 0.0f;
    private ArrayList<Contact> contacts = new ArrayList(40);
    public HashMap<String, Integer> mpContactsSkinGetTries = new HashMap();
    public HashMap<String, Integer> contactsSkinGetTries = new HashMap();
    private BufferedImage[][] mobImages = new BufferedImage[EnumMobs.values().length - 3][2];
    private boolean[] builtInCustom = new boolean[EnumMobs.values().length];
    private Sprite[] clothIcons = new Sprite[]{null, null};
    public static final int CLOTH = 0;
    public static final int CHAIN = 4;
    public static final int IRON = 5;
    public static final int GOLD = 6;
    public static final int DIAMOND = 7;
    public static final int TURTLE = 8;
    public static final int UNKNOWN = EnumMobs.UNKNOWN.ordinal();
    public static final int CUSTOM = EnumMobs.CUSTOM.ordinal();
    private BufferedImage[][] armorImages = new BufferedImage[9][2];
    private String[] armorNames = new String[]{"cloth", "clothOverlay", "clothOuter", "clothOverlayOuter", "chain", "iron", "gold", "diamond", "turtle"};
    private boolean randomobsOptifine = false;
    private Class<?> randomEntitiesClass = null;
    private Field mapPropertiesField = null;
    private Map<String, ?> mapProperties = null;
    private Field randomEntityField = null;
    private Object randomEntity = null;
    private Class<?> iRandomEntityClass = null;
    private Class<?> randomEntityClass = null;
    private Method setEntityMethod = null;
    private Class<?> randomEntitiesPropertiesClass = null;
    private Method getEntityTextureMethod = null;
    private boolean hasCustomNPCs = false;
    private Class<?> entityCustomNpcClass = null;
    private Class<?> modelDataClass = null;
    private Class<?> entityNPCInterfaceClass = null;
    private Field modelDataField = null;
    private Method getEntityMethod = null;
    private Class<?> modelScaleRendererClass = null;
    private boolean lastOutlines = true;
    UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");

    public Radar(IVoxelMap master) {
        this.master = master;
        this.minimapOptions = master.getMapOptions();
        this.options = master.getRadarOptions();
        this.game = Minecraft.func_71410_x();
        this.fontRenderer = new FontRendererWithAtlas(this.game.func_110434_K(), new ResourceLocation("textures/font/ascii.png"));
        this.textureAtlas = new TextureAtlas("mobs");
        this.textureAtlas.func_174937_a(false, false);
        try {
            this.randomEntitiesClass = Class.forName("net.optifine.RandomEntities");
            this.mapPropertiesField = this.randomEntitiesClass.getDeclaredField("mapProperties");
            this.mapPropertiesField.setAccessible(true);
            this.mapProperties = (Map)this.mapPropertiesField.get(null);
            this.randomEntityField = this.randomEntitiesClass.getDeclaredField("randomEntity");
            this.randomEntityField.setAccessible(true);
            this.randomEntity = this.randomEntityField.get(null);
            this.iRandomEntityClass = Class.forName("net.optifine.IRandomEntity");
            this.randomEntityClass = Class.forName("net.optifine.RandomEntity");
            Class[] argClasses1 = new Class[]{Entity.class};
            this.setEntityMethod = this.randomEntityClass.getDeclaredMethod("setEntity", argClasses1);
            this.randomEntitiesPropertiesClass = Class.forName("net.optifine.RandomEntityProperties");
            Class[] argClasses2 = new Class[]{ResourceLocation.class, this.iRandomEntityClass};
            this.getEntityTextureMethod = this.randomEntitiesPropertiesClass.getDeclaredMethod("getTextureLocation", argClasses2);
            this.randomobsOptifine = true;
        }
        catch (ClassNotFoundException e) {
            this.randomobsOptifine = false;
        }
        catch (NoSuchMethodException e) {
            this.randomobsOptifine = false;
        }
        catch (NoSuchFieldException e) {
            this.randomobsOptifine = false;
        }
        catch (SecurityException e) {
            this.randomobsOptifine = false;
        }
        catch (IllegalArgumentException e) {
            this.randomobsOptifine = false;
        }
        catch (IllegalAccessException e) {
            this.randomobsOptifine = false;
        }
        try {
            this.entityCustomNpcClass = Class.forName("noppes.npcs.entity.EntityCustomNpc");
            this.modelDataClass = Class.forName("noppes.npcs.ModelData");
            this.modelDataField = this.entityCustomNpcClass.getField("modelData");
            this.entityNPCInterfaceClass = Class.forName("noppes.npcs.entity.EntityNPCInterface");
            this.getEntityMethod = this.modelDataClass.getMethod("getEntity", this.entityNPCInterfaceClass);
            this.modelScaleRendererClass = Class.forName("noppes.npcs.client.model.ModelScaleRenderer");
            this.hasCustomNPCs = true;
        }
        catch (ClassNotFoundException e) {
            this.hasCustomNPCs = false;
        }
        catch (NoSuchFieldException e) {
            this.hasCustomNPCs = false;
        }
        catch (NoSuchMethodException e) {
            this.hasCustomNPCs = false;
        }
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.loadTexturePackIcons();
        this.fontRenderer.func_195410_a(resourceManager);
    }

    private void loadTexturePackIcons() {
        this.completedLoading = false;
        try {
            int t;
            this.mpContactsSkinGetTries.clear();
            this.contactsSkinGetTries.clear();
            this.textureAtlas.reset();
            EnumMobs.MOOSHROOM.secondaryResourceLocation = ReflectionUtils.classExists("com.prupe.mcpatcher.mob.MobOverlay") && ImageUtils.loadImage(new ResourceLocation("mcpatcher/mob/cow/mooshroom_overlay.png"), 0, 0, 1, 1) != null ? new ResourceLocation("mcpatcher/mob/cow/mooshroom_overlay.png") : new ResourceLocation("textures/block/red_mushroom.png");
            Arrays.fill(this.builtInCustom, false);
            for (t = 0; t < this.mobImages.length; ++t) {
                try {
                    int intendedSize = 8;
                    String fullPath = "";
                    InputStream is = null;
                    if (is == null) {
                        fullPath = "textures/icons/" + EnumMobs.values()[t].id + ".png";
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + EnumMobs.values()[t].id + "8.png";
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 16;
                        fullPath = "textures/icons/" + EnumMobs.values()[t].id + "16.png";
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 32;
                        fullPath = "textures/icons/" + EnumMobs.values()[t].id + "32.png";
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is != null) {
                        BufferedImage mobSkin = ImageIO.read(is);
                        is.close();
                        mobSkin = ImageUtils.loadImage(mobSkin, 0, 0, mobSkin.getWidth(), mobSkin.getHeight(), mobSkin.getWidth(), mobSkin.getHeight());
                        float scale = (float)mobSkin.getWidth() / (float)intendedSize;
                        this.mobImages[t][0] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 1.0f / scale)), this.options.outlines);
                        this.mobImages[t][1] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 2.0f / scale)), this.options.outlines);
                        this.builtInCustom[t] = true;
                    }
                }
                catch (Exception e) {
                    this.builtInCustom[t] = false;
                }
                if (!this.builtInCustom[t]) {
                    BufferedImage image = null;
                    image = this.createImageFromTypeAndResourceLocations(EnumMobs.values()[t], EnumMobs.values()[t].resourceLocation, EnumMobs.values()[t].secondaryResourceLocation, null);
                    if (image == null) {
                        System.err.println("Failed getting mob " + t + ": " + EnumMobs.values()[t].id);
                        image = new BufferedImage(2, 2, 6);
                    }
                    float scale = (float)image.getWidth() / (float)EnumMobs.values()[t].expectedWidth;
                    this.mobImages[t][1] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 2.0f / scale)), this.options.outlines);
                    this.mobImages[t][0] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 1.0f / scale)), this.options.outlines);
                }
                String nameWithoutSize = EnumMobs.values()[t].id + EnumMobs.values()[t].resourceLocation.toString();
                nameWithoutSize = nameWithoutSize + (EnumMobs.values()[t].secondaryResourceLocation != null ? EnumMobs.values()[t].secondaryResourceLocation.toString() : "");
                this.textureAtlas.registerIconForBufferedImage(nameWithoutSize + "1", this.mobImages[t][1]);
                this.textureAtlas.registerIconForBufferedImage(nameWithoutSize + "0", this.mobImages[t][0]);
            }
            this.armorImages[0][0] = ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1.png"), 8, 8, 8, 8);
            this.armorImages[1][0] = ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1.png"), 40, 8, 8, 8);
            this.armorImages[2][0] = ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1_overlay.png"), 8, 8, 8, 8);
            this.armorImages[3][0] = ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1_overlay.png"), 40, 8, 8, 8);
            this.armorImages[4][0] = ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/chainmail_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/chainmail_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            this.armorImages[5][0] = ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/iron_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/iron_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            this.armorImages[6][0] = ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/gold_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/gold_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            this.armorImages[7][0] = ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/diamond_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/diamond_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            this.armorImages[8][0] = ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/turtle_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/turtle_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
            for (t = 0; t < this.armorImages.length; ++t) {
                float scale = (float)this.armorImages[t][0].getWidth() / 8.0f;
                this.armorImages[t][1] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(this.armorImages[t][0], 2.0f / scale)), this.options.outlines, true, 16, t);
                this.armorImages[t][0] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(this.armorImages[t][0], 1.0f / scale)), this.options.outlines, true, 8, t);
                Sprite icon1 = this.textureAtlas.registerIconForBufferedImage("armor " + this.armorNames[t] + " 1", this.armorImages[t][1]);
                Sprite icon0 = this.textureAtlas.registerIconForBufferedImage("armor " + this.armorNames[t] + " 0", this.armorImages[t][0]);
                if (t != 0) continue;
                this.clothIcons = new Sprite[]{icon0, icon1};
            }
            BufferedImage sheepFur = ImageUtils.loadImage(new ResourceLocation("textures/entity/sheep/sheep_fur.png"), 6, 6, 6, 6);
            float scale = (float)sheepFur.getWidth() / 6.0f;
            BufferedImage sheepFur1 = ImageUtils.scaleImage(sheepFur, 4.0f / scale * 1.0625f);
            sheepFur1 = ImageUtils.eraseArea(sheepFur1, 2, 2, sheepFur1.getWidth() - 4, sheepFur1.getHeight() - 4, sheepFur1.getWidth(), sheepFur1.getHeight());
            sheepFur1 = ImageUtils.fillOutline(ImageUtils.pad(sheepFur1), this.options.outlines, true, 25, -10);
            sheepFur1 = ImageUtils.fillOutline(ImageUtils.pad(sheepFur1), this.options.outlines, true, 27, -10);
            BufferedImage sheepFur0 = ImageUtils.scaleImage(sheepFur, 2.0f / scale * 1.0625f);
            sheepFur0 = ImageUtils.eraseArea(sheepFur0, 1, 1, sheepFur0.getWidth() - 2, sheepFur0.getHeight() - 2, sheepFur0.getWidth(), sheepFur0.getHeight());
            sheepFur0 = ImageUtils.fillOutline(ImageUtils.pad(sheepFur0), this.options.outlines, true, 13, -10);
            sheepFur0 = ImageUtils.fillOutline(ImageUtils.pad(sheepFur0), this.options.outlines, true, 11, -10);
            this.textureAtlas.registerIconForBufferedImage("sheepfur1", sheepFur1);
            this.textureAtlas.registerIconForBufferedImage("sheepfur0", sheepFur0);
            BufferedImage crown = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/crown.png"), 0, 0, 16, 16, 16, 16);
            BufferedImage crown1 = ImageUtils.fillOutline(crown, this.options.outlines, true, 16, -10);
            BufferedImage crown0 = ImageUtils.fillOutline(ImageUtils.scaleImage(crown, 0.5f), this.options.outlines, true, 8, -10);
            this.textureAtlas.registerIconForBufferedImage("crown1", crown1);
            this.textureAtlas.registerIconForBufferedImage("crown0", crown0);
            BufferedImage glow = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/glow.png"), 0, 0, 16, 16, 16, 16);
            glow = ImageUtils.fillOutline(glow, this.options.outlines, true, 16, -10);
            this.textureAtlas.registerIconForBufferedImage("glow", glow);
            ResourceLocation fontResourceLocation = new ResourceLocation("textures/font/ascii.png");
            BufferedImage fontImage = ImageUtils.loadImage(fontResourceLocation, 0, 0, 128, 128, 128, 128);
            if (fontImage.getWidth() > 1024 || fontImage.getHeight() > 1024) {
                int maxDim = Math.max(fontImage.getWidth(), fontImage.getHeight());
                float scaleBy = 1024.0f / (float)maxDim;
                fontImage = ImageUtils.scaleImage(fontImage, scaleBy);
            }
            Sprite fontSprite = this.textureAtlas.registerIconForBufferedImage(fontResourceLocation.toString(), fontImage);
            this.fontRenderer.setFontSprite(fontSprite);
            this.fontRenderer.setFontRef(this.textureAtlas.func_110552_b());
            this.textureAtlas.stitch();
            this.completedLoading = true;
        }
        catch (Exception e) {
            System.err.println("Failed getting mobs " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private BufferedImage createImageFromTypeAndResourceLocations(EnumMobs type, ResourceLocation resourceLocation, ResourceLocation resourceLocationSecondary, Entity entity) {
        BufferedImage mobImage = null;
        BufferedImage mobImageSecondary = null;
        try {
            InputStream is = this.game.func_195551_G().func_199002_a(resourceLocation).func_199027_b();
            mobImage = ImageIO.read(is);
            is.close();
            if (resourceLocationSecondary != null) {
                is = this.game.func_195551_G().func_199002_a(resourceLocationSecondary).func_199027_b();
                mobImageSecondary = ImageIO.read(is);
                is.close();
            }
            return this.createImageFromTypeAndImages(type, mobImage, mobImageSecondary, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    private BufferedImage createImageFromTypeAndImages(EnumMobs type, BufferedImage mobImage, BufferedImage mobImageSecondary, Entity entity) {
        BufferedImage image = null;
        switch (type) {
            case BLANK: {
                image = ImageUtils.blankImage(mobImage, 2, 2);
                break;
            }
            case GENERICHOSTILE: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/hostile.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICNEUTRAL: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/neutral.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICTAME: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/tame.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case BAT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 64, 64), ImageUtils.loadImage(mobImage, 25, 1, 3, 4), 0.0f, 0.0f, 8, 12), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 25, 1, 3, 4)), 5.0f, 0.0f, 8, 12), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 3.0f, 8, 12);
                break;
            }
            case BLAZE: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case CAT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 5), ImageUtils.loadImage(mobImage, 5, 5, 5, 4), 0.0f, 1.0f, 5, 5), ImageUtils.loadImage(mobImage, 2, 26, 3, 2), 1.0f, 3.0f, 5, 5), ImageUtils.loadImage(mobImage, 2, 12, 1, 1), 1.0f, 0.0f, 5, 5), ImageUtils.loadImage(mobImage, 8, 12, 1, 1), 3.0f, 0.0f, 5, 5);
                break;
            }
            case CAVESPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case CHICKEN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 2, 3, 6, 6), ImageUtils.loadImage(mobImage, 16, 2, 4, 2), 1.0f, 2.0f, 6, 6), ImageUtils.loadImage(mobImage, 16, 6, 2, 2), 2.0f, 4.0f, 6, 6);
                break;
            }
            case COD: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 5, 32, 32), ImageUtils.loadImage(mobImage, 15, 3, 1, 3, 32, 32), 1.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 16, 3, 3, 4, 32, 32), 2.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 9, 7, 7, 4, 32, 32), 5.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 26, 7, 4, 4, 32, 32), 12.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 26, 0, 6, 1, 32, 32), 4.0f, 0.0f, 16, 5);
                break;
            }
            case COW: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 10), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 1.0f, 1.0f, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 0.0f, 0.0f, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 9.0f, 0.0f, 10, 10);
                break;
            }
            case CREEPER: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case DOLPHIN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 10), ImageUtils.loadImage(mobImage, 0, 6, 6, 7), 0.0f, 1.0f, 10, 10), ImageUtils.loadImage(mobImage, 0, 17, 4, 2), 6.0f, 6.0f, 10, 10);
                break;
            }
            case DROWNED: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImageSecondary, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImageSecondary, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case ENDERDRAGON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 20, 256, 256), ImageUtils.loadImage(mobImage, 128, 46, 16, 16, 256, 256), 0.0f, 4.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 60, 12, 5, 256, 256), 2.0f, 11.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 81, 12, 4, 256, 256), 2.0f, 16.0f, 16, 16), ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256), 3.0f, 0.0f, 16, 16), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256)), 11.0f, 0.0f, 16, 16);
                break;
            }
            case ENDERMAN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 8, 24, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 12, 8, 1), 0.0f, 4.0f, 8, 8);
                break;
            }
            case ENDERMITE: {
                image = ImageUtils.loadImage(mobImage, 2, 2, 4, 3);
                break;
            }
            case EVOKER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case GHAST: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case GHASTATTACKING: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case GUARDIAN: {
                image = ImageUtils.scaleImage(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12), 0.5f);
                break;
            }
            case GUARDIANELDER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12);
                break;
            }
            case HORSE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 24, 64, 64), ImageUtils.loadImage(mobImage, 56, 38, 2, 16, 64, 64), 1.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 42, 7, 12, 64, 64), 3.0f, 12.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 20, 7, 5, 64, 64), 3.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 30, 5, 5, 64, 64), 10.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 19, 17, 1, 3, 64, 64), 3.0f, 4.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 13, 1, 7, 64, 64), 3.0f, 0.0f, 16, 24);
                break;
            }
            case HUSK: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), ImageUtils.loadImage(mobImage, 40, 8, 8, 8, 64, 64), 0.0f, 0.0f, 8, 8);
                break;
            }
            case ILLUSIONER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case IRONGOLEM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 128, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 128, 128), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 128, 128), 3.0f, 8.0f, 8, 12);
                break;
            }
            case LLAMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 14, 128, 64), ImageUtils.loadImage(mobImage, 6, 20, 8, 8, 128, 64), 0.0f, 3.0f, 8, 14), ImageUtils.loadImage(mobImage, 9, 9, 4, 4, 128, 64), 2.0f, 5.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 0.0f, 0.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 5.0f, 0.0f, 8, 14);
                break;
            }
            case LLAMATRADER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 14, 128, 64), ImageUtils.loadImage(mobImage, 6, 20, 8, 8, 128, 64), 0.0f, 3.0f, 8, 14), ImageUtils.loadImage(mobImage, 9, 9, 4, 4, 128, 64), 2.0f, 5.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 0.0f, 0.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 5.0f, 0.0f, 8, 14);
                break;
            }
            case MAGMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 32, 18, 8, 1), 0.0f, 3.0f, 8, 8), ImageUtils.loadImage(mobImage, 32, 27, 8, 1), 0.0f, 4.0f, 8, 8);
                break;
            }
            case MOOSHROOM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 40, 40), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 16.0f, 16.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 15.0f, 15.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 24.0f, 15.0f, 40, 40);
                if (mobImageSecondary == null) break;
                BufferedImage mushroomImage = mobImageSecondary.getWidth() != mobImageSecondary.getHeight() ? ImageUtils.loadImage(mobImageSecondary, 32, 0, 16, 16, 48, 16) : ImageUtils.loadImage(mobImageSecondary, 0, 0, 16, 16, 16, 16);
                float ratio = (float)image.getWidth() / (float)mushroomImage.getWidth();
                if ((double)ratio < 2.5) {
                    image = ImageUtils.scaleImage(image, 2.5f / ratio);
                } else if ((double)ratio > 2.5) {
                    mushroomImage = ImageUtils.scaleImage(mushroomImage, ratio / 2.5f);
                }
                image = ImageUtils.addImages(image, mushroomImage, 12.0f, 0.0f, 40, 40);
                break;
            }
            case OCELOT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 5), ImageUtils.loadImage(mobImage, 5, 5, 5, 4), 0.0f, 1.0f, 5, 5), ImageUtils.loadImage(mobImage, 2, 26, 3, 2), 1.0f, 3.0f, 5, 5), ImageUtils.loadImage(mobImage, 2, 12, 1, 1), 1.0f, 0.0f, 5, 5), ImageUtils.loadImage(mobImage, 8, 12, 1, 1), 3.0f, 0.0f, 5, 5);
                break;
            }
            case PARROT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8, 32, 32), ImageUtils.loadImage(mobImage, 2, 22, 3, 5, 32, 32), 1.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 10, 4, 4, 1, 32, 32), 2.0f, 4.0f, 8, 8), ImageUtils.loadImage(mobImage, 2, 4, 2, 3, 32, 32), 2.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 11, 8, 1, 2, 32, 32), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 16, 8, 1, 2, 32, 32), 5.0f, 5.0f, 8, 8);
                break;
            }
            case PHANTOM: {
                image = ImageUtils.loadImage(mobImage, 5, 5, 7, 3, 64, 64);
                break;
            }
            case PIG: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 16, 17, 6, 3), 1.0f, 4.0f, 8, 8);
                break;
            }
            case PIGZOMBIE: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case PLAYER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case POLARBEAR: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 9, 8, 128, 64), ImageUtils.loadImage(mobImage, 27, 1, 2, 2, 128, 64), 0.0f, 0.0f, 9, 8), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 27, 1, 2, 2, 128, 64)), 7.0f, 0.0f, 9, 8), ImageUtils.loadImage(mobImage, 7, 7, 7, 7, 128, 64), 1.0f, 1.0f, 9, 8), ImageUtils.loadImage(mobImage, 3, 47, 5, 3, 128, 64), 2.0f, 5.0f, 9, 8);
                break;
            }
            case PUFFERFISH: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 3, 3, 32, 32), ImageUtils.loadImage(mobImage, 3, 30, 3, 2, 32, 32), 0.0f, 1.0f, 3, 3), ImageUtils.loadImage(mobImage, 3, 29, 1, 1, 32, 32), 0.0f, 0.0f, 3, 3), ImageUtils.loadImage(mobImage, 5, 29, 1, 1, 32, 32), 2.0f, 0.0f, 3, 3);
                break;
            }
            case PUFFERFISHHALF: {
                image = ImageUtils.loadImage(mobImage, 17, 27, 5, 5, 32, 32);
                break;
            }
            case PUFFERFISHFULL: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 32, 32);
                break;
            }
            case RABBIT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 10), ImageUtils.loadImage(mobImage, 37, 5, 5, 4), 0.0f, 5.0f, 5, 10), ImageUtils.loadImage(mobImage, 33, 10, 1, 1), 2.0f, 7.5f, 5, 10), ImageUtils.loadImage(mobImage, 53, 1, 2, 5), 0.0f, 0.0f, 5, 10), ImageUtils.loadImage(mobImage, 59, 1, 2, 5), 3.0f, 0.0f, 5, 10);
                break;
            }
            case SALMON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 26, 7, 32, 32), ImageUtils.loadImage(mobImage, 27, 3, 3, 4, 32, 32), 1.0f, 2.5f, 26, 7), ImageUtils.loadImage(mobImage, 11, 8, 8, 5, 32, 32), 4.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 11, 21, 8, 5, 32, 32), 12.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 26, 16, 6, 5, 32, 32), 20.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 0, 0, 2, 2, 32, 32), 10.0f, 0.0f, 26, 7), ImageUtils.loadImage(mobImage, 5, 6, 3, 2, 32, 32), 12.0f, 0.0f, 26, 7);
                break;
            }
            case SHEEP: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 6, 6);
                break;
            }
            case SHULKER: {
                image = ImageUtils.loadImage(mobImage, 6, 58, 6, 6);
                break;
            }
            case SILVERFISH: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 22, 20, 6, 6), ImageUtils.loadImage(mobImage, 2, 2, 3, 2), 2.0f, 2.0f, 6, 6);
                break;
            }
            case SKELETON: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SKELETONWITHER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SLIME: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 22, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 6, 2, 2), 5.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 2, 2, 2), 1.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 33, 9, 1, 1), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SNOWGOLEM: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case SPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SQUID: {
                image = ImageUtils.scaleImage(ImageUtils.loadImage(mobImage, 12, 12, 12, 16), 0.5f);
                break;
            }
            case STRAY: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImageSecondary, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImageSecondary, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case TROPICALFISHA: {
                float[] primaryColorsA = new float[]{0.9765f, 0.502f, 0.1137f};
                float[] secondaryColorsA = new float[]{0.9765f, 1.0f, 0.9961f};
                if (entity != null && entity instanceof TropicalFishEntity) {
                    TropicalFishEntity fish = (TropicalFishEntity)entity;
                    primaryColorsA = fish.func_204219_dC();
                    secondaryColorsA = fish.func_204222_dD();
                }
                BufferedImage baseA = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 6, 32, 32), ImageUtils.loadImage(mobImage, 8, 6, 6, 3, 32, 32), 0.0f, 3.0f, 10, 6), ImageUtils.loadImage(mobImage, 17, 1, 5, 3, 32, 32), 1.0f, 0.0f, 10, 6), ImageUtils.loadImage(mobImage, 28, 0, 4, 3, 32, 32), 6.0f, 3.0f, 10, 6), primaryColorsA[0], primaryColorsA[1], primaryColorsA[2]);
                BufferedImage patternA = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 10, 6, 32, 32), ImageUtils.loadImage(mobImageSecondary, 8, 6, 6, 3, 32, 32), 0.0f, 3.0f, 10, 6), ImageUtils.loadImage(mobImageSecondary, 17, 1, 5, 3, 32, 32), 1.0f, 0.0f, 10, 6), ImageUtils.loadImage(mobImageSecondary, 28, 0, 4, 3, 32, 32), 6.0f, 3.0f, 10, 6), secondaryColorsA[0], secondaryColorsA[1], secondaryColorsA[2]);
                image = ImageUtils.addImages(baseA, patternA, 0.0f, 0.0f, 10, 6);
                break;
            }
            case TROPICALFISHB: {
                float[] primaryColorsB = new float[]{0.5373f, 0.1961f, 0.7216f};
                float[] secondaryColorsB = new float[]{0.9961f, 0.8471f, 0.2392f};
                if (entity != null && entity instanceof TropicalFishEntity) {
                    TropicalFishEntity fish = (TropicalFishEntity)entity;
                    primaryColorsB = fish.func_204219_dC();
                    secondaryColorsB = fish.func_204222_dD();
                }
                BufferedImage baseB = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 12, 12, 32, 32), ImageUtils.loadImage(mobImage, 0, 26, 6, 6, 32, 32), 6.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 21, 6, 6, 32, 32), 0.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 18, 5, 3, 32, 32), 6.0f, 0.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 27, 5, 3, 32, 32), 6.0f, 9.0f, 12, 12), primaryColorsB[0], primaryColorsB[1], primaryColorsB[2]);
                BufferedImage patternB = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 12, 12, 32, 32), ImageUtils.loadImage(mobImageSecondary, 0, 26, 6, 6, 32, 32), 6.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 21, 6, 6, 32, 32), 0.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 18, 5, 3, 32, 32), 6.0f, 0.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 27, 5, 3, 32, 32), 6.0f, 9.0f, 12, 12), secondaryColorsB[0], secondaryColorsB[1], secondaryColorsB[2]);
                image = ImageUtils.addImages(baseB, patternB, 0.0f, 0.0f, 12, 12);
                break;
            }
            case TURTLE: {
                image = ImageUtils.loadImage(mobImage, 3, 6, 6, 5, 128, 64);
                break;
            }
            case VEX: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case VEXCHARGING: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case VILLAGER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case VINDICATOR: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case WITCH: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 16, 64, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 128), 1.0f, 5.0f, 10, 16), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 128), 4.0f, 12.0f, 10, 16), ImageUtils.loadImage(mobImage, 10, 74, 10, 3, 64, 128), 0.0f, 4.0f, 10, 16), ImageUtils.loadImage(mobImage, 7, 83, 7, 4, 64, 128), 1.5f, 0.0f, 10, 16), ImageUtils.loadImage(mobImage, 1, 1, 1, 1, 64, 128), 5.0f, 14.0f, 10, 16);
                break;
            }
            case WITHER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2.0f, 24, 10);
                break;
            }
            case WITHERINVULNERABLE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2.0f, 24, 10);
                break;
            }
            case WOLF: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 6, 8), ImageUtils.loadImage(mobImage, 4, 4, 6, 6), 0.0f, 2.0f, 6, 8), ImageUtils.loadImage(mobImage, 4, 14, 3, 3), 1.5f, 5.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 0.0f, 0.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 4.0f, 0.0f, 6, 8);
                break;
            }
            case WOLFANGRY: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 6, 8), ImageUtils.loadImage(mobImage, 4, 4, 6, 6), 0.0f, 2.0f, 6, 8), ImageUtils.loadImage(mobImage, 4, 14, 3, 3), 1.5f, 5.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 0.0f, 0.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 4.0f, 0.0f, 6, 8);
                break;
            }
            case WOLFTAME: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 6, 8), ImageUtils.loadImage(mobImage, 4, 4, 6, 6), 0.0f, 2.0f, 6, 8), ImageUtils.loadImage(mobImage, 4, 14, 3, 3), 1.5f, 5.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 0.0f, 0.0f, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 4.0f, 0.0f, 6, 8);
                break;
            }
            case ZOMBIE: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), ImageUtils.loadImage(mobImage, 40, 8, 8, 8, 64, 64), 0.0f, 0.0f, 8, 8);
                break;
            }
            case ZOMBIEVILLAGER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            default: {
                throw new IllegalArgumentException("New mob type: " + type.id + ". Need to construct icon for it!");
            }
        }
        return image;
    }

    @Override
    public void OnTickInGame(Minecraft mc, LayoutVariables layoutVariables) {
        int guiScale;
        if (!(this.options.radarAllowed.booleanValue() || this.options.radarMobsAllowed.booleanValue() || this.options.radarPlayersAllowed.booleanValue())) {
            return;
        }
        if (this.game == null) {
            this.game = mc;
        }
        this.layoutVariables = layoutVariables;
        if (this.options.isChanged()) {
            this.timer = 500;
            if (this.options.outlines != this.lastOutlines) {
                this.lastOutlines = this.options.outlines;
                this.loadTexturePackIcons();
            }
        }
        guiScale = (guiScale = layoutVariables.scScale) >= 4 ? 1 : 0;
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (this.enabled) {
            if (this.completedLoading && this.timer > 95) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            if (this.completedLoading) {
                this.renderMapMobs(this.layoutVariables.mapX, this.layoutVariables.mapY, guiScale);
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private int chkLen(String paramStr) {
        return this.fontRenderer.func_78256_a(paramStr);
    }

    private void write(String paramStr, float x, float y, int color) {
        GLShim.glTexParameteri(3553, 10241, 9728);
        GLShim.glTexParameteri(3553, 10240, 9728);
        this.fontRenderer.func_175063_a(paramStr, x, y, color);
    }

    public void calculateMobs() {
        this.contacts.clear();
        Iterable entities = this.game.field_71441_e.func_217416_b();
        for (Entity entity : entities) {
            try {
                String scrubbedName;
                if (entity == null || entity.func_98034_c((PlayerEntity)this.game.field_71439_g) || (!this.options.showHostiles || !this.options.radarAllowed.booleanValue() && !this.options.radarMobsAllowed.booleanValue() || !this.isHostile(entity)) && (!this.options.showPlayers || !this.options.radarAllowed.booleanValue() && !this.options.radarPlayersAllowed.booleanValue() || !this.isPlayer(entity)) && (!this.options.showNeutrals || !this.options.radarMobsAllowed.booleanValue() || !this.isNeutral(entity))) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.field_70165_t;
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.field_70161_v;
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.field_70163_u;
                double hypot = wayX * wayX + wayZ * wayZ + wayY * wayY;
                if (!((hypot /= this.layoutVariables.zoomScaleAdjusted * this.layoutVariables.zoomScaleAdjusted) < 961.0)) continue;
                if (this.hasCustomNPCs) {
                    try {
                        Object modelData;
                        LivingEntity wrappedEntity;
                        if (this.entityCustomNpcClass.isInstance(entity) && (wrappedEntity = (LivingEntity)this.getEntityMethod.invoke(modelData = this.modelDataField.get(entity), entity)) != null) {
                            entity = wrappedEntity;
                        }
                    }
                    catch (Exception modelData) {
                        // empty catch block
                    }
                }
                Contact contact = new Contact(entity, this.getContactTypeStrict(entity));
                String unscrubbedName = contact.entity.func_145748_c_().func_150254_d();
                contact.setName(unscrubbedName);
                if (contact.entity.func_184187_bx() != null) {
                    contact.yFudge = 1;
                }
                contact.updateLocation();
                if (contact.type != EnumMobs.UNKNOWN) {
                    contact.icons = new Sprite[]{this.textureAtlas.getAtlasSprite(contact.type.id + contact.type.resourceLocation.toString() + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : "") + "0"), this.textureAtlas.getAtlasSprite(contact.type.id + contact.type.resourceLocation.toString() + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : "") + "1")};
                }
                if (contact.type == EnumMobs.PLAYER) {
                    this.handleMPplayer(contact);
                }
                if (contact.type == EnumMobs.UNKNOWN) {
                    this.tryCustomIcon(contact);
                }
                if (contact.type == EnumMobs.UNKNOWN) {
                    this.tryAutoIcon(contact);
                }
                if (contact.type == EnumMobs.UNKNOWN) {
                    this.tryFallbackType(contact);
                }
                if (!this.builtInCustom[contact.type.ordinal()] && contact.type != EnumMobs.CUSTOM && contact.type != EnumMobs.UNKNOWN && contact.type != EnumMobs.BLANK && contact.type != EnumMobs.GENERICHOSTILE && contact.type != EnumMobs.GENERICNEUTRAL && contact.type != EnumMobs.GENERICTAME && this.options.randomobs) {
                    contact.icons = this.getIconsForRandomob(contact);
                }
                if (contact.type == EnumMobs.HORSE) {
                    contact.setRotationFactor(45);
                }
                if ((scrubbedName = TextUtils.scrubCodes(contact.entity.func_200200_C_().func_150261_e())) != null && (scrubbedName.equals("Dinnerbone") || scrubbedName.equals("Grumm")) && (!(contact.entity instanceof PlayerEntity) || ((PlayerEntity)contact.entity).func_175148_a(PlayerModelPart.CAPE))) {
                    contact.setRotationFactor(contact.rotationFactor + 180);
                }
                if (this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER || contact.type == EnumMobs.SHEEP) {
                    this.getArmor(contact, entity);
                }
                if (contact.type == EnumMobs.UNKNOWN || contact.type == EnumMobs.GENERICHOSTILE || contact.type == EnumMobs.GENERICNEUTRAL || contact.type == EnumMobs.GENERICTAME || contact.type == EnumMobs.CUSTOM || contact.type == EnumMobs.AUTO) {
                    String type = entity.func_200600_R().func_210760_d();
                    CustomMob customMob = CustomMobsManager.getCustomMobByType(type);
                    if (customMob != null && !customMob.enabled) continue;
                    this.contacts.add(contact);
                    continue;
                }
                if (!contact.type.enabled) continue;
                this.contacts.add(contact);
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (this.newMobs) {
            try {
                this.textureAtlas.stitchNew();
            }
            catch (StitcherException e) {
                System.err.println("Stitcher exception!  Resetting mobs texture atlas.");
                this.loadTexturePackIcons();
            }
        }
        this.newMobs = false;
        Collections.sort(this.contacts, new Comparator<Contact>(){

            @Override
            public int compare(Contact contact1, Contact contact2) {
                return contact1.y - contact2.y;
            }
        });
    }

    private void tryCustomIcon(Contact contact) {
        block30: {
            Sprite icon = this.textureAtlas.getAtlasSprite(contact.entity.getClass().getName() + "custom0");
            if (icon == this.textureAtlas.getMissingImage()) {
                boolean isHostile = this.isHostile(contact.entity);
                CustomMobsManager.add(contact.entity.func_200600_R().func_210760_d(), isHostile, !isHostile);
                try {
                    int intendedSize = 8;
                    String fullPath = ("textures/icons/" + contact.entity.getClass().getName() + ".png").toLowerCase();
                    InputStream is = null;
                    try {
                        is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                    }
                    catch (IOException e) {
                        is = null;
                    }
                    if (is == null) {
                        fullPath = ("textures/icons/" + contact.entity.getClass().getSimpleName() + ".png").toLowerCase();
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = ("textures/icons/" + contact.entity.getClass().getName() + "8.png").toLowerCase();
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = ("textures/icons/" + contact.entity.getClass().getSimpleName() + "8.png").toLowerCase();
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 16;
                        fullPath = ("textures/icons/" + contact.entity.getClass().getName() + "16.png").toLowerCase();
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = ("textures/icons/" + contact.entity.getClass().getSimpleName() + "16.png").toLowerCase();
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 32;
                        fullPath = ("textures/icons/" + contact.entity.getClass().getName() + "32.png").toLowerCase();
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = ("textures/icons/" + contact.entity.getClass().getSimpleName() + "32.png").toLowerCase();
                        try {
                            is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is != null) {
                        BufferedImage mobSkin = ImageIO.read(is);
                        is.close();
                        mobSkin = ImageUtils.loadImage(mobSkin, 0, 0, mobSkin.getWidth(), mobSkin.getHeight(), mobSkin.getWidth(), mobSkin.getHeight());
                        float scale = (float)mobSkin.getWidth() / (float)intendedSize;
                        BufferedImage mobSkin0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 1.0f / scale)), this.options.outlines);
                        BufferedImage mobSkin1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 2.0f / scale)), this.options.outlines);
                        Sprite icon0 = this.textureAtlas.registerIconForBufferedImage(contact.entity.getClass().getName() + "custom0", mobSkin0);
                        Sprite icon1 = this.textureAtlas.registerIconForBufferedImage(contact.entity.getClass().getName() + "custom1", mobSkin1);
                        this.newMobs = true;
                        contact.icons = new Sprite[]{icon0, icon1};
                        contact.type = EnumMobs.CUSTOM;
                        break block30;
                    }
                    contact.type = EnumMobs.UNKNOWN;
                    this.textureAtlas.registerFailedIcon(contact.entity.getClass().getName() + "custom0");
                }
                catch (IOException e) {
                    contact.type = EnumMobs.UNKNOWN;
                    this.textureAtlas.registerFailedIcon(contact.entity.getClass().getName() + "custom0");
                }
            } else if (icon != this.textureAtlas.getFailedImage()) {
                contact.type = EnumMobs.CUSTOM;
                contact.icons = new Sprite[]{icon, this.textureAtlas.getAtlasSprite(contact.entity.getClass().getName() + "custom1")};
            } else {
                contact.type = EnumMobs.UNKNOWN;
            }
        }
    }

    private void tryAutoIcon(Contact contact) {
        EntityRenderer render = this.game.func_175598_ae().func_78713_a(contact.entity);
        ResourceLocation resourceLocation = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity);
        String entityName = contact.entity.getClass().getName();
        String resourceLocationString = resourceLocation != null ? resourceLocation.toString() : "";
        String nameMinusSize = entityName + resourceLocationString;
        Sprite icon = this.textureAtlas.getAtlasSprite(nameMinusSize + 0);
        if (icon == this.textureAtlas.getMissingImage()) {
            BufferedImage mobImage;
            Integer checkCount = this.contactsSkinGetTries.get(nameMinusSize);
            if (checkCount == null) {
                checkCount = 0;
            }
            if ((mobImage = this.createAutoIconImageFromResourceLocation(contact, (EntityRenderer<? extends Entity>)render, resourceLocation)) != null) {
                try {
                    contact.type = EnumMobs.AUTO;
                    BufferedImage[] trimmedImages = this.trimAndOutlineImages(contact.type, mobImage);
                    Sprite icon0 = this.textureAtlas.registerIconForBufferedImage(nameMinusSize + "0", trimmedImages[0]);
                    Sprite icon1 = this.textureAtlas.registerIconForBufferedImage(nameMinusSize + "1", trimmedImages[1]);
                    contact.icons = new Sprite[]{icon0, icon1};
                    this.newMobs = true;
                    this.contactsSkinGetTries.remove(nameMinusSize);
                }
                catch (Exception e) {
                    contact.type = EnumMobs.UNKNOWN;
                    Integer n = checkCount;
                    Integer n2 = checkCount = Integer.valueOf(checkCount + 1);
                    if (checkCount > 4) {
                        this.textureAtlas.registerFailedIcon(nameMinusSize + "0");
                    }
                }
            } else {
                contact.type = EnumMobs.UNKNOWN;
                Integer n = checkCount;
                Integer n3 = checkCount = Integer.valueOf(checkCount + 1);
                if (checkCount > 4) {
                    this.textureAtlas.registerFailedIcon(nameMinusSize + "0");
                }
            }
        } else if (icon != this.textureAtlas.getFailedImage()) {
            contact.type = EnumMobs.AUTO;
            contact.icons = new Sprite[]{icon, this.textureAtlas.getAtlasSprite(nameMinusSize + 1)};
        } else {
            contact.type = EnumMobs.UNKNOWN;
        }
    }

    private BufferedImage createAutoIconImageFromResourceLocation(Contact contact, EntityRenderer<? extends Entity> render, ResourceLocation resourceLocation) {
        BufferedImage headImage = null;
        if (GLUtils.fboEnabled && render instanceof LivingRenderer) {
            try {
                EntityModel model = ((LivingRenderer)render).func_217764_d();
                if (render instanceof TropicalFishRenderer) {
                    Object fishModel = null;
                    int size = ((TropicalFishEntity)contact.entity).func_204217_dE();
                    fishModel = size == 0 ? ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishAModel.class) : ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishBModel.class);
                    if (fishModel != null) {
                        model = (EntityModel)fishModel;
                    }
                }
                ArrayList<Field> submodels = ReflectionUtils.getFieldsByType(model, EntityModel.class, RendererModel.class);
                ArrayList<Field> submodelArrays = ReflectionUtils.getFieldsByType(model, EntityModel.class, RendererModel[].class);
                RendererModel[] headBits = null;
                Properties properties = new Properties();
                String fullPath = "textures/icons/" + contact.entity.getClass().getName().toLowerCase() + ".properties";
                InputStream is = null;
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
                if (is == null) {
                    fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName().toLowerCase() + ".properties";
                    try {
                        is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                    }
                    catch (IOException e) {
                        is = null;
                    }
                }
                if (is != null) {
                    String name;
                    properties.load(is);
                    is.close();
                    String subModelNames = properties.getProperty("models", "").toLowerCase();
                    String[] submodelNamesArray = subModelNames.split(",");
                    Iterator<Field> subModelNamesList = Arrays.asList(submodelNamesArray);
                    HashSet<String> subModelNamesSet = new HashSet<String>();
                    subModelNamesSet.addAll((Collection<String>)((Object)subModelNamesList));
                    ArrayList<RendererModel> headPartsArrayList = new ArrayList<RendererModel>();
                    ArrayList purge = new ArrayList();
                    for (Field submodelArray : submodelArrays) {
                        RendererModel[] submodelArrayValue;
                        name = submodelArray.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || (submodelArrayValue = (RendererModel[])submodelArray.get(model)) == null) continue;
                        for (int t = 0; t < submodelArrayValue.length; ++t) {
                            headPartsArrayList.add(submodelArrayValue[t]);
                        }
                    }
                    for (Field submodel : submodels) {
                        name = submodel.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || submodel.get(model) == null) continue;
                        headPartsArrayList.add((RendererModel)submodel.get(model));
                    }
                    for (RendererModel bit : headPartsArrayList) {
                        if (bit.field_78805_m == null) continue;
                        purge.addAll(bit.field_78805_m);
                    }
                    headPartsArrayList.removeAll(purge);
                    if (headPartsArrayList.size() > 0) {
                        headBits = headPartsArrayList.toArray(new RendererModel[headPartsArrayList.size()]);
                    }
                }
                if (headBits == null) {
                    if (model instanceof BatModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, BatModel.class, RendererModel.class)};
                    } else if (model instanceof BipedModel) {
                        headBits = new RendererModel[]{((BipedModel)model).field_78116_c, ((BipedModel)model).field_178720_f};
                    } else if (model instanceof BlazeModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, BlazeModel.class, RendererModel.class)};
                    } else if (model instanceof ChickenModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, ChickenModel.class, RendererModel.class)};
                    } else if (model instanceof CowModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, CowModel.class, RendererModel.class)};
                    } else if (model instanceof CreeperModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, CreeperModel.class, RendererModel.class)};
                    } else if (model instanceof DolphinModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, DolphinModel.class, RendererModel.class)};
                    } else if (model instanceof EnderDragonModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, EnderDragonModel.class, RendererModel.class)};
                    } else if (model instanceof GhastModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, GhastModel.class, RendererModel.class)};
                    } else if (model instanceof GuardianModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, RendererModel.class, 0), (RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, RendererModel.class, 1)};
                    } else if (model instanceof HorseModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, HorseModel.class, RendererModel.class)};
                    } else if (model instanceof IllagerModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, IllagerModel.class, RendererModel.class)};
                    } else if (model instanceof IronGolemModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, IronGolemModel.class, RendererModel.class)};
                    } else if (model instanceof OcelotModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, OcelotModel.class, RendererModel.class, 6)};
                    } else if (model instanceof PhantomModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, PhantomModel.class, RendererModel.class)};
                    } else if (model instanceof PigModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, PigModel.class, RendererModel.class)};
                    } else if (model instanceof PolarBearModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, PolarBearModel.class, RendererModel.class)};
                    } else if (model instanceof RabbitModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, RendererModel.class, 7), (RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, RendererModel.class, 8), (RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, RendererModel.class, 9), (RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, RendererModel.class, 10)};
                    } else if (model instanceof RavagerModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, RavagerModel.class, RendererModel.class, 7)};
                    } else if (model instanceof ShulkerModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, ShulkerModel.class, RendererModel.class, 2)};
                    } else if (model instanceof SilverfishModel) {
                        headBits = new RendererModel[]{(RendererModel)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, RendererModel[].class))[0], (RendererModel)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, RendererModel[].class))[1]};
                    } else if (model instanceof SlimeModel) {
                        SlimeModel modelOuter = new SlimeModel(0);
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, RendererModel.class, 0), (RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, RendererModel.class, 1), (RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, RendererModel.class, 2), (RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, RendererModel.class, 3), (RendererModel)ReflectionUtils.getPrivateFieldValueByType(modelOuter, SlimeModel.class, RendererModel.class, 0)};
                    } else if (model instanceof SnowManModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, SnowManModel.class, RendererModel.class, 2)};
                    } else if (model instanceof SpiderModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, SpiderModel.class, RendererModel.class)};
                    } else if (model instanceof SquidModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, SquidModel.class, RendererModel.class)};
                    } else if (model instanceof VillagerModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, VillagerModel.class, RendererModel.class)};
                    } else if (model instanceof WolfModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, WolfModel.class, RendererModel.class)};
                    } else if (model instanceof QuadrupedModel) {
                        headBits = new RendererModel[]{(RendererModel)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, RendererModel.class)};
                    } else {
                        String name;
                        ArrayList<RendererModel> headPartsArrayList = new ArrayList<RendererModel>();
                        ArrayList purge = new ArrayList();
                        for (Field submodelArray : submodelArrays) {
                            RendererModel[] submodelArrayValue;
                            name = submodelArray.getName().toLowerCase();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler")) || (submodelArrayValue = (RendererModel[])submodelArray.get(model)) == null || submodelArrayValue.length < 0) continue;
                            headPartsArrayList.add(submodelArrayValue[0]);
                        }
                        for (Field submodel : submodels) {
                            name = submodel.getName().toLowerCase();
                            String nameS = submodel.getName();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler") | nameS.equals("REar") | nameS.equals("Trout")) || !(!nameS.equals("LeftSmallEar") & !nameS.equals("RightSmallEar") & !nameS.equals("BHead") & !nameS.equals("BSnout") & !nameS.equals("BMouth") & !nameS.equals("BMouthOpen") & !nameS.equals("BLEar") & !nameS.equals("BREar") & !nameS.equals("CHead") & !nameS.equals("CSnout") & !nameS.equals("CMouth") & !nameS.equals("CMouthOpen") & !nameS.equals("CLEar") & !nameS.equals("CREar")) || submodel.get(model) == null) continue;
                            headPartsArrayList.add((RendererModel)submodel.get(model));
                        }
                        if (headPartsArrayList.size() == 0) {
                            RendererModel[] submodelArrayValue;
                            if (submodels.size() > 0) {
                                if (submodels.get(0).get(model) != null) {
                                    headPartsArrayList.add((RendererModel)submodels.get(0).get(model));
                                }
                            } else if (submodelArrays.size() > 0 && submodelArrays.get(0).get(model) != null && (submodelArrayValue = (RendererModel[])submodelArrays.get(0).get(model)).length > 0) {
                                headPartsArrayList.add(submodelArrayValue[0]);
                            }
                        }
                        for (RendererModel bit : headPartsArrayList) {
                            if (bit.field_78805_m == null) continue;
                            purge.addAll(bit.field_78805_m);
                        }
                        headPartsArrayList.removeAll(purge);
                        headBits = headPartsArrayList.toArray(new RendererModel[headPartsArrayList.size()]);
                    }
                }
                for (int t = 0; t < headBits.length; ++t) {
                    void bit = headBits[t];
                    if (!this.hasCustomNPCs || !this.modelScaleRendererClass.isInstance(bit)) continue;
                    bit.field_78807_k = false;
                }
                if (contact.entity != null && model != null && headBits.length > 0 && resourceLocation != null) {
                    String scaleString = properties.getProperty("scale", "1");
                    float scale = Float.parseFloat(scaleString);
                    Direction facing = Direction.NORTH;
                    String facingString = properties.getProperty("facing", "front");
                    if (facingString.equals("top")) {
                        facing = Direction.UP;
                    } else if (facingString.equals("side")) {
                        facing = Direction.EAST;
                    }
                    boolean success = this.drawModel(scale, 1000, (LivingEntity)contact.entity, facing, model, resourceLocation, headBits);
                    if (success) {
                        headImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
                    }
                }
            }
            catch (Exception e) {
                headImage = null;
            }
        }
        return headImage;
    }

    private boolean drawModel(float scale, int captureDepth, LivingEntity par5EntityLivingBase, Direction facing, EntityModel model, ResourceLocation resourceLocation, RendererModel ... headBits) {
        boolean failed = false;
        float size = 32.0f * scale;
        GLShim.glBindTexture(3553, GLUtils.fboTextureID);
        int width = GLShim.glGetTexLevelParameteri(3553, 0, 4096);
        int height = GLShim.glGetTexLevelParameteri(3553, 0, 4097);
        GLShim.glBindTexture(3553, 0);
        GLShim.glPushAttrib(4096);
        GLShim.glViewport(0, 0, width, height);
        GLShim.glMatrixMode(5889);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glOrtho(0.0, width, height, 0.0, 1000.0, 3000.0);
        GLShim.glMatrixMode(5888);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glTranslatef(0.0f, 0.0f, -3000.0f + (float)captureDepth);
        GLUtils.bindFrameBuffer();
        GLShim.glDepthMask(true);
        GLShim.glEnable(2929);
        GLShim.glEnable(3553);
        GLShim.glEnable(3042);
        GLShim.glEnable(3008);
        GLShim.glEnable(2977);
        GLShim.glDisable(2884);
        GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GLShim.glClear(16640);
        GLShim.glBlendFunc(770, 771);
        GLShim.glPushMatrix();
        GLShim.glTranslatef(width / 2, height / 2, 0.0f);
        GLShim.glScalef(size, size, size);
        GLShim.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        GLUtils.img(resourceLocation);
        GLShim.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
        if (facing == Direction.EAST) {
            GLShim.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        } else if (facing == Direction.UP) {
            GLShim.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        }
        try {
            int t;
            GLShim.glTranslatef(500.0f, 500.0f, 0.0f);
            model.func_78088_a((Entity)par5EntityLivingBase, 0.0f, 0.0f, 163.0f, 360.0f, 0.0f, 0.0625f);
            GLShim.glTranslatef(-500.0f, -500.0f, 0.0f);
            float offsetByY = 0.0f;
            float maxY = 0.0f;
            float minY = 0.0f;
            for (t = 0; t < headBits.length; ++t) {
                if (headBits[t].field_78797_d < minY) {
                    minY = headBits[t].field_78797_d;
                }
                if (!(headBits[t].field_78797_d > maxY)) continue;
                maxY = headBits[t].field_78797_d;
            }
            if (minY < -25.0f) {
                offsetByY = -25.0f - minY;
            } else if (maxY > 25.0f) {
                offsetByY = 25.0f - maxY;
            }
            if (captureDepth == 2) {
                offsetByY = 4.0f;
            }
            for (t = 0; t < headBits.length; ++t) {
                float y = headBits[t].field_78797_d;
                headBits[t].field_78797_d += offsetByY;
                headBits[t].func_78785_a(0.0625f);
                headBits[t].field_78797_d = y;
            }
        }
        catch (Exception e) {
            failed = true;
        }
        GLShim.glPopMatrix();
        GLShim.glEnable(2884);
        GLShim.glDisable(2929);
        GLShim.glDepthMask(false);
        GLUtils.unbindFrameBuffer();
        GLShim.glMatrixMode(5889);
        GLShim.glPopMatrix();
        GLShim.glMatrixMode(5888);
        GLShim.glPopMatrix();
        GLShim.glPopAttrib();
        GLShim.glViewport(0, 0, this.game.field_195558_d.func_198109_k(), this.game.field_195558_d.func_198091_l());
        return !failed;
    }

    private void tryFallbackType(Contact contact) {
        contact.type = this.getContactType(contact.entity);
        if (contact.type == EnumMobs.UNKNOWN) {
            contact.type = this.getUnknownMobNeutrality(contact.entity);
        }
        String resourceLocationString = contact.type.resourceLocation != null ? contact.type.resourceLocation.toString() : "";
        resourceLocationString = resourceLocationString + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : "");
        String nameWithoutSize = contact.type.id + resourceLocationString;
        contact.icons = new Sprite[]{this.textureAtlas.getAtlasSprite(nameWithoutSize + "0"), this.textureAtlas.getAtlasSprite(nameWithoutSize + "1")};
    }

    private Sprite[] getIconsForRandomob(Contact contact) {
        String entityName;
        String nameMinusSize;
        Sprite icon;
        if (contact.type == EnumMobs.PLAYER && !contact.icons[0].getIconName().equals(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + "0")) {
            return contact.icons;
        }
        String color = "";
        ResourceLocation resourceLocation = null;
        EntityRenderer render = this.game.func_175598_ae().func_78713_a(contact.entity);
        resourceLocation = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity);
        String originalResourceLocationString = resourceLocation != null ? resourceLocation.toString() : "";
        resourceLocation = this.getRandomizedResourceLocationForEntity(resourceLocation, contact.entity);
        Object resourceLocationSecondary = null;
        if (contact.type.secondaryResourceLocation != null) {
            resourceLocationSecondary = contact.type == EnumMobs.MOOSHROOM ? (!((MooshroomEntity)contact.entity).func_70631_g_() ? EnumMobs.MOOSHROOM.secondaryResourceLocation : null) : contact.type.secondaryResourceLocation;
            originalResourceLocationString = originalResourceLocationString + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "");
            if (contact.type == EnumMobs.TROPICALFISHA || contact.type == EnumMobs.TROPICALFISHB) {
                TropicalFishEntity fish = (TropicalFishEntity)contact.entity;
                resourceLocationSecondary = fish.func_204220_dF();
                color = fish.func_204219_dC() + " " + fish.func_204222_dD();
            } else if (resourceLocationSecondary != null) {
                resourceLocationSecondary = this.getRandomizedResourceLocationForEntity((ResourceLocation)resourceLocationSecondary, (Entity)((LivingEntity)contact.entity));
            }
        }
        String resourceLocationString = (resourceLocation != null ? resourceLocation.toString() : "") + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "");
        if (contact.type != EnumMobs.AUTO) {
            String defaultResourceLocationString = contact.type.resourceLocation.toString();
            if (resourceLocationString.equals(defaultResourceLocationString = defaultResourceLocationString + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : ""))) {
                return contact.icons;
            }
        } else if (resourceLocationString.equals(originalResourceLocationString)) {
            return contact.icons;
        }
        if ((icon = this.textureAtlas.getAtlasSprite((nameMinusSize = (entityName = contact.type != EnumMobs.AUTO ? contact.type.id : contact.entity.getClass().getName()) + color + resourceLocationString) + "0")) == this.textureAtlas.getMissingImage()) {
            BufferedImage mobImage = null;
            if (contact.type == EnumMobs.HORSE) {
                ITextureObject textureObject = GLUtils.textureManager.func_110581_b(resourceLocation);
                if (textureObject != null) {
                    mobImage = ImageUtils.createBufferedImageFromGLID(textureObject.func_110552_b());
                    mobImage = this.createImageFromTypeAndImages(contact.type, mobImage, null, null);
                }
            } else if (contact.type != EnumMobs.AUTO) {
                mobImage = this.createImageFromTypeAndResourceLocations(contact.type, resourceLocation, (ResourceLocation)resourceLocationSecondary, contact.entity);
            } else if (contact.type == EnumMobs.AUTO) {
                mobImage = this.createAutoIconImageFromResourceLocation(contact, (EntityRenderer<? extends Entity>)render, resourceLocation);
            }
            if (mobImage == null) {
                return contact.icons;
            }
            BufferedImage[] trimmedImages = this.trimAndOutlineImages(contact.type, mobImage);
            Sprite icon0 = this.textureAtlas.registerIconForBufferedImage(nameMinusSize + "0", trimmedImages[0]);
            Sprite icon1 = this.textureAtlas.registerIconForBufferedImage(nameMinusSize + "1", trimmedImages[1]);
            this.newMobs = true;
            return new Sprite[]{icon0, icon1};
        }
        return new Sprite[]{icon, this.textureAtlas.getAtlasSprite(nameMinusSize + "1")};
    }

    private ResourceLocation getRandomizedResourceLocationForEntity(ResourceLocation resourceLocation, Entity entity) {
        try {
            Object randomEntitiesProperties;
            if (this.randomobsOptifine && (randomEntitiesProperties = this.mapProperties.get(resourceLocation.func_110623_a())) != null) {
                this.setEntityMethod.invoke(this.randomEntityClass.cast(this.randomEntity), entity);
                resourceLocation = (ResourceLocation)this.getEntityTextureMethod.invoke(this.randomEntitiesPropertiesClass.cast(randomEntitiesProperties), resourceLocation, this.randomEntityClass.cast(this.randomEntity));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resourceLocation;
    }

    private BufferedImage[] trimAndOutlineImages(EnumMobs type, BufferedImage image) {
        if (type == EnumMobs.AUTO) {
            image = ImageUtils.trim(image);
            double acceptableMax = 32.0;
            if (ImageUtils.percentageOfEdgePixelsThatAreSolid(image) < 30.0f) {
                acceptableMax = 64.0;
            }
            int maxDimension = Math.max(image.getWidth(), image.getHeight());
            float scale = (float)(1.0 / Math.ceil((double)maxDimension / acceptableMax));
            BufferedImage image0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, scale / 2.0f)), this.options.outlines);
            BufferedImage image1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, scale)), this.options.outlines);
            return new BufferedImage[]{image0, image1};
        }
        float scale = (float)image.getWidth() / (float)type.expectedWidth;
        BufferedImage image0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 1.0f / scale)), this.options.outlines);
        BufferedImage image1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 2.0f / scale)), this.options.outlines);
        return new BufferedImage[]{image0, image1};
    }

    private void handleMPplayer(Contact contact) {
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)contact.entity;
        GameProfile gameProfile = player.func_146103_bH();
        UUID uuid = gameProfile.getId();
        contact.setUUID(uuid);
        String playerName = this.scrubCodes(gameProfile.getName());
        Sprite icon0 = this.textureAtlas.getAtlasSprite(playerName + " 0");
        Sprite icon1 = null;
        Integer checkCount = 0;
        if (icon0 == this.textureAtlas.getMissingImage()) {
            checkCount = this.mpContactsSkinGetTries.get(playerName);
            if (checkCount == null) {
                checkCount = 0;
            }
            if (checkCount < 5) {
                DownloadingTexture imageData = null;
                try {
                    if (player.func_110306_p() == DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au())) {
                        throw new Exception("failed to get skin: skin is default");
                    }
                    imageData = AbstractClientPlayerEntity.func_110304_a((ResourceLocation)player.func_110306_p(), (String)player.func_200200_C_().getString());
                    if (imageData == null) {
                        throw new Exception("failed to get skin: image data was null");
                    }
                    BufferedImage skinImage = ImageUtils.createBufferedImageFromGLID(imageData.func_110552_b());
                    boolean showHat = player.func_175148_a(PlayerModelPart.HAT);
                    skinImage = showHat ? ImageUtils.addImages(ImageUtils.loadImage(skinImage, 8, 8, 8, 8), ImageUtils.loadImage(skinImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8) : ImageUtils.loadImage(skinImage, 8, 8, 8, 8);
                    float scale = (float)skinImage.getWidth() / 8.0f;
                    BufferedImage skinImageSmall = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(skinImage, 1.0f / scale)), this.options.outlines);
                    BufferedImage skinImageLarge = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(skinImage, 2.0f / scale)), this.options.outlines);
                    icon0 = this.textureAtlas.registerIconForBufferedImage(playerName + " 0", skinImageSmall);
                    icon1 = this.textureAtlas.registerIconForBufferedImage(playerName + " 1", skinImageLarge);
                    this.newMobs = true;
                    this.mpContactsSkinGetTries.remove(playerName);
                }
                catch (Exception e) {
                    icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + "0");
                    icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + "1");
                    Integer n = checkCount;
                    Integer n2 = checkCount = Integer.valueOf(checkCount + 1);
                    this.mpContactsSkinGetTries.put(playerName, checkCount);
                }
                contact.icons = new Sprite[]{icon0, icon1};
            }
        } else {
            contact.icons = new Sprite[]{icon0, this.textureAtlas.getAtlasSprite(playerName + " 1")};
        }
    }

    private void getArmor(Contact contact, Entity entity) {
        Sprite icon0 = null;
        Sprite icon1 = null;
        ItemStack stack = ((LivingEntity)entity).func_184582_a(EquipmentSlotType.HEAD);
        Item helmet = null;
        if (stack != null) {
            helmet = stack.func_77973_b();
        }
        if (contact.type == EnumMobs.SHEEP) {
            SheepEntity sheepEntity = (SheepEntity)contact.entity;
            if (!sheepEntity.func_70892_o()) {
                icon0 = this.textureAtlas.getAtlasSprite("sheepfur0");
                icon1 = this.textureAtlas.getAtlasSprite("sheepfur1");
                float[] sheepColors = SheepEntity.func_175513_a((DyeColor)sheepEntity.func_175509_cj());
                contact.setArmorColor((int)(sheepColors[0] * 255.0f) << 16 | (int)(sheepColors[1] * 255.0f) << 8 | (int)(sheepColors[2] * 255.0f));
            }
        } else if (helmet != null) {
            if (helmet == Items.field_196182_dv) {
                icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.SKELETON.id + EnumMobs.SKELETON.resourceLocation.toString() + 0);
                icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.SKELETON.id + EnumMobs.SKELETON.resourceLocation.toString() + 1);
                contact.icons = new Sprite[]{icon0, icon1};
                icon0 = null;
                icon1 = null;
            } else if (helmet == Items.field_196183_dw) {
                icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.SKELETONWITHER.id + EnumMobs.SKELETONWITHER.resourceLocation.toString() + 0);
                icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.SKELETONWITHER.id + EnumMobs.SKELETONWITHER.resourceLocation.toString() + 1);
                contact.icons = new Sprite[]{icon0, icon1};
                icon0 = null;
                icon1 = null;
            } else if (helmet == Items.field_196186_dz) {
                icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.ZOMBIE.id + EnumMobs.ZOMBIE.resourceLocation.toString() + 0);
                icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.ZOMBIE.id + EnumMobs.ZOMBIE.resourceLocation.toString() + 1);
                contact.icons = new Sprite[]{icon0, icon1};
                icon0 = null;
                icon1 = null;
            } else if (helmet == Items.field_196184_dx) {
                GameProfile gameProfile = null;
                if (stack.func_77942_o()) {
                    String name;
                    CompoundNBT nbttagcompound = stack.func_77978_p();
                    if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                        gameProfile = NBTUtil.func_152459_a((CompoundNBT)nbttagcompound.func_74775_l("SkullOwner"));
                    } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && (name = nbttagcompound.func_74779_i("SkullOwner")) != null && !name.equals("")) {
                        gameProfile = SkullTileEntity.func_174884_b((GameProfile)new GameProfile((UUID)null, name));
                        nbttagcompound.func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)gameProfile));
                    }
                }
                if (gameProfile != null) {
                    ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
                    Minecraft minecraft = Minecraft.func_71410_x();
                    Map map = minecraft.func_152342_ad().func_152788_a(gameProfile);
                    if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                        resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                    }
                    if (resourcelocation != null) {
                        BufferedImage image;
                        ITextureObject textureObject;
                        icon0 = this.textureAtlas.getAtlasSpriteIncludingYetToBeStitched(EnumMobs.PLAYER.id + resourcelocation.toString() + "0");
                        icon1 = this.textureAtlas.getAtlasSpriteIncludingYetToBeStitched(EnumMobs.PLAYER.id + resourcelocation.toString() + "1");
                        if (icon0 == this.textureAtlas.getMissingImage() && (textureObject = GLUtils.textureManager.func_110581_b(resourcelocation)) != null && (image = ImageUtils.createBufferedImageFromGLID(textureObject.func_110552_b())) != null) {
                            image = this.createImageFromTypeAndImages(EnumMobs.PLAYER, image, null, null);
                            BufferedImage[] trimmedImages = this.trimAndOutlineImages(contact.type, image);
                            icon0 = this.textureAtlas.registerIconForBufferedImage(EnumMobs.PLAYER.id + resourcelocation.toString() + "0", trimmedImages[0]);
                            icon1 = this.textureAtlas.registerIconForBufferedImage(EnumMobs.PLAYER.id + resourcelocation.toString() + "1", trimmedImages[1]);
                            this.newMobs = true;
                        }
                    }
                }
                if (icon0 == null || icon1 == null) {
                    icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + 0);
                    icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString() + 1);
                }
                contact.icons = new Sprite[]{icon0, icon1};
                icon0 = null;
                icon1 = null;
            } else if (helmet == Items.field_196185_dy) {
                icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.CREEPER.id + EnumMobs.CREEPER.resourceLocation.toString() + 0);
                icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.CREEPER.id + EnumMobs.CREEPER.resourceLocation.toString() + 1);
                contact.icons = new Sprite[]{icon0, icon1};
                icon0 = null;
                icon1 = null;
            } else if (helmet == Items.field_196151_dA) {
                icon0 = this.textureAtlas.getAtlasSprite(EnumMobs.ENDERDRAGON.id + EnumMobs.ENDERDRAGON.resourceLocation.toString() + 0);
                icon1 = this.textureAtlas.getAtlasSprite(EnumMobs.ENDERDRAGON.id + EnumMobs.ENDERDRAGON.resourceLocation.toString() + 1);
                contact.icons = new Sprite[]{icon0, icon1};
                icon0 = null;
                icon1 = null;
            } else if (helmet instanceof ArmorItem) {
                ArmorItem helmetArmor = (ArmorItem)helmet;
                int armorType = this.getArmorType(helmetArmor);
                if (armorType == UNKNOWN) {
                    icon0 = this.textureAtlas.getAtlasSprite("armor " + helmet.func_77658_a() + " 0");
                    icon1 = this.textureAtlas.getAtlasSprite("armor " + helmet.func_77658_a() + " 1");
                    if (icon0 == this.textureAtlas.getMissingImage()) {
                        Sprite[] newIcons = this.createUnknownArmorIcons(contact, stack, helmet);
                        icon0 = newIcons[0];
                        icon1 = newIcons[1];
                    } else if (icon0 == this.textureAtlas.getFailedImage()) {
                        icon0 = null;
                        icon1 = null;
                    }
                } else {
                    icon0 = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[armorType] + " 0");
                    icon1 = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[armorType] + " 1");
                }
                if (helmetArmor instanceof DyeableArmorItem) {
                    contact.setArmorColor(((DyeableArmorItem)helmetArmor).func_200886_f(stack));
                }
            } else if (helmet instanceof BlockItem) {
                BufferedImage blockImage;
                Block block = ((BlockItem)helmet).func_179223_d();
                BlockState blockState = block.func_176223_P();
                int stateID = Block.func_196246_j((BlockState)blockState);
                icon0 = this.textureAtlas.getAtlasSprite("blockArmor " + stateID + " 0");
                icon1 = this.textureAtlas.getAtlasSprite("blockArmor " + stateID + " 1");
                if (icon0 == this.textureAtlas.getMissingImage() && (blockImage = this.master.getColorManager().getBlockImage(blockState, stack, entity.field_70170_p)) != null) {
                    BufferedImage largeImage = ImageUtils.fillOutline(ImageUtils.pad(blockImage), this.options.outlines, true, 16, 0);
                    BufferedImage smallImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(blockImage, 0.5f)), this.options.outlines, true, 8, 0);
                    icon0 = this.textureAtlas.registerIconForBufferedImage("blockArmor " + stateID + " 0", smallImage);
                    icon1 = this.textureAtlas.registerIconForBufferedImage("blockArmor " + stateID + " 1", largeImage);
                    this.newMobs = true;
                }
            }
        }
        contact.armorIcons = new Sprite[]{icon0, icon1};
    }

    private Sprite[] createUnknownArmorIcons(Contact contact, ItemStack stack, Item helmet) {
        BufferedImage armorTexture;
        Sprite icon0 = null;
        Sprite icon1 = null;
        Method m = null;
        try {
            Class<?> c = Class.forName("net.minecraftforge.client.ForgeHooksClient");
            m = c.getMethod("getArmorTexture", Entity.class, ItemStack.class, String.class, EquipmentSlotType.class, String.class);
        }
        catch (Exception c) {
            // empty catch block
        }
        Method getResourceLocation = m;
        ResourceLocation resourceLocation = null;
        try {
            String texture = ((ArmorItem)helmet).func_200880_d().func_200897_d();
            String domain = "minecraft";
            int sep = texture.indexOf(58);
            if (sep != -1) {
                domain = texture.substring(0, sep);
                texture = texture.substring(sep + 1);
            }
            String resourcePath = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, "");
            if (getResourceLocation != null) {
                resourcePath = (String)getResourceLocation.invoke(null, contact.entity, stack, resourcePath, EquipmentSlotType.HEAD, null);
            }
            resourceLocation = new ResourceLocation(resourcePath);
        }
        catch (Exception texture) {
            // empty catch block
        }
        m = null;
        try {
            Class<?> c = Class.forName("net.minecraftforge.client.ForgeHooksClient");
            m = c.getMethod("getArmorModel", LivingEntity.class, ItemStack.class, EquipmentSlotType.class, BipedModel.class);
        }
        catch (Exception c) {
            // empty catch block
        }
        Method getModel = m;
        BipedModel modelBiped = null;
        try {
            if (getModel != null) {
                modelBiped = (BipedModel)getModel.invoke(null, contact.entity, stack, EquipmentSlotType.HEAD, null);
            }
        }
        catch (Exception sep) {
            // empty catch block
        }
        if (modelBiped != null && resourceLocation != null && GLUtils.fboEnabled) {
            RendererModel[] headBits = new RendererModel[]{modelBiped.field_78116_c, modelBiped.field_178720_f};
            this.drawModel(0.888888f, 2, (LivingEntity)contact.entity, Direction.NORTH, (EntityModel)modelBiped, resourceLocation, headBits);
            armorTexture = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
            armorTexture = armorTexture.getSubimage(100, 100, 56, 56);
            float scale = 2.0f;
            BufferedImage armorImage0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 1.0f / scale)), this.options.outlines, true, 8, 0);
            BufferedImage armorImage1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 2.0f / scale)), this.options.outlines, true, 16, 0);
            icon0 = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a() + " 0", armorImage0);
            icon1 = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a() + " 1", armorImage1);
            this.newMobs = true;
        } else if (resourceLocation != null) {
            try {
                InputStream is = null;
                try {
                    is = this.game.func_195551_G().func_199002_a(resourceLocation).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
                if (is != null) {
                    armorTexture = ImageIO.read(is);
                    is.close();
                    armorTexture = ImageUtils.addImages(ImageUtils.loadImage(armorTexture, 8, 8, 8, 8), ImageUtils.loadImage(armorTexture, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                    float scale = (float)armorTexture.getWidth() / 8.0f;
                    BufferedImage armorImage0 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 1.0f / scale)), this.options.outlines, true, 8, 0);
                    BufferedImage armorImage1 = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 2.0f / scale)), this.options.outlines, true, 16, 0);
                    icon0 = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a() + " 0", armorImage0);
                    icon1 = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a() + " 1", armorImage1);
                    this.newMobs = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (icon0 == null || icon1 == null) {
            System.out.println("can't get texture for custom armor type: " + helmet.getClass());
            this.textureAtlas.registerFailedIcon("armor " + helmet.func_77658_a() + " 0");
        }
        return new Sprite[]{icon0, icon1};
    }

    private String scrubCodes(String string) {
        string = string.replaceAll("(\\xA7.)", "");
        return string;
    }

    private EnumMobs getContactTypeStrict(Entity entity) {
        Class<?> entityClass = entity.getClass();
        if (entityClass.equals(BatEntity.class)) {
            return EnumMobs.BAT;
        }
        if (entityClass.equals(BlazeEntity.class)) {
            return EnumMobs.BLAZE;
        }
        if (entityClass.equals(CatEntity.class)) {
            return EnumMobs.CAT;
        }
        if (entityClass.equals(CaveSpiderEntity.class)) {
            return EnumMobs.CAVESPIDER;
        }
        if (entityClass.equals(ChickenEntity.class)) {
            return EnumMobs.CHICKEN;
        }
        if (entityClass.equals(MooshroomEntity.class)) {
            return EnumMobs.MOOSHROOM;
        }
        if (entityClass.equals(CodEntity.class)) {
            return EnumMobs.COD;
        }
        if (entityClass.equals(CowEntity.class)) {
            return EnumMobs.COW;
        }
        if (entityClass.equals(CreeperEntity.class)) {
            return EnumMobs.CREEPER;
        }
        if (entityClass.equals(DolphinEntity.class)) {
            return EnumMobs.DOLPHIN;
        }
        if (entityClass.equals(DrownedEntity.class)) {
            return EnumMobs.DROWNED;
        }
        if (entityClass.equals(EnderDragonEntity.class)) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entityClass.equals(EndermanEntity.class)) {
            return EnumMobs.ENDERMAN;
        }
        if (entityClass.equals(EndermiteEntity.class)) {
            return EnumMobs.ENDERMITE;
        }
        if (entityClass.equals(EvokerEntity.class)) {
            return EnumMobs.EVOKER;
        }
        if (entityClass.equals(GhastEntity.class)) {
            return EnumMobs.GHAST;
        }
        if (entityClass.equals(GuardianEntity.class)) {
            return EnumMobs.GUARDIAN;
        }
        if (entityClass.equals(ElderGuardianEntity.class)) {
            return EnumMobs.GUARDIANELDER;
        }
        if (entityClass.equals(HorseEntity.class) || entityClass.equals(DonkeyEntity.class) || entityClass.equals(MuleEntity.class) || entityClass.equals(SkeletonHorseEntity.class) || entityClass.equals(ZombieHorseEntity.class)) {
            return EnumMobs.HORSE;
        }
        if (entityClass.equals(HuskEntity.class)) {
            return EnumMobs.HUSK;
        }
        if (entityClass.equals(LlamaEntity.class)) {
            return EnumMobs.LLAMA;
        }
        if (entityClass.equals(TraderLlamaEntity.class)) {
            return EnumMobs.LLAMATRADER;
        }
        if (entityClass.equals(IronGolemEntity.class)) {
            return EnumMobs.IRONGOLEM;
        }
        if (entityClass.equals(MagmaCubeEntity.class)) {
            return EnumMobs.MAGMA;
        }
        if (entityClass.equals(OcelotEntity.class)) {
            return EnumMobs.OCELOT;
        }
        if (entityClass.equals(ParrotEntity.class)) {
            return EnumMobs.PARROT;
        }
        if (entityClass.equals(PhantomEntity.class)) {
            return EnumMobs.PHANTOM;
        }
        if (entityClass.equals(PigEntity.class)) {
            return EnumMobs.PIG;
        }
        if (entityClass.equals(ZombiePigmanEntity.class)) {
            return EnumMobs.PIGZOMBIE;
        }
        if (entity instanceof RemoteClientPlayerEntity) {
            return EnumMobs.PLAYER;
        }
        if (entityClass.equals(PolarBearEntity.class)) {
            return EnumMobs.POLARBEAR;
        }
        if (entityClass.equals(PufferfishEntity.class)) {
            return EnumMobs.PUFFERFISH;
        }
        if (entityClass.equals(RabbitEntity.class)) {
            return EnumMobs.RABBIT;
        }
        if (entityClass.equals(SalmonEntity.class)) {
            return EnumMobs.SALMON;
        }
        if (entityClass.equals(SheepEntity.class)) {
            return EnumMobs.SHEEP;
        }
        if (entityClass.equals(ShulkerEntity.class)) {
            return EnumMobs.SHULKER;
        }
        if (entityClass.equals(SilverfishEntity.class)) {
            return EnumMobs.SILVERFISH;
        }
        if (entityClass.equals(SkeletonEntity.class)) {
            return EnumMobs.SKELETON;
        }
        if (entityClass.equals(WitherSkeletonEntity.class)) {
            return EnumMobs.SKELETONWITHER;
        }
        if (entityClass.equals(SlimeEntity.class)) {
            return EnumMobs.SLIME;
        }
        if (entityClass.equals(SnowGolemEntity.class)) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entityClass.equals(SpiderEntity.class)) {
            return EnumMobs.SPIDER;
        }
        if (entityClass.equals(SquidEntity.class)) {
            return EnumMobs.SQUID;
        }
        if (entityClass.equals(TropicalFishEntity.class)) {
            if (((TropicalFishEntity)entity).func_204217_dE() == 0) {
                return EnumMobs.TROPICALFISHA;
            }
            return EnumMobs.TROPICALFISHB;
        }
        if (entityClass.equals(StrayEntity.class)) {
            return EnumMobs.STRAY;
        }
        if (entityClass.equals(TurtleEntity.class)) {
            return EnumMobs.TURTLE;
        }
        if (entityClass.equals(VexEntity.class)) {
            return EnumMobs.VEX;
        }
        if (entityClass.equals(VillagerEntity.class)) {
            return EnumMobs.VILLAGER;
        }
        if (entityClass.equals(VindicatorEntity.class)) {
            return EnumMobs.VINDICATOR;
        }
        if (entityClass.equals(WitchEntity.class)) {
            return EnumMobs.WITCH;
        }
        if (entityClass.equals(WitherEntity.class)) {
            return EnumMobs.WITHER;
        }
        if (entityClass.equals(WolfEntity.class)) {
            boolean tamed = ((WolfEntity)entity).func_70909_n();
            boolean angry = ((WolfEntity)entity).func_70919_bu();
            return tamed ? EnumMobs.WOLFTAME : (angry ? EnumMobs.WOLFANGRY : EnumMobs.WOLF);
        }
        if (entityClass.equals(ZombieEntity.class)) {
            return EnumMobs.ZOMBIE;
        }
        if (entityClass.equals(ZombieVillagerEntity.class)) {
            return EnumMobs.ZOMBIEVILLAGER;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getContactType(Entity entity) {
        if (entity instanceof BatEntity) {
            return EnumMobs.BAT;
        }
        if (entity instanceof BlazeEntity) {
            return EnumMobs.BLAZE;
        }
        if (entity instanceof CatEntity) {
            return EnumMobs.CAT;
        }
        if (entity instanceof CaveSpiderEntity) {
            return EnumMobs.CAVESPIDER;
        }
        if (entity instanceof ChickenEntity) {
            return EnumMobs.CHICKEN;
        }
        if (entity instanceof MooshroomEntity) {
            return EnumMobs.MOOSHROOM;
        }
        if (entity instanceof CowEntity) {
            return EnumMobs.COW;
        }
        if (entity instanceof CreeperEntity) {
            return EnumMobs.CREEPER;
        }
        if (entity instanceof DolphinEntity) {
            return EnumMobs.DOLPHIN;
        }
        if (entity instanceof EnderDragonEntity) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entity instanceof EndermanEntity) {
            return EnumMobs.ENDERMAN;
        }
        if (entity instanceof EndermiteEntity) {
            return EnumMobs.ENDERMITE;
        }
        if (entity instanceof EvokerEntity) {
            return EnumMobs.EVOKER;
        }
        if (entity instanceof GhastEntity) {
            return EnumMobs.GHAST;
        }
        if (entity instanceof ElderGuardianEntity) {
            return EnumMobs.GUARDIANELDER;
        }
        if (entity instanceof GuardianEntity) {
            return EnumMobs.GUARDIAN;
        }
        if (entity instanceof TraderLlamaEntity) {
            return EnumMobs.LLAMATRADER;
        }
        if (entity instanceof LlamaEntity) {
            return EnumMobs.LLAMA;
        }
        if (entity instanceof AbstractHorseEntity) {
            return EnumMobs.HORSE;
        }
        if (entity instanceof IronGolemEntity) {
            return EnumMobs.IRONGOLEM;
        }
        if (entity instanceof MagmaCubeEntity) {
            return EnumMobs.MAGMA;
        }
        if (entity instanceof OcelotEntity) {
            return EnumMobs.OCELOT;
        }
        if (entity instanceof ParrotEntity) {
            return EnumMobs.PARROT;
        }
        if (entity instanceof PhantomEntity) {
            return EnumMobs.PHANTOM;
        }
        if (entity instanceof PigEntity) {
            return EnumMobs.PIG;
        }
        if (entity instanceof ZombiePigmanEntity) {
            return EnumMobs.PIGZOMBIE;
        }
        if (entity instanceof RemoteClientPlayerEntity) {
            return EnumMobs.PLAYER;
        }
        if (entity instanceof PolarBearEntity) {
            return EnumMobs.POLARBEAR;
        }
        if (entity instanceof PufferfishEntity) {
            return EnumMobs.PUFFERFISH;
        }
        if (entity instanceof RabbitEntity) {
            return EnumMobs.RABBIT;
        }
        if (entity instanceof SheepEntity) {
            return EnumMobs.SHEEP;
        }
        if (entity instanceof ShulkerEntity) {
            return EnumMobs.SHULKER;
        }
        if (entity instanceof SilverfishEntity) {
            return EnumMobs.SILVERFISH;
        }
        if (entity instanceof AbstractSkeletonEntity) {
            return EnumMobs.SKELETON;
        }
        if (entity instanceof SlimeEntity) {
            return EnumMobs.SLIME;
        }
        if (entity instanceof SnowGolemEntity) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entity instanceof SpiderEntity) {
            return EnumMobs.SPIDER;
        }
        if (entity instanceof SquidEntity) {
            return EnumMobs.SQUID;
        }
        if (entity instanceof VexEntity) {
            return EnumMobs.VEX;
        }
        if (entity instanceof VillagerEntity) {
            return EnumMobs.VILLAGER;
        }
        if (entity instanceof VindicatorEntity) {
            return EnumMobs.VINDICATOR;
        }
        if (entity instanceof WitchEntity) {
            return EnumMobs.WITCH;
        }
        if (entity instanceof WitherEntity) {
            return EnumMobs.WITHER;
        }
        if (entity instanceof WolfEntity) {
            boolean tamed = ((WolfEntity)entity).func_70909_n();
            boolean angry = ((WolfEntity)entity).func_70919_bu();
            return tamed ? EnumMobs.WOLFTAME : (angry ? EnumMobs.WOLFANGRY : EnumMobs.WOLF);
        }
        if (entity instanceof ZombieVillagerEntity) {
            return EnumMobs.ZOMBIEVILLAGER;
        }
        if (entity instanceof ZombieEntity) {
            return EnumMobs.ZOMBIE;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getUnknownMobNeutrality(Entity entity) {
        if (this.isHostile(entity)) {
            return EnumMobs.GENERICHOSTILE;
        }
        if (entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n() && (this.game.func_71356_B() || ((TameableEntity)entity).func_70902_q().equals((Object)this.game.field_71439_g))) {
            return EnumMobs.GENERICTAME;
        }
        return EnumMobs.GENERICNEUTRAL;
    }

    private int getArmorType(ArmorItem helmet) {
        if (helmet.func_77658_a().equals("item.minecraft.leather_helmet")) {
            return 0;
        }
        if (helmet.func_77658_a().equals("item.minecraft.chainmail_helmet")) {
            return 4;
        }
        if (helmet.func_77658_a().equals("item.minecraft.iron_helmet")) {
            return 5;
        }
        if (helmet.func_77658_a().equals("item.minecraft.golden_helmet")) {
            return 6;
        }
        if (helmet.func_77658_a().equals("item.minecraft.diamond_helmet")) {
            return 7;
        }
        if (helmet.func_77658_a().equals("item.minecraft.turtle_helmet")) {
            return 8;
        }
        return UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(int x, int y, int guiScale) {
        double max = this.layoutVariables.zoomScaleAdjusted * 32.0;
        GLUtils.disp(this.textureAtlas.func_110552_b());
        for (Contact contact : this.contacts) {
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            int contactY = contact.y;
            double wayX = GameVariableAccessShim.xCoordDouble() - contactX;
            double wayZ = GameVariableAccessShim.zCoordDouble() - contactZ;
            int wayY = GameVariableAccessShim.yCoord() - contactY;
            double adjustedDiff = max - (double)Math.max(Math.abs(wayY) - 0, 0);
            contact.brightness = (float)Math.max(adjustedDiff / max, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / this.layoutVariables.zoomScaleAdjusted;
            GLShim.glBlendFunc(770, 771);
            if (wayY < 0) {
                GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
            } else {
                GLShim.glColor3f(1.0f * contact.brightness, 1.0f * contact.brightness, 1.0f * contact.brightness);
            }
            if (this.minimapOptions.rotates) {
                contact.angle += this.direction;
            } else if (this.minimapOptions.oldNorth) {
                contact.angle -= 90.0f;
            }
            boolean inRange = false;
            if (this.minimapOptions.squareMap) {
                double radLocate = Math.toRadians(contact.angle);
                double dispX = contact.distance * Math.cos(radLocate);
                double dispY = contact.distance * Math.sin(radLocate);
                inRange = Math.abs(dispX) <= 28.5 && Math.abs(dispY) <= 28.5;
            } else {
                boolean bl = inRange = contact.distance < 31.0;
            }
            if (!inRange) continue;
            try {
                Sprite icon;
                GLShim.glPushMatrix();
                if (this.options.filtering) {
                    GLShim.glTranslatef(x, y, 0.0f);
                    GLShim.glRotatef(-contact.angle, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslated(0.0, -contact.distance, 0.0);
                    GLShim.glRotatef(contact.angle + (float)contact.rotationFactor, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslatef(-x, -y, 0.0f);
                } else {
                    wayX = Math.sin(Math.toRadians(contact.angle)) * contact.distance;
                    wayZ = Math.cos(Math.toRadians(contact.angle)) * contact.distance;
                    if (this.options.filtering) {
                        GLShim.glTranslated(-wayX, -wayZ, 0.0);
                    } else {
                        GLShim.glTranslated((double)Math.round(-wayX * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, (double)Math.round(-wayZ * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, 0.0);
                    }
                }
                float yOffset = 0.0f;
                if (contact.entity.func_184187_bx() != null) {
                    yOffset = -4.0f;
                }
                if (contact.uuid != null && contact.uuid.equals(this.devUUID)) {
                    icon = this.textureAtlas.getAtlasSprite("glow");
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset, (int)((float)icon.getIconWidth() / 2.0f));
                    GLUtils.drawPost();
                }
                if (contact.type == EnumMobs.GHAST || contact.type == EnumMobs.GHASTATTACKING || contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE || contact.type == EnumMobs.VEX || contact.type == EnumMobs.VEXCHARGING || contact.type == EnumMobs.PUFFERFISH || contact.type == EnumMobs.PUFFERFISHHALF || contact.type == EnumMobs.PUFFERFISHFULL) {
                    EntityRenderer render;
                    if (contact.type == EnumMobs.GHAST || contact.type == EnumMobs.GHASTATTACKING) {
                        render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity).func_110623_a();
                        contact.type = path.endsWith("ghast_fire.png") ? EnumMobs.GHASTATTACKING : EnumMobs.GHAST;
                    } else if (contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE) {
                        render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity).func_110623_a();
                        contact.type = path.endsWith("wither_invulnerable.png") ? EnumMobs.WITHERINVULNERABLE : EnumMobs.WITHER;
                    } else if (contact.type == EnumMobs.VEX || contact.type == EnumMobs.VEXCHARGING) {
                        render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity).func_110623_a();
                        contact.type = path.endsWith("vex_charging.png") ? EnumMobs.VEXCHARGING : EnumMobs.VEX;
                    } else if (contact.type == EnumMobs.PUFFERFISH || contact.type == EnumMobs.PUFFERFISHHALF || contact.type == EnumMobs.PUFFERFISHFULL) {
                        int size = ((PufferfishEntity)contact.entity).func_203715_dA();
                        switch (size) {
                            case 0: {
                                contact.type = EnumMobs.PUFFERFISH;
                                break;
                            }
                            case 1: {
                                contact.type = EnumMobs.PUFFERFISHHALF;
                                break;
                            }
                            case 2: {
                                contact.type = EnumMobs.PUFFERFISHFULL;
                            }
                        }
                    }
                    String resourceLocationString = contact.type.resourceLocation != null ? contact.type.resourceLocation.toString() : "";
                    String nameWithoutSize = contact.type.id + resourceLocationString;
                    contact.icons = new Sprite[]{this.textureAtlas.getAtlasSprite(nameWithoutSize + "0"), this.textureAtlas.getAtlasSprite(nameWithoutSize + "1")};
                    if (!this.builtInCustom[contact.type.ordinal()] && this.options.randomobs) {
                        contact.icons = this.getIconsForRandomob(contact);
                        if (this.newMobs) {
                            this.textureAtlas.stitchNew();
                        }
                        this.newMobs = false;
                    }
                }
                this.applyFilteringParameters();
                GLUtils.drawPre();
                GLUtils.setMap(contact.icons[guiScale], x, (float)y + yOffset, (int)((float)contact.icons[guiScale].getIconWidth() / (float)(guiScale + 1)));
                GLUtils.drawPost();
                if ((this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER || contact.type == EnumMobs.SHEEP) && contact.armorIcons[guiScale] != null) {
                    icon = contact.armorIcons[guiScale];
                    float armorOffset = 0.0f;
                    if (contact.type == EnumMobs.ZOMBIEVILLAGER) {
                        armorOffset = -0.5f;
                    }
                    float armorScale = 1.25f;
                    float red = 1.0f;
                    float green = 1.0f;
                    float blue = 1.0f;
                    if (contact.armorColor != -1) {
                        red = (float)(contact.armorColor >> 16 & 0xFF) / 255.0f;
                        green = (float)(contact.armorColor >> 8 & 0xFF) / 255.0f;
                        blue = (float)(contact.armorColor >> 0 & 0xFF) / 255.0f;
                        if (contact.type == EnumMobs.SHEEP) {
                            armorScale = 0.525f;
                            SheepEntity sheepEntity = (SheepEntity)contact.entity;
                            if (sheepEntity.func_145818_k_() && "jeb_".equals(sheepEntity.func_200200_C_().func_150261_e())) {
                                int semiRandom = sheepEntity.field_70173_aa / 25 + sheepEntity.func_145782_y();
                                int numDyeColors = DyeColor.values().length;
                                int colorID1 = semiRandom % numDyeColors;
                                int colorID2 = (semiRandom + 1) % numDyeColors;
                                float lerpVal = ((float)(sheepEntity.field_70173_aa % 25) + this.game.func_184121_ak()) / 25.0f;
                                float[] sheepColors1 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)colorID1));
                                float[] sheepColors2 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)colorID2));
                                red = sheepColors1[0] * (1.0f - lerpVal) + sheepColors2[0] * lerpVal;
                                green = sheepColors1[1] * (1.0f - lerpVal) + sheepColors2[1] * lerpVal;
                                blue = sheepColors1[2] * (1.0f - lerpVal) + sheepColors2[2] * lerpVal;
                            }
                        }
                        if (wayY < 0) {
                            GLShim.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            GLShim.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                    }
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (float)icon.getIconWidth() / (float)(guiScale + 1) * armorScale);
                    GLUtils.drawPost();
                    if (icon == this.clothIcons[guiScale]) {
                        if (wayY < 0) {
                            GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
                        } else {
                            GLShim.glColor3f(1.0f * contact.brightness, 1.0f * contact.brightness, 1.0f * contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[2] + " " + guiScale);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / (float)(guiScale + 1) * armorScale));
                        GLUtils.drawPost();
                        if (wayY < 0) {
                            GLShim.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            GLShim.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[1] + " " + guiScale);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / (float)(guiScale + 1) * armorScale));
                        GLUtils.drawPost();
                        GLShim.glColor3f(1.0f, 1.0f, 1.0f);
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[3] + " " + guiScale);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / (float)(guiScale + 1) * armorScale));
                        GLUtils.drawPost();
                    }
                } else if (contact.uuid != null && contact.uuid.equals(this.devUUID)) {
                    icon = this.textureAtlas.getAtlasSprite("crown" + guiScale);
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset, (int)((float)icon.getIconWidth() / (float)(guiScale + 1)));
                    GLUtils.drawPost();
                }
                if (!this.options.showPlayerNames || contact.type != EnumMobs.PLAYER) continue;
                float scaleFactor = (float)this.layoutVariables.scScale / this.options.fontScale;
                GLShim.glScalef(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
                int m = this.chkLen(contact.name) / 2;
                this.write(contact.name, (float)x * scaleFactor - (float)m, (float)(y + 3) * scaleFactor, 0xFFFFFF);
            }
            catch (Exception localException) {
                System.err.println("Error rendering mob icon! " + localException.getLocalizedMessage() + " contact type " + (Object)((Object)contact.type));
            }
            finally {
                GLShim.glPopMatrix();
            }
        }
    }

    private void applyFilteringParameters() {
        if (this.options.filtering) {
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTexParameteri(3553, 10242, 10496);
            GLShim.glTexParameteri(3553, 10243, 10496);
        } else {
            GLShim.glTexParameteri(3553, 10241, 9728);
            GLShim.glTexParameteri(3553, 10240, 9728);
        }
    }

    private boolean isHostile(Entity entity) {
        if (entity instanceof ZombiePigmanEntity) {
            return ((ZombiePigmanEntity)entity).func_191990_c((PlayerEntity)this.game.field_71439_g);
        }
        if (entity instanceof IMob) {
            return true;
        }
        if (entity instanceof PolarBearEntity) {
            for (Object object : ((PolarBearEntity)entity).field_70170_p.func_217357_a(PolarBearEntity.class, ((PolarBearEntity)entity).func_174813_aQ().func_72321_a(8.0, 4.0, 8.0))) {
                if (!((PolarBearEntity)object).func_70631_g_()) continue;
                return true;
            }
        }
        if (entity instanceof RabbitEntity) {
            return ((RabbitEntity)entity).func_175531_cl() == 99;
        }
        if (entity instanceof WolfEntity) {
            return ((WolfEntity)entity).func_70919_bu();
        }
        return false;
    }

    private boolean isPlayer(Entity entity) {
        return entity instanceof RemoteClientPlayerEntity;
    }

    private boolean isNeutral(Entity entity) {
        if (entity instanceof LivingEntity) {
            return !(entity instanceof PlayerEntity) && !this.isHostile(entity);
        }
        return false;
    }
}

