/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.forgemod;

import com.mamiyaotaru.voxelmap.forgemod.ClientProxy;
import com.mamiyaotaru.voxelmap.forgemod.IProxy;
import com.mamiyaotaru.voxelmap.forgemod.ServerProxy;
import com.mamiyaotaru.voxelmap.forgemod.WorldIDPacket;
import com.mamiyaotaru.voxelmap.forgemod.WorldInfoPacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="voxelmap")
public class ForgeModVoxelMap {
    public static final String MODID = "voxelmap";
    private boolean hasFullRadarPermission = true;
    private boolean hasPlayersOnRadarPermission = true;
    private boolean hasMobsOnRadarPermission = true;
    private boolean hasCavemodePermission = true;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static SimpleChannel WORLD_ID;
    public static SimpleChannel WORLD_INFO;
    public static ForgeModVoxelMap instance;
    public static IProxy proxy;

    public ForgeModVoxelMap() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::preInit);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::init);
    }

    public void preInit(FMLCommonSetupEvent event) {
        WORLD_ID = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("worldinfo", "world_id"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION -> true, PROTOCOL_VERSION -> true);
        WORLD_ID.registerMessage(0, WorldIDPacket.class, WorldIDPacket::encode, WorldIDPacket::decode, WorldIDHandler::handle);
    }

    public void init(final FMLClientSetupEvent event) {
        instance = this;
        Minecraft.func_71410_x().execute(new Runnable(){

            @Override
            public void run() {
                proxy.postInit(event);
            }
        });
    }

    static {
        proxy = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    }

    public static class WorldInfoHandler {
        public static void handle(WorldInfoPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> proxy.newWorldName(packet.getWorldID()));
            ctx.get().setPacketHandled(true);
        }
    }

    public static class WorldIDHandler {
        public static void handle(WorldIDPacket packet, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> proxy.newWorldName(packet.getWorldID()));
            ctx.get().setPacketHandled(true);
        }
    }
}

