/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiWaypoints;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiSlotMinimap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.text.TranslationTextComponent;

class GuiSlotWaypoints
extends GuiSlotMinimap<WaypointItem> {
    private ArrayList<WaypointItem> waypoints;
    private ArrayList<WaypointItem> waypointsFiltered;
    final GuiWaypoints parentGui;
    private String filterString = "";

    public GuiSlotWaypoints(GuiWaypoints par1GuiWaypoints) {
        super(par1GuiWaypoints.options.game, par1GuiWaypoints.getWidth(), par1GuiWaypoints.getHeight(), 54, par1GuiWaypoints.getHeight() - 90 + 4, 18);
        this.parentGui = par1GuiWaypoints;
        this.waypoints = new ArrayList();
        for (Waypoint pt : this.parentGui.waypointManager.getWaypoints()) {
            if (!pt.inWorld || !pt.inDimension) continue;
            this.waypoints.add(new WaypointItem(this.parentGui, pt));
        }
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        this.waypointsFiltered.forEach(arg_0 -> ((GuiSlotWaypoints)this).addEntry(arg_0));
    }

    public void setSelected(WaypointItem item) {
        super.setSelected((AbstractList.AbstractListEntry)item);
        if (this.getSelected() instanceof WaypointItem) {
            NarratorChatListener.field_193643_a.func_216864_a(new TranslationTextComponent("narrator.select", new Object[]{((WaypointItem)((WaypointItem)this.getSelected())).waypoint.name}).getString());
        }
        this.parentGui.setSelectedWaypoint(item.waypoint);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected boolean isSelectedItem(int par1) {
        return this.waypointsFiltered.get(par1).waypoint.equals(this.parentGui.selectedWaypoint);
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight;
    }

    public void renderBackground() {
        this.parentGui.renderBackground();
    }

    public void drawTexturedModalRect(int xCoord, int yCoord, Sprite textureSprite, int widthIn, int heightIn) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), 1.0).func_187315_a((double)textureSprite.getMinU(), (double)textureSprite.getMaxV()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), 1.0).func_187315_a((double)textureSprite.getMaxU(), (double)textureSprite.getMaxV()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), 1.0).func_187315_a((double)textureSprite.getMaxU(), (double)textureSprite.getMinV()).func_181675_d();
        vertexbuffer.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), 1.0).func_187315_a((double)textureSprite.getMinU(), (double)textureSprite.getMinV()).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void sortBy(int sortKey, boolean ascending) {
        final int order = ascending ? 1 : -1;
        this.parentGui.options.getClass();
        if (sortKey == 1) {
            final ArrayList<Waypoint> masterWaypointsList = this.parentGui.waypointManager.getWaypoints();
            Collections.sort(this.waypoints, new Comparator<WaypointItem>(){

                @Override
                public int compare(WaypointItem waypointEntry1, WaypointItem waypointEntry2) {
                    return Double.compare(masterWaypointsList.indexOf(waypointEntry1.waypoint), masterWaypointsList.indexOf(waypointEntry2.waypoint)) * order;
                }
            });
        } else {
            this.parentGui.options.getClass();
            if (sortKey == 3) {
                if (ascending) {
                    Collections.sort(this.waypoints);
                } else {
                    Collections.sort(this.waypoints, Collections.reverseOrder());
                }
            } else {
                this.parentGui.options.getClass();
                if (sortKey == 2) {
                    final Collator collator = I18nUtils.getLocaleAwareCollator();
                    Collections.sort(this.waypoints, new Comparator<WaypointItem>(){

                        @Override
                        public int compare(WaypointItem waypointEntry1, WaypointItem waypointEntry2) {
                            return collator.compare(((WaypointItem)waypointEntry1).waypoint.name, ((WaypointItem)waypointEntry2).waypoint.name) * order;
                        }
                    });
                } else {
                    this.parentGui.options.getClass();
                    if (sortKey == 4) {
                        Collections.sort(this.waypoints, new Comparator<WaypointItem>(){

                            @Override
                            public int compare(WaypointItem waypointEntry1, WaypointItem waypointEntry2) {
                                Waypoint waypoint1 = waypointEntry1.waypoint;
                                Waypoint waypoint2 = waypointEntry2.waypoint;
                                float hue1 = Color.RGBtoHSB((int)(waypoint1.red * 255.0f), (int)(waypoint1.green * 255.0f), (int)(waypoint1.blue * 255.0f), null)[0];
                                float hue2 = Color.RGBtoHSB((int)(waypoint2.red * 255.0f), (int)(waypoint2.green * 255.0f), (int)(waypoint2.blue * 255.0f), null)[0];
                                return Double.compare(hue1, hue2) * order;
                            }
                        });
                    }
                }
            }
        }
        this.updateFilter(this.filterString);
    }

    protected void updateFilter(String filterString) {
        this.clearEntries();
        this.filterString = filterString;
        this.waypointsFiltered = new ArrayList<WaypointItem>(this.waypoints);
        Iterator<WaypointItem> iterator = this.waypointsFiltered.iterator();
        while (iterator.hasNext()) {
            Waypoint waypoint = iterator.next().waypoint;
            if (TextUtils.scrubCodes(waypoint.name).toLowerCase().contains(filterString)) continue;
            if (waypoint == this.parentGui.selectedWaypoint) {
                this.parentGui.setSelectedWaypoint(null);
            }
            iterator.remove();
        }
        this.waypointsFiltered.forEach(arg_0 -> ((GuiSlotWaypoints)this).addEntry(arg_0));
    }

    public class WaypointItem
    extends ExtendedList.AbstractListEntry<WaypointItem>
    implements Comparable<WaypointItem> {
        private final GuiWaypoints parentGui;
        private final Waypoint waypoint;

        protected WaypointItem(GuiWaypoints waypointScreen, Waypoint waypoint) {
            this.parentGui = waypointScreen;
            this.waypoint = waypoint;
        }

        public void render(int slotIndex, int slotYPos, int leftEdge, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            this.parentGui.drawCenteredString(this.parentGui.getFontRenderer(), this.waypoint.name, this.parentGui.getWidth() / 2, slotYPos + 3, this.waypoint.getUnifiedColor());
            int padding = 3;
            if (mouseX >= leftEdge - padding && mouseY >= slotYPos && mouseX <= leftEdge + 215 + padding && mouseY <= slotYPos + entryHeight) {
                String tooltip;
                if (mouseX >= leftEdge + 215 - 16 - padding && mouseX <= leftEdge + 215 + padding) {
                    tooltip = this.waypoint.enabled ? I18nUtils.getString("minimap.waypoints.disable", new Object[0]) : I18nUtils.getString("minimap.waypoints.enable", new Object[0]);
                } else {
                    tooltip = "X: " + this.waypoint.getX() + " Z: " + this.waypoint.getZ();
                    if (this.waypoint.getY() > 0) {
                        tooltip = tooltip + " Y: " + this.waypoint.getY();
                    }
                }
                if (mouseX >= GuiSlotWaypoints.this.x0 && mouseX <= GuiSlotWaypoints.this.x1 && mouseY >= GuiSlotWaypoints.this.y0 && mouseY <= GuiSlotWaypoints.this.y1) {
                    GuiWaypoints.setTooltip(GuiSlotWaypoints.this.parentGui, tooltip);
                }
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
            GLUtils.img("textures/mob_effect/" + (this.waypoint.enabled ? "night_vision.png" : "blindness.png"));
            GuiWaypoints.blit((int)(leftEdge + 198), (int)(slotYPos - 2), (int)GuiSlotWaypoints.this.blitOffset, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            if (this.waypoint == this.parentGui.highlightedWaypoint) {
                int x = leftEdge + 199;
                int y = slotYPos - 1;
                GLShim.glColor4f(1.0f, 0.0f, 0.0f, 1.0f);
                TextureAtlas textureAtlas = this.parentGui.waypointManager.getTextureAtlas();
                GLUtils.disp(textureAtlas.func_110552_b());
                Sprite icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png");
                GuiSlotWaypoints.this.drawTexturedModalRect(x, y, icon, 16, 16);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            GuiSlotWaypoints.this.setSelected(this);
            int leftEdge = this.parentGui.getWidth() / 2 - 92 - 16;
            int padding = 3;
            int width = 215;
            if (mouseX >= (double)(leftEdge + width - 16 - padding) && mouseX <= (double)(leftEdge + width + padding)) {
                if (GuiSlotWaypoints.this.doubleclick) {
                    this.parentGui.setHighlightedWaypoint();
                }
                this.parentGui.toggleWaypointVisibility();
            } else if (GuiSlotWaypoints.this.doubleclick) {
                this.parentGui.editWaypoint(this.parentGui.selectedWaypoint);
            }
            return true;
        }

        @Override
        public int compareTo(WaypointItem arg0) {
            return this.waypoint.compareTo(arg0.waypoint);
        }
    }
}

