/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.persistent;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IPersistentMap;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeListener;
import com.mamiyaotaru.voxelmap.interfaces.ISettingsAndLightingChangeNotifier;
import com.mamiyaotaru.voxelmap.persistent.AbstractNotifyingRunnable;
import com.mamiyaotaru.voxelmap.persistent.CompressibleGLBufferedImage;
import com.mamiyaotaru.voxelmap.persistent.CompressibleMapData;
import com.mamiyaotaru.voxelmap.persistent.EmptyCachedRegion;
import com.mamiyaotaru.voxelmap.persistent.IThreadCompleteListener;
import com.mamiyaotaru.voxelmap.persistent.ThreadManager;
import com.mamiyaotaru.voxelmap.util.BlockStateParser;
import com.mamiyaotaru.voxelmap.util.CommandUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.MutableBlockPos;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.TickCounter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.concurrent.ThreadTaskExecutor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;

public class CachedRegion
implements IThreadCompleteListener,
ISettingsAndLightingChangeListener {
    public static EmptyCachedRegion emptyRegion = new EmptyCachedRegion();
    private long mostRecentView = 0L;
    private long mostRecentChange = 0L;
    private IPersistentMap persistentMap;
    private String key;
    private World world;
    private ServerWorld worldServer;
    private ServerChunkProvider chunkProvider;
    Class<?> executorClass;
    private ThreadTaskExecutor<Runnable> executor;
    private ChunkManager chunkLoader;
    private String worldName;
    private String subworldName;
    private String worldNamePathPart;
    private String subworldNamePathPart = "";
    private String dimensionNamePathPart;
    private boolean underground = false;
    private int x;
    private int z;
    private int width = 256;
    private boolean empty = true;
    private boolean liveChunksUpdated = false;
    boolean remoteWorld;
    private boolean[] liveChunkUpdateQueued = new boolean[256];
    private boolean[] chunkUpdateQueued = new boolean[256];
    private int[] chunkUpdateQueuedOnTick = new int[256];
    private CompressibleGLBufferedImage image;
    private CompressibleMapData data;
    MutableBlockPos blockPos = new MutableBlockPos(0, 0, 0);
    MutableBlockPos loopBlockPos = new MutableBlockPos(0, 0, 0);
    Future<?> future = null;
    private ReentrantLock threadLock = new ReentrantLock();
    boolean displayOptionsChanged = false;
    boolean imageChanged = false;
    boolean refreshQueued = false;
    boolean refreshingImage = false;
    boolean dataUpdated = false;
    boolean dataUpdateQueued = false;
    boolean loaded = false;
    boolean closed = false;
    private static final Object anvilLock = new Object();
    private static final ReadWriteLock tickLock = new ReentrantReadWriteLock();
    private static int loadedChunkCount = 0;
    private static boolean debug = false;
    private boolean queuedToCompress = false;

    public CachedRegion() {
    }

    public CachedRegion(IPersistentMap persistentMap, String key, World world, String worldName, String subworldName, int x, int z) {
        this.persistentMap = persistentMap;
        this.key = key;
        this.world = world;
        this.worldName = worldName;
        this.subworldName = subworldName;
        this.worldNamePathPart = TextUtils.scrubNameFile(worldName);
        if (subworldName != "") {
            this.subworldNamePathPart = TextUtils.scrubNameFile(subworldName) + "/";
        }
        String dimensionName = AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(world.field_73011_w).getStorageName();
        this.dimensionNamePathPart = TextUtils.scrubNameFile(dimensionName);
        boolean knownUnderground = false;
        knownUnderground = knownUnderground || dimensionName.toLowerCase().contains("erebus");
        this.underground = !world.field_73011_w.func_76569_d() && !world.field_73011_w.func_191066_m() && world.field_73011_w.func_186058_p() != DimensionType.field_223229_c_ || knownUnderground;
        this.remoteWorld = !Minecraft.func_71410_x().func_71387_A();
        persistentMap.getSettingsAndLightingChangeNotifier().addObserver(this);
        this.x = x;
        this.z = z;
        if (!this.remoteWorld) {
            this.worldServer = Minecraft.func_71410_x().func_71401_C().func_71218_a(world.field_73011_w.func_186058_p());
            this.chunkProvider = this.worldServer.func_72863_F();
            this.executorClass = this.chunkProvider.getClass().getDeclaredClasses()[0];
            this.executor = (ThreadTaskExecutor)ReflectionUtils.getPrivateFieldValueByType(this.chunkProvider, ServerChunkProvider.class, this.executorClass);
            this.chunkLoader = this.chunkProvider.field_217237_a;
        }
        Arrays.fill(this.liveChunkUpdateQueued, false);
        Arrays.fill(this.chunkUpdateQueued, false);
        Arrays.fill(this.chunkUpdateQueuedOnTick, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameSubworld(String oldName, String newName) {
        if (oldName.equals(this.subworldName)) {
            this.closed = true;
            this.threadLock.lock();
            try {
                this.subworldName = newName;
                if (this.subworldName != "") {
                    this.subworldNamePathPart = TextUtils.scrubNameFile(this.subworldName) + "/";
                }
            }
            catch (Exception exception) {
            }
            finally {
                this.threadLock.unlock();
                this.closed = false;
            }
        }
    }

    public void registerChangeAt(int chunkX, int chunkZ) {
        this.dataUpdateQueued = true;
        int index = (chunkZ -= this.z * 16) * 16 + (chunkX -= this.x * 16);
        this.liveChunkUpdateQueued[index] = true;
        if (this.chunkUpdateQueuedOnTick[index] == 0) {
            this.chunkUpdateQueuedOnTick[index] = TickCounter.tickCounter;
        }
    }

    @Override
    public void notifyOfActionableChange(ISettingsAndLightingChangeNotifier notifier) {
        this.displayOptionsChanged = true;
    }

    public void refresh(boolean forceCompress) {
        this.mostRecentView = System.currentTimeMillis();
        if (this.future != null && (this.future.isDone() || this.future.isCancelled())) {
            this.refreshQueued = false;
        }
        if (this.refreshQueued) {
            return;
        }
        this.refreshQueued = true;
        if (!this.loaded || this.dataUpdated || this.dataUpdateQueued || this.displayOptionsChanged) {
            RefreshRunnable regionProcessingRunnable = new RefreshRunnable(forceCompress);
            this.future = ThreadManager.executorService.submit(regionProcessingRunnable);
        } else {
            this.refreshQueued = false;
        }
    }

    public void handleChangedChunk(Chunk chunk) {
        int chunkZ = chunk.func_76632_l().field_77275_b - this.z * 16;
        int chunkX = chunk.func_76632_l().field_77276_a - this.x * 16;
        int index = chunkZ * 16 + chunkX;
        if (this.chunkUpdateQueued[index]) {
            return;
        }
        this.chunkUpdateQueued[index] = true;
        if (this.chunkUpdateQueuedOnTick[index] == 0) {
            this.chunkUpdateQueuedOnTick[index] = TickCounter.tickCounter;
        }
        this.mostRecentChange = this.mostRecentView = System.currentTimeMillis();
        FillChunkRunnable fillChunkRunnable = new FillChunkRunnable(chunk);
        ThreadManager.executorService.execute(fillChunkRunnable);
    }

    @Override
    public void notifyOfThreadComplete(AbstractNotifyingRunnable runnable) {
    }

    private void load() {
        this.data = new CompressibleMapData(256, 256);
        this.image = new CompressibleGLBufferedImage(256, 256, 6);
        this.loadCachedData();
        this.loadCurrentData(this.world);
        if (!this.remoteWorld) {
            this.loadAnvilData(this.world);
        }
        this.loaded = true;
    }

    private void loadCurrentData(World world) {
        for (int chunkX = 0; chunkX < 16; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                Chunk chunk = world.func_212866_a_(this.x * 16 + chunkX, this.z * 16 + chunkZ);
                if (chunk == null || chunk.func_76621_g() || !world.func_217354_b(this.x * 16 + chunkX, this.z * 16 + chunkZ)) continue;
                this.loadChunkData(chunk, chunkX, chunkZ);
            }
        }
    }

    private void loadModifiedData() {
        for (int chunkX = 0; chunkX < 16; ++chunkX) {
            for (int chunkZ = 0; chunkZ < 16; ++chunkZ) {
                if (!this.liveChunkUpdateQueued[chunkZ * 16 + chunkX]) continue;
                Chunk chunk = this.world.func_212866_a_(this.x * 16 + chunkX, this.z * 16 + chunkZ);
                if (chunk != null && !chunk.func_76621_g() && this.world.func_217354_b(this.x * 16 + chunkX, this.z * 16 + chunkZ)) {
                    this.loadChunkData(chunk, chunkX, chunkZ);
                }
                this.liveChunkUpdateQueued[chunkZ * 16 + chunkX] = false;
            }
        }
    }

    private void loadChunkData(Chunk chunk, int chunkX, int chunkZ) {
        boolean isEmpty = this.closed || this.isChunkEmptyOrUnlit(chunk);
        boolean isSurroundedByLoaded = this.isSurroundedByLoaded(chunk);
        if (!this.closed && this.world == GameVariableAccessShim.getWorld() && !isEmpty && isSurroundedByLoaded) {
            this.doLoadChunkData(chunk, chunkX, chunkZ);
        }
    }

    private void loadChunkDataSkipLightCheck(Chunk chunk, int chunkX, int chunkZ) {
        if (!this.closed && this.world == GameVariableAccessShim.getWorld() && !this.isChunkEmpty(chunk)) {
            this.doLoadChunkData(chunk, chunkX, chunkZ);
        }
    }

    private void doLoadChunkData(Chunk chunk, int chunkX, int chunkZ) {
        for (int t = 0; t < 16; ++t) {
            for (int s = 0; s < 16; ++s) {
                this.persistentMap.getAndStoreData(this.data, chunk.func_177412_p(), chunk, this.blockPos, this.underground, this.x * 256, this.z * 256, chunkX * 16 + t, chunkZ * 16 + s);
            }
        }
        this.empty = false;
        this.liveChunksUpdated = true;
        this.dataUpdated = true;
    }

    private boolean isChunkEmptyOrUnlit(Chunk chunk) {
        if (this.closed || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222617_m)) {
            return true;
        }
        boolean overworld = this.world.func_201675_m().func_191066_m();
        for (int t = 0; t < 16; ++t) {
            for (int s = 0; s < 16; ++s) {
                if (!(overworld ? chunk.func_177412_p().func_175642_b(LightType.SKY, (BlockPos)this.blockPos.withXYZ(chunk.func_76632_l().field_77276_a * 16 + t, chunk.func_76625_h() + 15, chunk.func_76632_l().field_77275_b * 16 + s)) != 0 : chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, t, s) != 0)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isChunkEmpty(Chunk chunk) {
        if (this.closed || !chunk.func_201589_g().func_209003_a(ChunkStatus.field_222617_m)) {
            return true;
        }
        for (int t = 0; t < 16; ++t) {
            for (int s = 0; s < 16; ++s) {
                if (chunk.func_201576_a(Heightmap.Type.MOTION_BLOCKING, t, s) != 0) {
                    return false;
                }
                if (chunk.func_177412_p().func_175642_b(LightType.SKY, (BlockPos)this.blockPos.withXYZ(chunk.func_76632_l().field_77276_a * 16 + t, chunk.func_76625_h() + 15, chunk.func_76632_l().field_77275_b * 16 + s)) == 0) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isSurroundedByLoaded(Chunk chunk) {
        int chunkX = chunk.func_76632_l().field_77276_a;
        int chunkZ = chunk.func_76632_l().field_77275_b;
        boolean neighborsLoaded = chunk != null && !chunk.func_76621_g() && Minecraft.func_71410_x().field_71441_e.func_217354_b(chunkX, chunkZ);
        for (int t = chunkX - 1; t <= chunkX + 1 && neighborsLoaded; ++t) {
            for (int s = chunkZ - 1; s <= chunkZ + 1 && neighborsLoaded; ++s) {
                Chunk neighborChunk = Minecraft.func_71410_x().field_71441_e.func_212866_a_(t, s);
                neighborsLoaded = neighborsLoaded && neighborChunk != null && !neighborChunk.func_76621_g() && Minecraft.func_71410_x().field_71441_e.func_217354_b(t, s);
            }
        }
        return neighborsLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAnvilData(World world) {
        if (this.remoteWorld) {
            return;
        }
        boolean full = true;
        for (int t = 0; t < 16; ++t) {
            for (int s = 0; s < 16; ++s) {
                if (this.closed || this.data.getHeight(t * 16, s * 16) != 0 || this.data.getLight(t * 16, s * 16) != 0) continue;
                full = false;
            }
        }
        if (this.closed || full) {
            return;
        }
        File directory = new File(this.worldServer.func_201675_m().func_186058_p().func_212679_a(this.worldServer.func_217485_w().func_75765_b()), "region");
        File regionFile = new File(directory, "r." + (int)Math.floor(this.x / 2) + "." + (int)Math.floor(this.z / 2) + ".mca");
        if (!regionFile.exists()) {
            return;
        }
        boolean dataChanged = false;
        boolean loadedChunks = false;
        Object[] chunks = new Chunk[256];
        Arrays.fill(chunks, null);
        tickLock.readLock().lock();
        try {
            Object object = anvilLock;
            synchronized (object) {
                if (debug) {
                    System.out.println(Thread.currentThread().getName() + " starting load");
                }
                long loadTime = System.currentTimeMillis();
                CompletableFuture<Void> loadFuture = CompletableFuture.runAsync(() -> this.lambda$loadAnvilData$1((IChunk[])chunks), this.executor);
                while (!this.closed && !loadFuture.isDone()) {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                loadFuture.cancel(false);
                if (debug) {
                    System.out.println(Thread.currentThread().getName() + " finished load after " + (System.currentTimeMillis() - loadTime) + " milliseconds");
                }
            }
            if (debug) {
                System.out.println(Thread.currentThread().getName() + " starting calculation");
            }
            long calcTime = System.currentTimeMillis();
            for (int t = 0; t < 16; ++t) {
                for (int s = 0; s < 16; ++s) {
                    int index = t + s * 16;
                    if (this.closed || chunks[index] == null) continue;
                    loadedChunks = true;
                    ++loadedChunkCount;
                    Chunk loadedChunk = null;
                    if (chunks[index] instanceof Chunk) {
                        loadedChunk = (Chunk)chunks[index];
                    } else {
                        System.out.println("non world chunk at " + chunks[index].func_76632_l().field_77276_a + "," + chunks[index].func_76632_l().field_77275_b);
                    }
                    if (!this.closed && loadedChunk != null && loadedChunk.func_201589_g().func_209003_a(ChunkStatus.field_222617_m)) {
                        CompletableFuture lightFuture = this.chunkProvider.func_212863_j_().func_215593_a((IChunk)loadedChunk, false);
                        while (!this.closed && !lightFuture.isDone()) {
                            try {
                                Thread.sleep(3L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        loadedChunk = lightFuture.getNow(loadedChunk);
                        lightFuture.cancel(false);
                    }
                    if (this.closed || loadedChunk == null || !loadedChunk.func_201589_g().func_209003_a(ChunkStatus.field_222617_m)) continue;
                    this.loadChunkDataSkipLightCheck(loadedChunk, t, s);
                    dataChanged = true;
                }
            }
            if (debug) {
                System.out.println(Thread.currentThread().getName() + " finished calculating after " + (System.currentTimeMillis() - calcTime) + " milliseconds");
            }
        }
        catch (Exception e) {
            System.out.println("error in anvil loading");
        }
        finally {
            tickLock.readLock().unlock();
        }
        if (!this.closed && dataChanged) {
            this.saveData(false);
        }
        if (!this.closed && loadedChunks && loadedChunkCount > 4096) {
            loadedChunkCount = 0;
            tickLock.writeLock().lock();
            try {
                CompletableFuture<Void> tickFuture = CompletableFuture.runAsync(() -> this.chunkProvider.func_217207_a(() -> true), this.executor);
                long tickTime = System.currentTimeMillis();
                if (debug) {
                    System.out.println(Thread.currentThread().getName() + " starting chunk GC tick");
                }
                while (!this.closed && !tickFuture.isDone()) {
                    try {
                        Thread.sleep(3L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (debug) {
                    System.out.println(Thread.currentThread().getName() + " finished chunk GC tick after " + (System.currentTimeMillis() - tickTime) + " milliseconds");
                }
            }
            catch (Exception e) {
                System.out.println("error ticking from anvil loading");
            }
            finally {
                tickLock.writeLock().unlock();
            }
        }
    }

    private void loadCachedData() {
        try {
            File cachedRegionFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/mamiyaotaru/voxelmap/cache/" + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart);
            cachedRegionFileDir.mkdirs();
            File cachedRegionFile = new File(cachedRegionFileDir, "/" + this.key + ".zip");
            if (cachedRegionFile.exists()) {
                ZipEntry ze;
                FileInputStream fis = new FileInputStream(cachedRegionFile);
                ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
                HashBiMap stateToInt = null;
                int total = 0;
                byte[] decompressedByteData = new byte[this.data.getWidth() * this.data.getHeight() * 17 * 4];
                while ((ze = zis.getNextEntry()) != null) {
                    if (ze.getName().equals("data")) {
                        int count;
                        byte[] data = new byte[2048];
                        while ((count = zis.read(data, 0, 2048)) != -1 && count + total <= this.data.getWidth() * this.data.getHeight() * 17 * 4) {
                            System.arraycopy(data, 0, decompressedByteData, total, count);
                            total += count;
                        }
                        zis.closeEntry();
                    }
                    if (!ze.getName().equals("key")) continue;
                    stateToInt = HashBiMap.create();
                    Scanner sc = new Scanner(zis);
                    while (sc.hasNextLine()) {
                        BlockStateParser.parseLine(sc.nextLine(), (BiMap<BlockState, Integer>)stateToInt);
                    }
                    zis.closeEntry();
                }
                if (total == this.data.getWidth() * this.data.getHeight() * 18 && stateToInt != null) {
                    byte[] byteData = new byte[this.data.getWidth() * this.data.getHeight() * 18];
                    System.arraycopy(decompressedByteData, 0, byteData, 0, byteData.length);
                    this.data.setData(byteData, (BiMap<BlockState, Integer>)stateToInt);
                    this.empty = false;
                    this.dataUpdated = true;
                } else {
                    System.out.println("failed to load data from " + cachedRegionFile.getPath());
                }
                zis.close();
                fis.close();
                if (stateToInt == null) {
                    this.liveChunksUpdated = true;
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load region file for " + this.x + "," + this.z + " in " + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart);
            e.printStackTrace();
        }
    }

    private void saveData(boolean newThread) {
        if (this.liveChunksUpdated && !this.worldNamePathPart.equals("")) {
            if (newThread) {
                ThreadManager.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        CachedRegion.this.threadLock.lock();
                        try {
                            CachedRegion.this.doSave();
                        }
                        catch (IOException e) {
                            System.err.println("Failed to save region file for " + CachedRegion.this.x + "," + CachedRegion.this.z + " in " + CachedRegion.this.worldNamePathPart + "/" + CachedRegion.this.subworldNamePathPart + CachedRegion.this.dimensionNamePathPart);
                            e.printStackTrace();
                        }
                        finally {
                            CachedRegion.this.threadLock.unlock();
                        }
                    }
                });
            } else {
                try {
                    this.doSave();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.liveChunksUpdated = false;
        }
    }

    private void doSave() throws IOException {
        BiMap<BlockState, Integer> stateToInt = this.data.getStateToInt();
        byte[] byteArray = this.data.getData();
        if (byteArray.length == this.data.getWidth() * this.data.getHeight() * 18) {
            File cachedRegionFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/mamiyaotaru/voxelmap/cache/" + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart);
            cachedRegionFileDir.mkdirs();
            File cachedRegionFile = new File(cachedRegionFileDir, "/" + this.key + ".zip");
            FileOutputStream fos = new FileOutputStream(cachedRegionFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            ZipEntry ze = new ZipEntry("data");
            ze.setSize(byteArray.length);
            zos.putNextEntry(ze);
            zos.write(byteArray);
            zos.closeEntry();
            if (stateToInt != null) {
                Iterator iterator = stateToInt.entrySet().iterator();
                StringBuffer stringBuffer = new StringBuffer();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    String nextLine = entry.getValue() + " " + ((BlockState)entry.getKey()).toString() + "\r\n";
                    stringBuffer.append(nextLine);
                }
                byte[] keyByteArray = String.valueOf(stringBuffer).getBytes();
                ze = new ZipEntry("key");
                ze.setSize(keyByteArray.length);
                zos.putNextEntry(ze);
                zos.write(keyByteArray);
                zos.closeEntry();
            }
            zos.close();
            fos.close();
        } else {
            System.err.println("Data array wrong size: " + byteArray.length + "for " + this.x + "," + this.z + " in " + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart);
        }
    }

    private void fillImage() {
        int color24 = 0;
        for (int t = 0; t < 256; ++t) {
            for (int s = 0; s < 256; ++s) {
                color24 = this.persistentMap.getPixelColor(this.data, this.world, this.blockPos, this.loopBlockPos, this.underground, 8, this.x * 256, this.z * 256, t, s);
                this.image.setRGB(t, s, color24);
            }
        }
    }

    private void saveImage() {
        if (!this.empty) {
            File imageFileDir = new File(Minecraft.func_71410_x().field_71412_D, "/mods/mamiyaotaru/voxelmap/cache/" + this.worldNamePathPart + "/" + this.subworldNamePathPart + this.dimensionNamePathPart + "/images/z1");
            imageFileDir.mkdirs();
            final File imageFile = new File(imageFileDir, this.key + ".png");
            if (this.liveChunksUpdated || !imageFile.exists()) {
                ThreadManager.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        CachedRegion.this.threadLock.lock();
                        try {
                            BufferedImage realBufferedImage = new BufferedImage(CachedRegion.this.width, CachedRegion.this.width, 6);
                            byte[] dstArray = ((DataBufferByte)realBufferedImage.getRaster().getDataBuffer()).getData();
                            System.arraycopy(CachedRegion.this.image.getData(), 0, dstArray, 0, CachedRegion.this.image.getData().length);
                            ImageIO.write((RenderedImage)realBufferedImage, "png", imageFile);
                        }
                        catch (IOException var9) {
                            var9.printStackTrace();
                        }
                        finally {
                            CachedRegion.this.threadLock.unlock();
                        }
                    }
                });
            }
        }
    }

    public long getMostRecentView() {
        return this.mostRecentView;
    }

    public long getMostRecentChange() {
        return this.mostRecentChange;
    }

    public String getKey() {
        return this.key;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getGLID() {
        if (this.image != null) {
            if (!this.refreshingImage) {
                CompressibleGLBufferedImage compressibleGLBufferedImage = this.image;
                synchronized (compressibleGLBufferedImage) {
                    if (this.imageChanged) {
                        this.imageChanged = false;
                        this.image.write();
                    }
                }
            }
            return this.image.getIndex();
        }
        return 0;
    }

    public CompressibleMapData getMapData() {
        return this.data;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isGroundAt(int blockX, int blockZ) {
        return this.isLoaded() && this.getHeightAt(blockX, blockZ) > 0;
    }

    public int getHeightAt(int blockX, int blockZ) {
        int y;
        int x = blockX - this.x * 256;
        int z = blockZ - this.z * 256;
        int n = y = this.data == null ? 0 : this.data.getHeight(x, z);
        if (this.underground && y == 255) {
            y = CommandUtils.getSafeHeight(blockX, 64, blockZ, this.world);
        }
        return y;
    }

    public void compress() {
        if (this.data != null && !this.isCompressed() && !this.queuedToCompress) {
            this.queuedToCompress = true;
            ThreadManager.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    if (CachedRegion.this.threadLock.tryLock()) {
                        try {
                            CachedRegion.this.compressData();
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            CachedRegion.this.threadLock.unlock();
                        }
                    }
                    CachedRegion.this.queuedToCompress = false;
                }
            });
        }
    }

    private void compressData() {
        this.data.compress();
    }

    private boolean isCompressed() {
        return this.data.isCompressed();
    }

    public synchronized void cleanup() {
        this.closed = true;
        Arrays.fill(this.liveChunkUpdateQueued, false);
        this.queuedToCompress = true;
        if (this.future != null) {
            this.future.cancel(false);
        }
        this.persistentMap.getSettingsAndLightingChangeNotifier().removeObserver(this);
        if (this.image != null) {
            this.image.baleet();
        }
        this.saveData(true);
        if (this.persistentMap.getOptions().outputImages) {
            this.saveImage();
        }
    }

    public synchronized void save() {
        this.saveData(true);
    }

    private /* synthetic */ void lambda$loadAnvilData$1(IChunk[] chunks) {
        for (int t = 0; t < 16; ++t) {
            for (int s = 0; s < 16; ++s) {
                if (this.closed || this.data.getHeight(t * 16, s * 16) != 0 || this.data.getLight(t * 16, s * 16) != 0) continue;
                try {
                    ListNBT sections;
                    int index = t + s * 16;
                    ChunkPos chunkPos = new ChunkPos(this.x * 16 + t, this.z * 16 + s);
                    CompoundNBT rawNbt = this.chunkLoader.func_219099_e(chunkPos);
                    if (rawNbt == null) continue;
                    CompoundNBT nbt = this.chunkLoader.func_219166_a(this.worldServer.func_201675_m().func_186058_p(), () -> this.worldServer.func_217481_x(), rawNbt);
                    if (this.closed || !nbt.func_150297_b("Level", 10)) continue;
                    CompoundNBT level = nbt.func_74775_l("Level");
                    int chunkX = level.func_74762_e("xPos");
                    int chunkZ = level.func_74762_e("zPos");
                    if (chunkPos.field_77276_a != chunkX || chunkPos.field_77275_b != chunkZ || !level.func_150297_b("Status", 8) || !ChunkStatus.func_222591_a((String)level.func_74779_i("Status")).func_209003_a(ChunkStatus.field_222615_k) || !level.func_74764_b("Sections") || (sections = level.func_150295_c("Sections", 10)).isEmpty() || sections.size() == 0) continue;
                    boolean hasInfo = false;
                    for (int i = 0; i < sections.size() && !hasInfo && !this.closed; ++i) {
                        CompoundNBT section = sections.func_150305_b(i);
                        if (!section.func_150297_b("Palette", 9) || !section.func_150297_b("BlockStates", 12)) continue;
                        hasInfo = true;
                    }
                    if (!hasInfo) continue;
                    boolean hasLight = true;
                    if (!level.func_74764_b("isLightOn") || !level.func_74767_n("isLightOn")) {
                        hasLight = false;
                    }
                    if (level.func_74764_b("LightPopulated")) {
                        hasLight = false;
                    }
                    if (!nbt.func_74764_b("DataVersion") || nbt.func_74762_e("DataVersion") < 1900) {
                        hasLight = false;
                    }
                    chunks[index] = this.worldServer.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
                    continue;
                }
                catch (IOException e) {
                    System.out.println("failed checking NBT while loading from anvil: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }

    private class FillChunkRunnable
    implements Runnable {
        private Chunk chunk;
        private int index;

        public FillChunkRunnable(Chunk chunk) {
            this.chunk = chunk;
            int chunkX = chunk.func_76632_l().field_77276_a - CachedRegion.this.x * 16;
            int chunkZ = chunk.func_76632_l().field_77275_b - CachedRegion.this.z * 16;
            this.index = chunkZ * 16 + chunkX;
        }

        @Override
        public void run() {
            CachedRegion.this.threadLock.lock();
            try {
                if (!CachedRegion.this.loaded) {
                    CachedRegion.this.load();
                }
                int chunkX = this.chunk.func_76632_l().field_77276_a - CachedRegion.this.x * 16;
                int chunkZ = this.chunk.func_76632_l().field_77275_b - CachedRegion.this.z * 16;
                CachedRegion.this.loadChunkData(this.chunk, chunkX, chunkZ);
            }
            catch (Exception exception) {
            }
            finally {
                CachedRegion.this.threadLock.unlock();
                ((CachedRegion)CachedRegion.this).chunkUpdateQueued[this.index] = false;
                ((CachedRegion)CachedRegion.this).chunkUpdateQueuedOnTick[this.index] = 0;
            }
        }
    }

    private class RefreshRunnable
    extends AbstractNotifyingRunnable {
        private boolean forceCompress = false;

        public RefreshRunnable(boolean forceCompress) {
            this.forceCompress = forceCompress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            CachedRegion.this.threadLock.lock();
            CachedRegion.this.mostRecentChange = System.currentTimeMillis();
            try {
                if (!CachedRegion.this.loaded) {
                    CachedRegion.this.load();
                }
                if (CachedRegion.this.dataUpdateQueued) {
                    CachedRegion.this.loadModifiedData();
                    CachedRegion.this.dataUpdateQueued = false;
                }
                while (CachedRegion.this.dataUpdated || CachedRegion.this.displayOptionsChanged) {
                    CachedRegion.this.dataUpdated = false;
                    CachedRegion.this.displayOptionsChanged = false;
                    CachedRegion.this.refreshingImage = true;
                    CompressibleGLBufferedImage compressibleGLBufferedImage = CachedRegion.this.image;
                    synchronized (compressibleGLBufferedImage) {
                        CachedRegion.this.fillImage();
                        CachedRegion.this.imageChanged = true;
                    }
                    CachedRegion.this.refreshingImage = false;
                }
                if (this.forceCompress) {
                    CachedRegion.this.compressData();
                }
            }
            catch (Exception e) {
                System.out.println("Exception loading chunk: " + e.getLocalizedMessage());
                e.printStackTrace();
            }
            finally {
                CachedRegion.this.threadLock.unlock();
                CachedRegion.this.refreshQueued = false;
            }
        }
    }
}

