/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;

public class ImageUtils {
    public static void saveImage(String name, int glid, int maxMipmapLevel, int width, int height) {
        Logger logger = LogManager.getLogger();
        GLShim.glBindTexture(3553, glid);
        GLShim.glPixelStorei(3333, 1);
        GLShim.glPixelStorei(3317, 1);
        for (int mipmapLevel = 0; mipmapLevel <= maxMipmapLevel; ++mipmapLevel) {
            File file = new File(name + "_" + mipmapLevel + ".png");
            int destWidth = width >> mipmapLevel;
            int destHeight = height >> mipmapLevel;
            int numPixels = destWidth * destHeight;
            IntBuffer pixelBuffer = BufferUtils.createIntBuffer((int)numPixels);
            int[] pixelArray = new int[numPixels];
            GLShim.glGetTexImage(3553, mipmapLevel, 32993, 33639, pixelBuffer);
            pixelBuffer.get(pixelArray);
            BufferedImage bufferedImage = new BufferedImage(destWidth, destHeight, 2);
            bufferedImage.setRGB(0, 0, destWidth, destHeight, pixelArray, 0, destWidth);
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                logger.debug("Exported png to: {}", new Object[]{file.getAbsolutePath()});
                continue;
            }
            catch (IOException var14) {
                logger.debug("Unable to write: ", (Throwable)var14);
            }
        }
    }

    public static BufferedImage getFaceForGameProfile(GameProfile gameProfile) {
        ITextureObject textureObject;
        BufferedImage image = ImageUtils.blankImage("textures/entity/bat.png", 2, 2);
        ResourceLocation resourcelocation = null;
        Minecraft minecraft = Minecraft.func_71410_x();
        Map map = minecraft.func_152342_ad().func_152788_a(gameProfile);
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
        }
        if (resourcelocation != null && (textureObject = GLUtils.textureManager.func_110581_b(resourcelocation)) != null) {
            image = ImageUtils.createBufferedImageFromGLID(textureObject.func_110552_b());
        }
        return image;
    }

    public static BufferedImage createBufferedImageFromGLID(int id) {
        GLShim.glBindTexture(3553, id);
        return ImageUtils.createBufferedImageFromCurrentGLImage();
    }

    public static BufferedImage createBufferedImageFromCurrentGLImage() {
        int width = GLShim.glGetTexLevelParameteri(3553, 0, 4096);
        int height = GLShim.glGetTexLevelParameteri(3553, 0, 4097);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(width * height * 4).order(ByteOrder.nativeOrder());
        GLShim.glGetTexImage(3553, 0, 6408, 5121, byteBuffer);
        BufferedImage image = new BufferedImage(width, height, 6);
        byteBuffer.position(0);
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int index = y * width * 4 + x * 4;
                int var8 = 0;
                int color24 = var8 | (bytes[index + 2] & 0xFF) << 0;
                color24 |= (bytes[index + 1] & 0xFF) << 8;
                color24 |= (bytes[index + 0] & 0xFF) << 16;
                image.setRGB(x, y, color24 |= (bytes[index + 3] & 0xFF) << 24);
            }
        }
        return image;
    }

    public static BufferedImage blankImage(String path, int w, int h) {
        return ImageUtils.blankImage(path, w, h, 64, 32);
    }

    public static BufferedImage blankImage(String path, int w, int h, int imageWidth, int imageHeight) {
        return ImageUtils.blankImage(path, w, h, imageWidth, imageHeight, 0, 0, 0, 0);
    }

    public static BufferedImage blankImage(String path, int w, int h, int r, int g, int b, int a) {
        return ImageUtils.blankImage(path, w, h, 64, 32, r, g, b, a);
    }

    public static BufferedImage blankImage(String path, int w, int h, int imageWidth, int imageHeight, int r, int g, int b, int a) {
        try {
            InputStream is = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(path)).func_199027_b();
            BufferedImage mobSkin = ImageIO.read(is);
            is.close();
            BufferedImage temp = new BufferedImage(w * mobSkin.getWidth() / imageWidth, h * mobSkin.getWidth() / imageWidth, 6);
            Graphics2D g2 = temp.createGraphics();
            g2.setColor(new Color(r, g, b, a));
            g2.fillRect(0, 0, temp.getWidth(), temp.getHeight());
            g2.dispose();
            return temp;
        }
        catch (Exception e) {
            System.err.println("Failed getting mob: " + path + " - " + e.getLocalizedMessage());
            e.printStackTrace();
            return null;
        }
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h) {
        return ImageUtils.blankImage(mobSkin, w, h, 64, 32);
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h, int imageWidth, int imageHeight) {
        return ImageUtils.blankImage(mobSkin, w, h, imageWidth, imageHeight, 0, 0, 0, 0);
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h, int r, int g, int b, int a) {
        return ImageUtils.blankImage(mobSkin, w, h, 64, 32, r, g, b, a);
    }

    public static BufferedImage blankImage(BufferedImage mobSkin, int w, int h, int imageWidth, int imageHeight, int r, int g, int b, int a) {
        BufferedImage temp = new BufferedImage(w * mobSkin.getWidth() / imageWidth, h * mobSkin.getWidth() / imageWidth, 6);
        Graphics2D g2 = temp.createGraphics();
        g2.setColor(new Color(r, g, b, a));
        g2.fillRect(0, 0, temp.getWidth(), temp.getHeight());
        g2.dispose();
        return temp;
    }

    public static BufferedImage addCharacter(BufferedImage image, String character) {
        Graphics2D g2 = image.createGraphics();
        g2.setColor(new Color(0, 0, 0, 255));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setFont(new Font("Arial", 0, image.getHeight()));
        FontMetrics fm = g2.getFontMetrics();
        int x = (image.getWidth() - fm.stringWidth("?")) / 2;
        int y = fm.getAscent() + (image.getHeight() - (fm.getAscent() + fm.getDescent())) / 2;
        g2.drawString("?", x, y);
        g2.dispose();
        return image;
    }

    public static BufferedImage eraseArea(BufferedImage image, int x, int y, int w, int h, int imageWidth, int imageHeight) {
        float scaleX = image.getWidth() / imageWidth;
        float scaleY = image.getHeight() / imageHeight;
        x = (int)((float)x * scaleX);
        y = (int)((float)y * scaleY);
        w = (int)((float)w * scaleX);
        h = (int)((float)h * scaleY);
        int[] blankPixels = new int[w * h];
        Arrays.fill(blankPixels, 0);
        image.setRGB(x, y, w, h, blankPixels, 0, w);
        return image;
    }

    public static BufferedImage loadImage(ResourceLocation resourceLocation, int x, int y, int w, int h) {
        return ImageUtils.loadImage(resourceLocation, x, y, w, h, 64, 32);
    }

    public static BufferedImage loadImage(ResourceLocation resourceLocation, int x, int y, int w, int h, int imageWidth, int imageHeight) {
        try {
            InputStream is = Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation).func_199027_b();
            BufferedImage mobSkin = ImageIO.read(is);
            is.close();
            return ImageUtils.loadImage(mobSkin, x, y, w, h, imageWidth, imageHeight);
        }
        catch (Exception e) {
            System.err.println("Failed getting mob: " + resourceLocation.toString() + " - " + e.getLocalizedMessage());
            return null;
        }
    }

    public static BufferedImage loadImage(BufferedImage mobSkin, int x, int y, int w, int h) {
        return ImageUtils.loadImage(mobSkin, x, y, w, h, 64, 32);
    }

    public static BufferedImage loadImage(BufferedImage mobSkin, int x, int y, int w, int h, int imageWidth, int imageHeight) {
        if (mobSkin.getType() != 6) {
            BufferedImage temp = new BufferedImage(mobSkin.getWidth(), mobSkin.getHeight(), 6);
            Graphics2D g2 = temp.createGraphics();
            g2.drawImage(mobSkin, 0, 0, mobSkin.getWidth(), mobSkin.getHeight(), null);
            g2.dispose();
            mobSkin = temp;
        }
        float scale = mobSkin.getWidth(null) / imageWidth;
        x = (int)((float)x * scale);
        y = (int)((float)y * scale);
        w = (int)((float)w * scale);
        h = (int)((float)h * scale);
        w = Math.max(1, w);
        h = Math.max(1, h);
        x = Math.min(mobSkin.getWidth(null) - w, x);
        y = Math.min(mobSkin.getHeight(null) - h, y);
        BufferedImage base = mobSkin.getSubimage(x, y, w, h);
        return base;
    }

    public static BufferedImage addImages(BufferedImage base, BufferedImage overlay, float x, float y, int baseWidth, int baseHeight) {
        int scale = base.getWidth() / baseWidth;
        Graphics gfx = base.getGraphics();
        gfx.drawImage(overlay, (int)(x * (float)scale), (int)(y * (float)scale), null);
        gfx.dispose();
        return base;
    }

    public static BufferedImage scaleImage(BufferedImage image, float scaleBy) {
        if (scaleBy == 1.0f) {
            return image;
        }
        int type = image.getType();
        if (type == 13) {
            type = 6;
        }
        int newWidth = Math.max(1, (int)((float)image.getWidth() * scaleBy));
        int newHeight = Math.max(1, (int)((float)image.getHeight() * scaleBy));
        BufferedImage tmp = new BufferedImage(newWidth, newHeight, type);
        Graphics2D g2 = tmp.createGraphics();
        g2.drawImage(image, 0, 0, newWidth, newHeight, null);
        g2.dispose();
        image = tmp;
        return image;
    }

    public static BufferedImage flipHorizontal(BufferedImage image) {
        AffineTransform tx = AffineTransform.getScaleInstance(-1.0, 1.0);
        tx.translate(-image.getWidth(null), 0.0);
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        return op.filter(image, null);
    }

    public static BufferedImage into128(BufferedImage base) {
        BufferedImage frame = new BufferedImage(128, 128, base.getType());
        Graphics gfx = frame.getGraphics();
        gfx.drawImage(base, 64 - base.getWidth() / 2, 64 - base.getHeight() / 2, base.getWidth(), base.getHeight(), null);
        gfx.dispose();
        return frame;
    }

    public static BufferedImage intoSquare(BufferedImage base) {
        int dim = Math.max(base.getWidth(), base.getHeight());
        int t = 1;
        while (Math.pow(2.0, t - 1) < (double)dim) {
            ++t;
        }
        int size = (int)Math.pow(2.0, t);
        BufferedImage frame = new BufferedImage(size, size, base.getType());
        Graphics gfx = frame.getGraphics();
        gfx.drawImage(base, (size - base.getWidth()) / 2, (size - base.getHeight()) / 2, base.getWidth(), base.getHeight(), null);
        gfx.dispose();
        return frame;
    }

    public static BufferedImage pad(BufferedImage base) {
        int dim = Math.max(base.getWidth(), base.getHeight());
        int size = dim + 4;
        BufferedImage frame = new BufferedImage(size, size, base.getType());
        Graphics gfx = frame.getGraphics();
        gfx.drawImage(base, (size - base.getWidth()) / 2, (size - base.getHeight()) / 2, base.getWidth(), base.getHeight(), null);
        gfx.dispose();
        return frame;
    }

    public static BufferedImage fillOutline(BufferedImage image, boolean outline) {
        return ImageUtils.fillOutline(image, outline, false, 0, 0);
    }

    public static BufferedImage fillOutline(BufferedImage image, boolean outline, boolean armor, int intendedWidth, int entry) {
        if (outline && entry != 2 && entry != 3) {
            image = ImageUtils.fillOutline(image, true, armor, intendedWidth);
        }
        image = ImageUtils.fillOutline(image, false, armor, intendedWidth);
        return image;
    }

    private static BufferedImage fillOutline(BufferedImage image, boolean solid, boolean armor, int intendedWidth) {
        float armorOutlineFraction = (float)intendedWidth / 2.0f;
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics gfx = temp.getGraphics();
        gfx.drawImage(image, 0, 0, null);
        gfx.dispose();
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        for (int t = 0; t < image.getWidth(); ++t) {
            for (int s = 0; s < image.getHeight(); ++s) {
                int newColor;
                int color = image.getRGB(s, t);
                if ((color >> 24 & 0xFF) != 0 || (newColor = ImageUtils.getNonTransparentPixel(s, t, image)) == -420) continue;
                if (solid) {
                    newColor = !armor || (float)t <= (float)(imageWidth / 2) - armorOutlineFraction || (float)t >= (float)(imageWidth / 2) + armorOutlineFraction - 1.0f || (float)s <= (float)(imageHeight / 2) - armorOutlineFraction || (float)s >= (float)(imageHeight / 2) + armorOutlineFraction - 1.0f ? -16777216 : 0;
                } else {
                    int red = newColor >> 16 & 0xFF;
                    int green = newColor >> 8 & 0xFF;
                    int blue = newColor >> 0 & 0xFF;
                    newColor = 0 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                }
                temp.setRGB(s, t, newColor);
            }
        }
        return temp;
    }

    public static int getNonTransparentPixel(int x, int y, BufferedImage image) {
        int color;
        if (x > 0 && ((color = image.getRGB(x - 1, y)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.getWidth() - 1 && ((color = image.getRGB(x + 1, y)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (y > 0 && ((color = image.getRGB(x, y - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (y < image.getHeight() - 1 && ((color = image.getRGB(x, y + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x > 0 && y > 0 && ((color = image.getRGB(x - 1, y - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x > 0 && y < image.getHeight() - 1 && ((color = image.getRGB(x - 1, y + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.getWidth() - 1 && y > 0 && ((color = image.getRGB(x + 1, y - 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        if (x < image.getWidth() - 1 && y < image.getHeight() - 1 && ((color = image.getRGB(x + 1, y + 1)) >> 24 & 0xFF) > 50) {
            return color;
        }
        return -420;
    }

    public static BufferedImage trim(BufferedImage image) {
        int t;
        int left = -1;
        int right = image.getWidth();
        int top = -1;
        int bottom = image.getHeight();
        boolean foundColor = false;
        int color = 0;
        while (!foundColor) {
            ++left;
            for (t = 0; t < image.getHeight(); ++t) {
                color = image.getRGB(left, t);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        foundColor = false;
        while (!foundColor) {
            --right;
            for (t = 0; t < image.getHeight(); ++t) {
                color = image.getRGB(right, t);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        foundColor = false;
        while (!foundColor) {
            ++top;
            for (t = 0; t < image.getWidth(); ++t) {
                color = image.getRGB(t, top);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        foundColor = false;
        while (!foundColor) {
            --bottom;
            for (t = 0; t < image.getWidth(); ++t) {
                color = image.getRGB(t, bottom);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        image = image.getSubimage(left, top, right - left + 1, bottom - top + 1);
        return image;
    }

    public static BufferedImage trimCentered(BufferedImage image) {
        int left = -1;
        int right = image.getWidth();
        int top = -1;
        int bottom = image.getHeight();
        boolean foundColor = false;
        int color = 0;
        while (!foundColor) {
            int t;
            ++left;
            --right;
            ++top;
            --bottom;
            for (t = 0; t < image.getHeight(); ++t) {
                color = image.getRGB(left, t);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
            for (t = 0; t < image.getHeight(); ++t) {
                color = image.getRGB(right, t);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
            for (t = 0; t < image.getWidth(); ++t) {
                color = image.getRGB(t, top);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
            for (t = 0; t < image.getWidth(); ++t) {
                color = image.getRGB(t, bottom);
                if (color >> 24 == 0) continue;
                foundColor = true;
            }
        }
        image = image.getSubimage(left, top, right - left + 1, bottom - top + 1);
        return image;
    }

    public static BufferedImage colorify(BufferedImage image, float r, float g, float b) {
        BufferedImage temp = new BufferedImage(image.getWidth(), image.getHeight(), 3);
        Graphics2D gfx = temp.createGraphics();
        gfx.drawImage((Image)image, 0, 0, null);
        gfx.dispose();
        for (int x = 0; x < temp.getWidth(); ++x) {
            for (int y = 0; y < temp.getHeight(); ++y) {
                int ax = temp.getColorModel().getAlpha(temp.getRaster().getDataElements(x, y, null));
                int rx = temp.getColorModel().getRed(temp.getRaster().getDataElements(x, y, null));
                int gx = temp.getColorModel().getGreen(temp.getRaster().getDataElements(x, y, null));
                int bx = temp.getColorModel().getBlue(temp.getRaster().getDataElements(x, y, null));
                rx = (int)((float)rx * r);
                gx = (int)((float)gx * g);
                bx = (int)((float)bx * b);
                temp.setRGB(x, y, ax << 24 | rx << 16 | gx << 8 | bx << 0);
            }
        }
        return temp;
    }

    public static BufferedImage colorify(BufferedImage image, int r, int g, int b) {
        return ImageUtils.colorify(image, (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
    }

    public static BufferedImage colorify(BufferedImage image, int rgb) {
        return ImageUtils.colorify(image, rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF);
    }

    public static float percentageOfEdgePixelsThatAreSolid(BufferedImage image) {
        int t;
        int edgePixels = image.getWidth() * 2 + image.getHeight() * 2 - 2;
        int edgePixelsWithColor = 0;
        int color = 0;
        for (t = 0; t < image.getHeight(); ++t) {
            color = image.getRGB(0, t);
            if (color >> 24 != 0) {
                ++edgePixelsWithColor;
            }
            if ((color = image.getRGB(image.getWidth() - 1, t)) >> 24 == 0) continue;
            ++edgePixelsWithColor;
        }
        for (t = 1; t < image.getWidth() - 1; ++t) {
            color = image.getRGB(t, 0);
            if (color >> 24 != 0) {
                ++edgePixelsWithColor;
            }
            if ((color = image.getRGB(t, image.getHeight() - 1)) >> 24 == 0) continue;
            ++edgePixelsWithColor;
        }
        return edgePixelsWithColor / edgePixels;
    }
}

