/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.interfaces.IChangeObserver;
import com.mamiyaotaru.voxelmap.util.MapChunk;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;

public class MapChunkCache {
    private int width;
    private int height;
    private Chunk lastCenterChunk = null;
    private MapChunk[] mapChunks;
    private int left = 0;
    private int right = 0;
    private int top = 0;
    private int bottom = 0;
    private boolean loaded = false;
    private IChangeObserver changeObserver;

    public MapChunkCache(int width, int height, IChangeObserver changeObserver) {
        this.width = width;
        this.height = height;
        this.mapChunks = new MapChunk[width * height];
        this.changeObserver = changeObserver;
    }

    public void centerChunks(BlockPos blockPos) {
        Chunk currentChunk = Minecraft.func_71410_x().field_71441_e.func_175726_f(blockPos);
        if (currentChunk != this.lastCenterChunk) {
            if (this.lastCenterChunk == null) {
                this.fillAllChunks(blockPos);
                this.lastCenterChunk = currentChunk;
                return;
            }
            int middleX = this.width / 2;
            int middleZ = this.height / 2;
            int movedX = currentChunk.func_76632_l().field_77276_a - this.lastCenterChunk.func_76632_l().field_77276_a;
            int movedZ = currentChunk.func_76632_l().field_77275_b - this.lastCenterChunk.func_76632_l().field_77275_b;
            if (Math.abs(movedX) < this.width && Math.abs(movedZ) < this.height && currentChunk.func_177412_p().equals(this.lastCenterChunk.func_177412_p())) {
                int x;
                int z;
                this.moveX(movedX);
                this.moveZ(movedZ);
                for (z = movedZ > 0 ? this.height - movedZ : 0; z < (movedZ > 0 ? this.height : -movedZ); ++z) {
                    for (x = 0; x < this.width; ++x) {
                        this.mapChunks[x + z * this.width] = new MapChunk(currentChunk.func_76632_l().field_77276_a - (middleX - x), currentChunk.func_76632_l().field_77275_b - (middleZ - z));
                    }
                }
                for (z = 0; z < this.height; ++z) {
                    for (x = movedX > 0 ? this.width - movedX : 0; x < (movedX > 0 ? this.width : -movedX); ++x) {
                        this.mapChunks[x + z * this.width] = new MapChunk(currentChunk.func_76632_l().field_77276_a - (middleX - x), currentChunk.func_76632_l().field_77275_b - (middleZ - z));
                    }
                }
            } else {
                this.fillAllChunks(blockPos);
            }
            this.left = this.mapChunks[0].getX();
            this.top = this.mapChunks[0].getZ();
            this.right = this.mapChunks[this.mapChunks.length - 1].getX();
            this.bottom = this.mapChunks[this.mapChunks.length - 1].getZ();
            this.lastCenterChunk = currentChunk;
        }
    }

    private void fillAllChunks(BlockPos blockPos) {
        IChunk currentChunk = Minecraft.func_71410_x().field_71441_e.func_217349_x(blockPos);
        int middleX = this.width / 2;
        int middleZ = this.height / 2;
        for (int z = 0; z < this.height; ++z) {
            for (int x = 0; x < this.width; ++x) {
                this.mapChunks[x + z * this.width] = new MapChunk(currentChunk.func_76632_l().field_77276_a - (middleX - x), currentChunk.func_76632_l().field_77275_b - (middleZ - z));
            }
        }
        this.left = this.mapChunks[0].getX();
        this.top = this.mapChunks[0].getZ();
        this.right = this.mapChunks[this.mapChunks.length - 1].getX();
        this.bottom = this.mapChunks[this.mapChunks.length - 1].getZ();
        this.loaded = true;
    }

    private void moveX(int offset) {
        if (offset > 0) {
            System.arraycopy(this.mapChunks, offset, this.mapChunks, 0, this.mapChunks.length - offset);
        } else if (offset < 0) {
            System.arraycopy(this.mapChunks, 0, this.mapChunks, -offset, this.mapChunks.length + offset);
        }
    }

    private void moveZ(int offset) {
        if (offset > 0) {
            System.arraycopy(this.mapChunks, offset * this.width, this.mapChunks, 0, this.mapChunks.length - offset * this.width);
        } else if (offset < 0) {
            System.arraycopy(this.mapChunks, 0, this.mapChunks, -offset * this.width, this.mapChunks.length + offset * this.width);
        }
    }

    public void checkIfChunksChanged() {
        if (!this.loaded) {
            return;
        }
        for (int z = this.height - 1; z >= 0; --z) {
            for (int x = 0; x < this.width; ++x) {
                this.mapChunks[x + z * this.width].checkIfChunkChanged(this.changeObserver);
            }
        }
    }

    public void registerChangeAt(int chunkX, int chunkZ) {
        if (this.lastCenterChunk != null && chunkX >= this.left && chunkX <= this.right && chunkZ >= this.top && chunkZ <= this.bottom) {
            int arrayX = chunkX - this.left;
            int arrayZ = chunkZ - this.top;
            MapChunk mapChunk = this.mapChunks[arrayX + arrayZ * this.width];
            mapChunk.setModified(true);
        }
    }
}

