/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.AbstractOption;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunk;

public class WaypointContainer {
    private ArrayList<Waypoint> wayPts = new ArrayList();
    private Waypoint highlightedWaypoint = null;
    private Minecraft mc = Minecraft.func_71410_x();
    public MapSettingsManager options = null;
    private final String TARGETFLAG = "*&^TARget%$^";

    public WaypointContainer(MapSettingsManager options) {
        this.options = options;
    }

    public void addWaypoint(Waypoint newWaypoint) {
        this.wayPts.add(newWaypoint);
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.wayPts.remove(waypoint);
    }

    public void setHighlightedWaypoint(Waypoint highlightedWaypoint) {
        this.highlightedWaypoint = highlightedWaypoint;
    }

    private void sortWaypoints() {
        Collections.sort(this.wayPts, Collections.reverseOrder());
    }

    public void renderWaypoints(float partialTicks) {
        this.sortWaypoints();
        Entity cameraEntity = this.options.game.func_175606_aa();
        double renderPosX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)partialTicks;
        double renderPosY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)partialTicks;
        double renderPosZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)partialTicks;
        GLShim.glEnable(2884);
        for (Waypoint pt : this.wayPts) {
            double distance;
            if (!pt.isActive() && pt != this.highlightedWaypoint) continue;
            int x = pt.getX();
            int z = pt.getZ();
            int y = pt.getY();
            BlockPos blockPos = new BlockPos(x, y, z);
            IChunk chunk = this.mc.field_71441_e.func_217349_x(blockPos);
            if (this.options.showBeacons && chunk != null && !((Chunk)chunk).func_76621_g() && this.mc.field_71441_e.func_217354_b(x >> 4, z >> 4)) {
                double bottomOfWorld = 0.0 - renderPosY;
                this.renderBeam(pt, (double)x - renderPosX, bottomOfWorld, (double)z - renderPosZ, 64.0f);
            }
            if (!((distance = Math.sqrt(pt.getDistanceSqToEntity(cameraEntity))) < (double)this.options.maxWaypointDisplayDistance) && this.options.maxWaypointDisplayDistance >= 0 && pt != this.highlightedWaypoint || !this.options.showWaypoints || this.options.game.field_71474_y.field_74319_N) continue;
            boolean isPointedAt = this.isPointedAt(pt, distance, cameraEntity, Float.valueOf(partialTicks));
            String label = pt.name;
            this.renderLabel(pt, distance, isPointedAt, label, (double)x - renderPosX, (double)y - renderPosY + 1.0, (double)z - renderPosZ, 64);
        }
        if (this.highlightedWaypoint != null && this.options.showWaypoints && !this.options.game.field_71474_y.field_74319_N) {
            int x = this.highlightedWaypoint.getX();
            int z = this.highlightedWaypoint.getZ();
            int y = this.highlightedWaypoint.getY();
            double distance = Math.sqrt(this.highlightedWaypoint.getDistanceSqToEntity(cameraEntity));
            boolean isPointedAt = this.isPointedAt(this.highlightedWaypoint, distance, cameraEntity, Float.valueOf(partialTicks));
            this.renderLabel(this.highlightedWaypoint, distance, isPointedAt, "*&^TARget%$^", (double)x - renderPosX, (double)y - renderPosY + 1.0, (double)z - renderPosZ, 64);
        }
    }

    private boolean isPointedAt(Waypoint waypoint, double distance, Entity cameraEntity, Float partialTicks) {
        Vec3d cameraPos = cameraEntity.func_174824_e(partialTicks.floatValue());
        double degrees = 5.0 + Math.min(5.0 / distance, 5.0);
        double angle = degrees * 0.0174533;
        double size = Math.sin(angle) * distance;
        Vec3d cameraPosPlusDirection = cameraEntity.func_70676_i(partialTicks.floatValue());
        Vec3d cameraPosPlusDirectionTimesDistance = cameraPos.func_72441_c(cameraPosPlusDirection.field_72450_a * distance, cameraPosPlusDirection.field_72448_b * distance, cameraPosPlusDirection.field_72449_c * distance);
        AxisAlignedBB axisalignedbb = new AxisAlignedBB((double)((float)waypoint.getX() + 0.5f) - size, (double)((float)waypoint.getY() + 1.5f) - size, (double)((float)waypoint.getZ() + 0.5f) - size, (double)((float)waypoint.getX() + 0.5f) + size, (double)((float)waypoint.getY() + 1.5f) + size, (double)((float)waypoint.getZ() + 0.5f) + size);
        Optional raytraceresult = axisalignedbb.func_216365_b(cameraPos, cameraPosPlusDirectionTimesDistance);
        return axisalignedbb.func_72318_a(cameraPos) ? distance >= 1.0 : raytraceresult.isPresent();
    }

    private void renderBeam(Waypoint par1EntityWaypoint, double baseX, double baseY, double baseZ, float par8) {
        Tessellator tesselator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tesselator.func_178180_c();
        GLShim.glDisable(3553);
        GLShim.glDisable(2896);
        GLShim.glDisable(2912);
        GLShim.glDepthMask(false);
        GLShim.glEnable(3042);
        GLShim.glBlendFunc(770, 1);
        int height = 256;
        float brightness = 0.06f;
        double topWidthFactor = 1.05;
        double bottomWidthFactor = 1.05;
        float r = par1EntityWaypoint.red;
        float b = par1EntityWaypoint.blue;
        float g = par1EntityWaypoint.green;
        for (int width = 0; width < 4; ++width) {
            vertexBuffer.func_181668_a(5, DefaultVertexFormats.field_181706_f);
            double d6 = 0.1 + (double)width * 0.2;
            d6 *= topWidthFactor;
            double d7 = 0.1 + (double)width * 0.2;
            d7 *= bottomWidthFactor;
            for (int side = 0; side < 5; ++side) {
                double vertX2 = baseX + 0.5 - d6;
                double vertZ2 = baseZ + 0.5 - d6;
                if (side == 1 || side == 2) {
                    vertX2 += d6 * 2.0;
                }
                if (side == 2 || side == 3) {
                    vertZ2 += d6 * 2.0;
                }
                double vertX1 = baseX + 0.5 - d7;
                double vertZ1 = baseZ + 0.5 - d7;
                if (side == 1 || side == 2) {
                    vertX1 += d7 * 2.0;
                }
                if (side == 2 || side == 3) {
                    vertZ1 += d7 * 2.0;
                }
                vertexBuffer.func_181662_b(vertX1, baseY + 0.0, vertZ1).func_181666_a(r * brightness, g * brightness, b * brightness, 0.8f).func_181675_d();
                vertexBuffer.func_181662_b(vertX2, baseY + (double)height, vertZ2).func_181666_a(r * brightness, g * brightness, b * brightness, 0.8f).func_181675_d();
            }
            tesselator.func_78381_a();
        }
        GLShim.glDisable(3042);
        GLShim.glEnable(2912);
        GLShim.glEnable(2896);
        GLShim.glEnable(3553);
        GLShim.glDepthMask(true);
    }

    private void renderLabel(Waypoint pt, double distance, boolean isPointedAt, String name, double par3, double par5, double par7, int par9) {
        Sprite icon;
        boolean target;
        GLShim.glAlphaFunc(516, 0.1f);
        boolean bl = target = name == "*&^TARget%$^";
        if (target) {
            if (pt.red == 2.0f || pt.green == 0.0f || pt.blue == 0.0f) {
                name = "X:" + pt.getX() + ", Y:" + pt.getY() + ", Z:" + pt.getZ();
            } else {
                isPointedAt = false;
            }
        }
        name = name + " (" + (int)distance + "m)";
        double maxDistance = AbstractOption.field_216706_m.func_216729_a(this.options.game.field_71474_y);
        double adjustedDistance = distance;
        if (distance > maxDistance) {
            par3 = par3 / distance * maxDistance;
            par5 = par5 / distance * maxDistance;
            par7 = par7 / distance * maxDistance;
            adjustedDistance = maxDistance;
        }
        float var14 = ((float)adjustedDistance * 0.1f + 1.0f) * 0.0266f;
        GLShim.glPushMatrix();
        GLShim.glTranslatef((float)par3 + 0.5f, (float)par5 + 0.5f, (float)par7 + 0.5f);
        GLShim.glNormal3f(0.0f, 1.0f, 0.0f);
        GLShim.glRotatef(-this.mc.func_175598_ae().field_78735_i, 0.0f, 1.0f, 0.0f);
        GLShim.glRotatef(this.mc.func_175598_ae().field_78732_j, 1.0f, 0.0f, 0.0f);
        GLShim.glScalef(-var14, -var14, var14);
        GLShim.glDisable(2896);
        GLShim.glDisable(2912);
        GLShim.glEnable(3042);
        GLShim.glBlendFunc(770, 771);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        float fade = distance > 5.0 ? 1.0f : (float)distance / 5.0f;
        fade = Math.min(fade, pt.enabled || target ? 1.0f : 0.3f);
        if (distance < maxDistance) {
            GLShim.glDepthMask(true);
        }
        GLShim.glEnable(3553);
        double width = 10.0;
        float r = target ? 1.0f : pt.red;
        float g = target ? 0.0f : pt.green;
        float b = target ? 0.0f : pt.blue;
        TextureAtlas textureAtlas = AbstractVoxelMap.getInstance().getWaypointManager().getTextureAtlas();
        Sprite sprite = icon = target ? textureAtlas.getAtlasSprite("voxelmap:images/waypoints/target.png") : textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint" + pt.imageSuffix + ".png");
        if (icon == textureAtlas.getMissingImage()) {
            icon = textureAtlas.getAtlasSprite("voxelmap:images/waypoints/waypoint.png");
        }
        GLUtils.disp(textureAtlas.func_110552_b());
        GLShim.glEnable(2929);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexBuffer.func_181662_b(-width, -width, 0.0).func_187315_a((double)icon.getMinU(), (double)icon.getMinV()).func_181666_a(r, g, b, 1.0f * fade).func_181675_d();
        vertexBuffer.func_181662_b(-width, width, 0.0).func_187315_a((double)icon.getMinU(), (double)icon.getMaxV()).func_181666_a(r, g, b, 1.0f * fade).func_181675_d();
        vertexBuffer.func_181662_b(width, width, 0.0).func_187315_a((double)icon.getMaxU(), (double)icon.getMaxV()).func_181666_a(r, g, b, 1.0f * fade).func_181675_d();
        vertexBuffer.func_181662_b(width, -width, 0.0).func_187315_a((double)icon.getMaxU(), (double)icon.getMinV()).func_181666_a(r, g, b, 1.0f * fade).func_181675_d();
        tessellator.func_78381_a();
        GLShim.glDisable(2929);
        GLShim.glDepthMask(false);
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        vertexBuffer.func_181662_b(-width, -width, 0.0).func_187315_a((double)icon.getMinU(), (double)icon.getMinV()).func_181666_a(r, g, b, 0.3f * fade).func_181675_d();
        vertexBuffer.func_181662_b(-width, width, 0.0).func_187315_a((double)icon.getMinU(), (double)icon.getMaxV()).func_181666_a(r, g, b, 0.3f * fade).func_181675_d();
        vertexBuffer.func_181662_b(width, width, 0.0).func_187315_a((double)icon.getMaxU(), (double)icon.getMaxV()).func_181666_a(r, g, b, 0.3f * fade).func_181675_d();
        vertexBuffer.func_181662_b(width, -width, 0.0).func_187315_a((double)icon.getMaxU(), (double)icon.getMinV()).func_181666_a(r, g, b, 0.3f * fade).func_181675_d();
        tessellator.func_78381_a();
        GLShim.glDepthMask(false);
        GLShim.glDisable(2929);
        int elevateBy = -18;
        FontRenderer fontRenderer = this.mc.func_175598_ae().func_78716_a();
        if (isPointedAt && fontRenderer != null) {
            GLShim.glDisable(3553);
            int halfStringWidth = fontRenderer.func_78256_a(name) / 2;
            GLShim.glEnable(2929);
            if (distance < maxDistance) {
                GLShim.glDepthMask(true);
            }
            GLShim.glEnable(32823);
            GLShim.glPolygonOffset(1.0f, 3.0f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexBuffer.func_181662_b((double)(-halfStringWidth - 2), (double)(-2 + elevateBy), 0.0).func_181666_a(pt.red, pt.green, pt.blue, 0.6f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(-halfStringWidth - 2), (double)(9 + elevateBy), 0.0).func_181666_a(pt.red, pt.green, pt.blue, 0.6f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(halfStringWidth + 2), (double)(9 + elevateBy), 0.0).func_181666_a(pt.red, pt.green, pt.blue, 0.6f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(halfStringWidth + 2), (double)(-2 + elevateBy), 0.0).func_181666_a(pt.red, pt.green, pt.blue, 0.6f * fade).func_181675_d();
            tessellator.func_78381_a();
            GLShim.glPolygonOffset(1.0f, 1.0f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexBuffer.func_181662_b((double)(-halfStringWidth - 1), (double)(-1 + elevateBy), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(-halfStringWidth - 1), (double)(8 + elevateBy), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(halfStringWidth + 1), (double)(8 + elevateBy), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(halfStringWidth + 1), (double)(-1 + elevateBy), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
            tessellator.func_78381_a();
            GLShim.glDisable(2929);
            GLShim.glDepthMask(false);
            GLShim.glPolygonOffset(1.0f, 7.0f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexBuffer.func_181662_b((double)(-halfStringWidth - 2), (double)(-2 + elevateBy), 0.0).func_181666_a(pt.red, pt.green, pt.blue, 0.15f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(-halfStringWidth - 2), (double)(9 + elevateBy), 0.0).func_181666_a(pt.red, pt.green, pt.blue, 0.15f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(halfStringWidth + 2), (double)(9 + elevateBy), 0.0).func_181666_a(pt.red, pt.green, pt.blue, 0.15f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(halfStringWidth + 2), (double)(-2 + elevateBy), 0.0).func_181666_a(pt.red, pt.green, pt.blue, 0.15f * fade).func_181675_d();
            tessellator.func_78381_a();
            GLShim.glPolygonOffset(1.0f, 5.0f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexBuffer.func_181662_b((double)(-halfStringWidth - 1), (double)(-1 + elevateBy), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(-halfStringWidth - 1), (double)(8 + elevateBy), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(halfStringWidth + 1), (double)(8 + elevateBy), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
            vertexBuffer.func_181662_b((double)(halfStringWidth + 1), (double)(-1 + elevateBy), 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.15f * fade).func_181675_d();
            tessellator.func_78381_a();
            GLShim.glDisable(32823);
            GLShim.glEnable(3553);
            int textColor = (int)(255.0f * fade) << 24 | 0xCCCCCC;
            fontRenderer.func_211126_b(name, (float)(-fontRenderer.func_78256_a(name) / 2), (float)elevateBy, textColor);
            GLShim.glEnable(2929);
            textColor = (int)(255.0f * fade) << 24 | 0xFFFFFF;
            fontRenderer.func_211126_b(name, (float)(-fontRenderer.func_78256_a(name) / 2), (float)elevateBy, textColor);
        }
        GLShim.glEnable(2929);
        GLShim.glDepthMask(true);
        GLShim.glEnable(2912);
        GLShim.glEnable(2896);
        GLShim.glDisable(3042);
        GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        GLShim.glPopMatrix();
    }
}

