/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap;

import com.mamiyaotaru.voxelmap.MapSettingsManager;
import com.mamiyaotaru.voxelmap.RadarSettingsManager;
import com.mamiyaotaru.voxelmap.interfaces.IRadar;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.textures.FontRendererWithAtlas;
import com.mamiyaotaru.voxelmap.textures.Sprite;
import com.mamiyaotaru.voxelmap.textures.StitcherException;
import com.mamiyaotaru.voxelmap.textures.TextureAtlas;
import com.mamiyaotaru.voxelmap.util.Contact;
import com.mamiyaotaru.voxelmap.util.CustomMob;
import com.mamiyaotaru.voxelmap.util.CustomMobsManager;
import com.mamiyaotaru.voxelmap.util.EnumMobs;
import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mamiyaotaru.voxelmap.util.GLUtils;
import com.mamiyaotaru.voxelmap.util.GameVariableAccessShim;
import com.mamiyaotaru.voxelmap.util.ImageUtils;
import com.mamiyaotaru.voxelmap.util.LayoutVariables;
import com.mamiyaotaru.voxelmap.util.ReflectionUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EnderDragonRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.TropicalFishRenderer;
import net.minecraft.client.renderer.entity.model.BatModel;
import net.minecraft.client.renderer.entity.model.BeeModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.BlazeModel;
import net.minecraft.client.renderer.entity.model.ChickenModel;
import net.minecraft.client.renderer.entity.model.CowModel;
import net.minecraft.client.renderer.entity.model.CreeperModel;
import net.minecraft.client.renderer.entity.model.DolphinModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.GhastModel;
import net.minecraft.client.renderer.entity.model.GuardianModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.IllagerModel;
import net.minecraft.client.renderer.entity.model.IronGolemModel;
import net.minecraft.client.renderer.entity.model.MagmaCubeModel;
import net.minecraft.client.renderer.entity.model.OcelotModel;
import net.minecraft.client.renderer.entity.model.PhantomModel;
import net.minecraft.client.renderer.entity.model.PigModel;
import net.minecraft.client.renderer.entity.model.PolarBearModel;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.RabbitModel;
import net.minecraft.client.renderer.entity.model.RavagerModel;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.entity.model.SilverfishModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.entity.model.SnowManModel;
import net.minecraft.client.renderer.entity.model.SpiderModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.client.renderer.entity.model.TropicalFishAModel;
import net.minecraft.client.renderer.entity.model.TropicalFishBModel;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.entity.model.WolfModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.DownloadingTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.data.VillagerMetadataSection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.CaveSpiderEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.DrownedEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.monster.EndermiteEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.monster.HuskEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.MagmaCubeEntity;
import net.minecraft.entity.monster.PhantomEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.RavagerEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.monster.SilverfishEntity;
import net.minecraft.entity.monster.SkeletonEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.entity.monster.StrayEntity;
import net.minecraft.entity.monster.VexEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.BeeEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.DolphinEntity;
import net.minecraft.entity.passive.FoxEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.PolarBearEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.SnowGolemEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.passive.fish.CodEntity;
import net.minecraft.entity.passive.fish.PufferfishEntity;
import net.minecraft.entity.passive.fish.SalmonEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.entity.passive.horse.LlamaEntity;
import net.minecraft.entity.passive.horse.MuleEntity;
import net.minecraft.entity.passive.horse.SkeletonHorseEntity;
import net.minecraft.entity.passive.horse.TraderLlamaEntity;
import net.minecraft.entity.passive.horse.ZombieHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeableArmorItem;
import net.minecraft.item.DyeableHorseArmorItem;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.src.VoxelMapProtectedFieldsHelper;
import net.minecraft.tileentity.SkullTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;

public class Radar
implements IRadar {
    private Minecraft game;
    private IVoxelMap master = null;
    private LayoutVariables layoutVariables = null;
    public MapSettingsManager minimapOptions = null;
    public RadarSettingsManager options = null;
    private FontRendererWithAtlas fontRenderer;
    private TextureAtlas textureAtlas;
    private boolean newMobs = false;
    private boolean enabled = true;
    private boolean completedLoading = false;
    private int timer = 500;
    private float direction = 0.0f;
    private ArrayList<Contact> contacts = new ArrayList(40);
    public HashMap<String, Integer> mpContactsSkinGetTries = new HashMap();
    public HashMap<String, Integer> contactsSkinGetTries = new HashMap();
    private Sprite clothIcon = null;
    private static final int CLOTH = 0;
    private static final int CHAIN = 4;
    private static final int IRON = 5;
    private static final int GOLD = 6;
    private static final int DIAMOND = 7;
    private static final int TURTLE = 8;
    private static final int UNKNOWN = EnumMobs.UNKNOWN.ordinal();
    private String[] armorNames = new String[]{"cloth", "clothOverlay", "clothOuter", "clothOverlayOuter", "chain", "iron", "gold", "diamond", "netherite", "turtle"};
    private final float iconScale = 4.0f;
    private boolean randomobsOptifine = false;
    private Class<?> randomEntitiesClass = null;
    private Field mapPropertiesField = null;
    private Map<String, ?> mapProperties = null;
    private Field randomEntityField = null;
    private Object randomEntity = null;
    private Class<?> iRandomEntityClass = null;
    private Class<?> randomEntityClass = null;
    private Method setEntityMethod = null;
    private Class<?> randomEntitiesPropertiesClass = null;
    private Method getEntityTextureMethod = null;
    private boolean hasCustomNPCs = false;
    private Class<?> entityCustomNpcClass = null;
    private Class<?> modelDataClass = null;
    private Class<?> entityNPCInterfaceClass = null;
    private Field modelDataField = null;
    private Method getEntityMethod = null;
    private boolean lastOutlines = true;
    UUID devUUID = UUID.fromString("9b37abb9-2487-4712-bb96-21a1e0b2023c");
    private static final Int2ObjectMap<ResourceLocation> LEVEL_TO_ID = (Int2ObjectMap)Util.func_200696_a((Object)new Int2ObjectOpenHashMap(), int2ObjectOpenHashMap -> {
        int2ObjectOpenHashMap.put(1, (Object)new ResourceLocation("stone"));
        int2ObjectOpenHashMap.put(2, (Object)new ResourceLocation("iron"));
        int2ObjectOpenHashMap.put(3, (Object)new ResourceLocation("gold"));
        int2ObjectOpenHashMap.put(4, (Object)new ResourceLocation("emerald"));
        int2ObjectOpenHashMap.put(5, (Object)new ResourceLocation("diamond"));
    });

    public Radar(IVoxelMap master) {
        this.master = master;
        this.minimapOptions = master.getMapOptions();
        this.options = master.getRadarOptions();
        this.game = Minecraft.func_71410_x();
        this.fontRenderer = new FontRendererWithAtlas(this.game.func_110434_K(), new ResourceLocation("textures/font/ascii.png"));
        this.textureAtlas = new TextureAtlas("mobs");
        this.textureAtlas.func_174937_a(false, false);
        try {
            this.randomEntitiesClass = Class.forName("net.optifine.RandomEntities");
            this.mapPropertiesField = this.randomEntitiesClass.getDeclaredField("mapProperties");
            this.mapPropertiesField.setAccessible(true);
            this.mapProperties = (Map)this.mapPropertiesField.get(null);
            this.randomEntityField = this.randomEntitiesClass.getDeclaredField("randomEntity");
            this.randomEntityField.setAccessible(true);
            this.randomEntity = this.randomEntityField.get(null);
            this.iRandomEntityClass = Class.forName("net.optifine.IRandomEntity");
            this.randomEntityClass = Class.forName("net.optifine.RandomEntity");
            Class[] argClasses1 = new Class[]{Entity.class};
            this.setEntityMethod = this.randomEntityClass.getDeclaredMethod("setEntity", argClasses1);
            this.randomEntitiesPropertiesClass = Class.forName("net.optifine.RandomEntityProperties");
            Class[] argClasses2 = new Class[]{ResourceLocation.class, this.iRandomEntityClass};
            this.getEntityTextureMethod = this.randomEntitiesPropertiesClass.getDeclaredMethod("getTextureLocation", argClasses2);
            this.randomobsOptifine = true;
        }
        catch (ClassNotFoundException e) {
            this.randomobsOptifine = false;
        }
        catch (NoSuchMethodException e) {
            this.randomobsOptifine = false;
        }
        catch (NoSuchFieldException e) {
            this.randomobsOptifine = false;
        }
        catch (SecurityException e) {
            this.randomobsOptifine = false;
        }
        catch (IllegalArgumentException e) {
            this.randomobsOptifine = false;
        }
        catch (IllegalAccessException e) {
            this.randomobsOptifine = false;
        }
        try {
            this.entityCustomNpcClass = Class.forName("noppes.npcs.entity.EntityCustomNpc");
            this.modelDataClass = Class.forName("noppes.npcs.ModelData");
            this.modelDataField = this.entityCustomNpcClass.getField("modelData");
            this.entityNPCInterfaceClass = Class.forName("noppes.npcs.entity.EntityNPCInterface");
            this.getEntityMethod = this.modelDataClass.getMethod("getEntity", this.entityNPCInterfaceClass);
            this.hasCustomNPCs = true;
        }
        catch (ClassNotFoundException e) {
            this.hasCustomNPCs = false;
        }
        catch (NoSuchFieldException e) {
            this.hasCustomNPCs = false;
        }
        catch (NoSuchMethodException e) {
            this.hasCustomNPCs = false;
        }
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager) {
        this.loadTexturePackIcons();
        this.fontRenderer.func_195410_a(resourceManager);
    }

    private void loadTexturePackIcons() {
        this.completedLoading = false;
        try {
            this.mpContactsSkinGetTries.clear();
            this.contactsSkinGetTries.clear();
            this.textureAtlas.reset();
            EnumMobs.MOOSHROOM.secondaryResourceLocation = ReflectionUtils.classExists("com.prupe.mcpatcher.mob.MobOverlay") && ImageUtils.loadImage(new ResourceLocation("mcpatcher/mob/cow/mooshroom_overlay.png"), 0, 0, 1, 1) != null ? new ResourceLocation("mcpatcher/mob/cow/mooshroom_overlay.png") : new ResourceLocation("textures/block/red_mushroom.png");
            for (int t = 0; t < EnumMobs.values().length - 1; ++t) {
                String identifier = "minecraft." + EnumMobs.values()[t].id;
                String identifierSimple = EnumMobs.values()[t].id;
                String spriteName = identifier + EnumMobs.values()[t].resourceLocation.toString();
                spriteName = spriteName + (EnumMobs.values()[t].secondaryResourceLocation != null ? EnumMobs.values()[t].secondaryResourceLocation.toString() : "");
                BufferedImage mobImage = this.getCustomMobImage(identifier, identifierSimple);
                if (mobImage != null) {
                    this.textureAtlas.registerIconForBufferedImage(identifier + "custom", mobImage);
                    this.textureAtlas.registerMaskedIcon(spriteName, this.textureAtlas.getAtlasSpriteIncludingYetToBeStitched(identifier + "custom"));
                    continue;
                }
                this.textureAtlas.registerFailedIcon(identifier + "custom");
                mobImage = this.createImageFromTypeAndResourceLocations(EnumMobs.values()[t], EnumMobs.values()[t].resourceLocation, EnumMobs.values()[t].secondaryResourceLocation, null);
                if (mobImage == null) continue;
                float scale = (float)mobImage.getWidth() / EnumMobs.values()[t].expectedWidth;
                mobImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobImage, 4.0f / scale)), this.options.outlines, 2);
                this.textureAtlas.registerIconForBufferedImage(spriteName, mobImage);
            }
            BufferedImage[] armorImages = new BufferedImage[]{ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1.png"), 40, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1_overlay.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/leather_layer_1_overlay.png"), 40, 8, 8, 8), ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/chainmail_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/chainmail_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/iron_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/iron_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/gold_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/gold_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/diamond_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/diamond_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.addImages(ImageUtils.loadImage(new ResourceLocation("textures/models/armor/turtle_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new ResourceLocation("textures/models/armor/turtle_layer_1.png"), 40, 8, 8, 8), 0.0f, 0.0f, 8, 8)};
            for (int t = 0; t < armorImages.length; ++t) {
                float scale = (float)armorImages[t].getWidth() / 8.0f;
                armorImages[t] = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorImages[t], 4.0f / scale)), this.options.outlines && t != 2 && t != 3, true, 32, 2);
                Sprite icon = this.textureAtlas.registerIconForBufferedImage("armor " + this.armorNames[t], armorImages[t]);
                if (t != 0) continue;
                this.clothIcon = icon;
            }
            BufferedImage sheepFur = ImageUtils.loadImage(new ResourceLocation("textures/entity/sheep/sheep_fur.png"), 6, 6, 6, 6);
            float scale = (float)sheepFur.getWidth() / 6.0f;
            sheepFur = ImageUtils.scaleImage(sheepFur, 4.0f / scale * 1.0625f);
            int chop = (int)Math.max(1.0f, 2.0f);
            sheepFur = ImageUtils.eraseArea(sheepFur, chop, chop, sheepFur.getWidth() - chop * 2, sheepFur.getHeight() - chop * 2, sheepFur.getWidth(), sheepFur.getHeight());
            sheepFur = ImageUtils.fillOutline(ImageUtils.pad(sheepFur), this.options.outlines, true, 27, (int)Math.max(1.0f, 2.0f));
            this.textureAtlas.registerIconForBufferedImage("sheepfur", sheepFur);
            BufferedImage crown = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/crown.png"), 0, 0, 16, 16, 16, 16);
            crown = ImageUtils.fillOutline(ImageUtils.scaleImage(crown, 2.0f), this.options.outlines, true, 32, 2);
            this.textureAtlas.registerIconForBufferedImage("crown", crown);
            BufferedImage glow = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/glow.png"), 0, 0, 16, 16, 16, 16);
            glow = ImageUtils.fillOutline(glow, this.options.outlines, true, 32, 2);
            this.textureAtlas.registerIconForBufferedImage("glow", glow);
            ResourceLocation fontResourceLocation = new ResourceLocation("textures/font/ascii.png");
            BufferedImage fontImage = ImageUtils.loadImage(fontResourceLocation, 0, 0, 128, 128, 128, 128);
            if (fontImage.getWidth() > 1024 || fontImage.getHeight() > 1024) {
                int maxDim = Math.max(fontImage.getWidth(), fontImage.getHeight());
                float scaleBy = 1024.0f / (float)maxDim;
                fontImage = ImageUtils.scaleImage(fontImage, scaleBy);
            }
            Sprite fontSprite = this.textureAtlas.registerIconForBufferedImage(fontResourceLocation.toString(), fontImage);
            this.fontRenderer.setFontSprite(fontSprite);
            this.fontRenderer.setFontRef(this.textureAtlas.func_110552_b());
            this.textureAtlas.stitch();
            this.completedLoading = true;
        }
        catch (Exception e) {
            System.err.println("Failed getting mobs " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private BufferedImage createImageFromTypeAndResourceLocations(EnumMobs type, ResourceLocation resourceLocation, ResourceLocation resourceLocationSecondary, Entity entity) {
        BufferedImage mobImage = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
        BufferedImage mobImageSecondary = null;
        if (resourceLocationSecondary != null) {
            mobImageSecondary = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationSecondary);
        }
        try {
            return this.createImageFromTypeAndImages(type, mobImage, mobImageSecondary, entity);
        }
        catch (Exception e) {
            return null;
        }
    }

    private BufferedImage createImageFromTypeAndImages(EnumMobs type, BufferedImage mobImage, BufferedImage mobImageSecondary, Entity entity) {
        BufferedImage image = null;
        switch (type) {
            case GENERICHOSTILE: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/hostile.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICNEUTRAL: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/neutral.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case GENERICTAME: {
                image = ImageUtils.loadImage(new ResourceLocation("voxelmap", "images/radar/tame.png"), 0, 0, 16, 16, 16, 16);
                break;
            }
            case BAT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 64, 64), ImageUtils.loadImage(mobImage, 25, 1, 3, 4), 0.0f, 0.0f, 8, 12), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 25, 1, 3, 4)), 5.0f, 0.0f, 8, 12), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 3.0f, 8, 12);
                break;
            }
            case BEE: {
                image = ImageUtils.loadImage(mobImage, 10, 10, 7, 7);
                break;
            }
            case BLAZE: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case CAVESPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case CHICKEN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 2, 3, 6, 6), ImageUtils.loadImage(mobImage, 16, 2, 4, 2), 1.0f, 2.0f, 6, 6), ImageUtils.loadImage(mobImage, 16, 6, 2, 2), 2.0f, 4.0f, 6, 6);
                break;
            }
            case COD: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 5, 32, 32), ImageUtils.loadImage(mobImage, 15, 3, 1, 3, 32, 32), 1.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 16, 3, 3, 4, 32, 32), 2.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 9, 7, 7, 4, 32, 32), 5.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 26, 7, 4, 4, 32, 32), 12.0f, 1.0f, 16, 5), ImageUtils.loadImage(mobImage, 26, 0, 6, 1, 32, 32), 4.0f, 0.0f, 16, 5);
                break;
            }
            case COW: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 10), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 1.0f, 1.0f, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 0.0f, 0.0f, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 9.0f, 0.0f, 10, 10);
                break;
            }
            case CREEPER: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case DOLPHIN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 10), ImageUtils.loadImage(mobImage, 0, 6, 6, 7), 0.0f, 1.0f, 10, 10), ImageUtils.loadImage(mobImage, 0, 17, 4, 2), 6.0f, 6.0f, 10, 10);
                break;
            }
            case DROWNED: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImageSecondary, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImageSecondary, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case ENDERDRAGON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 20, 256, 256), ImageUtils.loadImage(mobImage, 128, 46, 16, 16, 256, 256), 0.0f, 4.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 60, 12, 5, 256, 256), 2.0f, 11.0f, 16, 16), ImageUtils.loadImage(mobImage, 192, 81, 12, 4, 256, 256), 2.0f, 16.0f, 16, 16), ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256), 3.0f, 0.0f, 16, 16), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256)), 11.0f, 0.0f, 16, 16);
                break;
            }
            case ENDERMAN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 8, 24, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImageSecondary, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case ENDERMITE: {
                image = ImageUtils.loadImage(mobImage, 2, 2, 4, 3);
                break;
            }
            case EVOKER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case GHAST: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case GHASTATTACKING: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case GUARDIAN: {
                image = ImageUtils.scaleImage(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12), 0.5f);
                break;
            }
            case GUARDIANELDER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 16, 16, 12, 12), ImageUtils.loadImage(mobImage, 9, 1, 2, 2), 5.0f, 5.5f, 12, 12);
                break;
            }
            case HORSE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 24, 64, 64), ImageUtils.loadImage(mobImage, 56, 38, 2, 16, 64, 64), 1.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 42, 7, 12, 64, 64), 3.0f, 12.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 20, 7, 5, 64, 64), 3.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 30, 5, 5, 64, 64), 10.0f, 7.0f, 16, 24), ImageUtils.loadImage(mobImage, 19, 17, 1, 3, 64, 64), 3.0f, 4.0f, 16, 24), ImageUtils.loadImage(mobImage, 0, 13, 1, 7, 64, 64), 3.0f, 0.0f, 16, 24);
                break;
            }
            case HUSK: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), ImageUtils.loadImage(mobImage, 40, 8, 8, 8, 64, 64), 0.0f, 0.0f, 8, 8);
                break;
            }
            case ILLUSIONER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case IRONGOLEM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 128, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 128, 128), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 128, 128), 3.0f, 8.0f, 8, 12);
                break;
            }
            case LLAMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 14, 128, 64), ImageUtils.loadImage(mobImage, 6, 20, 8, 8, 128, 64), 0.0f, 3.0f, 8, 14), ImageUtils.loadImage(mobImage, 9, 9, 4, 4, 128, 64), 2.0f, 5.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 0.0f, 0.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 5.0f, 0.0f, 8, 14);
                break;
            }
            case LLAMATRADER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 14, 128, 64), ImageUtils.loadImage(mobImage, 6, 20, 8, 8, 128, 64), 0.0f, 3.0f, 8, 14), ImageUtils.loadImage(mobImage, 9, 9, 4, 4, 128, 64), 2.0f, 5.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 0.0f, 0.0f, 8, 14), ImageUtils.loadImage(mobImage, 19, 2, 3, 3, 128, 64), 5.0f, 0.0f, 8, 14);
                break;
            }
            case MAGMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 32, 18, 8, 1), 0.0f, 3.0f, 8, 8), ImageUtils.loadImage(mobImage, 32, 27, 8, 1), 0.0f, 4.0f, 8, 8);
                break;
            }
            case MOOSHROOM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 40, 40), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 16.0f, 16.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 15.0f, 15.0f, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 24.0f, 15.0f, 40, 40);
                if (mobImageSecondary == null) break;
                BufferedImage mushroomImage = mobImageSecondary.getWidth() != mobImageSecondary.getHeight() ? ImageUtils.loadImage(mobImageSecondary, 32, 0, 16, 16, 48, 16) : ImageUtils.loadImage(mobImageSecondary, 0, 0, 16, 16, 16, 16);
                float ratio = (float)image.getWidth() / (float)mushroomImage.getWidth();
                if ((double)ratio < 2.5) {
                    image = ImageUtils.scaleImage(image, 2.5f / ratio);
                } else if ((double)ratio > 2.5) {
                    mushroomImage = ImageUtils.scaleImage(mushroomImage, ratio / 2.5f);
                }
                image = ImageUtils.addImages(image, mushroomImage, 12.0f, 0.0f, 40, 40);
                break;
            }
            case PARROT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8, 32, 32), ImageUtils.loadImage(mobImage, 2, 22, 3, 5, 32, 32), 1.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 10, 4, 4, 1, 32, 32), 2.0f, 4.0f, 8, 8), ImageUtils.loadImage(mobImage, 2, 4, 2, 3, 32, 32), 2.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 11, 8, 1, 2, 32, 32), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 16, 8, 1, 2, 32, 32), 5.0f, 5.0f, 8, 8);
                break;
            }
            case PHANTOM: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 5, 5, 7, 3, 64, 64), ImageUtils.loadImage(mobImageSecondary, 5, 5, 7, 3, 64, 64), 0.0f, 0.0f, 7, 3);
                break;
            }
            case PIG: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 16, 17, 6, 3), 1.0f, 4.0f, 8, 8);
                break;
            }
            case PIGZOMBIE: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case PLAYER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case POLARBEAR: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 9, 8, 128, 64), ImageUtils.loadImage(mobImage, 27, 1, 2, 2, 128, 64), 0.0f, 0.0f, 9, 8), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 27, 1, 2, 2, 128, 64)), 7.0f, 0.0f, 9, 8), ImageUtils.loadImage(mobImage, 7, 7, 7, 7, 128, 64), 1.0f, 1.0f, 9, 8), ImageUtils.loadImage(mobImage, 3, 47, 5, 3, 128, 64), 2.0f, 5.0f, 9, 8);
                break;
            }
            case PUFFERFISH: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 3, 3, 32, 32), ImageUtils.loadImage(mobImage, 3, 30, 3, 2, 32, 32), 0.0f, 1.0f, 3, 3), ImageUtils.loadImage(mobImage, 3, 29, 1, 1, 32, 32), 0.0f, 0.0f, 3, 3), ImageUtils.loadImage(mobImage, 5, 29, 1, 1, 32, 32), 2.0f, 0.0f, 3, 3);
                break;
            }
            case PUFFERFISHHALF: {
                image = ImageUtils.loadImage(mobImage, 17, 27, 5, 5, 32, 32);
                break;
            }
            case PUFFERFISHFULL: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 32, 32);
                break;
            }
            case RABBIT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 10), ImageUtils.loadImage(mobImage, 37, 5, 5, 4), 0.0f, 5.0f, 5, 10), ImageUtils.loadImage(mobImage, 33, 10, 1, 1), 2.0f, 7.5f, 5, 10), ImageUtils.loadImage(mobImage, 53, 1, 2, 5), 0.0f, 0.0f, 5, 10), ImageUtils.loadImage(mobImage, 59, 1, 2, 5), 3.0f, 0.0f, 5, 10);
                break;
            }
            case SALMON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 26, 7, 32, 32), ImageUtils.loadImage(mobImage, 27, 3, 3, 4, 32, 32), 1.0f, 2.5f, 26, 7), ImageUtils.loadImage(mobImage, 11, 8, 8, 5, 32, 32), 4.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 11, 21, 8, 5, 32, 32), 12.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 26, 16, 6, 5, 32, 32), 20.0f, 2.0f, 26, 7), ImageUtils.loadImage(mobImage, 0, 0, 2, 2, 32, 32), 10.0f, 0.0f, 26, 7), ImageUtils.loadImage(mobImage, 5, 6, 3, 2, 32, 32), 12.0f, 0.0f, 26, 7);
                break;
            }
            case SHEEP: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 6, 6);
                break;
            }
            case SHULKER: {
                image = ImageUtils.loadImage(mobImage, 6, 58, 6, 6);
                break;
            }
            case SILVERFISH: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 22, 20, 6, 6), ImageUtils.loadImage(mobImage, 2, 2, 3, 2), 2.0f, 2.0f, 6, 6);
                break;
            }
            case SKELETON: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SKELETONWITHER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SLIME: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 22, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 6, 2, 2), 5.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 34, 2, 2, 2), 1.0f, 2.0f, 8, 8), ImageUtils.loadImage(mobImage, 33, 9, 1, 1), 4.0f, 5.0f, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case SNOWGOLEM: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case SPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case STRAY: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImageSecondary, 8, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8), ImageUtils.loadImage(mobImageSecondary, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                break;
            }
            case TROPICALFISHA: {
                float[] primaryColorsA = new float[]{0.9765f, 0.502f, 0.1137f};
                float[] secondaryColorsA = new float[]{0.9765f, 1.0f, 0.9961f};
                if (entity != null && entity instanceof TropicalFishEntity) {
                    TropicalFishEntity fish = (TropicalFishEntity)entity;
                    primaryColorsA = fish.func_204219_dC();
                    secondaryColorsA = fish.func_204222_dD();
                }
                BufferedImage baseA = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 6, 32, 32), ImageUtils.loadImage(mobImage, 8, 6, 6, 3, 32, 32), 0.0f, 3.0f, 10, 6), ImageUtils.loadImage(mobImage, 17, 1, 5, 3, 32, 32), 1.0f, 0.0f, 10, 6), ImageUtils.loadImage(mobImage, 28, 0, 4, 3, 32, 32), 6.0f, 3.0f, 10, 6), primaryColorsA[0], primaryColorsA[1], primaryColorsA[2]);
                BufferedImage patternA = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 10, 6, 32, 32), ImageUtils.loadImage(mobImageSecondary, 8, 6, 6, 3, 32, 32), 0.0f, 3.0f, 10, 6), ImageUtils.loadImage(mobImageSecondary, 17, 1, 5, 3, 32, 32), 1.0f, 0.0f, 10, 6), ImageUtils.loadImage(mobImageSecondary, 28, 0, 4, 3, 32, 32), 6.0f, 3.0f, 10, 6), secondaryColorsA[0], secondaryColorsA[1], secondaryColorsA[2]);
                image = ImageUtils.addImages(baseA, patternA, 0.0f, 0.0f, 10, 6);
                break;
            }
            case TROPICALFISHB: {
                float[] primaryColorsB = new float[]{0.5373f, 0.1961f, 0.7216f};
                float[] secondaryColorsB = new float[]{0.9961f, 0.8471f, 0.2392f};
                if (entity != null && entity instanceof TropicalFishEntity) {
                    TropicalFishEntity fish = (TropicalFishEntity)entity;
                    primaryColorsB = fish.func_204219_dC();
                    secondaryColorsB = fish.func_204222_dD();
                }
                BufferedImage baseB = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 12, 12, 32, 32), ImageUtils.loadImage(mobImage, 0, 26, 6, 6, 32, 32), 6.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 21, 6, 6, 32, 32), 0.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 18, 5, 3, 32, 32), 6.0f, 0.0f, 12, 12), ImageUtils.loadImage(mobImage, 20, 27, 5, 3, 32, 32), 6.0f, 9.0f, 12, 12), primaryColorsB[0], primaryColorsB[1], primaryColorsB[2]);
                BufferedImage patternB = ImageUtils.colorify(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 12, 12, 32, 32), ImageUtils.loadImage(mobImageSecondary, 0, 26, 6, 6, 32, 32), 6.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 21, 6, 6, 32, 32), 0.0f, 3.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 18, 5, 3, 32, 32), 6.0f, 0.0f, 12, 12), ImageUtils.loadImage(mobImageSecondary, 20, 27, 5, 3, 32, 32), 6.0f, 9.0f, 12, 12), secondaryColorsB[0], secondaryColorsB[1], secondaryColorsB[2]);
                image = ImageUtils.addImages(baseB, patternB, 0.0f, 0.0f, 12, 12);
                break;
            }
            case TURTLE: {
                image = ImageUtils.loadImage(mobImage, 3, 6, 6, 5, 128, 64);
                break;
            }
            case VEX: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case VEXCHARGING: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case VILLAGER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImageSecondary, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 40, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImageSecondary, 40, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case VINDICATOR: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
                break;
            }
            case WITCH: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 16, 64, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 128), 1.0f, 5.0f, 10, 16), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 128), 4.0f, 12.0f, 10, 16), ImageUtils.loadImage(mobImage, 10, 74, 10, 3, 64, 128), 0.0f, 4.0f, 10, 16), ImageUtils.loadImage(mobImage, 7, 83, 7, 4, 64, 128), 1.5f, 0.0f, 10, 16), ImageUtils.loadImage(mobImage, 1, 1, 1, 1, 64, 128), 5.0f, 14.0f, 10, 16);
                break;
            }
            case WITHER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2.0f, 24, 10);
                break;
            }
            case WITHERINVULNERABLE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2.0f, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2.0f, 24, 10);
                break;
            }
            case ZOMBIE: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), ImageUtils.loadImage(mobImage, 40, 8, 8, 8, 64, 64), 0.0f, 0.0f, 8, 8);
                break;
            }
            case ZOMBIEVILLAGER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImageSecondary, 8, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 40, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImageSecondary, 40, 8, 8, 10, 64, 64), 0.0f, 1.0f, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8.0f, 8, 12);
            }
        }
        return image;
    }

    @Override
    public void OnTickInGame(Minecraft mc, LayoutVariables layoutVariables) {
        if (!(this.options.radarAllowed.booleanValue() || this.options.radarMobsAllowed.booleanValue() || this.options.radarPlayersAllowed.booleanValue())) {
            return;
        }
        if (this.game == null) {
            this.game = mc;
        }
        this.layoutVariables = layoutVariables;
        if (this.options.isChanged()) {
            this.timer = 500;
            if (this.options.outlines != this.lastOutlines) {
                this.lastOutlines = this.options.outlines;
                this.loadTexturePackIcons();
            }
        }
        this.direction = GameVariableAccessShim.rotationYaw() + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (this.enabled) {
            if (this.completedLoading && this.timer > 95) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            if (this.completedLoading) {
                this.renderMapMobs(this.layoutVariables.mapX, this.layoutVariables.mapY);
            }
            GLShim.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private int chkLen(String paramStr) {
        return this.fontRenderer.func_78256_a(paramStr);
    }

    private void write(String paramStr, float x, float y, int color) {
        GLShim.glTexParameteri(3553, 10241, 9728);
        GLShim.glTexParameteri(3553, 10240, 9728);
        this.fontRenderer.func_175063_a(paramStr, x, y, color);
    }

    public void calculateMobs() {
        this.contacts.clear();
        Iterable entities = this.game.field_71441_e.func_217416_b();
        for (Entity entity : entities) {
            try {
                String scrubbedName;
                if (entity == null || entity.func_98034_c((PlayerEntity)this.game.field_71439_g) || (!this.options.showHostiles || !this.options.radarAllowed.booleanValue() && !this.options.radarMobsAllowed.booleanValue() || !this.isHostile(entity)) && (!this.options.showPlayers || !this.options.radarAllowed.booleanValue() && !this.options.radarPlayersAllowed.booleanValue() || !this.isPlayer(entity)) && (!this.options.showNeutrals || !this.options.radarMobsAllowed.booleanValue() || !this.isNeutral(entity))) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.func_226277_ct_();
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.func_226281_cx_();
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.func_226278_cu_();
                double hypot = wayX * wayX + wayZ * wayZ + wayY * wayY;
                if (!((hypot /= this.layoutVariables.zoomScaleAdjusted * this.layoutVariables.zoomScaleAdjusted) < 961.0)) continue;
                if (this.hasCustomNPCs) {
                    try {
                        Object modelData;
                        LivingEntity wrappedEntity;
                        if (this.entityCustomNpcClass.isInstance(entity) && (wrappedEntity = (LivingEntity)this.getEntityMethod.invoke(modelData = this.modelDataField.get(entity), entity)) != null) {
                            entity = wrappedEntity;
                        }
                    }
                    catch (Exception modelData) {
                        // empty catch block
                    }
                }
                Contact contact = new Contact(entity, this.getContactTypeStrict(entity));
                String unscrubbedName = contact.entity.func_145748_c_().func_150254_d();
                contact.setName(unscrubbedName);
                if (contact.entity.func_184187_bx() != null) {
                    contact.yFudge = 1;
                }
                contact.updateLocation();
                boolean enabled = false;
                if (!contact.vanillaType) {
                    String type = entity.func_200600_R().func_210760_d();
                    CustomMob customMob = CustomMobsManager.getCustomMobByType(type);
                    if (customMob == null || customMob.enabled) {
                        enabled = true;
                    }
                } else if (contact.type.enabled) {
                    enabled = true;
                }
                if (!enabled) continue;
                if (contact.type == EnumMobs.PLAYER) {
                    this.handleMPplayer(contact);
                }
                if (contact.icon == null) {
                    this.tryCustomIcon(contact);
                }
                if (contact.icon == null) {
                    this.tryAutoIcon(contact);
                }
                if (contact.icon == null) {
                    this.tryFallbackType(contact);
                }
                if (contact.type == EnumMobs.HORSE) {
                    contact.setRotationFactor(45);
                }
                if ((scrubbedName = TextUtils.scrubCodes(contact.entity.func_200200_C_().getString())) != null && (scrubbedName.equals("Dinnerbone") || scrubbedName.equals("Grumm")) && (!(contact.entity instanceof PlayerEntity) || ((PlayerEntity)contact.entity).func_175148_a(PlayerModelPart.CAPE))) {
                    contact.setRotationFactor(contact.rotationFactor + 180);
                }
                if (this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER || contact.type == EnumMobs.SHEEP) {
                    this.getArmor(contact, entity);
                }
                this.contacts.add(contact);
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        if (this.newMobs) {
            try {
                this.textureAtlas.stitchNew();
            }
            catch (StitcherException e) {
                System.err.println("Stitcher exception!  Resetting mobs texture atlas.");
                this.loadTexturePackIcons();
            }
        }
        this.newMobs = false;
        Collections.sort(this.contacts, new Comparator<Contact>(){

            @Override
            public int compare(Contact contact1, Contact contact2) {
                return contact1.y - contact2.y;
            }
        });
    }

    private void tryCustomIcon(Contact contact) {
        String identifier = contact.vanillaType ? "minecraft." + contact.type.id : contact.entity.getClass().getName();
        String identifierSimple = contact.vanillaType ? contact.type.id : contact.entity.getClass().getSimpleName();
        Sprite icon = this.textureAtlas.getAtlasSprite(identifier + "custom");
        if (icon == this.textureAtlas.getMissingImage()) {
            boolean isHostile = this.isHostile(contact.entity);
            CustomMobsManager.add(contact.entity.func_200600_R().func_210760_d(), isHostile, !isHostile);
            BufferedImage mobSkin = this.getCustomMobImage(identifier, identifierSimple);
            if (mobSkin != null) {
                icon = this.textureAtlas.registerIconForBufferedImage(identifier + "custom", mobSkin);
                this.newMobs = true;
                contact.icon = icon;
                contact.custom = true;
            } else {
                this.textureAtlas.registerFailedIcon(identifier + "custom");
            }
        } else if (icon != this.textureAtlas.getFailedImage()) {
            contact.custom = true;
            contact.icon = icon;
        }
    }

    private BufferedImage getCustomMobImage(String identifier, String identifierSimple) {
        BufferedImage mobSkin = null;
        try {
            int intendedSize = 8;
            String fullPath = ("textures/icons/" + identifier + ".png").toLowerCase();
            InputStream is = null;
            try {
                is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
            }
            catch (IOException e) {
                is = null;
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + ".png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifier + "8.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + "8.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                intendedSize = 16;
                fullPath = ("textures/icons/" + identifier + "16.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + "16.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                intendedSize = 32;
                fullPath = ("textures/icons/" + identifier + "32.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is == null) {
                fullPath = ("textures/icons/" + identifierSimple + "32.png").toLowerCase();
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
            }
            if (is != null) {
                mobSkin = ImageIO.read(is);
                is.close();
                mobSkin = ImageUtils.loadImage(mobSkin, 0, 0, mobSkin.getWidth(), mobSkin.getHeight(), mobSkin.getWidth(), mobSkin.getHeight());
                float scale = (float)mobSkin.getWidth() / (float)intendedSize;
                mobSkin = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(mobSkin, 4.0f / scale)), this.options.outlines, 2);
            }
        }
        catch (Exception e) {
            mobSkin = null;
        }
        return mobSkin;
    }

    private void tryAutoIcon(Contact contact) {
        block39: {
            EntityRenderer render = this.game.func_175598_ae().func_78713_a(contact.entity);
            ResourceLocation resourceLocation = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity);
            resourceLocation = this.getRandomizedResourceLocationForEntity(resourceLocation, contact.entity);
            ResourceLocation resourceLocationSecondary = null;
            ResourceLocation resourceLocationTertiary = null;
            ResourceLocation resourceLocationQuaternary = null;
            String color = "";
            if (contact.type.secondaryResourceLocation != null) {
                if (contact.type == EnumMobs.MOOSHROOM) {
                    resourceLocationSecondary = !((MooshroomEntity)contact.entity).func_70631_g_() ? EnumMobs.MOOSHROOM.secondaryResourceLocation : null;
                } else if (contact.type == EnumMobs.TROPICALFISHA || contact.type == EnumMobs.TROPICALFISHB) {
                    TropicalFishEntity fish = (TropicalFishEntity)contact.entity;
                    resourceLocationSecondary = fish.func_204220_dF();
                    color = fish.func_204219_dC() + " " + fish.func_204222_dD();
                } else if (contact.type == EnumMobs.HORSE) {
                    ItemStack itemStack = ((HorseEntity)contact.entity).func_213803_dV();
                    if (this.options.showHelmetsMobs && itemStack.func_77973_b() instanceof HorseArmorItem) {
                        HorseArmorItem horseArmorItem = (HorseArmorItem)itemStack.func_77973_b();
                        resourceLocationTertiary = horseArmorItem.func_219976_d();
                        if (horseArmorItem instanceof DyeableHorseArmorItem) {
                            contact.armorColor = ((DyeableHorseArmorItem)horseArmorItem).func_200886_f(itemStack);
                        }
                    }
                } else if (contact.type == EnumMobs.VILLAGER || contact.type == EnumMobs.ZOMBIEVILLAGER) {
                    String zombie = contact.type == EnumMobs.ZOMBIEVILLAGER ? "zombie_" : "";
                    VillagerData villagerData = ((IVillagerDataHolder)contact.entity).func_213700_eh();
                    IVillagerType villagerType = villagerData.func_221129_a();
                    VillagerProfession villagerProfession = villagerData.func_221130_b();
                    resourceLocationSecondary = Registry.field_218369_K.func_177774_c((Object)villagerType);
                    resourceLocationSecondary = new ResourceLocation(resourceLocationSecondary.func_110624_b(), "textures/entity/" + zombie + "villager/type/" + resourceLocationSecondary.func_110623_a() + ".png");
                    if (villagerProfession != VillagerProfession.field_221151_a && !((LivingEntity)contact.entity).func_70631_g_()) {
                        resourceLocationTertiary = Registry.field_218370_L.func_177774_c((Object)villagerProfession);
                        resourceLocationTertiary = new ResourceLocation(resourceLocationTertiary.func_110624_b(), "textures/entity/" + zombie + "villager/profession/" + resourceLocationTertiary.func_110623_a() + ".png");
                        if (villagerProfession != VillagerProfession.field_221162_l) {
                            resourceLocationQuaternary = (ResourceLocation)LEVEL_TO_ID.get(MathHelper.func_76125_a((int)villagerData.func_221132_c(), (int)1, (int)LEVEL_TO_ID.size()));
                            resourceLocationQuaternary = new ResourceLocation(resourceLocationQuaternary.func_110624_b(), "textures/entity/" + zombie + "villager/profession_level/" + resourceLocationQuaternary.func_110623_a() + ".png");
                        }
                    }
                } else {
                    resourceLocationSecondary = contact.type.secondaryResourceLocation;
                }
                if (resourceLocationSecondary != null) {
                    resourceLocationSecondary = this.getRandomizedResourceLocationForEntity(resourceLocationSecondary, (Entity)((LivingEntity)contact.entity));
                }
                if (resourceLocationTertiary != null) {
                    resourceLocationTertiary = this.getRandomizedResourceLocationForEntity(resourceLocationTertiary, (Entity)((LivingEntity)contact.entity));
                }
                if (resourceLocationQuaternary != null) {
                    resourceLocationQuaternary = this.getRandomizedResourceLocationForEntity(resourceLocationQuaternary, (Entity)((LivingEntity)contact.entity));
                }
            }
            String entityName = contact.vanillaType ? "minecraft." + contact.type.id : contact.entity.getClass().getName();
            String resourceLocationString = (resourceLocation != null ? resourceLocation.toString() : "") + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "");
            resourceLocationString = resourceLocationString + (resourceLocationTertiary != null ? resourceLocationTertiary.toString() : "") + (resourceLocationQuaternary != null ? resourceLocationQuaternary.toString() : "");
            resourceLocationString = resourceLocationString + (contact.armorColor != -1 ? Integer.valueOf(contact.armorColor) : "");
            String name = entityName + color + resourceLocationString;
            Sprite icon = this.textureAtlas.getAtlasSprite(name);
            if (icon == this.textureAtlas.getMissingImage()) {
                Integer n;
                Integer checkCount = this.contactsSkinGetTries.get(name);
                if (checkCount == null) {
                    checkCount = 0;
                }
                BufferedImage mobImage = null;
                if (contact.type == EnumMobs.HORSE) {
                    Texture textureObject = GLUtils.textureManager.func_229267_b_(resourceLocation);
                    if (textureObject != null) {
                        BufferedImage base = ImageUtils.createBufferedImageFromGLID(textureObject.func_110552_b());
                        if (resourceLocationSecondary != null) {
                            BufferedImage pattern = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationSecondary);
                            pattern = ImageUtils.scaleImage(pattern, (float)base.getWidth() / (float)pattern.getWidth(), (float)base.getHeight() / (float)pattern.getHeight());
                            base = ImageUtils.addImages(base, pattern, 0.0f, 0.0f, base.getWidth(), base.getHeight());
                        }
                        mobImage = this.createImageFromTypeAndImages(contact.type, base, null, contact.entity);
                        if (resourceLocationTertiary != null) {
                            BufferedImage armor = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationTertiary);
                            armor = ImageUtils.scaleImage(armor, (float)base.getWidth() / (float)armor.getWidth(), (float)base.getHeight() / (float)armor.getHeight());
                            armor = ImageUtils.colorify(armor, contact.armorColor);
                            base = ImageUtils.addImages(base, armor, 0.0f, 0.0f, base.getWidth(), base.getHeight());
                        }
                        mobImage = this.createImageFromTypeAndImages(contact.type, base, null, contact.entity);
                    }
                } else if (contact.type == EnumMobs.VILLAGER || contact.type == EnumMobs.ZOMBIEVILLAGER) {
                    VillagerMetadataSection.HatType biomeHatType = this.getHatType(resourceLocationSecondary);
                    VillagerMetadataSection.HatType professionHatType = this.getHatType(resourceLocationTertiary);
                    boolean showBiomeHat = professionHatType == VillagerMetadataSection.HatType.NONE || professionHatType == VillagerMetadataSection.HatType.PARTIAL && biomeHatType != VillagerMetadataSection.HatType.FULL;
                    BufferedImage base = ImageUtils.createBufferedImageFromResourceLocation(resourceLocation);
                    if (showBiomeHat) {
                        BufferedImage biomeSkin = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationSecondary);
                        biomeSkin = ImageUtils.scaleImage(biomeSkin, (float)base.getWidth() / (float)biomeSkin.getWidth(), (float)base.getHeight() / (float)biomeSkin.getHeight());
                        base = ImageUtils.addImages(base, biomeSkin, 0.0f, 0.0f, base.getWidth(), base.getHeight());
                    }
                    BufferedImage overlay = null;
                    if (resourceLocationTertiary != null) {
                        BufferedImage professionSkin = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationTertiary);
                        if (resourceLocationQuaternary != null) {
                            BufferedImage levelSkin = ImageUtils.createBufferedImageFromResourceLocation(resourceLocationQuaternary);
                            levelSkin = ImageUtils.scaleImage(levelSkin, (float)professionSkin.getWidth() / (float)levelSkin.getWidth(), (float)professionSkin.getHeight() / (float)levelSkin.getHeight());
                            professionSkin = ImageUtils.addImages(professionSkin, levelSkin, 0.0f, 0.0f, professionSkin.getWidth(), professionSkin.getHeight());
                        }
                        overlay = professionSkin = ImageUtils.scaleImage(professionSkin, (float)base.getWidth() / (float)professionSkin.getWidth(), (float)base.getHeight() / (float)professionSkin.getHeight());
                    } else {
                        overlay = ImageUtils.blankImage(resourceLocation.toString(), base.getWidth(), base.getHeight(), base.getWidth(), base.getHeight());
                    }
                    mobImage = this.createImageFromTypeAndImages(contact.type, base, overlay, contact.entity);
                } else {
                    mobImage = this.createImageFromTypeAndResourceLocations(contact.type, resourceLocation, resourceLocationSecondary, contact.entity);
                }
                if (mobImage == null) {
                    mobImage = this.createAutoIconImageFromResourceLocations(contact, (EntityRenderer<? extends Entity>)render, resourceLocation, resourceLocationSecondary);
                    contact.auto = true;
                }
                if (mobImage != null) {
                    try {
                        BufferedImage trimmedImage = this.trimAndOutlineImage(contact, mobImage);
                        contact.icon = icon = this.textureAtlas.registerIconForBufferedImage(name, trimmedImage);
                        this.newMobs = true;
                        this.contactsSkinGetTries.remove(name);
                    }
                    catch (Exception e) {
                        n = checkCount;
                        Integer n2 = checkCount = Integer.valueOf(checkCount + 1);
                        if (checkCount > 4) {
                            this.textureAtlas.registerFailedIcon(name);
                            this.contactsSkinGetTries.remove(name);
                            break block39;
                        }
                        this.contactsSkinGetTries.put(name, checkCount);
                    }
                } else {
                    Integer n3 = checkCount;
                    n = checkCount = Integer.valueOf(checkCount + 1);
                    if (checkCount > 4) {
                        this.textureAtlas.registerFailedIcon(name);
                        this.contactsSkinGetTries.remove(name);
                    } else {
                        this.contactsSkinGetTries.put(name, checkCount);
                    }
                }
            } else if (icon != this.textureAtlas.getFailedImage()) {
                contact.icon = icon;
            }
        }
    }

    public VillagerMetadataSection.HatType getHatType(ResourceLocation resourceLocation) {
        VillagerMetadataSection.HatType hatType = VillagerMetadataSection.HatType.NONE;
        if (resourceLocation != null) {
            try {
                IResource resource = this.game.func_195551_G().func_199002_a(resourceLocation);
                if (resource != null) {
                    VillagerMetadataSection villagerResourceMetadata = (VillagerMetadataSection)resource.func_199028_a((IMetadataSectionSerializer)VillagerMetadataSection.field_217827_a);
                    if (villagerResourceMetadata != null) {
                        hatType = villagerResourceMetadata.func_217826_a();
                    }
                    resource.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return hatType;
    }

    private BufferedImage createAutoIconImageFromResourceLocations(Contact contact, EntityRenderer<? extends Entity> render, ResourceLocation resourceLocation, ResourceLocation resourceLocationSecondary) {
        BufferedImage headImage = null;
        if (render instanceof LivingRenderer) {
            try {
                EntityModel model = ((LivingRenderer)render).func_217764_d();
                if (render instanceof TropicalFishRenderer) {
                    Object fishModel = null;
                    int size = ((TropicalFishEntity)contact.entity).func_204217_dE();
                    fishModel = size == 0 ? ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishAModel.class) : ReflectionUtils.getPrivateFieldValueByType(render, TropicalFishRenderer.class, TropicalFishBModel.class);
                    if (fishModel != null) {
                        model = (EntityModel)fishModel;
                    }
                }
                ArrayList<Field> submodels = ReflectionUtils.getFieldsByType(model, EntityModel.class, ModelRenderer.class);
                ArrayList<Field> submodelArrays = ReflectionUtils.getFieldsByType(model, EntityModel.class, ModelRenderer[].class);
                ModelRenderer[] headBits = null;
                Properties properties = new Properties();
                String fullName = contact.vanillaType ? "minecraft." + contact.type.id : contact.entity.getClass().getName();
                String simpleName = contact.vanillaType ? contact.type.id : contact.entity.getClass().getSimpleName();
                String fullPath = ("textures/icons/" + fullName + ".properties").toLowerCase();
                InputStream is = null;
                try {
                    is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
                if (is == null) {
                    fullPath = ("textures/icons/" + simpleName + ".properties").toLowerCase();
                    try {
                        is = this.game.func_195551_G().func_199002_a(new ResourceLocation(fullPath)).func_199027_b();
                    }
                    catch (IOException e) {
                        is = null;
                    }
                }
                if (is != null) {
                    String name;
                    properties.load(is);
                    is.close();
                    String subModelNames = properties.getProperty("models", "").toLowerCase();
                    String[] submodelNamesArray = subModelNames.split(",");
                    Iterator<Field> subModelNamesList = Arrays.asList(submodelNamesArray);
                    HashSet<String> subModelNamesSet = new HashSet<String>();
                    subModelNamesSet.addAll((Collection<String>)((Object)subModelNamesList));
                    ArrayList<ModelRenderer> headPartsArrayList = new ArrayList<ModelRenderer>();
                    for (Field submodelArray : submodelArrays) {
                        ModelRenderer[] submodelArrayValue;
                        name = submodelArray.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || (submodelArrayValue = (ModelRenderer[])submodelArray.get(model)) == null) continue;
                        for (int t = 0; t < submodelArrayValue.length; ++t) {
                            headPartsArrayList.add(submodelArrayValue[t]);
                        }
                    }
                    for (Field submodel : submodels) {
                        name = submodel.getName().toLowerCase();
                        if (!subModelNamesSet.contains(name) && !subModelNames.equals("all") || submodel.get(model) == null) continue;
                        headPartsArrayList.add((ModelRenderer)submodel.get(model));
                    }
                    if (headPartsArrayList.size() > 0) {
                        headBits = headPartsArrayList.toArray(new ModelRenderer[headPartsArrayList.size()]);
                    }
                }
                if (headBits == null) {
                    if (model instanceof BatModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BatModel.class, ModelRenderer.class)};
                    } else if (model instanceof BeeModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class, 8), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BeeModel.class, ModelRenderer.class, 9)};
                    } else if (model instanceof BipedModel) {
                        headBits = new ModelRenderer[]{((BipedModel)model).field_78116_c, ((BipedModel)model).field_178720_f};
                    } else if (model instanceof BlazeModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, BlazeModel.class, ModelRenderer.class)};
                    } else if (model instanceof ChickenModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ChickenModel.class, ModelRenderer.class)};
                    } else if (model instanceof CowModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else if (model instanceof CreeperModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, CreeperModel.class, ModelRenderer.class)};
                    } else if (model instanceof DolphinModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, DolphinModel.class, ModelRenderer.class)};
                    } else if (model instanceof EnderDragonRenderer.EnderDragonModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, EnderDragonRenderer.EnderDragonModel.class, ModelRenderer.class)};
                    } else if (model instanceof GhastModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)((GhastModel)model).func_225601_a_().iterator().next()};
                    } else if (model instanceof GuardianModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, GuardianModel.class, ModelRenderer.class, 1)};
                    } else if (model instanceof HorseModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, HorseModel.class, ModelRenderer.class)};
                    } else if (model instanceof IllagerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, IllagerModel.class, ModelRenderer.class)};
                    } else if (model instanceof IronGolemModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, IronGolemModel.class, ModelRenderer.class)};
                    } else if (model instanceof MagmaCubeModel) {
                        headBits = (ModelRenderer[])ReflectionUtils.getPrivateFieldValueByType(model, MagmaCubeModel.class, ModelRenderer[].class);
                    } else if (model instanceof OcelotModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, OcelotModel.class, ModelRenderer.class, 6)};
                    } else if (model instanceof PhantomModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, PhantomModel.class, ModelRenderer.class)};
                    } else if (model instanceof PigModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else if (model instanceof PolarBearModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else if (model instanceof RabbitModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 7), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 8), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 9), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RabbitModel.class, ModelRenderer.class, 10)};
                    } else if (model instanceof RavagerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, RavagerModel.class, ModelRenderer.class, 7)};
                    } else if (model instanceof ShulkerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, ShulkerModel.class, ModelRenderer.class, 2)};
                    } else if (model instanceof SilverfishModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, ModelRenderer[].class))[0], (ModelRenderer)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, SilverfishModel.class, ModelRenderer[].class))[1]};
                    } else if (model instanceof SlimeModel) {
                        SlimeModel modelOuter = new SlimeModel(0);
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 0), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 1), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 2), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SlimeModel.class, ModelRenderer.class, 3), (ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(modelOuter, SlimeModel.class, ModelRenderer.class, 0)};
                    } else if (model instanceof SnowManModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SnowManModel.class, ModelRenderer.class, 2)};
                    } else if (model instanceof SpiderModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SpiderModel.class, ModelRenderer.class)};
                    } else if (model instanceof SquidModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, SquidModel.class, ModelRenderer.class)};
                    } else if (model instanceof VillagerModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, VillagerModel.class, ModelRenderer.class)};
                    } else if (model instanceof WolfModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, WolfModel.class, ModelRenderer.class)};
                    } else if (model instanceof QuadrupedModel) {
                        headBits = new ModelRenderer[]{(ModelRenderer)ReflectionUtils.getPrivateFieldValueByType(model, QuadrupedModel.class, ModelRenderer.class)};
                    } else {
                        String name;
                        ArrayList<ModelRenderer> headPartsArrayList = new ArrayList<ModelRenderer>();
                        ArrayList purge = new ArrayList();
                        for (Field submodelArray : submodelArrays) {
                            ModelRenderer[] submodelArrayValue;
                            name = submodelArray.getName().toLowerCase();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler")) || (submodelArrayValue = (ModelRenderer[])submodelArray.get(model)) == null || submodelArrayValue.length < 0) continue;
                            headPartsArrayList.add(submodelArrayValue[0]);
                        }
                        for (Field submodel : submodels) {
                            name = submodel.getName().toLowerCase();
                            String nameS = submodel.getName();
                            if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("mand") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler") | nameS.equals("REar") | nameS.equals("Trout")) || !(!nameS.equals("LeftSmallEar") & !nameS.equals("RightSmallEar") & !nameS.equals("BHead") & !nameS.equals("BSnout") & !nameS.equals("BMouth") & !nameS.equals("BMouthOpen") & !nameS.equals("BLEar") & !nameS.equals("BREar") & !nameS.equals("CHead") & !nameS.equals("CSnout") & !nameS.equals("CMouth") & !nameS.equals("CMouthOpen") & !nameS.equals("CLEar") & !nameS.equals("CREar")) || submodel.get(model) == null) continue;
                            headPartsArrayList.add((ModelRenderer)submodel.get(model));
                        }
                        if (headPartsArrayList.size() == 0) {
                            ModelRenderer[] submodelArrayValue;
                            if (submodels.size() > 0) {
                                if (submodels.get(0).get(model) != null) {
                                    headPartsArrayList.add((ModelRenderer)submodels.get(0).get(model));
                                }
                            } else if (submodelArrays.size() > 0 && submodelArrays.get(0).get(model) != null && (submodelArrayValue = (ModelRenderer[])submodelArrays.get(0).get(model)).length > 0) {
                                headPartsArrayList.add(submodelArrayValue[0]);
                            }
                        }
                        for (ModelRenderer bit : headPartsArrayList) {
                            try {
                                Object childrenObj = ReflectionUtils.getPrivateFieldValueByType(bit, ModelRenderer.class, ObjectList.class, 1);
                                if (childrenObj == null) continue;
                                List children = (List)childrenObj;
                                purge.addAll(children);
                            }
                            catch (Exception childrenObj) {}
                        }
                        headPartsArrayList.removeAll(purge);
                        headBits = headPartsArrayList.toArray(new ModelRenderer[headPartsArrayList.size()]);
                    }
                }
                if (contact.entity != null && model != null && headBits.length > 0 && resourceLocation != null) {
                    String scaleString = properties.getProperty("scale", "1");
                    float scale = Float.parseFloat(scaleString);
                    Direction facing = Direction.NORTH;
                    String facingString = properties.getProperty("facing", "front");
                    if (facingString.equals("top")) {
                        facing = Direction.UP;
                    } else if (facingString.equals("side")) {
                        facing = Direction.EAST;
                    }
                    boolean success = this.drawModel(scale, 1000, (LivingEntity)contact.entity, facing, model, resourceLocation, resourceLocationSecondary, headBits);
                    if (success) {
                        headImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
                    }
                }
            }
            catch (Exception e) {
                headImage = null;
            }
        }
        return headImage;
    }

    private boolean drawModel(float scale, int captureDepth, LivingEntity par5EntityLivingBase, Direction facing, EntityModel model, ResourceLocation resourceLocation, ResourceLocation resourceLocationSecondary, ModelRenderer ... headBits) {
        boolean failed = false;
        float size = 64.0f * scale;
        GLShim.glBindTexture(3553, GLUtils.fboTextureID);
        int width = GLShim.glGetTexLevelParameteri(3553, 0, 4096);
        int height = GLShim.glGetTexLevelParameteri(3553, 0, 4097);
        GLShim.glBindTexture(3553, 0);
        GLShim.glPushAttrib(4096);
        GLShim.glViewport(0, 0, width, height);
        GLShim.glMatrixMode(5889);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glOrtho(0.0, width, height, 0.0, 1000.0, 3000.0);
        GLShim.glMatrixMode(5888);
        GLShim.glPushMatrix();
        GLShim.glLoadIdentity();
        GLShim.glTranslatef(0.0f, 0.0f, -3000.0f + (float)captureDepth);
        GLUtils.bindFrameBuffer();
        GLShim.glDepthMask(true);
        GLShim.glEnable(2929);
        GLShim.glEnable(3553);
        GLShim.glEnable(3042);
        GLShim.glEnable(3008);
        GLShim.glEnable(2977);
        GLShim.glDisable(2884);
        GLShim.glTexEnvi(8960, 8704, 7681);
        GLShim.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GLShim.glClear(16640);
        GLShim.glBlendFunc(770, 771);
        GLShim.glPushMatrix();
        GLShim.glTranslatef(width / 2, height / 2, 0.0f);
        GLShim.glScalef(size, size, size);
        GLShim.glRotatef(180.0f, 0.0f, 0.0f, 1.0f);
        if (resourceLocationSecondary != null) {
            try {
                InputStream is = this.game.func_195551_G().func_199002_a(resourceLocation).func_199027_b();
                BufferedImage base = ImageIO.read(is);
                is.close();
                is = this.game.func_195551_G().func_199002_a(resourceLocationSecondary).func_199027_b();
                BufferedImage overlay = ImageIO.read(is);
                is.close();
                float xScale = base.getWidth() / overlay.getWidth();
                float yScale = base.getHeight() / overlay.getHeight();
                if (xScale != 1.0f || yScale != 1.0f) {
                    overlay = ImageUtils.scaleImage(overlay, xScale, yScale);
                }
                base = ImageUtils.addImages(base, overlay, 0.0f, 0.0f, base.getWidth(), base.getHeight());
                ResourceLocation resourceLocationCombined = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a() + resourceLocationSecondary.func_110623_a());
                NativeImage nativeImage = GLUtils.nativeImageFromBufferedImage(base);
                DynamicTexture texture = new DynamicTexture(nativeImage);
                GLUtils.register(resourceLocationCombined, (Texture)texture);
                resourceLocation = resourceLocationCombined;
            }
            catch (Exception is) {
                // empty catch block
            }
        }
        GLShim.glRotatef(180.0f, 0.0f, 1.0f, 0.0f);
        if (facing == Direction.EAST) {
            GLShim.glRotatef(-90.0f, 0.0f, 1.0f, 0.0f);
        } else if (facing == Direction.UP) {
            GLShim.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
        }
        try {
            int t;
            MatrixStack matrixStack = new MatrixStack();
            IRenderTypeBuffer.Impl immediate = this.game.func_228019_au_().func_228487_b_();
            IVertexBuilder vertexConsumer = immediate.getBuffer(RenderType.func_228638_b_((ResourceLocation)resourceLocation));
            model.func_225597_a_((Entity)par5EntityLivingBase, 0.0f, 0.0f, 163.0f, 360.0f, 0.0f);
            matrixStack.func_227862_a_(-1.0f, 1.0f, 1.0f);
            float offsetByY = 0.0f;
            float maxY = 0.0f;
            float minY = 0.0f;
            for (t = 0; t < headBits.length; ++t) {
                if (headBits[t].field_78797_d < minY) {
                    minY = headBits[t].field_78797_d;
                }
                if (!(headBits[t].field_78797_d > maxY)) continue;
                maxY = headBits[t].field_78797_d;
            }
            if (minY < -25.0f) {
                offsetByY = -25.0f - minY;
            } else if (maxY > 25.0f) {
                offsetByY = 25.0f - maxY;
            }
            if (captureDepth == 2) {
                offsetByY = 4.0f;
            }
            for (t = 0; t < headBits.length; ++t) {
                float y = headBits[t].field_78797_d;
                headBits[t].field_78797_d += offsetByY;
                headBits[t].func_228308_a_(matrixStack, vertexConsumer, 0xF000F0, OverlayTexture.field_229196_a_);
                headBits[t].field_78797_d = y;
            }
            immediate.func_228461_a_();
        }
        catch (Exception e) {
            failed = true;
        }
        GLShim.glPopMatrix();
        GLShim.glTexEnvi(8960, 8704, 8448);
        GLShim.glEnable(2884);
        GLShim.glDisable(2929);
        GLShim.glDepthMask(false);
        GLUtils.unbindFrameBuffer();
        GLShim.glMatrixMode(5889);
        GLShim.glPopMatrix();
        GLShim.glMatrixMode(5888);
        GLShim.glPopMatrix();
        GLShim.glPopAttrib();
        GLShim.glViewport(0, 0, this.game.func_228018_at_().func_198109_k(), this.game.func_228018_at_().func_198091_l());
        return !failed;
    }

    private void tryFallbackType(Contact contact) {
        contact.type = this.getContactType(contact.entity);
        if (contact.type == EnumMobs.UNKNOWN) {
            contact.type = this.getUnknownMobNeutrality(contact.entity);
        }
        String resourceLocationString = contact.type.resourceLocation != null ? contact.type.resourceLocation.toString() : "";
        resourceLocationString = resourceLocationString + (contact.type.secondaryResourceLocation != null ? contact.type.secondaryResourceLocation.toString() : "");
        String name = contact.type.id + resourceLocationString;
        contact.icon = this.textureAtlas.getAtlasSprite(name);
    }

    private ResourceLocation getRandomizedResourceLocationForEntity(ResourceLocation resourceLocation, Entity entity) {
        try {
            Object randomEntitiesProperties;
            if (this.randomobsOptifine && (randomEntitiesProperties = this.mapProperties.get(resourceLocation.func_110623_a())) != null) {
                this.setEntityMethod.invoke(this.randomEntityClass.cast(this.randomEntity), entity);
                resourceLocation = (ResourceLocation)this.getEntityTextureMethod.invoke(this.randomEntitiesPropertiesClass.cast(randomEntitiesProperties), resourceLocation, this.randomEntityClass.cast(this.randomEntity));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resourceLocation;
    }

    private BufferedImage trimAndOutlineImage(Contact contact, BufferedImage image) {
        if (contact.auto) {
            image = ImageUtils.trim(image);
            double acceptableMax = 32.0;
            if (ImageUtils.percentageOfEdgePixelsThatAreSolid(image) < 30.0f) {
                acceptableMax = 64.0;
            }
            int maxDimension = Math.max(image.getWidth(), image.getHeight());
            float scale = (float)Math.ceil((double)maxDimension / acceptableMax);
            image = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 1.0f / scale)), this.options.outlines, 2);
            return image;
        }
        float scale = (float)image.getWidth() / contact.type.expectedWidth;
        image = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(image, 4.0f / scale)), this.options.outlines, 2);
        return image;
    }

    private void handleMPplayer(Contact contact) {
        AbstractClientPlayerEntity player = (AbstractClientPlayerEntity)contact.entity;
        GameProfile gameProfile = player.func_146103_bH();
        UUID uuid = gameProfile.getId();
        contact.setUUID(uuid);
        String playerName = this.scrubCodes(gameProfile.getName());
        Sprite icon = this.textureAtlas.getAtlasSprite(playerName);
        Integer checkCount = 0;
        if (icon == this.textureAtlas.getMissingImage()) {
            checkCount = this.mpContactsSkinGetTries.get(playerName);
            if (checkCount == null) {
                checkCount = 0;
            }
            if (checkCount < 5) {
                DownloadingTexture imageData = null;
                try {
                    if (player.func_110306_p() == DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au())) {
                        throw new Exception("failed to get skin: skin is default");
                    }
                    imageData = AbstractClientPlayerEntity.func_110304_a((ResourceLocation)player.func_110306_p(), (String)player.func_200200_C_().getString());
                    if (imageData == null) {
                        throw new Exception("failed to get skin: image data was null");
                    }
                    BufferedImage skinImage = ImageUtils.createBufferedImageFromGLID(imageData.func_110552_b());
                    boolean showHat = player.func_175148_a(PlayerModelPart.HAT);
                    skinImage = showHat ? ImageUtils.addImages(ImageUtils.loadImage(skinImage, 8, 8, 8, 8), ImageUtils.loadImage(skinImage, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8) : ImageUtils.loadImage(skinImage, 8, 8, 8, 8);
                    float scale = (float)skinImage.getWidth() / 8.0f;
                    skinImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(skinImage, 4.0f / scale)), this.options.outlines, 2);
                    icon = this.textureAtlas.registerIconForBufferedImage(playerName, skinImage);
                    this.newMobs = true;
                    this.mpContactsSkinGetTries.remove(playerName);
                }
                catch (Exception e) {
                    icon = this.textureAtlas.getAtlasSprite(EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString());
                    Integer n = checkCount;
                    Integer n2 = checkCount = Integer.valueOf(checkCount + 1);
                    this.mpContactsSkinGetTries.put(playerName, checkCount);
                }
                contact.icon = icon;
            }
        } else {
            contact.icon = icon;
        }
    }

    private void getArmor(Contact contact, Entity entity) {
        Sprite icon = null;
        ItemStack stack = ((LivingEntity)entity).func_184582_a(EquipmentSlotType.HEAD);
        Item helmet = null;
        if (stack != null && stack.func_190916_E() > 0) {
            helmet = stack.func_77973_b();
        }
        if (contact.type == EnumMobs.SHEEP) {
            SheepEntity sheepEntity = (SheepEntity)contact.entity;
            if (!sheepEntity.func_70892_o()) {
                icon = this.textureAtlas.getAtlasSprite("sheepfur");
                float[] sheepColors = SheepEntity.func_175513_a((DyeColor)sheepEntity.func_175509_cj());
                contact.setArmorColor((int)(sheepColors[0] * 255.0f) << 16 | (int)(sheepColors[1] * 255.0f) << 8 | (int)(sheepColors[2] * 255.0f));
            }
        } else if (helmet != null) {
            if (helmet == Items.field_196182_dv) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.SKELETON.id + EnumMobs.SKELETON.resourceLocation.toString());
            } else if (helmet == Items.field_196183_dw) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.SKELETONWITHER.id + EnumMobs.SKELETONWITHER.resourceLocation.toString());
            } else if (helmet == Items.field_196186_dz) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.ZOMBIE.id + EnumMobs.ZOMBIE.resourceLocation.toString());
            } else if (helmet == Items.field_196184_dx) {
                GameProfile gameProfile = null;
                if (stack.func_77942_o()) {
                    String name;
                    CompoundNBT nbttagcompound = stack.func_77978_p();
                    if (nbttagcompound.func_150297_b("SkullOwner", 10)) {
                        gameProfile = NBTUtil.func_152459_a((CompoundNBT)nbttagcompound.func_74775_l("SkullOwner"));
                    } else if (nbttagcompound.func_150297_b("SkullOwner", 8) && (name = nbttagcompound.func_74779_i("SkullOwner")) != null && !name.equals("")) {
                        gameProfile = SkullTileEntity.func_174884_b((GameProfile)new GameProfile((UUID)null, name));
                        nbttagcompound.func_218657_a("SkullOwner", (INBT)NBTUtil.func_180708_a((CompoundNBT)new CompoundNBT(), (GameProfile)gameProfile));
                    }
                }
                if (gameProfile != null) {
                    BufferedImage image;
                    Texture textureObject;
                    ResourceLocation resourcelocation = DefaultPlayerSkin.func_177335_a();
                    Minecraft minecraft = Minecraft.func_71410_x();
                    Map map = minecraft.func_152342_ad().func_152788_a(gameProfile);
                    if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                        resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                    }
                    if (resourcelocation != null && (icon = this.textureAtlas.getAtlasSpriteIncludingYetToBeStitched(EnumMobs.PLAYER.id + resourcelocation.toString())) == this.textureAtlas.getMissingImage() && (textureObject = GLUtils.textureManager.func_229267_b_(resourcelocation)) != null && (image = ImageUtils.createBufferedImageFromGLID(textureObject.func_110552_b())) != null) {
                        image = this.createImageFromTypeAndImages(EnumMobs.PLAYER, image, null, null);
                        BufferedImage trimmedImage = this.trimAndOutlineImage(contact, image);
                        icon = this.textureAtlas.registerIconForBufferedImage(EnumMobs.PLAYER.id + resourcelocation.toString(), trimmedImage);
                        this.newMobs = true;
                    }
                }
                if (icon == null) {
                    icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.PLAYER.id + EnumMobs.PLAYER.resourceLocation.toString());
                }
                contact.icon = icon;
                icon = null;
            } else if (helmet == Items.field_196185_dy) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.CREEPER.id + EnumMobs.CREEPER.resourceLocation.toString());
            } else if (helmet == Items.field_196151_dA) {
                icon = this.textureAtlas.getAtlasSprite("minecraft." + EnumMobs.ENDERDRAGON.id + EnumMobs.ENDERDRAGON.resourceLocation.toString());
            } else if (helmet instanceof ArmorItem) {
                ArmorItem helmetArmor = (ArmorItem)helmet;
                int armorType = this.getArmorType(helmetArmor);
                if (armorType == UNKNOWN) {
                    icon = this.textureAtlas.getAtlasSprite("armor " + helmet.func_77658_a());
                    if (icon == this.textureAtlas.getMissingImage()) {
                        icon = this.createUnknownArmorIcons(contact, stack, helmet);
                    } else if (icon == this.textureAtlas.getFailedImage()) {
                        icon = null;
                    }
                } else {
                    icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[armorType]);
                }
                if (helmetArmor instanceof DyeableArmorItem) {
                    contact.setArmorColor(((DyeableArmorItem)helmetArmor).func_200886_f(stack));
                }
            } else if (helmet instanceof BlockItem) {
                BufferedImage blockImage;
                Block block = ((BlockItem)helmet).func_179223_d();
                BlockState blockState = block.func_176223_P();
                int stateID = Block.func_196246_j((BlockState)blockState);
                icon = this.textureAtlas.getAtlasSprite("blockArmor " + stateID);
                if (icon == this.textureAtlas.getMissingImage() && (blockImage = this.master.getColorManager().getBlockImage(blockState, stack, entity.field_70170_p)) != null) {
                    blockImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(blockImage, 2.0f)), this.options.outlines, true, 32, 2);
                    icon = this.textureAtlas.registerIconForBufferedImage("blockArmor " + stateID, blockImage);
                    this.newMobs = true;
                }
            }
        }
        contact.armorIcon = icon;
    }

    private Sprite createUnknownArmorIcons(Contact contact, ItemStack stack, Item helmet) {
        BufferedImage armorTexture;
        Sprite icon = null;
        Method m = null;
        try {
            Class<?> c = Class.forName("net.minecraftforge.client.ForgeHooksClient");
            m = c.getMethod("getArmorTexture", Entity.class, ItemStack.class, String.class, EquipmentSlotType.class, String.class);
        }
        catch (Exception c) {
            // empty catch block
        }
        Method getResourceLocation = m;
        ResourceLocation resourceLocation = null;
        try {
            String texture = ((ArmorItem)helmet).func_200880_d().func_200897_d();
            String domain = "minecraft";
            int sep = texture.indexOf(58);
            if (sep != -1) {
                domain = texture.substring(0, sep);
                texture = texture.substring(sep + 1);
            }
            String resourcePath = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, 1, "");
            if (getResourceLocation != null) {
                resourcePath = (String)getResourceLocation.invoke(null, contact.entity, stack, resourcePath, EquipmentSlotType.HEAD, null);
            }
            resourceLocation = new ResourceLocation(resourcePath);
        }
        catch (Exception texture) {
            // empty catch block
        }
        m = null;
        try {
            Class<?> c = Class.forName("net.minecraftforge.client.ForgeHooksClient");
            m = c.getMethod("getArmorModel", LivingEntity.class, ItemStack.class, EquipmentSlotType.class, BipedModel.class);
        }
        catch (Exception c) {
            // empty catch block
        }
        Method getModel = m;
        BipedModel modelBiped = null;
        try {
            if (getModel != null) {
                modelBiped = (BipedModel)getModel.invoke(null, contact.entity, stack, EquipmentSlotType.HEAD, null);
            }
        }
        catch (Exception sep) {
            // empty catch block
        }
        if (modelBiped == null) {
            EntityRenderer render = this.game.func_175598_ae().func_78713_a(contact.entity);
            modelBiped = (BipedModel)((LivingRenderer)render).func_217764_d();
        }
        if (modelBiped != null && resourceLocation != null) {
            ModelRenderer[] headBits = new ModelRenderer[]{modelBiped.field_78116_c, modelBiped.field_178720_f};
            this.drawModel(0.8636364f, 2, (LivingEntity)contact.entity, Direction.NORTH, (EntityModel)modelBiped, resourceLocation, null, headBits);
            System.out.println("***************drawing helmet model");
            armorTexture = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
            armorTexture = armorTexture.getSubimage(100, 100, 56, 56);
            BufferedImage armorImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 1.0f)), this.options.outlines, true, 32, 2);
            icon = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a(), armorImage);
            this.newMobs = true;
        } else if (resourceLocation != null) {
            try {
                InputStream is = null;
                try {
                    is = this.game.func_195551_G().func_199002_a(resourceLocation).func_199027_b();
                }
                catch (IOException e) {
                    is = null;
                }
                if (is != null) {
                    armorTexture = ImageIO.read(is);
                    is.close();
                    armorTexture = ImageUtils.addImages(ImageUtils.loadImage(armorTexture, 8, 8, 8, 8), ImageUtils.loadImage(armorTexture, 40, 8, 8, 8), 0.0f, 0.0f, 8, 8);
                    float scale = (float)armorTexture.getWidth() / 8.0f;
                    BufferedImage armorImage = ImageUtils.fillOutline(ImageUtils.pad(ImageUtils.scaleImage(armorTexture, 4.0f / scale)), this.options.outlines, true, 32, 2);
                    icon = this.textureAtlas.registerIconForBufferedImage("armor " + helmet.func_77658_a(), armorImage);
                    this.newMobs = true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (icon == null) {
            System.out.println("can't get texture for custom armor type: " + helmet.getClass());
            this.textureAtlas.registerFailedIcon("armor " + helmet.func_77658_a());
        }
        return icon;
    }

    private String scrubCodes(String string) {
        string = string.replaceAll("(\\xA7.)", "");
        return string;
    }

    private EnumMobs getContactTypeStrict(Entity entity) {
        Class<?> entityClass = entity.getClass();
        if (entityClass.equals(BatEntity.class)) {
            return EnumMobs.BAT;
        }
        if (entityClass.equals(BeeEntity.class)) {
            return EnumMobs.BEE;
        }
        if (entityClass.equals(BlazeEntity.class)) {
            return EnumMobs.BLAZE;
        }
        if (entityClass.equals(CatEntity.class)) {
            return EnumMobs.CAT;
        }
        if (entityClass.equals(CaveSpiderEntity.class)) {
            return EnumMobs.CAVESPIDER;
        }
        if (entityClass.equals(ChickenEntity.class)) {
            return EnumMobs.CHICKEN;
        }
        if (entityClass.equals(CodEntity.class)) {
            return EnumMobs.COD;
        }
        if (entityClass.equals(MooshroomEntity.class)) {
            return EnumMobs.MOOSHROOM;
        }
        if (entityClass.equals(CowEntity.class)) {
            return EnumMobs.COW;
        }
        if (entityClass.equals(CreeperEntity.class)) {
            return EnumMobs.CREEPER;
        }
        if (entity instanceof DolphinEntity) {
            return EnumMobs.DOLPHIN;
        }
        if (entity instanceof DrownedEntity) {
            return EnumMobs.DROWNED;
        }
        if (entityClass.equals(EnderDragonEntity.class)) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entityClass.equals(EndermanEntity.class)) {
            return EnumMobs.ENDERMAN;
        }
        if (entityClass.equals(EndermiteEntity.class)) {
            return EnumMobs.ENDERMITE;
        }
        if (entityClass.equals(EvokerEntity.class)) {
            return EnumMobs.EVOKER;
        }
        if (entityClass.equals(FoxEntity.class)) {
            return EnumMobs.FOX;
        }
        if (entityClass.equals(GhastEntity.class)) {
            return EnumMobs.GHAST;
        }
        if (entityClass.equals(GuardianEntity.class)) {
            return EnumMobs.GUARDIAN;
        }
        if (entityClass.equals(ElderGuardianEntity.class)) {
            return EnumMobs.GUARDIANELDER;
        }
        if (entityClass.equals(HorseEntity.class) || entityClass.equals(DonkeyEntity.class) || entityClass.equals(MuleEntity.class) || entityClass.equals(SkeletonHorseEntity.class) || entityClass.equals(ZombieHorseEntity.class)) {
            return EnumMobs.HORSE;
        }
        if (entityClass.equals(HuskEntity.class)) {
            return EnumMobs.HUSK;
        }
        if (entityClass.equals(LlamaEntity.class)) {
            return EnumMobs.LLAMA;
        }
        if (entityClass.equals(TraderLlamaEntity.class)) {
            return EnumMobs.LLAMATRADER;
        }
        if (entityClass.equals(IronGolemEntity.class)) {
            return EnumMobs.IRONGOLEM;
        }
        if (entityClass.equals(MagmaCubeEntity.class)) {
            return EnumMobs.MAGMA;
        }
        if (entityClass.equals(OcelotEntity.class)) {
            return EnumMobs.OCELOT;
        }
        if (entityClass.equals(PandaEntity.class)) {
            return EnumMobs.PANDA;
        }
        if (entityClass.equals(ParrotEntity.class)) {
            return EnumMobs.PARROT;
        }
        if (entityClass.equals(PhantomEntity.class)) {
            return EnumMobs.PHANTOM;
        }
        if (entityClass.equals(PigEntity.class)) {
            return EnumMobs.PIG;
        }
        if (entityClass.equals(ZombiePigmanEntity.class)) {
            return EnumMobs.PIGZOMBIE;
        }
        if (entityClass.equals(PillagerEntity.class)) {
            return EnumMobs.PILLAGER;
        }
        if (entity instanceof RemoteClientPlayerEntity) {
            return EnumMobs.PLAYER;
        }
        if (entityClass.equals(PolarBearEntity.class)) {
            return EnumMobs.POLARBEAR;
        }
        if (entityClass.equals(PufferfishEntity.class)) {
            return EnumMobs.PUFFERFISH;
        }
        if (entityClass.equals(RabbitEntity.class)) {
            return EnumMobs.RABBIT;
        }
        if (entityClass.equals(RavagerEntity.class)) {
            return EnumMobs.RAVAGER;
        }
        if (entityClass.equals(SalmonEntity.class)) {
            return EnumMobs.SALMON;
        }
        if (entityClass.equals(SheepEntity.class)) {
            return EnumMobs.SHEEP;
        }
        if (entityClass.equals(ShulkerEntity.class)) {
            return EnumMobs.SHULKER;
        }
        if (entityClass.equals(SilverfishEntity.class)) {
            return EnumMobs.SILVERFISH;
        }
        if (entityClass.equals(SkeletonEntity.class)) {
            return EnumMobs.SKELETON;
        }
        if (entityClass.equals(WitherSkeletonEntity.class)) {
            return EnumMobs.SKELETONWITHER;
        }
        if (entityClass.equals(SlimeEntity.class)) {
            return EnumMobs.SLIME;
        }
        if (entityClass.equals(SnowGolemEntity.class)) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entityClass.equals(SpiderEntity.class)) {
            return EnumMobs.SPIDER;
        }
        if (entityClass.equals(SquidEntity.class)) {
            return EnumMobs.SQUID;
        }
        if (entityClass.equals(TropicalFishEntity.class)) {
            if (((TropicalFishEntity)entity).func_204217_dE() == 0) {
                return EnumMobs.TROPICALFISHA;
            }
            return EnumMobs.TROPICALFISHB;
        }
        if (entityClass.equals(StrayEntity.class)) {
            return EnumMobs.STRAY;
        }
        if (entityClass.equals(TurtleEntity.class)) {
            return EnumMobs.TURTLE;
        }
        if (entityClass.equals(VexEntity.class)) {
            return EnumMobs.VEX;
        }
        if (entityClass.equals(VillagerEntity.class)) {
            return EnumMobs.VILLAGER;
        }
        if (entityClass.equals(VindicatorEntity.class)) {
            return EnumMobs.VINDICATOR;
        }
        if (entityClass.equals(WanderingTraderEntity.class)) {
            return EnumMobs.WANDERINGTRADER;
        }
        if (entityClass.equals(WitchEntity.class)) {
            return EnumMobs.WITCH;
        }
        if (entityClass.equals(WitherEntity.class)) {
            return EnumMobs.WITHER;
        }
        if (entityClass.equals(WolfEntity.class)) {
            return EnumMobs.WOLF;
        }
        if (entityClass.equals(ZombieEntity.class)) {
            return EnumMobs.ZOMBIE;
        }
        if (entityClass.equals(ZombieVillagerEntity.class)) {
            return EnumMobs.ZOMBIEVILLAGER;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getContactType(Entity entity) {
        if (entity instanceof BatEntity) {
            return EnumMobs.BAT;
        }
        if (entity instanceof BeeEntity) {
            return EnumMobs.BEE;
        }
        if (entity instanceof BlazeEntity) {
            return EnumMobs.BLAZE;
        }
        if (entity instanceof CatEntity) {
            return EnumMobs.CAT;
        }
        if (entity instanceof CaveSpiderEntity) {
            return EnumMobs.CAVESPIDER;
        }
        if (entity instanceof ChickenEntity) {
            return EnumMobs.CHICKEN;
        }
        if (entity instanceof MooshroomEntity) {
            return EnumMobs.MOOSHROOM;
        }
        if (entity instanceof CowEntity) {
            return EnumMobs.COW;
        }
        if (entity instanceof CreeperEntity) {
            return EnumMobs.CREEPER;
        }
        if (entity instanceof DolphinEntity) {
            return EnumMobs.DOLPHIN;
        }
        if (entity instanceof EnderDragonEntity) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entity instanceof EndermanEntity) {
            return EnumMobs.ENDERMAN;
        }
        if (entity instanceof EndermiteEntity) {
            return EnumMobs.ENDERMITE;
        }
        if (entity instanceof EvokerEntity) {
            return EnumMobs.EVOKER;
        }
        if (entity instanceof GhastEntity) {
            return EnumMobs.GHAST;
        }
        if (entity instanceof ElderGuardianEntity) {
            return EnumMobs.GUARDIANELDER;
        }
        if (entity instanceof GuardianEntity) {
            return EnumMobs.GUARDIAN;
        }
        if (entity instanceof TraderLlamaEntity) {
            return EnumMobs.LLAMATRADER;
        }
        if (entity instanceof LlamaEntity) {
            return EnumMobs.LLAMA;
        }
        if (entity instanceof AbstractHorseEntity) {
            return EnumMobs.HORSE;
        }
        if (entity instanceof IronGolemEntity) {
            return EnumMobs.IRONGOLEM;
        }
        if (entity instanceof MagmaCubeEntity) {
            return EnumMobs.MAGMA;
        }
        if (entity instanceof OcelotEntity) {
            return EnumMobs.OCELOT;
        }
        if (entity instanceof ParrotEntity) {
            return EnumMobs.PARROT;
        }
        if (entity instanceof PhantomEntity) {
            return EnumMobs.PHANTOM;
        }
        if (entity instanceof PigEntity) {
            return EnumMobs.PIG;
        }
        if (entity instanceof ZombiePigmanEntity) {
            return EnumMobs.PIGZOMBIE;
        }
        if (entity instanceof RemoteClientPlayerEntity) {
            return EnumMobs.PLAYER;
        }
        if (entity instanceof PolarBearEntity) {
            return EnumMobs.POLARBEAR;
        }
        if (entity instanceof PufferfishEntity) {
            return EnumMobs.PUFFERFISH;
        }
        if (entity instanceof RabbitEntity) {
            return EnumMobs.RABBIT;
        }
        if (entity instanceof SheepEntity) {
            return EnumMobs.SHEEP;
        }
        if (entity instanceof ShulkerEntity) {
            return EnumMobs.SHULKER;
        }
        if (entity instanceof SilverfishEntity) {
            return EnumMobs.SILVERFISH;
        }
        if (entity instanceof AbstractSkeletonEntity) {
            return EnumMobs.SKELETON;
        }
        if (entity instanceof SlimeEntity) {
            return EnumMobs.SLIME;
        }
        if (entity instanceof SnowGolemEntity) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entity instanceof SpiderEntity) {
            return EnumMobs.SPIDER;
        }
        if (entity instanceof SquidEntity) {
            return EnumMobs.SQUID;
        }
        if (entity instanceof VexEntity) {
            return EnumMobs.VEX;
        }
        if (entity instanceof VillagerEntity) {
            return EnumMobs.VILLAGER;
        }
        if (entity instanceof VindicatorEntity) {
            return EnumMobs.VINDICATOR;
        }
        if (entity instanceof WitchEntity) {
            return EnumMobs.WITCH;
        }
        if (entity instanceof WitherEntity) {
            return EnumMobs.WITHER;
        }
        if (entity instanceof WolfEntity) {
            return EnumMobs.WOLF;
        }
        if (entity instanceof ZombieVillagerEntity) {
            return EnumMobs.ZOMBIEVILLAGER;
        }
        if (entity instanceof ZombieEntity) {
            return EnumMobs.ZOMBIE;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getUnknownMobNeutrality(Entity entity) {
        if (this.isHostile(entity)) {
            return EnumMobs.GENERICHOSTILE;
        }
        if (entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n() && (this.game.func_71387_A() || ((TameableEntity)entity).func_70902_q().equals((Object)this.game.field_71439_g))) {
            return EnumMobs.GENERICTAME;
        }
        return EnumMobs.GENERICNEUTRAL;
    }

    private int getArmorType(ArmorItem helmet) {
        if (helmet.func_77658_a().equals("item.minecraft.leather_helmet")) {
            return 0;
        }
        if (helmet.func_77658_a().equals("item.minecraft.chainmail_helmet")) {
            return 4;
        }
        if (helmet.func_77658_a().equals("item.minecraft.iron_helmet")) {
            return 5;
        }
        if (helmet.func_77658_a().equals("item.minecraft.golden_helmet")) {
            return 6;
        }
        if (helmet.func_77658_a().equals("item.minecraft.diamond_helmet")) {
            return 7;
        }
        if (helmet.func_77658_a().equals("item.minecraft.turtle_helmet")) {
            return 8;
        }
        return UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(int x, int y) {
        double max = this.layoutVariables.zoomScaleAdjusted * 32.0;
        GLUtils.disp(this.textureAtlas.func_110552_b());
        for (Contact contact : this.contacts) {
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            int contactY = contact.y;
            double wayX = GameVariableAccessShim.xCoordDouble() - contactX;
            double wayZ = GameVariableAccessShim.zCoordDouble() - contactZ;
            int wayY = GameVariableAccessShim.yCoord() - contactY;
            double adjustedDiff = max - (double)Math.max(Math.abs(wayY) - 0, 0);
            contact.brightness = (float)Math.max(adjustedDiff / max, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / this.layoutVariables.zoomScaleAdjusted;
            GLShim.glBlendFunc(770, 771);
            if (wayY < 0) {
                GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
            } else {
                GLShim.glColor3f(1.0f * contact.brightness, 1.0f * contact.brightness, 1.0f * contact.brightness);
            }
            if (this.minimapOptions.rotates) {
                contact.angle += this.direction;
            } else if (this.minimapOptions.oldNorth) {
                contact.angle -= 90.0f;
            }
            boolean inRange = false;
            if (this.minimapOptions.squareMap) {
                double radLocate = Math.toRadians(contact.angle);
                double dispX = contact.distance * Math.cos(radLocate);
                double dispY = contact.distance * Math.sin(radLocate);
                inRange = Math.abs(dispX) <= 28.5 && Math.abs(dispY) <= 28.5;
            } else {
                boolean bl = inRange = contact.distance < 31.0;
            }
            if (!inRange) continue;
            try {
                Sprite icon;
                GLShim.glPushMatrix();
                if (this.options.filtering) {
                    GLShim.glTranslatef(x, y, 0.0f);
                    GLShim.glRotatef(-contact.angle, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslated(0.0, -contact.distance, 0.0);
                    GLShim.glRotatef(contact.angle + (float)contact.rotationFactor, 0.0f, 0.0f, 1.0f);
                    GLShim.glTranslatef(-x, -y, 0.0f);
                } else {
                    wayX = Math.sin(Math.toRadians(contact.angle)) * contact.distance;
                    wayZ = Math.cos(Math.toRadians(contact.angle)) * contact.distance;
                    if (this.options.filtering) {
                        GLShim.glTranslated(-wayX, -wayZ, 0.0);
                    } else {
                        GLShim.glTranslated((double)Math.round(-wayX * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, (double)Math.round(-wayZ * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale, 0.0);
                    }
                }
                float yOffset = 0.0f;
                if (contact.entity.func_184187_bx() != null) {
                    yOffset = -4.0f;
                }
                if (contact.uuid != null && contact.uuid.equals(this.devUUID)) {
                    icon = this.textureAtlas.getAtlasSprite("glow");
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset, (int)((float)icon.getIconWidth() / 2.0f));
                    GLUtils.drawPost();
                }
                if (contact.type == EnumMobs.GHAST || contact.type == EnumMobs.GHASTATTACKING || contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE || contact.type == EnumMobs.VEX || contact.type == EnumMobs.VEXCHARGING || contact.type == EnumMobs.PUFFERFISH || contact.type == EnumMobs.PUFFERFISHHALF || contact.type == EnumMobs.PUFFERFISHFULL) {
                    EntityRenderer render;
                    if (contact.type == EnumMobs.GHAST || contact.type == EnumMobs.GHASTATTACKING) {
                        render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity).func_110623_a();
                        contact.type = path.endsWith("ghast_fire.png") ? EnumMobs.GHASTATTACKING : EnumMobs.GHAST;
                    } else if (contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE) {
                        render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity).func_110623_a();
                        contact.type = path.endsWith("wither_invulnerable.png") ? EnumMobs.WITHERINVULNERABLE : EnumMobs.WITHER;
                    } else if (contact.type == EnumMobs.VEX || contact.type == EnumMobs.VEXCHARGING) {
                        render = this.game.func_175598_ae().func_78713_a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity).func_110623_a();
                        contact.type = path.endsWith("vex_charging.png") ? EnumMobs.VEXCHARGING : EnumMobs.VEX;
                    } else if (contact.type == EnumMobs.PUFFERFISH || contact.type == EnumMobs.PUFFERFISHHALF || contact.type == EnumMobs.PUFFERFISHFULL) {
                        int size = ((PufferfishEntity)contact.entity).func_203715_dA();
                        switch (size) {
                            case 0: {
                                contact.type = EnumMobs.PUFFERFISH;
                                break;
                            }
                            case 1: {
                                contact.type = EnumMobs.PUFFERFISHHALF;
                                break;
                            }
                            case 2: {
                                contact.type = EnumMobs.PUFFERFISHFULL;
                            }
                        }
                    }
                    this.tryAutoIcon(contact);
                    this.tryCustomIcon(contact);
                    if (this.newMobs) {
                        try {
                            this.textureAtlas.stitchNew();
                        }
                        catch (StitcherException e) {
                            System.err.println("Stitcher exception in render method!  Resetting mobs texture atlas.");
                            this.loadTexturePackIcons();
                        }
                    }
                    this.newMobs = false;
                }
                this.applyFilteringParameters();
                GLUtils.drawPre();
                GLUtils.setMap(contact.icon, x, (float)y + yOffset, (int)((float)contact.icon.getIconWidth() / 4.0f));
                GLUtils.drawPost();
                if ((this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER || contact.type == EnumMobs.SHEEP) && contact.armorIcon != null) {
                    icon = contact.armorIcon;
                    float armorOffset = 0.0f;
                    if (contact.type == EnumMobs.ZOMBIEVILLAGER) {
                        armorOffset = -0.5f;
                    }
                    float armorScale = 1.1578947f;
                    float red = 1.0f;
                    float green = 1.0f;
                    float blue = 1.0f;
                    if (contact.armorColor != -1) {
                        red = (float)(contact.armorColor >> 16 & 0xFF) / 255.0f;
                        green = (float)(contact.armorColor >> 8 & 0xFF) / 255.0f;
                        blue = (float)(contact.armorColor >> 0 & 0xFF) / 255.0f;
                        if (contact.type == EnumMobs.SHEEP) {
                            armorScale = 1.04f;
                            SheepEntity sheepEntity = (SheepEntity)contact.entity;
                            if (sheepEntity.func_145818_k_() && "jeb_".equals(sheepEntity.func_200200_C_().func_150261_e())) {
                                int semiRandom = sheepEntity.field_70173_aa / 25 + sheepEntity.func_145782_y();
                                int numDyeColors = DyeColor.values().length;
                                int colorID1 = semiRandom % numDyeColors;
                                int colorID2 = (semiRandom + 1) % numDyeColors;
                                float lerpVal = ((float)(sheepEntity.field_70173_aa % 25) + this.game.func_184121_ak()) / 25.0f;
                                float[] sheepColors1 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)colorID1));
                                float[] sheepColors2 = SheepEntity.func_175513_a((DyeColor)DyeColor.func_196056_a((int)colorID2));
                                red = sheepColors1[0] * (1.0f - lerpVal) + sheepColors2[0] * lerpVal;
                                green = sheepColors1[1] * (1.0f - lerpVal) + sheepColors2[1] * lerpVal;
                                blue = sheepColors1[2] * (1.0f - lerpVal) + sheepColors2[2] * lerpVal;
                            }
                        }
                        if (wayY < 0) {
                            GLShim.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            GLShim.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                    }
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (float)icon.getIconWidth() / 4.0f * armorScale);
                    GLUtils.drawPost();
                    if (icon == this.clothIcon) {
                        if (wayY < 0) {
                            GLShim.glColor4f(1.0f, 1.0f, 1.0f, contact.brightness);
                        } else {
                            GLShim.glColor3f(1.0f * contact.brightness, 1.0f * contact.brightness, 1.0f * contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[2]);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / 4.0f * armorScale));
                        GLUtils.drawPost();
                        if (wayY < 0) {
                            GLShim.glColor4f(red, green, blue, contact.brightness);
                        } else {
                            GLShim.glColor3f(red * contact.brightness, green * contact.brightness, blue * contact.brightness);
                        }
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[1]);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / 4.0f * armorScale));
                        GLUtils.drawPost();
                        GLShim.glColor3f(1.0f, 1.0f, 1.0f);
                        icon = this.textureAtlas.getAtlasSprite("armor " + this.armorNames[3]);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(icon, x, (float)y + yOffset + armorOffset, (int)((float)icon.getIconWidth() / 4.0f * armorScale));
                        GLUtils.drawPost();
                    }
                } else if (contact.uuid != null && contact.uuid.equals(this.devUUID)) {
                    icon = this.textureAtlas.getAtlasSprite("crown");
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(icon, x, (float)y + yOffset, (int)((float)icon.getIconWidth() / 4.0f));
                    GLUtils.drawPost();
                }
                if (!this.options.showPlayerNames || contact.type != EnumMobs.PLAYER) continue;
                float scaleFactor = (float)this.layoutVariables.scScale / this.options.fontScale;
                GLShim.glScalef(1.0f / scaleFactor, 1.0f / scaleFactor, 1.0f);
                int m = this.chkLen(contact.name) / 2;
                this.write(contact.name, (float)x * scaleFactor - (float)m, (float)(y + 3) * scaleFactor, 0xFFFFFF);
            }
            catch (Exception localException) {
                System.err.println("Error rendering mob icon! " + localException.getLocalizedMessage() + " contact type " + (Object)((Object)contact.type));
            }
            finally {
                GLShim.glPopMatrix();
            }
        }
    }

    private void applyFilteringParameters() {
        if (this.options.filtering) {
            GLShim.glTexParameteri(3553, 10241, 9729);
            GLShim.glTexParameteri(3553, 10240, 9729);
            GLShim.glTexParameteri(3553, 10242, 10496);
            GLShim.glTexParameteri(3553, 10243, 10496);
        } else {
            GLShim.glTexParameteri(3553, 10241, 9728);
            GLShim.glTexParameteri(3553, 10240, 9728);
        }
    }

    private boolean isHostile(Entity entity) {
        if (entity instanceof ZombiePigmanEntity) {
            return ((ZombiePigmanEntity)entity).func_191990_c((PlayerEntity)this.game.field_71439_g);
        }
        if (entity instanceof IMob) {
            return true;
        }
        if (entity instanceof BeeEntity) {
            return ((BeeEntity)entity).func_226427_ez_();
        }
        if (entity instanceof PolarBearEntity) {
            for (Object object : ((PolarBearEntity)entity).field_70170_p.func_217357_a(PolarBearEntity.class, ((PolarBearEntity)entity).func_174813_aQ().func_72321_a(8.0, 4.0, 8.0))) {
                if (!((PolarBearEntity)object).func_70631_g_()) continue;
                return true;
            }
        }
        if (entity instanceof RabbitEntity) {
            return ((RabbitEntity)entity).func_175531_cl() == 99;
        }
        if (entity instanceof WolfEntity) {
            return ((WolfEntity)entity).func_70919_bu();
        }
        return false;
    }

    private boolean isPlayer(Entity entity) {
        return entity instanceof RemoteClientPlayerEntity;
    }

    private boolean isNeutral(Entity entity) {
        if (entity instanceof LivingEntity) {
            return !(entity instanceof PlayerEntity) && !this.isHostile(entity);
        }
        return false;
    }
}

