/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui;

import com.mamiyaotaru.voxelmap.gui.GuiSubworldEdit;
import com.mamiyaotaru.voxelmap.gui.overridden.GuiScreenMinimap;
import com.mamiyaotaru.voxelmap.interfaces.IVoxelMap;
import com.mamiyaotaru.voxelmap.interfaces.IWaypointManager;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.util.ClientRecipeBook;
import net.minecraft.entity.Entity;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiSubworldsSelect
extends GuiScreenMinimap
implements BooleanConsumer {
    private String title = "VoxelMap - Multiworld Selection";
    private String select = "Which world are you in?";
    private boolean multiworld = false;
    private Button cancelBtn;
    private TextFieldWidget newNameField;
    private boolean newWorld = false;
    private float yaw;
    private int thirdPersonViewOrig;
    private Button[] selectButtons;
    private Button[] editButtons;
    private String[] worlds;
    private Screen parent;
    ClientPlayerEntity thePlayer;
    ClientPlayerEntity camera;
    private IVoxelMap master;
    private IWaypointManager waypointManager;

    public GuiSubworldsSelect(Screen parent, IVoxelMap master) {
        this.minecraft = Minecraft.func_71410_x();
        this.parent = parent;
        this.thePlayer = this.getMinecraft().field_71439_g;
        this.camera = new ClientPlayerEntity(this.getMinecraft(), this.getMinecraft().field_71441_e, this.getMinecraft().func_147114_u(), this.thePlayer.func_146107_m(), new ClientRecipeBook(null));
        this.camera.field_71158_b = new MovementInputFromOptions(this.getMinecraft().field_71474_y);
        this.camera.func_70012_b(this.thePlayer.func_226277_ct_(), this.thePlayer.func_226278_cu_() - this.thePlayer.func_70033_W(), this.thePlayer.func_226281_cx_(), this.thePlayer.field_70177_z, 0.0f);
        this.yaw = this.thePlayer.field_70177_z;
        this.thirdPersonViewOrig = this.getMinecraft().field_71474_y.field_74320_O;
        this.master = master;
        this.waypointManager = master.getWaypointManager();
    }

    public void init() {
        ArrayList<String> knownSubworldNames = new ArrayList<String>(this.waypointManager.getKnownSubworldNames());
        if (!(this.multiworld || this.waypointManager.isMultiworld() || this.getMinecraft().func_181540_al())) {
            ConfirmScreen var8 = new ConfirmScreen((BooleanConsumer)this, (ITextComponent)new TranslationTextComponent("worldmap.multiworld.isthismultiworld", new Object[0]), (ITextComponent)new TranslationTextComponent("worldmap.multiworld.explanation", new Object[0]), I18nUtils.getString("gui.yes", new Object[0]), I18nUtils.getString("gui.no", new Object[0]));
            this.getMinecraft().func_147108_a((Screen)var8);
        } else {
            this.getMinecraft().field_71474_y.field_74320_O = 0;
            this.getMinecraft().func_175607_a((Entity)this.camera);
        }
        this.title = I18nUtils.getString("worldmap.multiworld.title", new Object[0]);
        this.select = I18nUtils.getString("worldmap.multiworld.select", new Object[0]);
        this.getButtonList().clear();
        int centerX = this.width / 2;
        int buttonsPerRow = this.width / 150;
        if (buttonsPerRow == 0) {
            buttonsPerRow = 1;
        }
        int buttonWidth = this.width / buttonsPerRow - 5;
        int xSpacing = (this.width - buttonsPerRow * buttonWidth) / 2;
        this.cancelBtn = new Button(centerX - 100, this.height - 30, 200, 20, I18nUtils.getString("gui.cancel", new Object[0]), null){

            public void onPress() {
                GuiSubworldsSelect.this.actionPerformed(this, 0);
            }
        };
        this.addButton((Widget)this.cancelBtn);
        final Collator collator = I18nUtils.getLocaleAwareCollator();
        Collections.sort(knownSubworldNames, new Comparator<String>(){

            @Override
            public int compare(String name1, String name2) {
                return -collator.compare(name1, name2);
            }
        });
        int numKnownSubworlds = knownSubworldNames.size();
        int completeRows = (int)Math.floor((float)(numKnownSubworlds + 1) / (float)buttonsPerRow);
        int lastRowShiftBy = (int)(Math.ceil((float)(numKnownSubworlds + 1) / (float)buttonsPerRow) * (double)buttonsPerRow - (double)(numKnownSubworlds + 1));
        this.worlds = new String[numKnownSubworlds];
        this.selectButtons = new Button[numKnownSubworlds + 1];
        this.editButtons = new Button[numKnownSubworlds + 1];
        for (int t = 0; t < numKnownSubworlds; ++t) {
            int shiftBy = 1;
            if (t / buttonsPerRow >= completeRows) {
                shiftBy = lastRowShiftBy + 1;
            }
            this.worlds[t] = knownSubworldNames.get(t);
            final int tt = t;
            this.selectButtons[t] = new Button((buttonsPerRow - shiftBy - t % buttonsPerRow) * buttonWidth + xSpacing, this.height - 60 - t / buttonsPerRow * 21, buttonWidth - 32, 20, this.worlds[t], null){

                public void onPress() {
                    GuiSubworldsSelect.this.actionPerformed(this, tt + 1);
                }
            };
            this.editButtons[t] = new Button((buttonsPerRow - shiftBy - t % buttonsPerRow) * buttonWidth + xSpacing + buttonWidth - 32, this.height - 60 - t / buttonsPerRow * 21, 30, 20, "\u2692", null){

                public void onPress() {
                    GuiSubworldsSelect.this.actionPerformed(this, -(tt + 1));
                }
            };
            this.addButton((Widget)this.selectButtons[t]);
            this.addButton((Widget)this.editButtons[t]);
        }
        final int numButtons = this.selectButtons.length - 1;
        if (!this.newWorld) {
            this.selectButtons[numButtons] = new Button((buttonsPerRow - 1 - lastRowShiftBy - numButtons % buttonsPerRow) * buttonWidth + xSpacing, this.height - 60 - numButtons / buttonsPerRow * 21, buttonWidth - 2, 20, "< " + I18nUtils.getString("worldmap.multiworld.newname", new Object[0]) + " >", null){

                public void onPress() {
                    GuiSubworldsSelect.this.actionPerformed(this, numButtons + 1);
                }
            };
            this.addButton((Widget)this.selectButtons[numButtons]);
        }
        this.newNameField = new TextFieldWidget(this.getFontRenderer(), (buttonsPerRow - 1 - lastRowShiftBy - numButtons % buttonsPerRow) * buttonWidth + xSpacing + 1, this.height - 60 - numButtons / buttonsPerRow * 21 + 1, buttonWidth - 4, 18, "");
    }

    protected void actionPerformed(Button button, int id) {
        if (button.active) {
            this.newWorld = false;
            if (id == this.worlds.length + 1) {
                this.newWorld = true;
                this.addButton((Widget)this.selectButtons[this.worlds.length]);
                this.newNameField.func_146195_b(true);
            } else if (id == 0) {
                this.getMinecraft().func_147108_a((Screen)null);
            } else if (id > 0) {
                this.worldSelected(this.worlds[id - 1]);
            } else {
                this.editWorld(this.worlds[-id - 1]);
            }
        }
    }

    public void accept(boolean par1) {
        if (!par1) {
            this.getMinecraft().func_147108_a(this.parent);
        } else {
            this.multiworld = true;
            this.getMinecraft().func_147108_a((Screen)this);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.newWorld) {
            this.newNameField.mouseClicked(mouseX, mouseY, mouseButton);
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean keyPressed(int keysm, int scancode, int b) {
        if (this.newNameField.isFocused()) {
            String newName;
            this.newNameField.keyPressed(keysm, scancode, b);
            if ((keysm == 257 || keysm == 335) && this.newNameField.isFocused() && (newName = this.newNameField.func_146179_b()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.keyPressed(keysm, scancode, b);
    }

    public boolean charTyped(char typedChar, int keyCode) {
        if (this.newNameField.isFocused()) {
            String newName;
            this.newNameField.charTyped(typedChar, keyCode);
            if (keyCode == 28 && (newName = this.newNameField.func_146179_b()) != null && !newName.isEmpty()) {
                this.worldSelected(newName);
            }
        }
        return super.charTyped(typedChar, keyCode);
    }

    public void tick() {
        this.newNameField.func_146178_a();
        super.tick();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int titleStringWidth = this.getFontRenderer().func_78256_a(this.title);
        titleStringWidth = Math.max(titleStringWidth, this.getFontRenderer().func_78256_a(this.select));
        GuiSubworldsSelect.fill((int)(this.width / 2 - titleStringWidth / 2 - 5), (int)0, (int)(this.width / 2 + titleStringWidth / 2 + 5), (int)27, (int)-1073741824);
        this.drawCenteredString(this.getFontRenderer(), this.title, this.width / 2, 5, 0xFFFFFF);
        this.drawCenteredString(this.getFontRenderer(), this.select, this.width / 2, 15, 0xFF0000);
        this.camera.field_70125_A = 0.0f;
        this.camera.field_70127_C = 0.0f;
        this.camera.field_70126_B = this.camera.field_70177_z = this.yaw;
        float var4 = 0.475f;
        this.camera.field_70137_T = this.camera.field_70167_r = this.thePlayer.func_226278_cu_();
        this.camera.field_70142_S = this.camera.field_70169_q = this.thePlayer.func_226277_ct_() - (double)var4 * Math.sin((double)this.yaw / 180.0 * Math.PI);
        this.camera.field_70136_U = this.camera.field_70166_s = this.thePlayer.func_226281_cx_() + (double)var4 * Math.cos((double)this.yaw / 180.0 * Math.PI);
        this.camera.func_70107_b(this.camera.field_70169_q, this.camera.field_70167_r, this.camera.field_70166_s);
        float var5 = 1.0f;
        this.yaw = (float)((double)this.yaw + (double)var5 * (1.0 + (double)0.7f * Math.cos((double)(this.yaw + 45.0f) / 45.0 * Math.PI)));
        super.render(mouseX, mouseY, partialTicks);
        if (this.newWorld) {
            this.newNameField.render(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void removed() {
        super.removed();
        this.getMinecraft().field_71474_y.field_74320_O = this.thirdPersonViewOrig;
        this.getMinecraft().func_175607_a((Entity)this.thePlayer);
    }

    private void worldSelected(String selectedSubworldName) {
        this.waypointManager.setSubworldName(selectedSubworldName, false);
        if (this.parent == null) {
            this.getMinecraft().func_147108_a((Screen)null);
        } else {
            this.getMinecraft().func_147108_a(this.parent);
        }
    }

    private void editWorld(String subworldNameToEdit) {
        this.getMinecraft().func_147108_a((Screen)new GuiSubworldEdit(this, this.master, subworldNameToEdit));
    }
}

