/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.gui.overridden;

import com.mamiyaotaru.voxelmap.util.GLShim;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;

public abstract class GuiSlotMinimap<E extends AbstractList.AbstractListEntry<E>>
extends ExtendedList<E> {
    protected int slotWidth = 220;
    protected boolean centerListVertically = true;
    private boolean showTopBottomBG = true;
    private boolean showSlotBG = true;
    private boolean hasListHeader;
    protected int headerPadding;
    protected long lastClicked = 0L;
    public boolean doubleclick = false;

    public GuiSlotMinimap(Minecraft par1Minecraft, int width, int height, int top, int bottom, int slotHeight) {
        super(par1Minecraft, width, height, top, bottom, slotHeight);
        this.setBlitOffset(0);
    }

    public void setDimensions(int width, int height, int top, int bottom) {
        this.width = width;
        this.height = height;
        this.y0 = top;
        this.y1 = bottom;
        this.x0 = 0;
        this.x1 = width;
    }

    public void setShowTopBottomBG(boolean showTopBottomBG) {
        this.showTopBottomBG = showTopBottomBG;
    }

    public void setShowSlotBG(boolean showSlotBG) {
        this.showSlotBG = showSlotBG;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        int maxScroll;
        this.renderBackground();
        int scrollBarLeft = this.getScrollbarPosition();
        int scrollBarRight = scrollBarLeft + 6;
        this.setScrollAmount(this.getScrollAmount());
        GLShim.glDisable(2896);
        GLShim.glDisable(2912);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        if (this.showSlotBG) {
            this.minecraft.func_110434_K().func_110577_a(Screen.BACKGROUND_LOCATION);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float f = 32.0f;
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_((float)this.x0 / f, (float)(this.y1 + (int)this.getScrollAmount()) / f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_((float)this.x1 / f, (float)(this.y1 + (int)this.getScrollAmount()) / f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_((float)this.x1 / f, (float)(this.y0 + (int)this.getScrollAmount()) / f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_((float)this.x0 / f, (float)(this.y0 + (int)this.getScrollAmount()) / f).func_225586_a_(32, 32, 32, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        int leftEdge = this.x0 + this.width / 2 - this.getRowWidth() / 2 + 2;
        int topOfListYPos = this.y0 + 4 - (int)this.getScrollAmount();
        if (this.hasListHeader) {
            this.renderHeader(leftEdge, topOfListYPos, tessellator);
        }
        this.renderList(leftEdge, topOfListYPos, mouseX, mouseY, partialTicks);
        GLShim.glDisable(2929);
        int topBottomFadeHeight = 4;
        if (this.showTopBottomBG) {
            this.renderHoleBackground(0, this.y0, 255, 255);
            this.renderHoleBackground(this.y1, this.height, 255, 255);
        }
        GLShim.glEnable(3042);
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
        GLShim.glDisable(3008);
        GLShim.glShadeModel(7425);
        GLShim.glDisable(3553);
        if (this.showTopBottomBG) {
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_225582_a_((double)this.x0, (double)(this.y0 + topBottomFadeHeight), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            vertexBuffer.func_225582_a_((double)this.x1, (double)(this.y0 + topBottomFadeHeight), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            vertexBuffer.func_225582_a_((double)this.x1, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)this.x0, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_225582_a_((double)this.x0, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)this.x1, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)this.x1, (double)(this.y1 - topBottomFadeHeight), 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            vertexBuffer.func_225582_a_((double)this.x0, (double)(this.y1 - topBottomFadeHeight), 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
        }
        if ((maxScroll = this.getMaxScroll()) > 0) {
            int k1 = (this.y1 - this.y0) * (this.y1 - this.y0) / this.getMaxPosition();
            k1 = MathHelper.func_76125_a((int)k1, (int)32, (int)(this.y1 - this.y0 - 8));
            int l1 = (int)this.getScrollAmount() * (this.y1 - this.y0 - k1) / maxScroll + this.y0;
            if (l1 < this.y0) {
                l1 = this.y0;
            }
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_225582_a_((double)scrollBarLeft, (double)this.y1, 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)scrollBarRight, (double)this.y1, 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)scrollBarRight, (double)this.y0, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)scrollBarLeft, (double)this.y0, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_225582_a_((double)scrollBarLeft, (double)(l1 + k1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)scrollBarRight, (double)(l1 + k1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)scrollBarRight, (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)scrollBarLeft, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(128, 128, 128, 255).func_181675_d();
            tessellator.func_78381_a();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            vertexBuffer.func_225582_a_((double)scrollBarLeft, (double)(l1 + k1 - 1), 0.0).func_225583_a_(0.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)(scrollBarRight - 1), (double)(l1 + k1 - 1), 0.0).func_225583_a_(1.0f, 1.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)(scrollBarRight - 1), (double)l1, 0.0).func_225583_a_(1.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            vertexBuffer.func_225582_a_((double)scrollBarLeft, (double)l1, 0.0).func_225583_a_(0.0f, 0.0f).func_225586_a_(192, 192, 192, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        this.renderDecorations(mouseX, mouseY);
        GLShim.glEnable(3553);
        GLShim.glShadeModel(7424);
        GLShim.glEnable(3008);
        GLShim.glDisable(3042);
    }

    private int getMaxScroll() {
        return Math.max(0, this.getMaxPosition() - (this.y1 - this.y0 - 4));
    }

    public int getRowWidth() {
        return this.slotWidth;
    }

    public void setSlotWidth(int slotWidth) {
        this.slotWidth = slotWidth;
    }

    protected int getScrollbarPosition() {
        if (this.slotWidth >= 220) {
            return this.width / 2 + 124;
        }
        return this.x1 - 6;
    }

    public void setLeftPos(int left) {
        this.x0 = left;
        this.x1 = left + this.width;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.doubleclick = System.currentTimeMillis() - this.lastClicked < 250L;
        this.lastClicked = System.currentTimeMillis();
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

