/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.gui.GuiAddWaypoint;
import com.mamiyaotaru.voxelmap.gui.GuiSelectPlayer;
import com.mamiyaotaru.voxelmap.interfaces.AbstractVoxelMap;
import com.mamiyaotaru.voxelmap.util.DimensionContainer;
import com.mamiyaotaru.voxelmap.util.I18nUtils;
import com.mamiyaotaru.voxelmap.util.TextUtils;
import com.mamiyaotaru.voxelmap.util.Waypoint;
import java.util.ArrayList;
import java.util.Random;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;

public class CommandUtils {
    private static final String NEW_WAYPOINT_COMMAND = "/newWaypoint ";
    private static final int NEW_WAYPOINT_COMMAND_LENGTH = "/newWaypoint ".length();
    private static final String TELEPORT_COMMAND = "/ztp ";
    private static final int TELEPORT_COMMAND_LENGTH = "/ztp ".length();
    private static Random generator = new Random();
    public static Pattern pattern = Pattern.compile("\\[(\\w+\\s*:\\s*[-#]?[^\\[\\]]+)(,\\s*\\w+\\s*:\\s*[-#]?[^\\[\\]]+)+\\]", 2);

    public static boolean checkForWaypoints(ITextComponent chat, String message) {
        message = chat.getString();
        ArrayList<String> waypointStrings = CommandUtils.getWaypointStrings(message);
        if (waypointStrings.size() > 0) {
            ArrayList<StringTextComponent> textComponents = new ArrayList<StringTextComponent>();
            int count = 0;
            for (String waypointString : waypointStrings) {
                int n = message.indexOf(waypointString);
                if (n > count) {
                    textComponents.add(new StringTextComponent(message.substring(count, n)));
                }
                StringTextComponent clickableWaypoint = new StringTextComponent(waypointString);
                Style chatStyle = clickableWaypoint.func_150256_b();
                chatStyle.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, NEW_WAYPOINT_COMMAND + waypointString.substring(1, waypointString.length() - 1)));
                chatStyle.func_150238_a(TextFormatting.AQUA);
                StringTextComponent hover = new StringTextComponent(I18nUtils.getString("minimap.waypointshare.tooltip1", new Object[0]) + "\n" + I18nUtils.getString("minimap.waypointshare.tooltip2", new Object[0]));
                chatStyle.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hover));
                textComponents.add(clickableWaypoint);
                count = n + waypointString.length();
            }
            if (count < message.length() - 1) {
                textComponents.add(new StringTextComponent(message.substring(count, message.length())));
            }
            StringTextComponent finalTextComponent = new StringTextComponent("");
            for (ITextComponent iTextComponent : textComponents) {
                finalTextComponent.func_150257_a(iTextComponent);
            }
            Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)finalTextComponent);
            return false;
        }
        return true;
    }

    public static ArrayList<String> getWaypointStrings(String message) {
        ArrayList<String> list = new ArrayList<String>();
        if (message.contains("[") && message.contains("]")) {
            Matcher matcher = pattern.matcher(message);
            while (matcher.find()) {
                String match = matcher.group();
                if (CommandUtils.createWaypointFromChat(match.substring(1, match.length() - 1)) == null) continue;
                list.add(match);
            }
        }
        return list;
    }

    private static Waypoint createWaypointFromChat(String details) {
        Waypoint waypoint = null;
        String[] pairs = details.split(",");
        try {
            String name = "";
            Integer x = null;
            Integer z = null;
            Integer y = 64;
            boolean enabled = true;
            float red = generator.nextFloat();
            float green = generator.nextFloat();
            float blue = generator.nextFloat();
            String suffix = "";
            String world = "";
            TreeSet<DimensionContainer> dimensions = new TreeSet<DimensionContainer>();
            for (int t = 0; t < pairs.length; ++t) {
                int splitIndex = pairs[t].indexOf(":");
                if (splitIndex == -1) continue;
                String key = pairs[t].substring(0, splitIndex).toLowerCase().trim();
                String value = pairs[t].substring(splitIndex + 1).trim();
                if (key.equals("name")) {
                    name = TextUtils.descrubName(value);
                    continue;
                }
                if (key.equals("x")) {
                    x = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("z")) {
                    z = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("y")) {
                    y = Integer.parseInt(value);
                    continue;
                }
                if (key.equals("enabled")) {
                    enabled = Boolean.parseBoolean(value);
                    continue;
                }
                if (key.equals("red")) {
                    red = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("green")) {
                    green = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("blue")) {
                    blue = Float.parseFloat(value);
                    continue;
                }
                if (key.equals("color")) {
                    int color = Integer.decode(value);
                    red = (float)(color >> 16 & 0xFF) / 255.0f;
                    green = (float)(color >> 8 & 0xFF) / 255.0f;
                    blue = (float)(color >> 0 & 0xFF) / 255.0f;
                    continue;
                }
                if (key.equals("suffix") || key.equals("icon")) {
                    suffix = value;
                    continue;
                }
                if (key.equals("world")) {
                    world = TextUtils.descrubName(value);
                    continue;
                }
                if (key.equals("dimensions")) {
                    String[] dimensionStrings = value.split("#");
                    for (int s = 0; s < dimensionStrings.length; ++s) {
                        dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByIdentifier(dimensionStrings[s]));
                    }
                    continue;
                }
                if (!key.equals("dimension") && !key.equals("dim")) continue;
                dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByIdentifier(value));
            }
            if (world == "") {
                world = AbstractVoxelMap.getInstance().getWaypointManager().getCurrentSubworldDescriptor(false);
            }
            if (dimensions.size() == 0) {
                dimensions.add(AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension(Minecraft.func_71410_x().field_71441_e.field_73011_w));
            }
            if (x != null && z != null) {
                if (dimensions.size() == 1 && ((DimensionContainer)dimensions.first()).id == -1) {
                    x = x * 8;
                    z = z * 8;
                }
                waypoint = new Waypoint(name, x, z, y, enabled, red, green, blue, suffix, world, dimensions);
            }
        }
        catch (NumberFormatException e) {
            waypoint = null;
        }
        return waypoint;
    }

    public static void waypointClicked(String command) {
        boolean control = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)InputMappings.func_197955_a((String)"key.keyboard.left.control").func_197937_c()) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)InputMappings.func_197955_a((String)"key.keyboard.right.control").func_197937_c());
        String details = command.substring(NEW_WAYPOINT_COMMAND_LENGTH);
        Waypoint newWaypoint = CommandUtils.createWaypointFromChat(details);
        if (newWaypoint != null) {
            for (Waypoint existingWaypoint : AbstractVoxelMap.getInstance().getWaypointManager().getWaypoints()) {
                if (newWaypoint.getX() != existingWaypoint.getX() || newWaypoint.getZ() != existingWaypoint.getZ()) continue;
                if (control) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new GuiAddWaypoint(null, AbstractVoxelMap.getInstance(), existingWaypoint, true));
                } else {
                    AbstractVoxelMap.getInstance().getWaypointManager().setHighlightedWaypoint(existingWaypoint, false);
                }
                return;
            }
            if (control) {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiAddWaypoint(null, AbstractVoxelMap.getInstance(), newWaypoint, false));
            } else {
                AbstractVoxelMap.getInstance().getWaypointManager().setHighlightedWaypoint(newWaypoint, false);
            }
        }
    }

    public static void sendWaypoint(Waypoint waypoint) {
        int dimension = AbstractVoxelMap.getInstance().getDimensionManager().getDimensionContainerByDimension((Dimension)Minecraft.func_71410_x().field_71441_e.field_73011_w).id;
        int color = ((int)(waypoint.red * 255.0f) & 0xFF) << 16 | ((int)(waypoint.green * 255.0f) & 0xFF) << 8 | (int)(waypoint.blue * 255.0f) & 0xFF;
        String hexColor = Integer.toHexString(color);
        while (hexColor.length() < 6) {
            hexColor = "0" + hexColor;
        }
        hexColor = "#" + hexColor;
        String world = AbstractVoxelMap.getInstance().getWaypointManager().getCurrentSubworldDescriptor(false);
        if (waypoint.world != null && waypoint.world != "") {
            world = waypoint.world;
        }
        String suffix = waypoint.imageSuffix;
        Object[] args = new Object[]{TextUtils.scrubNameRegex(waypoint.name), waypoint.getX(), waypoint.getY(), waypoint.getZ(), dimension};
        String message = String.format("[name:%s, x:%s, y:%s, z:%s, dim:%s", args);
        if (world != null && !world.equals("")) {
            message = message + ", world:" + world;
        }
        if (suffix != null && !suffix.equals("")) {
            message = message + ", icon:" + suffix;
        }
        message = message + "]";
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiSelectPlayer(null, AbstractVoxelMap.getInstance(), message, true));
    }

    public static void sendCoordinate(int x, int y, int z) {
        String message = String.format("[x:%s, y:%s, z:%s]", x, y, z);
        Minecraft.func_71410_x().func_147108_a((Screen)new GuiSelectPlayer(null, AbstractVoxelMap.getInstance(), message, false));
    }

    public static void teleport(String command) {
        String details = command.substring(TELEPORT_COMMAND_LENGTH);
        ArrayList<Waypoint> waypoints = AbstractVoxelMap.getInstance().getWaypointManager().getWaypoints();
        for (Waypoint wp : waypoints) {
            boolean mp;
            if (!wp.name.equalsIgnoreCase(details) || !wp.inDimension || !wp.inWorld) continue;
            boolean bl = mp = !Minecraft.func_71410_x().func_71387_A();
            int y = wp.getY() > 0 ? wp.getY() : (Minecraft.func_71410_x().field_71439_g.field_71093_bK != DimensionType.field_223228_b_ ? 128 : 64);
            Minecraft.func_71410_x().field_71439_g.func_71165_d("/tp " + Minecraft.func_71410_x().field_71439_g.func_200200_C_().getString() + " " + wp.getX() + " " + y + " " + wp.getZ());
            if (mp) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d("/tppos " + wp.getX() + " " + y + " " + wp.getZ());
            }
            return;
        }
    }

    public static int getSafeHeight(int x, int y, int z, World worldObj) {
        boolean inNetherDimension = worldObj.field_73011_w.func_177495_o();
        BlockPos blockPos = new BlockPos(x, y, z);
        Chunk chunk = worldObj.func_175726_f(blockPos);
        worldObj.func_72863_F().func_212849_a_(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4, ChunkStatus.field_222617_m, true);
        if (inNetherDimension) {
            int safeY = -1;
            for (int t = 0; t < 127; ++t) {
                if (y + t < 127 && CommandUtils.isBlockStandable(worldObj, x, y + t, z) && CommandUtils.isBlockOpen(worldObj, x, y + t + 1, z) && CommandUtils.isBlockOpen(worldObj, x, y + t + 2, z)) {
                    safeY = y + t + 1;
                    t = 128;
                }
                if (y - t <= 0 || !CommandUtils.isBlockStandable(worldObj, x, y - t, z) || !CommandUtils.isBlockOpen(worldObj, x, y - t + 1, z) || !CommandUtils.isBlockOpen(worldObj, x, y - t + 2, z)) continue;
                safeY = y - t + 1;
                t = 128;
            }
            y = safeY;
        } else if (y <= 0) {
            y = worldObj.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, x, z) + 1;
        }
        return y;
    }

    private static boolean isBlockStandable(World worldObj, int par1, int par2, int par3) {
        BlockPos blockPos = new BlockPos(par1, par2, par3);
        BlockState blockState = worldObj.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        return block == null ? false : blockState.func_185904_a().func_76218_k();
    }

    private static boolean isBlockOpen(World worldObj, int par1, int par2, int par3) {
        BlockPos blockPos = new BlockPos(par1, par2, par3);
        BlockState blockState = worldObj.func_180495_p(blockPos);
        Block block = blockState.func_177230_c();
        return block == null ? true : !blockState.func_215696_m((IBlockReader)worldObj, blockPos);
    }
}

