/*
 * Decompiled with CFR 0.152.
 */
package com.mamiyaotaru.voxelmap.util;

import com.mamiyaotaru.voxelmap.interfaces.IChangeObserver;
import net.minecraft.client.Minecraft;
import net.minecraft.world.chunk.Chunk;

public class MapChunk {
    private int x = 0;
    private int z = 0;
    private Chunk chunk;
    private boolean isChanged = false;
    private boolean isLoaded = false;
    private boolean isSurroundedByLoaded = false;

    public MapChunk(int x, int z) {
        this.x = x;
        this.z = z;
        this.chunk = Minecraft.func_71410_x().field_71441_e.func_212866_a_(x, z);
        this.isLoaded = this.chunk != null && !this.chunk.func_76621_g() && Minecraft.func_71410_x().field_71441_e.func_217354_b(x, z);
        this.isSurroundedByLoaded = false;
        this.isChanged = true;
    }

    public void checkIfChunkChanged(IChangeObserver changeObserver) {
        if (this.hasChunkLoadedOrUnloaded() || this.isChanged) {
            this.isChanged = false;
            changeObserver.processChunk(this.chunk);
        }
    }

    private boolean hasChunkLoadedOrUnloaded() {
        boolean hasChanged = false;
        if (!this.isLoaded) {
            this.chunk = Minecraft.func_71410_x().field_71441_e.func_212866_a_(this.x, this.z);
            if (this.chunk != null && !this.chunk.func_76621_g() && Minecraft.func_71410_x().field_71441_e.func_217354_b(this.x, this.z)) {
                this.isLoaded = true;
                hasChanged = true;
            }
        } else if (this.isLoaded && (this.chunk == null || this.chunk.func_76621_g() || !Minecraft.func_71410_x().field_71441_e.func_217354_b(this.x, this.z))) {
            this.isLoaded = false;
            hasChanged = true;
        }
        return hasChanged;
    }

    public void checkIfChunkBecameSurroundedByLoaded(IChangeObserver changeObserver) {
        this.chunk = Minecraft.func_71410_x().field_71441_e.func_212866_a_(this.x, this.z);
        boolean bl = this.isLoaded = this.chunk != null && !this.chunk.func_76621_g() && Minecraft.func_71410_x().field_71441_e.func_217354_b(this.x, this.z);
        if (this.isLoaded) {
            boolean formerSurroundedByLoaded = this.isSurroundedByLoaded;
            this.isSurroundedByLoaded = this.isSurroundedByLoaded();
            if (!formerSurroundedByLoaded && this.isSurroundedByLoaded) {
                changeObserver.processChunk(this.chunk);
            }
        } else {
            this.isSurroundedByLoaded = false;
        }
    }

    public boolean isSurroundedByLoaded() {
        this.chunk = Minecraft.func_71410_x().field_71441_e.func_212866_a_(this.x, this.z);
        boolean neighborsLoaded = this.isLoaded = this.chunk != null && !this.chunk.func_76621_g() && Minecraft.func_71410_x().field_71441_e.func_217354_b(this.x, this.z);
        for (int t = this.x - 1; t <= this.x + 1 && neighborsLoaded; ++t) {
            for (int s = this.z - 1; s <= this.z + 1 && neighborsLoaded; ++s) {
                Chunk neighborChunk = Minecraft.func_71410_x().field_71441_e.func_212866_a_(t, s);
                neighborsLoaded = neighborsLoaded && neighborChunk != null && !neighborChunk.func_76621_g() && Minecraft.func_71410_x().field_71441_e.func_217354_b(t, s);
            }
        }
        return neighborsLoaded;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public void setModified(boolean isModified) {
        this.isChanged = isModified;
    }
}

