/*
 * Decompiled with CFR 0.152.
 */
package friendlymobs.client.gui;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import friendlymobs.api.event.GuiSelectedEvent;
import friendlymobs.client.gui.GuiListSlot;
import friendlymobs.util.ArrayListExtended;
import friendlymobs.util.FriendlyUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiSelectMob
extends GuiScreen {
    protected final GuiScreen parent;
    protected GuiConfigEntries.ArrayEntry configElement;
    protected MobList mobList;
    protected GuiButton doneButton;
    protected GuiTextField filterTextField;
    protected HoverChecker selectedHoverChecker;
    protected Collection<ResourceLocation> presetMobs;

    public GuiSelectMob(GuiScreen parent) {
        this.parent = parent;
    }

    public GuiSelectMob(GuiScreen parent, GuiConfigEntries.ArrayEntry entry) {
        this(parent);
        this.configElement = entry;
    }

    public GuiSelectMob setPresetMobs(Collection<ResourceLocation> mobs) {
        this.presetMobs = mobs;
        return this;
    }

    public Collection<ResourceLocation> getPresetMobs() {
        return this.presetMobs;
    }

    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.mobList == null) {
            this.mobList = new MobList();
        }
        this.mobList.func_148122_a(this.field_146294_l, this.field_146295_m, 32, this.field_146295_m - 28);
        if (this.doneButton == null) {
            this.doneButton = new GuiButtonExt(0, 0, 0, 145, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        }
        this.doneButton.field_146128_h = this.field_146294_l / 2 + 10;
        this.doneButton.field_146129_i = this.field_146295_m - this.doneButton.field_146121_g - 4;
        this.field_146292_n.clear();
        this.field_146292_n.add(this.doneButton);
        if (this.filterTextField == null) {
            this.filterTextField = new GuiTextField(1, this.field_146289_q, 0, 0, 150, 16);
            this.filterTextField.func_146203_f(100);
        }
        this.filterTextField.field_146209_f = this.field_146294_l / 2 - this.filterTextField.field_146218_h - 5;
        this.filterTextField.field_146210_g = this.field_146295_m - this.filterTextField.field_146219_i - 6;
        if (this.selectedHoverChecker == null) {
            this.selectedHoverChecker = new HoverChecker(0, 20, 0, 100, 800);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            switch (button.field_146127_k) {
                case 0: {
                    List<ResourceLocation> selected = this.mobList.getSelected();
                    GuiSelectedEvent.OnMobSelectedEvent event = new GuiSelectedEvent.OnMobSelectedEvent(selected.toArray(new ResourceLocation[selected.size()]));
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (!event.getResult().equals((Object)Event.Result.DENY) && event.mobs != null) {
                        MinecraftForge.EVENT_BUS.post((Event)new GuiSelectedEvent.PostMobSelectedEvent(event.mobs));
                        if (this.configElement != null) {
                            Object[] entries = new String[event.mobs.length];
                            for (int i = 0; i < entries.length; ++i) {
                                entries[i] = event.mobs[i].toString();
                            }
                            this.configElement.setListFromChildScreen(entries);
                        }
                    }
                    this.field_146297_k.func_147108_a(this.parent);
                    if (this.parent == null) {
                        this.field_146297_k.func_71381_h();
                    }
                    this.mobList.selected.clear();
                    this.mobList.scrollToTop();
                    break;
                }
                default: {
                    this.mobList.func_148147_a(button);
                }
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.filterTextField.func_146178_a();
    }

    public void func_73863_a(int mouseX, int mouseY, float ticks) {
        if (this.mobList == null || this.doneButton == null || this.filterTextField == null) {
            return;
        }
        this.mobList.func_148128_a(mouseX, mouseY, ticks);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"friendlymobs.config.select.mob", (Object[])new Object[0]), this.field_146294_l / 2, 15, 0xFFFFFF);
        super.func_73863_a(mouseX, mouseY, ticks);
        this.filterTextField.func_146194_f();
        if (!this.mobList.selected.isEmpty()) {
            List<String> selected = this.mobList.getSelectedMobs();
            if (mouseX <= 100 && mouseY <= 20) {
                this.func_73731_b(this.field_146289_q, I18n.func_135052_a((String)"friendlymobs.config.select.mob.selected", (Object[])new Object[]{selected.size()}), 5, 5, 0xEFEFEF);
            }
            if (this.selectedHoverChecker.checkHover(mouseX, mouseY)) {
                this.func_146283_a(selected, mouseX, mouseY);
            }
        }
    }

    protected void func_73864_a(int x, int y, int code) throws IOException {
        super.func_73864_a(x, y, code);
        this.filterTextField.func_146192_a(x, y, code);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        this.mobList.func_178039_p();
    }

    protected void func_73869_a(char c, int code) throws IOException {
        if (this.filterTextField.func_146206_l()) {
            boolean changed;
            if (code == 1) {
                this.filterTextField.func_146195_b(false);
            }
            String prev = this.filterTextField.func_146179_b();
            this.filterTextField.func_146201_a(c, code);
            String text = this.filterTextField.func_146179_b();
            boolean bl = changed = text != prev;
            if (Strings.isNullOrEmpty((String)text) && changed) {
                this.mobList.setFilter(null);
            } else if (changed || code == 28) {
                this.mobList.setFilter(text);
            }
        } else if (code == 1) {
            this.field_146297_k.func_147108_a(this.parent);
            if (this.parent == null) {
                this.field_146297_k.func_71381_h();
            }
        } else if (code == 14) {
            this.mobList.selected.clear();
        } else if (code == 15) {
            if (++this.mobList.nameType > 1) {
                this.mobList.nameType = 0;
            }
        } else if (code == 200) {
            this.mobList.scrollUp();
        } else if (code == 208) {
            this.mobList.scrollDown();
        } else if (code == 199) {
            this.mobList.scrollToTop();
        } else if (code == 207) {
            this.mobList.scrollToEnd();
        } else if (code == 57) {
            this.mobList.scrollToSelected();
        } else if (code == 201) {
            this.mobList.scrollToPrev();
        } else if (code == 209) {
            this.mobList.scrollToNext();
        } else if (code == 33 || code == this.field_146297_k.field_71474_y.field_74310_D.func_151463_i()) {
            this.filterTextField.func_146195_b(true);
        } else if (GuiSelectMob.func_146271_m() && code == 30) {
            this.mobList.selected.clear();
            this.mobList.selected.addAll(this.mobList.contents);
        }
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected class MobList
    extends GuiListSlot<ResourceLocation>
    implements Comparator<ResourceLocation> {
        protected final ArrayListExtended<ResourceLocation> mobs;
        protected final ArrayListExtended<ResourceLocation> contents;
        protected final ArrayListExtended<ResourceLocation> selected;
        protected final Map<String, List<ResourceLocation>> filterCache;
        protected int nameType;
        private boolean clickFlag;

        protected MobList() {
            super(GuiSelectMob.this.field_146297_k, 0, 0, 0, 0, 18);
            this.mobs = new ArrayListExtended();
            this.contents = new ArrayListExtended();
            this.selected = new ArrayListExtended();
            this.filterCache = Maps.newHashMap();
            this.initEntries();
        }

        protected void initEntries() {
            this.mobs.clear();
            this.contents.clear();
            this.selected.clear();
            this.filterCache.clear();
            for (Map.Entry entry : ForgeRegistries.ENTITIES.getEntries()) {
                EntityEntry entityEntry = (EntityEntry)entry.getValue();
                Class entityClass = entityEntry.getEntityClass();
                if (EntityMob.class == entityClass || EntityLiving.class == entityClass || !EntityLiving.class.isAssignableFrom(entityClass)) continue;
                this.mobs.addIfAbsent((ResourceLocation)entry.getKey());
            }
            Collections.sort(this.mobs, this);
            this.contents.addAll(this.mobs);
            if (GuiSelectMob.this.presetMobs != null && !GuiSelectMob.this.presetMobs.isEmpty()) {
                for (ResourceLocation key : GuiSelectMob.this.presetMobs) {
                    this.selected.addIfAbsent(key);
                }
            } else if (GuiSelectMob.this.configElement != null) {
                for (Object obj : GuiSelectMob.this.configElement.getCurrentValues()) {
                    ResourceLocation key = new ResourceLocation(obj.toString());
                    this.selected.addIfAbsent(key);
                }
            }
            if (!this.selected.isEmpty()) {
                Collections.sort(this.selected, this);
            }
        }

        @Override
        protected List<ResourceLocation> getContents() {
            return this.contents;
        }

        @Override
        protected List<ResourceLocation> getSelected() {
            return this.selected;
        }

        protected List<String> getMobs() {
            return Lists.transform(this.contents, entry -> I18n.func_135052_a((String)("entity." + EntityList.func_191302_a((ResourceLocation)entry) + ".name"), (Object[])new Object[0]));
        }

        protected List<String> getSelectedMobs() {
            return Lists.transform(this.getSelected(), entry -> I18n.func_135052_a((String)("entity." + EntityList.func_191302_a((ResourceLocation)entry) + ".name"), (Object[])new Object[0]));
        }

        protected void func_148123_a() {
            GuiSelectMob.this.func_146276_q_();
        }

        protected void func_192637_a(int index, int insideLeft, int par3, int par4, int mouseX, int mouseY, float ticks) {
            String name;
            ResourceLocation key = this.contents.get(index, null);
            if (key == null) {
                return;
            }
            switch (this.nameType) {
                case 1: {
                    name = key.toString();
                    break;
                }
                default: {
                    name = I18n.func_135052_a((String)("entity." + EntityList.func_191302_a((ResourceLocation)key) + ".name"), (Object[])new Object[0]);
                }
            }
            GuiSelectMob.this.func_73732_a(GuiSelectMob.this.field_146289_q, name, this.field_148155_a / 2, par3 + 1, 0xFFFFFF);
        }

        protected void func_148144_a(int index, boolean flag, int mouseX, int mouseY) {
            ResourceLocation key = this.contents.get(index, null);
            if (key != null && (this.clickFlag = !this.clickFlag) && !this.selected.remove(key)) {
                this.selected.addIfAbsent(key);
                Collections.sort(this.selected, this);
            }
        }

        protected boolean func_148131_a(int index) {
            ResourceLocation key = this.contents.get(index, null);
            return key != null && this.selected.contains(key);
        }

        @Override
        public int compare(ResourceLocation o1, ResourceLocation o2) {
            return StringUtils.compare((String)o1.toString(), (String)o2.toString());
        }

        protected void setFilter(String filter) {
            FriendlyUtils.getPool().execute(() -> {
                List<ResourceLocation> result;
                if (Strings.isNullOrEmpty((String)filter)) {
                    result = this.mobs;
                } else if (filter.equals("selected")) {
                    result = this.selected;
                } else {
                    if (!this.filterCache.containsKey(filter)) {
                        this.filterCache.put(filter, Lists.newArrayList((Iterable)Collections2.filter(this.mobs, input -> this.filterMatch((ResourceLocation)input, filter))));
                    }
                    result = this.filterCache.get(filter);
                }
                if (!this.contents.equals(result)) {
                    this.contents.clear();
                    this.contents.addAll(result);
                }
            });
        }

        protected boolean filterMatch(ResourceLocation key, String filter) {
            if ("monster".equalsIgnoreCase(filter)) {
                Class entityClass = EntityList.getClass((ResourceLocation)key);
                if (IMob.class.isAssignableFrom(entityClass)) {
                    return true;
                }
            } else if ("animal".equalsIgnoreCase(filter)) {
                Class entityClass = EntityList.getClass((ResourceLocation)key);
                if (IMob.class.isAssignableFrom(entityClass)) {
                    return false;
                }
                if (IAnimals.class.isAssignableFrom(entityClass)) {
                    return true;
                }
            }
            return StringUtils.containsIgnoreCase((CharSequence)key.toString(), (CharSequence)filter) || StringUtils.containsIgnoreCase((CharSequence)I18n.func_135052_a((String)("entity." + EntityList.func_191302_a((ResourceLocation)key) + ".name"), (Object[])new Object[0]), (CharSequence)filter);
        }
    }
}

