/*
 * Decompiled with CFR 0.152.
 */
package friendlymobs.core;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import friendlymobs.client.config.SelectMobEntry;
import friendlymobs.util.FriendlyLog;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class Config
implements IMessage,
IMessageHandler<Config, IMessage> {
    public static Configuration config;
    public static String[] friendlyMobs;
    public static Class<? extends GuiConfigEntries.IConfigEntry> selectMobEntry;
    public static final String LANG_KEY = "friendlymobs.config.";

    @SideOnly(value=Side.CLIENT)
    public static void initializeConfigEntries() {
        selectMobEntry = SelectMobEntry.class;
    }

    public static void syncConfig() {
        if (config == null) {
            File file = new File(Loader.instance().getConfigDir(), "FriendlyMobs.cfg");
            config = new Configuration(file);
            try {
                config.load();
            }
            catch (Exception e) {
                File dest = new File(file.getParentFile(), file.getName() + ".bak");
                if (dest.exists()) {
                    dest.delete();
                }
                file.renameTo(dest);
                FriendlyLog.log(Level.ERROR, e, "A critical error occured reading the " + file.getName() + " file, defaults will be used - the invalid file is backed up at " + dest.getName(), new Object[0]);
            }
        }
        String category = "general";
        ArrayList propOrder = Lists.newArrayList();
        Property prop = config.get(category, "friendlyMobs", new String[0]);
        prop.setLanguageKey(LANG_KEY + category + "." + prop.getName()).setConfigEntryClass(selectMobEntry);
        String comment = I18n.func_74838_a((String)(prop.getLanguageKey() + ".tooltip"));
        prop.setComment(comment);
        propOrder.add(prop.getName());
        friendlyMobs = prop.getStringList();
        config.setCategoryPropertyOrder(category, (List)propOrder);
        if (config.hasChanged()) {
            config.save();
        }
    }

    public void fromBytes(ByteBuf buf) {
        friendlyMobs = ByteBufUtils.readUTF8String((ByteBuf)buf).split(";");
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)Joiner.on((String)";").skipNulls().join((Object[])friendlyMobs));
    }

    public IMessage onMessage(Config message, MessageContext ctx) {
        return null;
    }
}

