/*
 * Decompiled with CFR 0.152.
 */
package friendlymobs.core;

import friendlymobs.api.FriendlyMobsAPI;
import friendlymobs.core.CommandFriendlyMobs;
import friendlymobs.core.Config;
import friendlymobs.handler.FriendlyEventHooks;
import friendlymobs.handler.FriendlyMobsAPIHandler;
import friendlymobs.network.DisplayGuiMessage;
import friendlymobs.network.MobsSelectedMessage;
import java.util.Map;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="friendlymobs", guiFactory="friendlymobs.client.config.FriendlyGuiFactory")
public class FriendlyMobs {
    public static final String MODID = "friendlymobs";
    public static final SimpleNetworkWrapper NETWORK = NetworkRegistry.INSTANCE.newSimpleChannel("friendlymobs");

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        FriendlyMobsAPI.instance = new FriendlyMobsAPIHandler();
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        if (event.getSide().isClient()) {
            Config.initializeConfigEntries();
        }
        Config.syncConfig();
        NETWORK.registerMessage(Config.class, Config.class, 0, Side.CLIENT);
        NETWORK.registerMessage(DisplayGuiMessage.class, DisplayGuiMessage.class, 1, Side.CLIENT);
        NETWORK.registerMessage(MobsSelectedMessage.class, MobsSelectedMessage.class, 2, Side.SERVER);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new FriendlyEventHooks());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandFriendlyMobs());
    }

    @NetworkCheckHandler
    public boolean netCheckHandler(Map<String, String> mods, Side side) {
        return true;
    }
}

