/*
 * Decompiled with CFR 0.152.
 */
package friendlymobs.handler;

import com.google.common.collect.Sets;
import friendlymobs.api.FriendlyMobsAPI;
import friendlymobs.api.event.GuiSelectedEvent;
import friendlymobs.client.gui.GuiSelectMob;
import friendlymobs.core.Config;
import friendlymobs.core.FriendlyMobs;
import friendlymobs.network.DisplayGuiMessage;
import friendlymobs.network.MobsSelectedMessage;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Explosion;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FriendlyEventHooks {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("friendlymobs")) {
            Config.syncConfig();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onMobSelected(GuiSelectedEvent.OnMobSelectedEvent event) {
        GuiSelectMob gui;
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (event.mobs != null && mc.field_71462_r != null && mc.field_71462_r instanceof GuiSelectMob && (gui = (GuiSelectMob)mc.field_71462_r).getPresetMobs() != null) {
            ResourceLocation[] mobs = event.mobs;
            String[] entries = new String[mobs.length];
            for (int i = 0; i < entries.length; ++i) {
                entries[i] = mobs[i].toString();
            }
            if (mc.func_71356_B()) {
                Config.config.getCategory("general").get("friendlyMobs").set(entries);
                Config.syncConfig();
            } else {
                Config.friendlyMobs = entries;
                FriendlyMobs.NETWORK.sendToServer((IMessage)new MobsSelectedMessage(entries));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (DisplayGuiMessage.guiType != null) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            switch (DisplayGuiMessage.guiType) {
                case SELECT_MOB: {
                    String[] mobs;
                    HashSet keys = Sets.newHashSet();
                    for (String str : mobs = FriendlyMobsAPI.getFriendlyMobs()) {
                        ResourceLocation key = new ResourceLocation(str);
                        if (!ForgeRegistries.ENTITIES.containsKey(key)) continue;
                        keys.add(key);
                    }
                    mc.func_147108_a((GuiScreen)new GuiSelectMob(mc.field_71462_r).setPresetMobs(keys));
                    break;
                }
            }
            DisplayGuiMessage.guiType = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        Config.syncConfig();
    }

    @SubscribeEvent
    public void onServerConnect(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        event.getManager().func_179290_a(FriendlyMobs.NETWORK.getPacketFrom((IMessage)new Config()));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingSetAttack(LivingSetAttackTargetEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null && !entity.field_70170_p.field_72995_K && FriendlyMobsAPI.isFriendly((Entity)entity) && event.getTarget() != null) {
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70624_b(null);
            }
            entity.func_110142_aN().func_94549_h();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingAttack(LivingAttackEvent event) {
        Entity entity = event.getSource().func_76346_g();
        if (entity != null && !entity.field_70170_p.field_72995_K && FriendlyMobsAPI.isFriendly(entity)) {
            event.setCanceled(true);
        }
        if ((entity = event.getSource().func_76364_f()) != null && !entity.field_70170_p.field_72995_K && FriendlyMobsAPI.isFriendly(entity)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEnderTeleport(EnderTeleportEvent event) {
        if (FriendlyMobsAPI.isFriendly((Entity)event.getEntityLiving())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onExplosion(ExplosionEvent.Start event) {
        Explosion explosion = event.getExplosion();
        if (explosion != null && FriendlyMobsAPI.isFriendly((Entity)explosion.func_94613_c())) {
            event.setCanceled(true);
        }
    }
}

