/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates;

import com.github.se7_kn8.gates.Gates;
import com.github.se7_kn8.gates.GatesItems;
import com.github.se7_kn8.gates.block.TwoInputLogicGate;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="gates", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GatesBlocks {
    public static final Map<ResourceLocation, Block> BLOCKS = new HashMap<ResourceLocation, Block>();
    public static final Block AND_GATE = GatesBlocks.addBlock("and_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 != false && x2 != false), Gates.GATES_ITEM_GROUP);
    public static final Block OR_GATE = GatesBlocks.addBlock("or_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 != false || x2 != false), Gates.GATES_ITEM_GROUP);
    public static final Block NAND_GATE = GatesBlocks.addBlock("nand_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 == false || x2 == false), Gates.GATES_ITEM_GROUP);
    public static final Block NOR_GATE = GatesBlocks.addBlock("nor_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 == false && x2 == false), Gates.GATES_ITEM_GROUP);
    public static final Block XOR_GATE = GatesBlocks.addBlock("xor_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 ^ x2), Gates.GATES_ITEM_GROUP);
    public static final Block XNOR_GATE = GatesBlocks.addBlock("xnor_gate", (Block)new TwoInputLogicGate((x1, x2) -> !(x1 ^ x2)), Gates.GATES_ITEM_GROUP);

    @SubscribeEvent
    public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        for (ResourceLocation location : BLOCKS.keySet()) {
            Block block = BLOCKS.get(location);
            block.setRegistryName(location);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    private static Block addBlock(String name, Block block, ItemGroup tab) {
        BLOCKS.put(new ResourceLocation("gates", name), block);
        ItemBlock itemBlock = new ItemBlock(block, new Item.Properties().func_200916_a(tab));
        itemBlock.func_195946_a(Item.field_179220_a, (Item)itemBlock);
        GatesItems.ITEMS.put(new ResourceLocation("gates", name), (Item)itemBlock);
        return block;
    }
}

