/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates;

import com.github.se7_kn8.gates.Gates;
import com.github.se7_kn8.gates.GatesItems;
import com.github.se7_kn8.gates.block.CustomDetector;
import com.github.se7_kn8.gates.block.CustomRepeater;
import com.github.se7_kn8.gates.block.OneInputLogicGate;
import com.github.se7_kn8.gates.block.RSFlipFlop;
import com.github.se7_kn8.gates.block.RotarySwitch;
import com.github.se7_kn8.gates.block.TwoInputLogicGate;
import com.github.se7_kn8.gates.block.redstone_clock.AdvancedRedstoneClock;
import com.github.se7_kn8.gates.block.redstone_clock.RedstoneClock;
import com.github.se7_kn8.gates.block.wireless_redstone.ReceiverBlock;
import com.github.se7_kn8.gates.block.wireless_redstone.TransmitterBlock;
import com.github.se7_kn8.gates.block.wireless_redstone.WirelessRedstoneLamp;
import com.github.se7_kn8.gates.tile.CustomDetectorTile;
import com.github.se7_kn8.gates.tile.ReceiverTileEntity;
import com.github.se7_kn8.gates.tile.RedstoneClockTileEntity;
import com.github.se7_kn8.gates.tile.TransmitterTileEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="gates", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GatesBlocks {
    public static final Map<ResourceLocation, Block> BLOCKS = new HashMap<ResourceLocation, Block>();
    public static final List<TileEntityType<? extends TileEntity>> TILE_ENTITIES = new ArrayList<TileEntityType<? extends TileEntity>>();
    public static final Block REDSTONE_BLOCK_OFF = GatesBlocks.addBlock("redstone_block_off", new Block(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150451_bX)), Gates.GATES_ITEM_GROUP);
    public static final Block AND_GATE = GatesBlocks.addBlock("and_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 != false && x2 != false), Gates.GATES_ITEM_GROUP);
    public static final Block OR_GATE = GatesBlocks.addBlock("or_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 != false || x2 != false), Gates.GATES_ITEM_GROUP);
    public static final Block NAND_GATE = GatesBlocks.addBlock("nand_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 == false || x2 == false), Gates.GATES_ITEM_GROUP);
    public static final Block NOR_GATE = GatesBlocks.addBlock("nor_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 == false && x2 == false), Gates.GATES_ITEM_GROUP);
    public static final Block XOR_GATE = GatesBlocks.addBlock("xor_gate", (Block)new TwoInputLogicGate((x1, x2) -> x1 ^ x2), Gates.GATES_ITEM_GROUP);
    public static final Block XNOR_GATE = GatesBlocks.addBlock("xnor_gate", (Block)new TwoInputLogicGate((x1, x2) -> !(x1 ^ x2)), Gates.GATES_ITEM_GROUP);
    public static final Block NOT_GATE = GatesBlocks.addBlock("not_gate", (Block)new OneInputLogicGate(x1 -> x1 == false), Gates.GATES_ITEM_GROUP);
    public static final Block FAST_REPEATER = GatesBlocks.addBlock("fast_repeater", (Block)new CustomRepeater(1), Gates.GATES_ITEM_GROUP);
    public static final Block SLOW_REPEATER = GatesBlocks.addBlock("slow_repeater", (Block)new CustomRepeater(4), Gates.GATES_ITEM_GROUP);
    public static final Block WIRELESS_REDSTONE_RECEIVER = GatesBlocks.addBlock("receiver", (Block)new ReceiverBlock(), Gates.GATES_ITEM_GROUP);
    public static final Block WIRELESS_REDSTONE_TRANSMITTER = GatesBlocks.addBlock("transmitter", (Block)new TransmitterBlock(), Gates.GATES_ITEM_GROUP);
    public static final Block WIRELESS_REDSTONE_LAMP = GatesBlocks.addBlock("wireless_redstone_lamp", (Block)new WirelessRedstoneLamp(), Gates.GATES_ITEM_GROUP);
    public static final Block RAIN_DETECTOR = GatesBlocks.addBlock("rain_detector", (Block)new CustomDetector((blockState, world, blockPos) -> world.func_175727_C(blockPos.func_177981_b(2)) ? 15 : 0), Gates.GATES_ITEM_GROUP);
    public static final Block THUNDER_DETECTOR = GatesBlocks.addBlock("thunder_detector", (Block)new CustomDetector((blockState, world, blockPos) -> world.func_72911_I() ? 15 : 0), Gates.GATES_ITEM_GROUP);
    public static final Block REDSTONE_CLOCK = GatesBlocks.addBlock("redstone_clock", (Block)new RedstoneClock(), Gates.GATES_ITEM_GROUP);
    public static final Block ADVANCED_REDSTONE_CLOCK = GatesBlocks.addBlock("advanced_redstone_clock", (Block)new AdvancedRedstoneClock(), Gates.GATES_ITEM_GROUP);
    public static final Block ROTARY_SWITCH = GatesBlocks.addBlock("rotary_switch", (Block)new RotarySwitch(), Gates.GATES_ITEM_GROUP);
    public static final Block RS_FLIP_FLOP = GatesBlocks.addBlock("rs_flip_flop", (Block)new RSFlipFlop(), Gates.GATES_ITEM_GROUP);
    public static final TileEntityType<CustomDetectorTile> RAIN_DETECTOR_TILE_ENTITY = GatesBlocks.addTileEntity("rain_detector", CustomDetectorTile::new, RAIN_DETECTOR, THUNDER_DETECTOR);
    public static final TileEntityType<ReceiverTileEntity> RECEIVER_TILE_ENTITY_TYPE = GatesBlocks.addTileEntity("receiver", ReceiverTileEntity::new, WIRELESS_REDSTONE_RECEIVER);
    public static final TileEntityType<TransmitterTileEntity> TRANSMITTER_TILE_ENTITY_TYPE = GatesBlocks.addTileEntity("transmitter", TransmitterTileEntity::new, WIRELESS_REDSTONE_TRANSMITTER, WIRELESS_REDSTONE_LAMP);
    public static final TileEntityType<RedstoneClockTileEntity> REDSTONE_CLOCK_TILE_ENTITY_TYPE = GatesBlocks.addTileEntity("redstone_clock", RedstoneClockTileEntity::new, REDSTONE_CLOCK, ADVANCED_REDSTONE_CLOCK);

    @SubscribeEvent
    public static void onTileEntityRegistry(RegistryEvent.Register<TileEntityType<?>> tileEntityTypeRegister) {
        tileEntityTypeRegister.getRegistry().registerAll((IForgeRegistryEntry[])TILE_ENTITIES.toArray(new TileEntityType[0]));
    }

    @SubscribeEvent
    public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        for (ResourceLocation location : BLOCKS.keySet()) {
            Block block = BLOCKS.get(location);
            block.setRegistryName(location);
            blockRegistryEvent.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    private static Block addBlock(String name, Block block, ItemGroup tab) {
        BLOCKS.put(new ResourceLocation("gates", name), block);
        BlockItem itemBlock = new BlockItem(block, new Item.Properties().func_200916_a(tab));
        itemBlock.func_195946_a(Item.field_179220_a, (Item)itemBlock);
        GatesItems.ITEMS.put(new ResourceLocation("gates", name), (Item)itemBlock);
        return block;
    }

    private static <T extends TileEntity> TileEntityType<T> addTileEntity(String name, Supplier<T> tileEntitySupplier, Block ... validBlocks) {
        TileEntityType type = TileEntityType.Builder.func_223042_a(tileEntitySupplier, (Block[])validBlocks).func_206865_a(null);
        type.setRegistryName(name);
        TILE_ENTITIES.add((TileEntityType<? extends TileEntity>)type);
        return type;
    }
}

