/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.block;

import com.github.se7_kn8.gates.tile.CustomDetectorTile;
import com.github.se7_kn8.gates.util.TriFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class CustomDetector
extends ContainerBlock {
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final BooleanProperty INVERTED = BlockStateProperties.field_208188_o;
    public static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private final TriFunction<BlockState, World, BlockPos, Integer> activateFunction;

    public CustomDetector(TriFunction<BlockState, World, BlockPos, Integer> activateFunction) {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150453_bW));
        this.activateFunction = activateFunction;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)INVERTED, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState p_220053_1_, IBlockReader p_220053_2_, BlockPos p_220053_3_, ISelectionContext p_220053_4_) {
        return SHAPE;
    }

    public int func_180656_a(BlockState state, IBlockReader p_180656_2_, BlockPos p_180656_3_, Direction p_180656_4_) {
        return (Integer)state.func_177229_b((Property)POWER);
    }

    public void updatePower(BlockState state, World world, BlockPos pos) {
        int newPower = this.activateFunction.apply(state, world, pos);
        if (((Boolean)state.func_177229_b((Property)INVERTED)).booleanValue()) {
            newPower = 15 - newPower;
        }
        if (newPower != (Integer)state.func_177229_b((Property)POWER)) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(newPower)));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand p_220051_5_, BlockRayTraceResult p_220051_6_) {
        if (player.func_175142_cm()) {
            if (!world.func_201670_d()) {
                BlockState newState = (BlockState)state.func_235896_a_((Property)INVERTED);
                world.func_180501_a(pos, newState, 4);
                this.updatePower(newState, world, pos);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149744_f(BlockState p_149744_1_) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.func_206894_a(new Property[]{POWER, INVERTED});
    }

    @Nullable
    public TileEntity func_196283_a_(@Nonnull IBlockReader worldIn) {
        return new CustomDetectorTile();
    }
}

