/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RotarySwitch
extends HorizontalFaceBlock {
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    protected static final VoxelShape LEVER_NORTH_AABB = Block.func_208617_a((double)5.0, (double)4.0, (double)10.0, (double)11.0, (double)12.0, (double)16.0);
    protected static final VoxelShape LEVER_SOUTH_AABB = Block.func_208617_a((double)5.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)6.0);
    protected static final VoxelShape LEVER_WEST_AABB = Block.func_208617_a((double)10.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
    protected static final VoxelShape LEVER_EAST_AABB = Block.func_208617_a((double)0.0, (double)4.0, (double)5.0, (double)6.0, (double)12.0, (double)11.0);
    protected static final VoxelShape FLOOR_Z_SHAPE = Block.func_208617_a((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)6.0, (double)12.0);
    protected static final VoxelShape FLOOR_X_SHAPE = Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)6.0, (double)11.0);
    protected static final VoxelShape CEILING_Z_SHAPE = Block.func_208617_a((double)5.0, (double)10.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
    protected static final VoxelShape CEILING_X_SHAPE = Block.func_208617_a((double)4.0, (double)10.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);

    public RotarySwitch() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150442_at));
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0))).func_206870_a((Property)field_196366_M, (Comparable)AttachFace.WALL));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((AttachFace)state.func_177229_b((Property)field_196366_M)) {
            case FLOOR: {
                switch (((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k()) {
                    case X: {
                        return FLOOR_X_SHAPE;
                    }
                }
                return FLOOR_Z_SHAPE;
            }
            case WALL: {
                switch ((Direction)state.func_177229_b((Property)field_185512_D)) {
                    case EAST: {
                        return LEVER_EAST_AABB;
                    }
                    case WEST: {
                        return LEVER_WEST_AABB;
                    }
                    case SOUTH: {
                        return LEVER_SOUTH_AABB;
                    }
                }
                return LEVER_NORTH_AABB;
            }
        }
        switch (((Direction)state.func_177229_b((Property)field_185512_D)).func_176740_k()) {
            case X: {
                return CEILING_X_SHAPE;
            }
        }
        return CEILING_Z_SHAPE;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            BlockState newState;
            if (player.func_225608_bj_()) {
                int power = (Integer)state.func_177229_b((Property)POWER);
                if (power == 0) {
                    power = 16;
                }
                newState = (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(--power));
            } else {
                newState = (BlockState)state.func_235896_a_((Property)POWER);
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 0.6f);
            worldIn.func_175656_a(pos, newState);
            worldIn.func_195593_d(pos, (Block)this);
            worldIn.func_195593_d(pos.func_177972_a(RotarySwitch.func_196365_i((BlockState)newState).func_176734_d()), (Block)this);
        }
        return ActionResultType.SUCCESS;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.func_177229_b((Property)POWER);
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (RotarySwitch.func_196365_i((BlockState)blockState) == side) {
            return (Integer)blockState.func_177229_b((Property)POWER);
        }
        return 0;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_196366_M, field_185512_D, POWER});
    }
}

