/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.block.wireless_redstone;

import com.github.se7_kn8.gates.tile.ReceiverTileEntity;
import com.github.se7_kn8.gates.util.Utils;
import com.github.se7_kn8.gates.util.WirelessRedstoneUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ReceiverBlock
extends ContainerBlock
implements ReceiverTileEntity.IWirelessReceiver {
    public static final VoxelShape SHAPE = VoxelShapes.func_197872_a((VoxelShape)Utils.GATE_SHAPE, (VoxelShape)Block.func_208617_a((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)10.0, (double)9.0));
    public static IntegerProperty POWER = BlockStateProperties.field_208136_ak;

    public ReceiverBlock() {
        super(AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_196633_cV));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return WirelessRedstoneUtil.onBlockActivated(world, pos, player, hand);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return ReceiverBlock.func_220064_c((IBlockReader)worldIn, (BlockPos)pos.func_177977_b());
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        WirelessRedstoneUtil.onBlockAdded(state, worldIn, pos, oldState);
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        WirelessRedstoneUtil.onReplace(state, worldIn, pos, newState);
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new ReceiverTileEntity();
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.func_177229_b((Property)POWER);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.func_177229_b((Property)POWER);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWER});
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((Integer)stateIn.func_177229_b((Property)POWER) > 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void onPowerChange(World world, BlockPos pos, int newPower) {
        world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(newPower)));
    }
}

