/*
 * Decompiled with CFR 0.152.
 */
package com.github.se7_kn8.gates.packages;

import com.github.se7_kn8.gates.packages.BasePacket;
import com.github.se7_kn8.gates.tile.RedstoneClockTileEntity;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateRedstoneClockPacket
implements BasePacket {
    private final BlockPos pos;
    private final int clockTime;
    private final int clockLength;

    public UpdateRedstoneClockPacket(BlockPos pos, int clockTime, int clockLength) {
        this.pos = pos;
        this.clockTime = clockTime;
        this.clockLength = clockLength;
    }

    public UpdateRedstoneClockPacket(PacketBuffer buffer) {
        this.pos = buffer.func_179259_c();
        this.clockTime = buffer.readInt();
        this.clockLength = buffer.readInt();
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_179255_a(this.pos);
        buffer.writeInt(this.clockTime);
        buffer.writeInt(this.clockLength);
    }

    @Override
    public void handle(Supplier<NetworkEvent.Context> ctx) {
        TileEntity tile = ctx.get().getSender().field_70170_p.func_175625_s(this.pos);
        if (tile instanceof RedstoneClockTileEntity) {
            RedstoneClockTileEntity redstoneClockTileEntity = (RedstoneClockTileEntity)tile;
            redstoneClockTileEntity.setClockTime(this.clockTime);
            redstoneClockTileEntity.setClockLength(this.clockLength);
            redstoneClockTileEntity.resetClock();
        }
    }
}

